#!/usr/bin/env bash
# This file MUST BE copied in the same directory where the main JAR file is located

echo -e "Executing QCS in silent mode (no GUI)\n"

# Example of background execution (no GUI) using protocol 2020 (protocolID = 11).
# Path to target file (e.g. "incidence_1.csv") MUST be changed according to your needs.
java -jar -Xmx2g jrc-qcs-2.3.1.jar -v 11 C:/Home/workspace/test-suite/input/encr/2020/incidence/incidence_1.csv

# Example of  background execution (no GUI) using protocol 2014 (protocolID = 1).
# Path to target file (e.g. "incidence_1.csv") MUST be changed according to your needs.
# java -jar -Xmx2g jrc-qcs-2.3.1.jar -v 1 C:/Home/workspace/test-suite/input/encr/2014/incidence/incidence_1.csv

# Example of background execution (no GUI) from Maven build (e.g. IDE)
# Notice the usage of simple quotes (i.e. the "'" char) to parse whitespaces
# mvn exec:java -Dexec.args="-v 11 'S:/ECARS/DATA CALLS/2022/CR_DATA/FORMAT CHECKS/BUDDY_OUTPUT/INCIDENCE_V1_DLC.csv'"

echo -e "\nOutput directory:  $PWD/output"