@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

REM List of supported Java installation on NET1

REM Java Adoptium OpenJDK 21 (from Welcome DPW EC Store)
SET "JAVA_PATHS[1]=C:\Programdata\Microsoft\AppV\Client\Integration\aa0d1243-668e-4493-b7b1-cf60854218d1\Root\bin"
REM Java SE Development Kit 17, Manuela F. (version 17.0.10, not on EC Store)
SET "JAVA_PATHS[2]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\E67655A5-4F43-4895-8BC2-C706D7275DF2\Root\utilities\java\windows-x64\zulu-jdk17.0.10\bin"
REM Java SE Development Kit 11, Stefano A. (version 11.0.18)
SET "JAVA_PATHS[3]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\CEC66B04-C6A0-4222-A261-9930BF0D92D5\Root\bin"
REM SQL Developer 22.2.0 (version 11.0.16.1)
SET "JAVA_PATHS[4]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\21A80766-42E2-4BD2-BF4B-B211F84AE6EC\Root\jdk\jre\bin"
REM Jar file launcher 11, Cristina B. (TBD)
SET "JAVA_PATHS[5]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\1E988A69-CA1A-4938-98FF-9360B9C5CD00\Root\VFS\ProgramFilesX64\AdoptOpenJDK\jre11\bin"

REM DEPRECATED: QCS 2.2.2 and later requires at least JDK 11. However we prefer to keep track of 
REM these installation paths to easy distinguishing the newest paths from the oldest one.

REM Java SE Development Kit 8, Stefano A. (version 1.8.0_361)
REM SET "JAVA_PATHS[X]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\07AEE123-3C92-42B7-9227-CA80DEA80356\Root\bin"
REM Java SE Development Kit 8, Stefano A. (version 1.8.0_191)
REM SET "JAVA_PATHS[X]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\E6927214-4460-4CE4-A0F8-3BE1CC5F9914\Root\bin"
REM Eclipse IDE 2020-03, Stefano A. (version 1.8.0_252)
REM SET "JAVA_PATHS[X]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\86394D63-F5E6-4C44-A00E-97B8863C008F\Root\VFS\ProgramFilesX64\AdoptOpenJDK\jdk8u252\bin"
REM Unknown version, unknown version (TBD)
REM SET "JAVA_PATHS[X]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\36E219E4-4296-4F8C-A011-0CAE2215FE55\Root\VFS\ProgramFilesX64\Java\jdk7\bin"

REM Set cardinality of Java paths
SET "NUMBER=5"
ECHO Number of Javapaths: !NUMBER!

REM Uncomment to enable verbose test of each Java path
REM SET VERBOSE=TRUE

REM Only for testing or debug
IF /I "%VERBOSE%"=="TRUE" (
	ECHO.
	FOR /L %%I IN (1,1,!NUMBER!) DO (
		SET "JAVA_EXE=!JAVA_PATHS[%%I]!\javaw.exe"
		ECHO %%I^) Trying path: !JAVA_PATHS[%%I]!								   
		IF EXIST "!JAVA_EXE!" (
			ECHO.
			ECHO Found Java  : !JAVA_EXE!
			FOR /F "tokens=* USEBACKQ" %%F IN (`"!JAVA_EXE!" -version 2^>^&1`) DO (
				ECHO %%F
			)
		) ELSE (
			ECHO Java not found: !JAVA_EXE!
			ECHO.
		)
	)
)

REM Target jar command
SET "JAR_FILE=jrc-qcs-2.3.1.jar -gui "No Xmx^""

REM Trying all Java installation (one by one)
FOR /L %%I IN (1,1,!NUMBER!) DO (
	SET "JAVA_EXE=!JAVA_PATHS[%%I]!\javaw.exe"
	IF EXIST "!JAVA_EXE!" (
		ECHO.
		ECHO Using Java  : !JAVA_EXE!
        START !JAVA_EXE! -jar !JAR_FILE!
        EXIT /B
	)
)

REM If not found, notify the error to the user
ECHO.
ECHO ERROR: cannot find Java in current white list, please install Java on your local machine
ECHO If Java is already installed, please locate the path of your local installation and inform IT group your local settings
EXIT /B
