@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

REM STEP 1 : Select target protocol

REM Incidence protocol (ID=11)
SET "PROTOCOL_ID=11"
REM Mortality protocol with "Age unit" (ID=13)
REM SET "PROTOCOL_ID=13"
REM Mortality protocol with "Age range" (ID=14)
REM SET "PROTOCOL_ID=14"
REM Population protocol with "Age unit" (ID=15)
REM SET "PROTOCOL_ID=15"
REM Population protocol with "Age range" (ID=16)
REM SET "PROTOCOL_ID=16"
REM Life Table protocol (ID=17)
REM SET "PROTOCOL_ID=17"

REM STEP 2 : Select input directory
SET "INPUT_PATH=C:\Users\adriste\Home\workspace\test-suite\input\encr\2022\incidence"

REM STEP 3 : Select output directory
SET "OUTPUT_PATH=C:\Users\adriste\Home\temp\ENCR\incidence"

REM List of supported Java installation on NET1

REM Java SE Development Kit 17, Manuela F. (version 17.0.10, not on EC Store)
SET "JAVA_PATHS[1]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\E67655A5-4F43-4895-8BC2-C706D7275DF2\Root\utilities\java\windows-x64\zulu-jdk17.0.10\bin"
REM Java SE Development Kit 11, Stefano A. (version 11.0.18)
SET "JAVA_PATHS[2]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\CEC66B04-C6A0-4222-A261-9930BF0D92D5\Root\bin"
REM SQL Developer 22.2.0 (version 11.0.16.1)
SET "JAVA_PATHS[3]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\21A80766-42E2-4BD2-BF4B-B211F84AE6EC\Root\jdk\jre\bin"
REM Jar file launcher 11, Cristina B. (TBD)
SET "JAVA_PATHS[4]=%LOCALAPPDATA%\Microsoft\AppV\Client\Integration\1E988A69-CA1A-4938-98FF-9360B9C5CD00\Root\VFS\ProgramFilesX64\AdoptOpenJDK\jre11\bin"

REM Set cardinality of Java paths
SET "NUMBER=4"
ECHO Number of Javapaths: !NUMBER!

REM Target jar command
SET "JAR_FILE=jrc-qcs-2.3.1.jar -d %PROTOCOL_ID% %INPUT_PATH% %OUTPUT_PATH%"

REM Trying all Java installation (one by one)
FOR /L %%I IN (1,1,!NUMBER!) DO (
	SET "JAVA_EXE=!JAVA_PATHS[%%I]!\javaw.exe"
	IF EXIST "!JAVA_EXE!" (
		ECHO.
		ECHO Protocol ID : !PROTOCOL_ID!
		ECHO Using Java  : !JAVA_EXE!
		ECHO Command     : !JAR_FILE!
        START !JAVA_EXE! -jar !JAR_FILE!
		START "Status of bulk validation" powershell -Command "Get-Content -Path ./logs/qcs-library.log -Wait"																							
        EXIT /B
	)
)

REM If not found, notify the error to the user
ECHO.
ECHO ERROR: cannot find Java in current white list, please install Java on your local machine
ECHO If Java is already installed, please locate the path of your local installation and inform IT group your local settings
EXIT /B
