CLS
@ECHO OFF

REM Header
ECHO.
ECHO JRC-ENCR-QCS Windows BAT file: searching for Java installations

REM Uncomment to enable verbose test of each Java path
REM SET VERBOSE=TRUE
REM Uncomment to use a minimal clean Windows path
REM SET PATH=C:\Windows\system32;C:\Windows

REM Initialization
SET JAVA_PATH=
SET LATEST_VERSION=

REM 1. 	Search JDK in Windows Registry first:
REM		this is necessary since Hibernate requires JDK
ECHO.
ECHO 1. Search JDK in Windows registry
SET REG_KEY=HKLM\Software\JavaSoft\Java Development Kit
CALL :SEARCH_REG

REM 2.	If no JDK is found, search for JRE in Windows Registry
IF NOT DEFINED JAVA_PATH (
	ECHO.
    ECHO 2. Search JRE in Windows registry
    SET REG_KEY=HKLM\Software\JavaSoft\Java Runtime Environment
    CALL :SEARCH_REG
)

REM 3.	If still not found, try JAVA_HOME environment variable
IF NOT DEFINED JAVA_PATH (
	ECHO.
    ECHO 3. Checking if JAVA_HOME variable exists
    IF NOT "%JAVA_HOME%"=="" (
        SET JAVA_PATH=%JAVA_HOME%
        ECHO JAVA_HOME found: %JAVA_PATH%
    )
)

REM 4. If still not found, search in common paths (Win-64)
IF NOT DEFINED JAVA_PATH (
	ECHO.
    ECHO 4. Checking common Java installation paths
    IF EXIST "C:\Program Files\Java\" (
        FOR /D %%D IN ("C:\Program Files\Java\*") DO (
            IF EXIST "%%D\bin\java.exe" (
                SET JAVA_PATH=%%D
                ECHO Found 64 bit Java in: %%D
                REM GOTO :JAVA_FOUND
            )
        )
    )
)

REM Uncomment to force searching again
REM SET JAVA_PATH=

REM 5. If still not found, search in legacy paths (Win-32)
IF NOT DEFINED JAVA_PATH (
    IF EXIST "C:\Program Files (x86)\Java\" (
		ECHO.
		ECHO 5. Checking legacy Java installation paths
        FOR /D %%D IN ("C:\Program Files (x86)\Java\*") DO (
            IF EXIST "%%D\bin\java.exe" (
                SET JAVA_PATH=%%D
                ECHO Found 32 bit Java in: %%D
                REM GOTO :JAVA_FOUND
            )
        )
    ) ELSE (
		ECHO No directory "C:\Program Files (x86)\Java\"
	)
)

REM 6.	Output the result
:JAVA_FOUND
IF DEFINED JAVA_PATH (
	ECHO.
    ECHO Java found in "%JAVA_PATH%"
	SET "PATH=%PATH%;%JAVA_PATH%\bin"
) ELSE (
    ECHO ERROR: Java installation not found
)
IF "%VERBOSE%"=="TRUE" (
	ECHO Windows path: "%PATH%"
)
GOTO :RUN

REM Helper function used to search in Windows registry
:SEARCH_REG
IF "%VERBOSE%"=="TRUE" ECHO Searching Windows key: "%REG_KEY%"
FOR /F "skip=2 tokens=2*" %%A IN ('REG QUERY "%REG_KEY%" /v CurrentVersion') DO (
    SET LATEST_VERSION=%%B
)
IF DEFINED LATEST_VERSION (
	ECHO Found latest version: %LATEST_VERSION%
    FOR /F "skip=2 tokens=2*" %%A IN ('REG QUERY "%REG_KEY%\%LATEST_VERSION%" /v JavaHome') DO (
        SET JAVA_PATH=%%B
        GOTO :EOF
    )
)
GOTO :EOF

:RUN
REM 7. Executes the ECARS-ENCR-QCS application
ECHO.
ECHO Running QCS using Java: "%JAVA_PATH%"
IF "%VERBOSE%"=="TRUE" (
	ECHO.
	java -version
)
START javaw -jar -Xmx1g jrc-qcs-2.3.1.jar -gui "1GB"
