/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.ArrayInitializer;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;

public class JdbcValuesSourceProcessingStateStandardImpl
implements JdbcValuesSourceProcessingState {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JdbcValuesSourceProcessingStateStandardImpl.class);
    private final ExecutionContext executionContext;
    private final JdbcValuesSourceProcessingOptions processingOptions;
    private Map<EntityKey, LoadingEntityEntry> loadingEntityMap;
    private Map<EntityKey, LoadingEntityEntry> reloadedEntityMap;
    private Map<EntityUniqueKey, Initializer> initializerByUniquKeyMap;
    private Map<CollectionKey, LoadingCollectionEntry> loadingCollectionMap;
    private List<CollectionInitializer> arrayInitializers;
    private final PreLoadEvent preLoadEvent;
    private final PostLoadEvent postLoadEvent;

    public JdbcValuesSourceProcessingStateStandardImpl(ExecutionContext executionContext, JdbcValuesSourceProcessingOptions processingOptions) {
        this.executionContext = executionContext;
        this.processingOptions = processingOptions;
        if (executionContext.getSession().isEventSource()) {
            EventSource eventSource = executionContext.getSession().asEventSource();
            this.preLoadEvent = new PreLoadEvent(eventSource);
            this.postLoadEvent = new PostLoadEvent(eventSource);
        } else {
            this.preLoadEvent = null;
            this.postLoadEvent = null;
        }
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.executionContext.getQueryOptions();
    }

    @Override
    public JdbcValuesSourceProcessingOptions getProcessingOptions() {
        return this.processingOptions;
    }

    @Override
    public PreLoadEvent getPreLoadEvent() {
        return this.preLoadEvent;
    }

    @Override
    public PostLoadEvent getPostLoadEvent() {
        return this.postLoadEvent;
    }

    @Override
    public void registerLoadingEntity(EntityKey entityKey, LoadingEntityEntry loadingEntry) {
        if (this.loadingEntityMap == null) {
            this.loadingEntityMap = new HashMap<EntityKey, LoadingEntityEntry>();
        }
        this.loadingEntityMap.put(entityKey, loadingEntry);
    }

    @Override
    public void registerReloadedEntity(EntityKey entityKey, LoadingEntityEntry loadingEntry) {
        if (this.reloadedEntityMap == null) {
            this.reloadedEntityMap = new HashMap<EntityKey, LoadingEntityEntry>();
        }
        this.reloadedEntityMap.put(entityKey, loadingEntry);
    }

    @Override
    public void registerInitializer(EntityUniqueKey entityKey, Initializer initializer) {
        if (this.initializerByUniquKeyMap == null) {
            this.initializerByUniquKeyMap = new HashMap<EntityUniqueKey, Initializer>();
        }
        this.initializerByUniquKeyMap.put(entityKey, initializer);
    }

    @Override
    public Initializer findInitializer(EntityUniqueKey entityKey) {
        return this.initializerByUniquKeyMap == null ? null : this.initializerByUniquKeyMap.get(entityKey);
    }

    @Override
    public LoadingEntityEntry findLoadingEntityLocally(EntityKey entityKey) {
        return this.loadingEntityMap == null ? null : this.loadingEntityMap.get(entityKey);
    }

    @Override
    public LoadingCollectionEntry findLoadingCollectionLocally(CollectionKey key) {
        if (this.loadingCollectionMap == null) {
            return null;
        }
        return this.loadingCollectionMap.get(key);
    }

    @Override
    public void registerSubselect() {
        if (this.loadingEntityMap != null && this.loadingEntityMap.size() > 1) {
            this.loadingEntityMap.forEach((entityKey, loadingEntityEntry) -> this.executionContext.registerSubselect((EntityKey)entityKey, (LoadingEntityEntry)loadingEntityEntry));
        } else {
            LOG.tracef("Skipping create subselects because there are fewer than 2 results, so query by key is more efficient.", this.getClass().getName());
        }
    }

    @Override
    public void registerLoadingCollection(CollectionKey key, LoadingCollectionEntry loadingCollectionEntry) {
        if (this.loadingCollectionMap == null) {
            this.loadingCollectionMap = new HashMap<CollectionKey, LoadingCollectionEntry>();
        }
        this.loadingCollectionMap.put(key, loadingCollectionEntry);
        if (loadingCollectionEntry.getInitializer() instanceof ArrayInitializer) {
            if (this.arrayInitializers == null) {
                this.arrayInitializers = new ArrayList<CollectionInitializer>();
            }
            this.arrayInitializers.add(loadingCollectionEntry.getInitializer());
        }
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.executionContext.getSession();
    }

    @Override
    public void finishUp() {
        this.finishLoadingCollections();
        this.postLoad();
    }

    private void postLoad() {
        Callback callback = this.executionContext.getCallback();
        if (this.loadingEntityMap != null) {
            EventListenerGroup<PostLoadEventListener> listenerGroup = this.executionContext.getSession().getFactory().getFastSessionServices().eventListenerGroup_POST_LOAD;
            this.loadingEntityMap.forEach((entityKey, loadingEntityEntry) -> {
                if (loadingEntityEntry.getEntityInstance() != null) {
                    if (this.postLoadEvent != null) {
                        this.postLoadEvent.reset();
                        this.postLoadEvent.setEntity(loadingEntityEntry.getEntityInstance()).setId(entityKey.getIdentifier()).setPersister(loadingEntityEntry.getDescriptor());
                        listenerGroup.fireEventOnEachListener(this.postLoadEvent, PostLoadEventListener::onPostLoad);
                    }
                    if (callback != null) {
                        callback.invokeAfterLoadActions(loadingEntityEntry.getEntityInstance(), loadingEntityEntry.getDescriptor(), this.getSession());
                    }
                }
            });
        }
        this.loadingEntityMap = null;
        if (this.reloadedEntityMap != null) {
            if (callback != null) {
                this.reloadedEntityMap.forEach((entityKey, loadingEntityEntry) -> callback.invokeAfterLoadActions(loadingEntityEntry.getEntityInstance(), loadingEntityEntry.getDescriptor(), this.getSession()));
            }
            this.reloadedEntityMap = null;
        }
    }

    private boolean isReadOnly() {
        if (this.getQueryOptions().isReadOnly() != null) {
            return this.getQueryOptions().isReadOnly();
        }
        if (this.executionContext.getSession() instanceof EventSource) {
            return this.executionContext.getSession().isDefaultReadOnly();
        }
        return false;
    }

    private void finishLoadingCollections() {
        if (this.loadingCollectionMap != null) {
            for (LoadingCollectionEntry loadingCollectionEntry : this.loadingCollectionMap.values()) {
                loadingCollectionEntry.finishLoading(this.getExecutionContext());
            }
            this.loadingCollectionMap = null;
        }
    }
}

