/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.internal;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class ParameterMarkerStrategyInitiator
implements StandardServiceInitiator<ParameterMarkerStrategy> {
    public static final ParameterMarkerStrategyInitiator INSTANCE = new ParameterMarkerStrategyInitiator();

    @Override
    public ParameterMarkerStrategy initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        Dialect dialect;
        ParameterMarkerStrategy nativeParameterMarkerStrategy;
        boolean useNativeMarkers = ConfigurationHelper.getBoolean("hibernate.dialect.native_param_markers", configurationValues);
        if (useNativeMarkers && (nativeParameterMarkerStrategy = (dialect = registry.getService(JdbcServices.class).getDialect()).getNativeParameterMarkerStrategy()) != null) {
            return nativeParameterMarkerStrategy;
        }
        return ParameterMarkerStrategyStandard.INSTANCE;
    }

    @Override
    public Class<ParameterMarkerStrategy> getServiceInitiated() {
        return ParameterMarkerStrategy.class;
    }
}

