/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.util;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadManager {
    protected String leadingName = "ThreadManager - ";
    protected static Logger logger = LoggerFactory.getLogger(ThreadManager.class);

    public static void printList(boolean all) {
        StringBuffer message = ThreadManager.getFormattedList(all);
        System.out.println(message.toString());
    }

    public static void logList(boolean all) {
        StringBuffer message = ThreadManager.getFormattedList(all);
        logger.info(message.toString());
    }

    public static StringBuffer getFormattedList(boolean all) {
        Thread[] list = ThreadManager.getList(all);
        StringBuffer message = new StringBuffer("THREAD LIST:\n\n");
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            message.append(list[i].getName());
            message.append(" [");
            message.append("] - ");
            message.append("Priority: ");
            message.append(list[i].getPriority());
            message.append(" (");
            message.append((Object)list[i].getState());
            message.append(")\n");
        }
        return message;
    }

    public static Thread[] getList(boolean all) {
        if (all) {
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            return threadSet.toArray(new Thread[threadSet.size()]);
        }
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Thread[] list = new Thread[group.activeCount()];
        if (group != null) {
            group.enumerate(list);
        }
        return list;
    }
}

