/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionExecutor {
    protected boolean singleton = true;
    protected Map<String, Object> cache;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public ReflectionExecutor() {
        this.init();
    }

    public void init() {
        if (this.singleton && this.cache == null) {
            this.cache = new HashMap<String, Object>();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initialized singletons cache");
            }
        }
    }

    public Object getInstance(String className) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting instance: " + className);
        }
        if (this.singleton) {
            Object obj = this.cache.get(className);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Got reflection instance from cache: " + String.valueOf(obj));
            }
            if (obj != null) {
                return obj;
            }
        }
        Class<?> the_class = null;
        try {
            the_class = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Model name \"" + className + "\" NOT FOUND !!!");
            return null;
        }
        Object obj = null;
        try {
            obj = the_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            this.logger.error("No instance: " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            this.logger.error("No access: " + e.getMessage());
            return null;
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Illegal argument: " + e.getMessage());
            return null;
        }
        catch (InvocationTargetException e) {
            this.logger.error("Target error: " + e.getMessage());
            return null;
        }
        catch (NoSuchMethodException e) {
            this.logger.error("No such method: " + e.getMessage());
            return null;
        }
        catch (SecurityException e) {
            this.logger.error("Security problem: " + e.getMessage());
            return null;
        }
        if (this.singleton) {
            this.cache.put(className, obj);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Put new reflection instance in cache: " + String.valueOf(obj));
            }
        }
        return obj;
    }

    protected Method getMethod(Object instance, String name, Class<?>[] signature) {
        Method method = null;
        String className = instance.getClass().getName();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Getting method " + className + "." + name + "() via Java Reflection");
        }
        try {
            method = signature == null ? instance.getClass().getMethod(name, new Class[0]) : instance.getClass().getMethod(name, signature);
        }
        catch (SecurityException e) {
            this.logger.error("Security exception when creating method " + name + " for class: " + className);
        }
        catch (NoSuchMethodException e) {
            this.logger.error("Missing method " + name + " in class: " + className);
        }
        return method;
    }

    protected Object invokeMethod(Object obj, Method method, Object[] args) {
        int argsSize;
        Object result = null;
        int n = argsSize = args == null ? 0 : args.length;
        if (method != null) {
            try {
                switch (argsSize) {
                    case 1: {
                        result = method.invoke(obj, args[0]);
                        break;
                    }
                    case 2: {
                        result = method.invoke(obj, args[0], args[1]);
                        break;
                    }
                    default: {
                        result = method.invoke(obj, new Object[0]);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Wrong argument: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.logger.error("Wrong Access: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                this.logger.error("Wrong target: " + e.getMessage());
            }
        }
        return result;
    }

    public static void testReflection() {
        ReflectionExecutor executor = new ReflectionExecutor();
        String modelObject = "eu.europa.ec.jrc.qcs.gui.controller.OpenHelpAction";
        Object obj = executor.getInstance(modelObject);
        if (obj == null) {
            return;
        }
        Method method = executor.getMethod(obj, "testReflection", null);
        Object[] args = null;
        executor.invokeMethod(obj, method, args);
    }
}

