/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.util;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeProducer {
    public static final int minDigit = 0;
    public static final int maxDigit = 9;
    public static final int minChar = 65;
    public static final int maxChar = 90;
    public static final String startDigit = "1";
    public static final char startChar = "1".charAt(0);
    protected static Logger logger = LoggerFactory.getLogger(RangeProducer.class);

    public List<String> getRangeAsList(String start, String end) {
        String value = new String(start);
        ArrayList<String> result = new ArrayList<String>();
        while (!value.equalsIgnoreCase(end)) {
            result.add(value);
            value = this.incrementAlphaNumeric(value, true);
        }
        result.add(end);
        return result;
    }

    public String getRangeValuesAsString(int start, int end) {
        return this.getRangeValuesAsString(Integer.toString(start), Integer.toString(end));
    }

    public String getRangeValuesAsString(String start, String end) {
        String sep = "";
        String value = new String(start);
        StringBuilder result = new StringBuilder();
        while (!value.equalsIgnoreCase(end)) {
            result.append(sep);
            result.append(value);
            sep = ",";
            value = this.incrementAlphaNumeric(value, true);
        }
        result.append(sep);
        result.append(end);
        return result.toString();
    }

    public String incrementAlphaNumeric(String input, boolean forward) {
        char oldValue = '-';
        int numCarry = forward ? 0 : 9;
        char alphaCarry = forward ? (char)'A' : 'Z';
        boolean loop = true;
        int newValue = numCarry;
        int index = input.length() - 1;
        StringBuilder builder = new StringBuilder(input);
        while (loop) {
            if (index >= 0) {
                oldValue = builder.charAt(index);
            }
            if ((newValue = this.incrementDigitAt(builder, index, forward)) >= 0) {
                builder.setCharAt(index--, Character.forDigit(newValue, 10));
                boolean bl = loop = newValue == numCarry;
                if (newValue != 0 || index >= 0 || oldValue != startChar) continue;
                return builder.substring(1);
            }
            if (index >= 0) {
                char newChar = this.incrementCharAt(builder, index, forward);
                builder.setCharAt(index--, newChar);
                loop = newChar == alphaCarry;
                continue;
            }
            return startDigit + String.valueOf(builder);
        }
        return builder.toString();
    }

    protected int incrementDigitAt(StringBuilder input, int index, boolean forward) {
        if (logger.isDebugEnabled()) {
            logger.trace("incrementDigitAt: " + String.valueOf(input) + " [" + index + "]");
        }
        if (index < 0) {
            return index;
        }
        int digit = Character.digit(input.charAt(index), 10);
        if (digit < 0) {
            return digit;
        }
        if (forward) {
            return ++digit > 9 ? 0 : digit;
        }
        return --digit >= 0 ? digit : 9;
    }

    protected char incrementCharAt(StringBuilder input, int index, boolean forward) throws NumberFormatException {
        int ascii;
        if (logger.isDebugEnabled()) {
            logger.trace("incrementCharAt: " + String.valueOf(input) + " [" + index + "]");
        }
        if ((ascii = input.charAt(index)) < 65 || ascii > 90) {
            throw new NumberFormatException("Invalid character");
        }
        if (forward) {
            return (char)(++ascii > 90 ? 65 : ascii);
        }
        return (char)(--ascii >= 65 ? ascii : 90);
    }
}

