/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class HashedTimestamp {
    protected long time;
    protected String nounce;
    protected String hash;
    public static final char[] SYMBOLS = "0123456789ABCDEF".toCharArray();

    public HashedTimestamp() {
        this.time = new Date().getTime();
        this.nounce = Long.toString(this.time);
    }

    public HashedTimestamp(long time) {
        this.time = time;
        this.nounce = Long.toString(time);
    }

    public String getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        return this.hashNounce();
    }

    protected String hashNounce() {
        int max = 10;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(this.nounce.getBytes(StandardCharsets.UTF_8));
            this.hash = this.bytesToHex(encodedhash);
            if (this.hash.length() > max) {
                this.hash = this.hash.substring(0, max);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return this.hash;
    }

    protected String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int value = bytes[i] & 0xFF;
            hexChars[i * 2] = SYMBOLS[value >>> 4];
            hexChars[i * 2 + 1] = SYMBOLS[value & 0xF];
        }
        return new String(hexChars);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getNounce() {
        return this.nounce;
    }

    public void setNounce(String nounce) {
        this.nounce = nounce;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }
}

