/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.test.Breakpoint;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTester {
    protected static int counter;
    protected static long startTime;
    protected static long stopTime;
    protected static long prevMemory;
    protected static int chunkSize;
    protected static boolean garbage;
    protected static boolean memory;
    protected static FileHandlerCSV<DataRecord> fileHandler;
    protected static Map<String, Breakpoint> breakpoints;
    protected static Logger logger;

    public static String checkConfiguration() {
        StringBuilder builder = new StringBuilder();
        builder.append("SystemTester - Check configuration: ");
        return builder.toString();
    }

    public static String checkMemory(boolean all) {
        int mb = 0x100000;
        String suffix = "MB\n";
        Runtime runtime = Runtime.getRuntime();
        StringBuilder builder = new StringBuilder("Memory Heap statistics [MB]\n");
        long freeMemory = runtime.freeMemory();
        if (all) {
            builder.append("Used Memory   : " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb + suffix);
        }
        builder.append("Free Memory   : " + freeMemory / (long)mb + suffix);
        builder.append("Memory Change : " + (freeMemory - prevMemory) / (long)mb + suffix);
        if (freeMemory > prevMemory) {
            builder.append("Free Memory increased!\n");
        }
        if (all) {
            builder.append("Total Memory  : " + runtime.totalMemory() / (long)mb + suffix);
        }
        if (all) {
            builder.append("Max Memory    : " + runtime.maxMemory() / (long)mb + suffix);
        }
        prevMemory = freeMemory;
        return builder.toString();
    }

    public static boolean initBenchmark() {
        if (SystemTester.isStarted()) {
            logger.warn("SystemTester already initialized");
            return false;
        }
        counter = 0;
        breakpoints = new HashMap<String, Breakpoint>();
        Date date = new Date();
        long time = date.getTime();
        String fileName = "benchmark_" + time + ".csv";
        String chunkString = "1000";
        String outputFile = "C:/Home/workspace/qcs-2.0/temp/" + fileName;
        FileConnection fileConnection = new FileConnection(outputFile);
        fileConnection.setWriteAccess(true);
        fileHandler = new FileHandlerCSV(fileConnection);
        String[] array = new String[]{"label", "chunck_time_ms", "avg_line_time_ns", "free_memory", "garbage"};
        DataRecordCSV record = new DataRecordCSV(array);
        ArrayList<DataRecordCSV> list = new ArrayList<DataRecordCSV>();
        list.add(record);
        fileHandler.writeFile(list);
        try {
            chunkSize = Integer.parseInt(chunkString);
        }
        catch (NumberFormatException e) {
            chunkSize = 1000;
        }
        Runtime runtime = Runtime.getRuntime();
        prevMemory = runtime.freeMemory();
        SystemTester.startChronwatch();
        if (logger.isInfoEnabled()) {
            logger.info("Benchmark suite: ready");
        }
        return true;
    }

    public static void benchmark() {
        if (++counter % chunkSize != 0) {
            return;
        }
        SystemTester.benchmark(null, null);
    }

    public static void benchmark(String label) {
        SystemTester.benchmark(label, null);
    }

    public static void benchmark(String master, String detail) {
        Object label = detail == null ? master : master + detail;
        SystemTester.stopChronwatch();
        if (garbage) {
            DummyObject dummyObject = new DummyObject(counter);
        }
        Object key = master == null && detail == null ? String.valueOf(counter) : label;
        long freeMemory = 0L;
        long delta = stopTime - startTime;
        String flag = garbage ? "1" : "0";
        StringBuilder builder = new StringBuilder();
        if (memory) {
            builder.append("Benchmark:\n");
            builder.append((String)key);
            builder.append(") ");
            builder.append(SystemTester.checkMemory(true));
            builder.append("Process Time  : " + delta + " [ms]\n");
            freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        }
        String averageString = "N/A";
        if (master == null && detail == null) {
            long average = 1000L * delta / (long)chunkSize;
            averageString = String.valueOf(average);
        }
        String[] array = new String[]{key, String.valueOf(delta), averageString, String.valueOf(freeMemory), flag};
        DataRecordCSV record = new DataRecordCSV(array);
        ArrayList<DataRecordCSV> list = new ArrayList<DataRecordCSV>();
        list.add(record);
        fileHandler.writeFile(list);
        if (garbage) {
            builder.append("Garbage collected: System.gc()\n");
            garbage = false;
        }
        if (memory) {
            logger.info(builder.toString());
        }
        if (detail != null) {
            Breakpoint breakpoint = breakpoints.get(master);
            if (breakpoint == null) {
                breakpoint = new Breakpoint();
                breakpoints.put(master, breakpoint);
            }
            breakpoint.incrementAll(delta);
        }
        SystemTester.startChronwatch();
    }

    public static void endBenchmark() {
    }

    public static void startChronwatch() {
        startTime = System.currentTimeMillis();
    }

    public static void stopChronwatch() {
        stopTime = System.currentTimeMillis();
    }

    public static void logMasterAverage() {
        FileHandlerCSV averagesfileHandler = null;
        Date date = new Date();
        long time = date.getTime();
        String fileName = "averages_" + time + ".csv";
        String outputFile = "C:/Home/workspace/qcs-2.0/temp/" + fileName;
        FileConnection fileConnection = new FileConnection(outputFile);
        fileConnection.setWriteAccess(true);
        averagesfileHandler = new FileHandlerCSV(fileConnection);
        String[] headerArray = new String[]{"label", "sum", "total", "min", "max", "average", "rms"};
        DataRecordCSV header = new DataRecordCSV(headerArray);
        ArrayList<DataRecordCSV> headerList = new ArrayList<DataRecordCSV>();
        headerList.add(header);
        averagesfileHandler.writeFile(headerList);
        DecimalFormat df = new DecimalFormat("#.#");
        df.setRoundingMode(RoundingMode.CEILING);
        for (Map.Entry<String, Breakpoint> entry : breakpoints.entrySet()) {
            String key = entry.getKey();
            Breakpoint breakpoint = entry.getValue();
            long sum = breakpoint.getSum();
            long total = breakpoint.getTotal();
            long min = breakpoint.getMin();
            long max = breakpoint.getMax();
            long avg = breakpoint.getAverage();
            Double rms = breakpoint.getRootMeanSquare();
            String[] array = new String[]{key, String.valueOf(sum), String.valueOf(total), String.valueOf(min), String.valueOf(max), String.valueOf(avg), String.valueOf(df.format(rms))};
            DataRecordCSV record = new DataRecordCSV(array);
            ArrayList<DataRecordCSV> list = new ArrayList<DataRecordCSV>();
            list.add(record);
            averagesfileHandler.writeFile(list);
        }
    }

    public static boolean isStarted() {
        return fileHandler != null;
    }

    static {
        garbage = false;
        memory = false;
        logger = LoggerFactory.getLogger(SystemTester.class);
    }

    static class DummyObject {
        int counter = 0;

        public DummyObject(int counter) {
            this.counter = counter;
            if (logger.isDebugEnabled()) {
                logger.debug("Created instance: " + String.valueOf(this) + " [" + counter + "]");
            }
        }

        public void finalize() {
            garbage = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Destroyed instance: " + String.valueOf(this) + " [" + this.counter + "]");
            }
        }
    }
}

