/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceData;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceDatum;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.RangeParser;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.encr.util.TopographyParser;
import eu.europa.ec.jrc.qcs.gui.view.InputDialog;
import eu.europa.ec.jrc.qcs.report.PDFReport;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snippet {
    protected static Logger logger = LoggerFactory.getLogger(Snippet.class);

    public void test() {
        String version = Configuration.getInstance().getProperty(Property.VERSION);
        logger.info("test() - Testing version " + version + " ...\n");
        this.testAlert();
    }

    public void testTopographyParser() {
        int topoIndex = 0;
        String line = "C70-C72,C751-C753,C50;9390,8290;0;9;Yes";
        logger.info("testTopographyParser() - Input line: " + line);
        TopographyParser topographyParser = new TopographyParser();
        List<String> list = topographyParser.expandTopographies(line, topoIndex);
        logger.info("");
        if (list != null) {
            for (String item : list) {
                logger.info("testTopographyParser() - Parsed line: " + item);
            }
        }
    }

    public void testRangeParser() {
        RangeParser rangeParser = new RangeParser();
        int[] range = rangeParser.expandIntegers("3-12");
        logger.info("testRangeParser() - Parsed range: " + range[0] + " -> " + range[1]);
    }

    public void testSchemaDAO() {
        logger.info("testSchemaDAO() - Testing JPA ...");
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"local_dev");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        logger.info("testSchemaDAO() - Created entiy manager: " + String.valueOf(entityManager));
        List list = entityManager.createQuery("from schema").getResultList();
        logger.info("");
        if (list != null) {
            logger.info("testSchemaDAO() - Fetched list with " + list.size() + " elements");
        } else {
            logger.warn("testSchemaDAO() - Fetched null list!");
        }
        for (eu.europa.ec.jrc.qcs.dao.dto.Schema dto : list) {
            Schema model = new Schema(dto);
            logger.info("testSchemaDAO() - Schema: " + String.valueOf(model));
        }
    }

    public void generatePDF(int validationRunID) {
        PDFReport pdfReport = new PDFReport(validationRunID);
        logger.info("generatePDF() - Starting generation of PDF report for validationRunID: " + validationRunID);
        try {
            pdfReport.generate();
        }
        catch (Exception e) {
            String message = "Failed creation of PDF/TXT reports: " + e.getMessage();
            logger.error(message);
            e.printStackTrace();
        }
        catch (Throwable t) {
            String message = "Fatal error when creating PDF/TXT reports: " + t.getMessage();
            logger.error(message);
        }
        logger.info("generatePDF() - Completed generation of PDF report for validationRunID: " + validationRunID);
    }

    public void testAlert() {
        logger.info("testAlert() - Opening Swing alert ...");
        boolean result = InputDialog.showDialog("RESTORE");
        logger.info("testAlert() - Did user confirm ? " + result);
    }

    public void testSorter() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(99);
        set.add(76);
        set.add(5);
        set.add(10);
        ArrayList targetList = new ArrayList(set);
        Collections.sort(targetList);
        HashSet messedUp = new HashSet(targetList);
        logger.info("Set (natural order) : " + String.valueOf(set));
        logger.info("List (sorted)       : " + String.valueOf(targetList));
        logger.info("Set (messed)        : " + String.valueOf(messedUp));
    }

    public void testTimestamp() {
        StringBuilder builder = new StringBuilder();
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        builder.append(" (");
        builder.append(timestamp);
        builder.append(" )");
        logger.info("Date      : " + String.valueOf(date));
        logger.info("Time      : " + date.getTime());
        logger.info("Timestamp : " + String.valueOf(timestamp));
    }

    public void testSortingMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("One", 1);
        map.put("Two", 2);
        map.put("Three", 3);
        map.put("Four", 4);
        map.put("Five", 5);
        logger.info("Before sorting");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            int value = (Integer)entry.getValue();
            logger.info("Map entry: " + key + " -> " + value);
        }
    }

    public void serializeJSON() {
        if (logger.isInfoEnabled()) {
            logger.info("serializeJSON() - Started ...");
        }
        String value = "Hola chica";
        String[] fieldData_1 = new String[]{"1", "1", "2", "PatID", "1", "", "1", "Patient"};
        String[] fieldData_2 = new String[]{"6", "1", "7", "Sex", "7", "0", "0", "Sex"};
        ReferenceField field_1 = new ReferenceField(fieldData_1);
        ReferenceField field_2 = new ReferenceField(fieldData_2);
        ReferenceDatum datum_1 = new ReferenceDatum(field_1, value);
        ReferenceDatum datum_2 = new ReferenceDatum(field_2, "1");
        String element_1 = datum_1.stringfy();
        String element_2 = datum_2.stringfy();
        String json = "{" + element_1 + "," + element_2 + "}";
        if (logger.isInfoEnabled()) {
            logger.info("serializeJSON() - Serialized JSON: " + json + "\n");
        }
        int protocolID = 1;
        ValidationOptions validationOptions = Configuration.getInstance().getValidationOptions();
        List<ReferenceField> referenceFields = validationOptions.getReferenceFields(protocolID);
        ReferenceData referenceDataSingleton = new ReferenceData(referenceFields, true);
        ReferenceData referenceData = new ReferenceData(json);
        referenceData.setReferenceData(referenceDataSingleton);
        try {
            referenceData.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<ReferenceDatum> list = referenceData.getAllReferenceData();
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("serializeJSON() - Result of parse operation:");
            for (ReferenceDatum referenceDatum : list) {
                logger.info("serializeJSON() - ReferenceDatum: " + String.valueOf(referenceDatum));
            }
        }
    }
}

