/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.RangeDAO;
import eu.europa.ec.jrc.qcs.dao.RangeDataDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaGroupDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.Message;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Range;
import eu.europa.ec.jrc.qcs.dao.model.schema.RangeData;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaToField;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.test.DAOReader;
import eu.europa.ec.jrc.qcs.test.FlatFileTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasAnalyzer
extends DAOReader {
    protected List<Field> allFields;
    protected List<SchemaToField> allSchemaToFields;
    protected List<Range> allRanges;
    protected List<RangeData> distinctRangeData;
    protected static Logger logger = LoggerFactory.getLogger(SchemasAnalyzer.class);

    public SchemasAnalyzer() {
        this.init();
        this.dump = true;
        this.openDumpFile("schemas-coherence-report.txt", "SCHEMAS COHERENCE TEST REPORT");
    }

    public void loadSchema(int schemaID, boolean full) {
        int position;
        Field field2;
        int maxRows = 60;
        boolean verbose = false;
        SchemaGroupDAO schemaGroupDAO = (SchemaGroupDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMAS_GROUP));
        int maxGroupID = schemaGroupDAO.getMaxID();
        if (logger.isInfoEnabled()) {
            logger.info(this.formatSchemaGroups(this.allGroups, maxGroupID));
        }
        SchemaDAO schemaDAO = (SchemaDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA));
        int maxSchemaID = schemaDAO.getMaxID();
        if (logger.isInfoEnabled()) {
            logger.info(this.formatSchemas(this.allSchemas, maxSchemaID));
        }
        Schema schema = (Schema)schemaDAO.getByID(schemaID);
        SchemasGroup group = schema.getSchemaGroup();
        if (logger.isInfoEnabled()) {
            logger.info("Target group  : " + String.valueOf(group) + " [groupID=" + group.getId() + "]");
            logger.info("Target schema : " + String.valueOf(schema));
        }
        if (group == SchemasGroup.UNDEF || schema == Schema.UNDEF) {
            logger.warn("");
            logger.warn("Wrong group/schema: exiting...");
            logger.warn("");
            return;
        }
        SchemaViewDAO schemaViewDAO = (SchemaViewDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA_VIEW));
        SchemaView schemaView = full ? schemaViewDAO.getFullSchemaViewByID(schemaID) : (SchemaView)schemaViewDAO.getByID(schemaID);
        int schemaSize = schemaView.getNumberOfFields();
        int counter = 1;
        int offset = 1;
        int parentID = schema.getParentID();
        if (!full && parentID > 0) {
            SchemaView parentSchemaView = (SchemaView)schemaViewDAO.getByID(parentID);
            offset = parentSchemaView.getNumberOfFields();
            schemaSize += offset;
            ++offset;
            if (logger.isInfoEnabled()) {
                logger.info("Target schema extends schema " + parentID + " --> offset = " + offset + ", schemaSize = " + schemaSize);
            }
        }
        String suffix = " the " + schema.getName() + " schema (" + group.getName() + " group)";
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("List of first " + maxRows + " FIELDS for" + suffix);
            logger.info("");
        }
        for (int position2 = offset; position2 <= schemaSize; ++position2) {
            field2 = schemaView.getFieldByPosition(position2);
            if (logger.isInfoEnabled()) {
                logger.info(position2 + ") Field: " + String.valueOf(field2));
            }
            if (counter++ >= maxRows) break;
        }
        counter = 1;
        logger.info("");
        logger.info("List of all FUNCTION fields for" + suffix);
        logger.info("");
        for (Field field2 : schemaView.getFunctionFields()) {
            if (!logger.isInfoEnabled()) continue;
            logger.info(counter++ + ") Field: " + String.valueOf(field2));
        }
        counter = 1;
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("List of first " + maxRows + " RANGES for" + suffix);
            logger.info("");
        }
        for (position = offset; position <= schemaSize; ++position) {
            field2 = schemaView.getFieldByPosition(position);
            Range range = field2.getRange();
            if (range.equals(Range.UNDEF)) continue;
            logger.info("Range: " + String.valueOf(range));
            if (counter++ >= maxRows) break;
        }
        if (verbose && logger.isInfoEnabled()) {
            this.logHorizontalLine();
            logger.info("Listing all fields in schema: " + schemaView.getName() + " [" + schemaSize + " fields]");
            for (position = offset; position <= schemaSize; ++position) {
                field2 = schemaView.getFieldByPosition(position);
                if (field2 != Field.UNDEF) {
                    logger.info(position + ") Field: " + field2.toShortString());
                    continue;
                }
                logger.info(position + ") MISSING");
            }
        }
    }

    public void checkSchemasIntegrity(int schemaID) {
        this.logHorizontalLine();
        if (logger.isInfoEnabled()) {
            logger.info("checkSchemasIntegrity() - CHECK_1: checking flat files existence...");
        }
        FlatFileTester flatFileDAOTester = new FlatFileTester();
        boolean flatFileConfiguration = flatFileDAOTester.checkFlatFilesConfiguration(schemaID);
        if (logger.isInfoEnabled()) {
            logger.info("checkSchemasIntegrity() - CHECK_1: existence of all declared flat files: " + (flatFileConfiguration ? "OK" : "ERROR"));
        }
        if (!flatFileConfiguration) {
            logger.warn("checkSchemasIntegrity() - Found invalid flat file configuration: skipping next checks");
        }
        if (logger.isInfoEnabled()) {
            this.logHorizontalLine();
            logger.info("checkSchemasIntegrity() - CHECK_2: checking coherence of target schema...");
        }
        this.checkSchemasComponents();
        if (logger.isInfoEnabled()) {
            this.logHorizontalLine();
            logger.info("checkSchemasIntegrity() - CHECK_3: propagating errors and warnings...");
        }
        this.propagateErrors(schemaID);
    }

    public void checkSchemasComponents() {
        FieldDAO fieldDAO = (FieldDAO)((Object)this.daoFactory.getDAO(DAO.FIELD));
        RangeDAO rangeDAO = (RangeDAO)((Object)this.daoFactory.getDAO(DAO.RANGE));
        RangeDataDAO rangeDataDAO = (RangeDataDAO)((Object)this.daoFactory.getDAO(DAO.RANGE_DATA));
        SchemaToFieldDAO schemaFieldLinkDAO = (SchemaToFieldDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA_TO_FIELD));
        this.allFields = fieldDAO.getAll();
        this.allRanges = rangeDAO.getAll();
        this.distinctRangeData = rangeDataDAO.getDistinctById();
        this.allSchemaToFields = schemaFieldLinkDAO.getAll();
        this.checkPrimaryConstraint(this.allGroups);
        this.checkPrimaryConstraint(this.allSchemas);
        for (GenericModel genericModel : this.allSchemas) {
            this.checkForeignConstraint(genericModel, "default", this.allGroups);
        }
        this.checkPrimaryConstraint(this.allFields);
        for (GenericModel genericModel : this.allFields) {
            this.checkForeignConstraint(genericModel, "default", this.allRanges);
        }
        for (GenericModel genericModel : this.allSchemaToFields) {
            this.checkForeignConstraint(genericModel, "schemaId", this.allSchemas);
            this.checkForeignConstraint(genericModel, "default", this.allFields);
        }
        this.checkFieldsPositions();
        this.checkPrimaryConstraint(this.allRanges);
        for (GenericModel genericModel : this.allRanges) {
            this.checkForeignConstraint(genericModel, "default", this.distinctRangeData);
        }
        this.checkUnreferredRecords(this.allSchemaToFields, "schemaId", this.allSchemas, "id");
        this.checkUnreferredRecords(this.allFields, "id", this.allSchemaToFields, "default");
        this.checkUnreferredRecords(this.allRanges, "id", this.allFields, "default");
    }

    public boolean checkPrimaryConstraint(List<? extends GenericModel> list) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (GenericModel genericModel : list) {
            ids.add(genericModel.getId());
        }
        boolean hasDuplicates = false;
        Object var4_6 = null;
        if (this.hasDuplicates(ids)) {
            List list2 = this.getDuplicates(ids);
            for (GenericModel genericModel : list) {
                if (!list2.contains(genericModel.getId()) || genericModel.getId() <= 0) continue;
                hasDuplicates = true;
                String message = "Duplicate model ID for " + genericModel.getModelLabel();
                genericModel.addErrorMessage(message);
            }
        }
        return !hasDuplicates;
    }

    protected boolean checkForeignConstraint(GenericModel record, String key, List<? extends GenericModel> primaryList) {
        boolean verbose = false;
        if (verbose) {
            logger.info("");
            logger.info("checkForeignConstraint() - Checking " + record.getClassName() + " foreign key : " + key);
            logger.info("checkForeignConstraint() - Record values : " + String.valueOf(record));
        }
        int foreignID = record.getForeignId(key);
        boolean isRangeEntity = "Range".equalsIgnoreCase(record.getClassName());
        if (isRangeEntity) {
            String rangeType;
            Range range = (Range)record;
            foreignID = range.getId();
            String string = rangeType = range.isInterval() ? " (interval)" : " (emum)";
            if (logger.isDebugEnabled()) {
                logger.debug("checkForeignContraint - Using main ID as 'foreignID' for range: " + foreignID + rangeType);
            }
            if (range.isInterval()) {
                return true;
            }
        }
        if (verbose) {
            logger.info("checkForeignConstraint() - Foreign ID : " + foreignID);
        }
        if (foreignID == 0 && record.isNillableForeignKey(key)) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkForeignContraint - skipping check for " + record.getModelLabel() + " with null foreign key");
            }
            return true;
        }
        if (primaryList == null || primaryList.size() == 0) {
            String message = "Empty lookup table for " + record.getModelLabel();
            record.addErrorMessage(message);
            return false;
        }
        String primaryLabel = primaryList.get(0).getClass().getSimpleName().toLowerCase();
        String notification = record.getModelLabel() + " - Referred " + primaryLabel + " ID: " + record.getIntegerLabel(foreignID);
        if (verbose) {
            logger.info("checkForeignConstraint() - Primary label / foreignID : " + primaryLabel + " / " + foreignID);
        }
        if (foreignID <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkForeignContraint - Wrong foreignID for " + record.getClassName() + ": not in " + primaryLabel);
            }
            String message = "Wrong foreignID for " + notification;
            record.addWarningMessage(message);
            return false;
        }
        GenericModel matchedPrimary = this.getModelFromList(primaryList, foreignID);
        if (verbose) {
            logger.info("checkForeignConstraint() - Matched primary model: " + matchedPrimary.getClassName() + " -> " + String.valueOf(matchedPrimary));
        }
        if (matchedPrimary == null || matchedPrimary == GenericModel.UNDEF) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkForeignContraint - Broken foreign contraint " + record.getClassName() + ": not in " + primaryLabel);
            }
            String message = "Broken foreign contraint for " + notification;
            record.addErrorMessage(message);
            return false;
        }
        if (!matchedPrimary.isValid()) {
            String recordLabel;
            String foreignLabel = matchedPrimary.getClass().getSimpleName().toLowerCase();
            if (logger.isTraceEnabled()) {
                logger.trace("checkForeignConstraint() - Invalid foreign record: " + foreignLabel + " " + String.valueOf(matchedPrimary));
            }
            if (!"schematofield".equalsIgnoreCase(recordLabel = record.getClass().getSimpleName().toLowerCase())) {
                String message = "Invalid reference for " + notification;
                record.addErrorMessage(message);
                Set<Message> primaryMessages = matchedPrimary.getErrorMessages();
                record.addErrorMessages(primaryMessages);
                return false;
            }
        } else if (verbose) {
            logger.info("checkForeignConstraint() - Matched primary model is valid: OK");
        }
        return true;
    }

    protected boolean checkFieldsPositions() {
        boolean isValid = true;
        SchemaViewDAO schemaViewDAO = (SchemaViewDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA_VIEW));
        for (Schema schema : this.allSchemas) {
            int schemaID = schema.getId();
            SchemaView schemaView = (SchemaView)schemaViewDAO.getByID(schemaID);
            int schemaSize = schemaView.getNumberOfFields();
            List<Integer> positions = schemaView.getPositions();
            List<SchemaToField> schemaToFields = schemaView.getSchemaToFields();
            boolean verbose = false;
            if (verbose) {
                logger.info("");
                logger.info("SchemaID " + schemaID + " number of 'owned' fields : " + schemaSize);
                logger.info(positions.size() + " declared positions : " + String.valueOf(positions));
            }
            int offset = 0;
            int parentID = schema.getParentID();
            if (parentID > 0) {
                SchemaView parentSchemaView = (SchemaView)schemaViewDAO.getByID(parentID);
                offset = parentSchemaView.getNumberOfFields();
                if (logger.isDebugEnabled()) {
                    logger.debug("Schema: " + schema.getId() + " extends schema " + parentID + " -> offset= " + offset);
                }
            }
            ArrayList<Integer> positionsOK = new ArrayList<Integer>();
            for (int i = 1 + offset; i <= schemaSize + offset; ++i) {
                positionsOK.add(i);
            }
            if (verbose) {
                logger.info(positionsOK.size() + " positionsOK : " + String.valueOf(positionsOK));
            }
            ListIterator iterator = positionsOK.listIterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                if (!positions.contains(pos)) continue;
                iterator.remove();
                positions.remove((Object)pos);
            }
            if (verbose) {
                logger.info("Expected positions, but not declared : " + String.valueOf(positionsOK));
                logger.info("Positions declared, but not expected : " + String.valueOf(positions));
            }
            if (positionsOK.size() > 0) {
                isValid = false;
                String message = "Following list of positions are missing in declared list of schema_to_field: " + String.valueOf(positionsOK);
                schema.addErrorMessage(message);
            }
            if (positions.size() <= 0) continue;
            for (SchemaToField schemaToField : schemaToFields) {
                int index;
                if (verbose) {
                    logger.debug("Checking position for : " + String.valueOf(schemaToField));
                }
                if (!positions.contains(index = schemaToField.getPosition()) || index == -2147483001) continue;
                String message = "Duplicate (or out of range) position value for " + schemaToField.getModelLabel(index);
                if (logger.isDebugEnabled()) {
                    logger.debug("Duplicate (or out of range) position: " + index + " -> " + schemaToField.getModelLabel(index));
                }
                GenericModel actualSchemaToField = this.getModelFromList(this.allSchemaToFields, schemaToField);
                actualSchemaToField.addErrorMessage(message);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Duplicate (or out of range) position: " + index + " -> " + actualSchemaToField.getModelLabel());
            }
        }
        return isValid;
    }

    protected void checkUnreferredRecords(List<? extends GenericModel> referred, String referredColumn, List<? extends GenericModel> referring, String referringColumn) {
        for (GenericModel genericModel : referred) {
            boolean found = false;
            int recordID = genericModel.getGenericId(referredColumn);
            if (recordID > 0) {
                GenericModel referringRecord;
                Iterator<? extends GenericModel> iterator = referring.iterator();
                while (iterator.hasNext() && !(found = recordID == (referringRecord = iterator.next()).getGenericId(referringColumn))) {
                }
            } else {
                genericModel.setUnreferred(true);
                genericModel.addWarningMessage("Record with wrong modelID (unreferred by definition): " + genericModel.getName());
            }
            if (recordID <= 0 || found) continue;
            genericModel.setUnreferred(true);
            genericModel.addWarningMessage("Unreferred record: " + genericModel.getName() + " [id=" + recordID + "]");
        }
    }

    public void propagateErrors(int schemaID) {
        boolean unset;
        boolean bl = unset = this.allFields == null || this.allSchemaToFields == null || this.allRanges == null || this.distinctRangeData == null;
        if (unset) {
            String message = "Can not check schema integrity before checking single elements. Please call \"checkSchemasComponents()\" first";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        for (Schema schema : this.allSchemas) {
            SchemasGroup schemaGroup;
            if (schemaID > 0 && schema.getId() != schemaID) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("propagateErrors() - Propagate generic errors for schema: " + schema.getId());
            }
            if ((schemaGroup = schema.getSchemaGroup()) != SchemasGroup.UNDEF) {
                this.propagateErrors(schemaGroup, this.allGroups, schema);
            }
            boolean verbose = false;
            for (SchemaToField schema_to_field : schema.getAllSchemaToField()) {
                Field field;
                Range range;
                if (verbose) {
                    logger.info("propagateErrors() - Propagate SCHEMA_TO_FIELD errors for record: " + String.valueOf(schema_to_field));
                }
                if ((range = (field = schema_to_field.getField()).getRange()) != Range.UNDEF) {
                    if (field.isValid()) {
                        String note = "referred by field ID " + field.getIdAsString();
                        this.propagateErrors(range, this.allRanges, field, note);
                    } else {
                        this.propagateErrors(range, this.allRanges, field);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Propagated range [" + range.getIdAsString() + "] error into field " + field.getIdAsString());
                    }
                }
                if (field != Field.UNDEF) {
                    this.propagateErrors(field, this.allFields, schema_to_field);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Propagated field [" + field.getIdAsString() + "] error into schema_to_field " + schema_to_field.getModelLabel());
                    }
                }
                this.propagateErrors(schema_to_field, this.allSchemaToFields, schema);
            }
        }
    }

    protected void propagateErrors(GenericModel model, List<? extends GenericModel> list, GenericModel target) {
        this.propagateErrors(model, list, target, null);
    }

    protected void propagateErrors(GenericModel model, List<? extends GenericModel> list, GenericModel target, String note) {
        if (model == null) {
            target.addErrorMessage("Found null input model for target: " + target.getModelName());
            return;
        }
        boolean verbose = false;
        if (verbose) {
            logger.info("propagateErrors() - Checking: " + model.getModelLabel() + " TO " + target.getModelLabel());
        }
        List matched = this.getAllModelsFromList(list, model);
        if (verbose) {
            logger.info("propagateErrors() - ORIGINAL : " + String.valueOf(model) + ":\n\n" + model.getAllMessages());
            for (GenericModel source : matched) {
                logger.info("propagateErrors() - MATCHED  : " + String.valueOf(source) + ":\n\n" + source.getAllMessages());
            }
        }
        if (matched == null) {
            target.addErrorMessage("Found null reference to " + model.getModelName() + " for target: " + target.getModelName());
            if (logger.isInfoEnabled()) {
                logger.info("propagateErrors() - Failed to find model " + String.valueOf(model) + " in list of: " + list.get(0).getClass().getName());
            }
        } else {
            for (GenericModel source : matched) {
                target.addWarningMessages(source.getWarningMessages(), note);
                target.addErrorMessages(source.getErrorMessages(), note);
            }
        }
        if (verbose) {
            logger.info("propagateErrors() - TARGET : " + String.valueOf(target) + ":\n\n" + target.getAllMessages());
        }
    }

    protected <T> boolean hasDuplicates(Collection<T> list) {
        HashSet<T> set = new HashSet<T>(list);
        return set.size() != list.size();
    }

    protected <T> List<T> getDuplicates(Collection<T> list) {
        final ArrayList duplicatedObjects = new ArrayList();
        HashSet set = new HashSet<T>(){

            @Override
            public boolean add(T e) {
                if (this.contains(e)) {
                    duplicatedObjects.add(e);
                }
                return super.add(e);
            }
        };
        for (T t : list) {
            set.add(t);
        }
        return duplicatedObjects;
    }

    protected GenericModel getModelFromList(List<? extends GenericModel> list, int modelID) {
        boolean verbose = false;
        GenericModel firstModel = list.get(0);
        if (verbose) {
            logger.info("Looking for ID " + modelID + " in model: " + firstModel.getClassName());
        }
        if (modelID > 0) {
            for (GenericModel genericModel : list) {
                if (genericModel.getId() != modelID) continue;
                return genericModel;
            }
        } else {
            return GenericModel.UNDEF;
        }
        return GenericModel.UNDEF;
    }

    protected GenericModel getModelFromList(List<? extends GenericModel> list, GenericModel model) {
        int modelID;
        if (!this.hasDuplicateIDs(list) && (modelID = model.getId()) > 0) {
            return this.getModelFromList(list, modelID);
        }
        return this.getModelWithoutID(list, model);
    }

    protected GenericModel getModelWithoutID(List<? extends GenericModel> list, GenericModel model) {
        boolean verbose = false;
        boolean hasName = model.getName() != null;
        boolean hasDescription = model.getDescription() != null;
        boolean hasForeignID = model.getForeignId() > 0;
        for (GenericModel genericModel : list) {
            boolean forID;
            boolean candidateMatch = hasName && model.getName().equalsIgnoreCase(genericModel.getName()) || hasDescription && model.getDescription().equalsIgnoreCase(genericModel.getDescription()) || hasForeignID && model.getForeignId() == genericModel.getForeignId();
            if (!candidateMatch) continue;
            boolean name = hasName && model.getName().equalsIgnoreCase(genericModel.getName()) || !hasName;
            boolean desc = hasDescription && model.getDescription().equalsIgnoreCase(genericModel.getDescription()) || !hasDescription;
            boolean bl = forID = hasForeignID && model.getForeignId() == genericModel.getForeignId() || !hasForeignID;
            if (!name || !desc || !forID) continue;
            if (verbose) {
                logger.info("Matched model: " + genericModel.getName() + " (" + genericModel.getClass().getSimpleName() + ")");
                if (genericModel.getWarningMessages() != null) {
                    for (Message message : genericModel.getWarningMessages()) {
                        if (message == null) continue;
                        logger.info(message.toString());
                    }
                }
            }
            return genericModel;
        }
        if (verbose) {
            logger.info("Failed matching model: " + list.get(0).getClass().getSimpleName());
        }
        return GenericModel.UNDEF;
    }

    protected <T> List<T> getAllModelsFromList(List<? extends GenericModel> list, GenericModel model) {
        int modelID = model.getId();
        ArrayList<GenericModel> duplicates = new ArrayList<GenericModel>();
        if (modelID > 0) {
            for (GenericModel genericModel : list) {
                if (genericModel.getId() != modelID) continue;
                duplicates.add(genericModel);
            }
        } else {
            GenericModel firstMatch = this.getModelWithoutID(list, model);
            duplicates.add(firstMatch);
        }
        return duplicates;
    }

    protected boolean hasDuplicateIDs(Collection<? extends GenericModel> list) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (GenericModel genericModel : list) {
            ids.add(genericModel.getId());
        }
        return this.hasDuplicates(ids);
    }

    public String logIntegrityReport(int schemaID) {
        String report = schemaID > 0 ? this.getResultsBySchema(schemaID) : this.getAllResults();
        if (logger.isInfoEnabled()) {
            logger.info(report);
        }
        if (this.dump) {
            this.writer.print(report);
            this.closeDumpFile();
        }
        return report;
    }

    public String getAllResults() {
        String groupStatus = this.getModelsStatus(this.allGroups, "group", false);
        String schemaStatus = this.getModelsStatus(this.allSchemas, "schema", false);
        String orphanFields = this.getModelsStatus(this.allFields, "fields", true);
        String orphanSchemaToFields = this.getModelsStatus(this.allSchemaToFields, "schemaToFields", true);
        String orphanRanges = this.getModelsStatus(this.allRanges, "range", true);
        StringBuilder builder = new StringBuilder();
        builder.append("Listing status of all declared GROUPS:\n\n" + groupStatus);
        builder.append("\n");
        builder.append("Listing status of all declared SCHEMAS:\n\n" + schemaStatus);
        builder.append("\n");
        builder.append("Listing status of all orphan FIELDS:\n\n" + orphanFields);
        builder.append("\n");
        builder.append("Listing status of all orphan SCHEMA_TO_FIELDS:\n\n" + orphanSchemaToFields);
        builder.append("\n");
        builder.append("Listing status of all orphan RANGES:\n\n" + orphanRanges);
        builder.append("\n");
        return builder.toString();
    }

    public String getResultsBySchema(int schemaID) {
        StringBuilder builder = new StringBuilder("Integrity status of schema:\n\n");
        for (Schema schema : this.allSchemas) {
            if (schema.getId() != schemaID) continue;
            String schemaStatus = this.getModelsStatus(schema, "schema", false);
            builder.append(schemaStatus);
        }
        return builder.toString();
    }

    public List<Field> getAllFields() {
        return this.allFields;
    }

    public void setAllFields(List<Field> allFields) {
        this.allFields = allFields;
    }

    public List<Range> getAllRanges() {
        return this.allRanges;
    }

    public void setAllRanges(List<Range> allRanges) {
        this.allRanges = allRanges;
    }

    public List<SchemaToField> getAllSchemaToFields() {
        return this.allSchemaToFields;
    }

    public void setAllSchemaToFields(List<SchemaToField> allSchemaToFields) {
        this.allSchemaToFields = allSchemaToFields;
    }

    public List<RangeData> getDistinctRangeData() {
        return this.distinctRangeData;
    }

    public void setDistinctRangeData(List<RangeData> distinctRangeData) {
        this.distinctRangeData = distinctRangeData;
    }

    protected void checkCriticalSchemaToField(List<Schema> list) {
        if (logger.isInfoEnabled()) {
            logger.info("checkCriticalSchemaToField() - Checking subset of SchemaToField items");
        }
        for (Schema schema : list) {
            int schemaID = schema.getId();
            for (SchemaToField schema_to_field : schema.getAllSchemaToField()) {
                if (schema_to_field.getId() < 74 || schema_to_field.getId() > 84) continue;
                logger.info("SchemaID:  " + schemaID + " -> " + String.valueOf(schema_to_field));
            }
        }
    }
}

