/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.Validator;
import eu.europa.ec.jrc.qcs.dao.datasource.DynamicFileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.crossfield.IsBiggerThanRule;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.ExternalSorter;
import eu.europa.ec.jrc.qcs.test.DAOReader;
import eu.europa.ec.jrc.qcs.test.DAOWriter;
import eu.europa.ec.jrc.qcs.test.EngineTester;
import eu.europa.ec.jrc.qcs.test.FlatFileTester;
import eu.europa.ec.jrc.qcs.test.GenericTester;
import eu.europa.ec.jrc.qcs.test.SchemasAnalyzer;
import eu.europa.ec.jrc.qcs.util.RangeProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainTester
extends GenericTester {
    public static final String FILE = "file";
    public static final String CHECK = "check";
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final String RANGE = "range";
    public static final String RULE = "try_rule";
    public static final String ENGINE = "engine";
    public static final String SORTER = "sorter";
    protected static Logger logger = LoggerFactory.getLogger(MainTester.class);

    public static void main(String[] args) {
        Configuration.loadLoggerConfiguration();
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("---------------------------------------------------------------------------------------");
            logger.info("Running MainTester...\n");
        }
        MainTester tester = new MainTester();
        tester.manageOptions(args);
    }

    public void manageOptions(String[] args) {
        if (logger.isInfoEnabled()) {
            logger.info("Running introspection test with args: " + Arrays.toString(args));
        }
        Options options = new Options();
        DefaultParser parser = new DefaultParser();
        String readDescription = "Unit test of one generic DAO (read).\n<name> = all | logger | properties | i18n | options | group | schema | field | schematofield | range | rangedata | schemaview | data | protocol | rule | protocoltorule | ruletofield | message | protocolview | run | output | detail | reference";
        String saveDescription = "Unit test of one legacy DAO (write).\n<name> = data | run | output | detail | custom";
        String rangeDescription = "Test the RangeProducer class, which produces a range from the range's ends (from and to).\n Usage example: -range 1 10 produces the range [1..10]";
        String ruleDescription = "Test a single validation rule.\nIf ruleID is omitted, the default rule (hard-coded in the EngineTester class) is executed.\n If ruleID = 0, the 'myRule' class is tested (hard-coded in the MainTester class)";
        String engineDescription = "Executes the main validation engine on default dataset (as from configuration files)";
        String checkDescription = "Check coherence of configuration for validation schemas.\n If schemaID is missing or not found, all schemas are checked";
        Option help = Option.builder((String)"a").longOpt("aid").desc("Print available options").build();
        Option file = Option.builder((String)"fh").longOpt(FILE).desc("Check low-level file handlers").build();
        Option sorter = Option.builder((String)"s").longOpt(SORTER).desc("Check external sorter utility").build();
        Option read = Option.builder((String)"r").longOpt(READ).desc(readDescription).hasArg().numberOfArgs(1).argName("name").build();
        Option write = Option.builder((String)"w").longOpt(WRITE).desc(saveDescription).hasArg().numberOfArgs(1).argName("name").build();
        Option check = Option.builder((String)"c").longOpt(CHECK).desc(checkDescription).optionalArg(true).hasArg().numberOfArgs(1).argName("schemaID").build();
        Option rule = Option.builder((String)"tr").longOpt(RULE).desc(ruleDescription).optionalArg(true).hasArg().numberOfArgs(1).argName("ruleID").build();
        Option engine = Option.builder((String)"e").longOpt(ENGINE).desc(engineDescription).optionalArg(true).hasArg().numberOfArgs(1).argName("protocolID").build();
        Option range = Option.builder((String)"ra").longOpt(RANGE).desc(rangeDescription).hasArgs().numberOfArgs(2).argName("from to").build();
        options.addOption(help);
        options.addOption(file);
        options.addOption(check);
        options.addOption(read);
        options.addOption(write);
        options.addOption(range);
        options.addOption(rule);
        options.addOption(engine);
        options.addOption(sorter);
        CommandLine command = null;
        Validator validator = new Validator();
        try {
            command = parser.parse(options, args);
            validator.validateAndSanitizeTestOptions(command, options);
        }
        catch (ParseException e) {
            logger.error("Error passing input arguments: " + String.valueOf(args) + " -> " + e.getMessage());
            this.printHelp(options);
            return;
        }
        DAOReader daoTester = new DAOReader();
        DAOWriter daoWriter = new DAOWriter();
        FlatFileTester fileTester = new FlatFileTester();
        SchemasAnalyzer schemasAnalyzer = new SchemasAnalyzer();
        EngineTester engineTester = new EngineTester();
        if (command.hasOption("aid")) {
            this.printHelp(options);
        } else if (command.hasOption(FILE)) {
            fileTester.checkAllFileHandlers();
        } else if (command.hasOption(CHECK)) {
            int schemaID = 0;
            String[] params = command.getOptionValues(CHECK);
            if (params != null) {
                schemaID = this.parseIntegerValue(params[0]);
            }
            if (schemaID > 0) {
                logger.info("Checking target validation schema: " + schemaID);
            } else {
                logger.info("Checking all validation schemas");
            }
            schemasAnalyzer.checkSchemasIntegrity(schemaID);
            schemasAnalyzer.logIntegrityReport(schemaID);
        } else if (command.hasOption(READ)) {
            String daoName = command.getOptionValue(READ);
            if (logger.isDebugEnabled()) {
                logger.debug("Testing DAO = " + daoName);
            }
            if ("logger".equalsIgnoreCase(daoName)) {
                daoTester.testLoggerConfiguration();
            }
            if ("properties".equalsIgnoreCase(daoName)) {
                daoTester.testProperties();
            }
            if ("options".equalsIgnoreCase(daoName)) {
                daoTester.testValidationOptions();
            }
            if ("i18n".equalsIgnoreCase(daoName)) {
                daoTester.testInternationalization();
            }
            if ("group".equalsIgnoreCase(daoName)) {
                daoTester.testSchemaGroupDAO();
            }
            if ("schema".equalsIgnoreCase(daoName)) {
                daoTester.testSchemaDAO();
            }
            if ("field".equalsIgnoreCase(daoName)) {
                daoTester.testFieldDAO();
            }
            if ("schematofield".equalsIgnoreCase(daoName)) {
                daoTester.testSchemaToFieldDAO();
            }
            if (RANGE.equalsIgnoreCase(daoName)) {
                daoTester.testRangeDAO();
            }
            if ("rangedata".equalsIgnoreCase(daoName)) {
                daoTester.testRangeDataDAO();
            }
            if ("schemaview".equalsIgnoreCase(daoName)) {
                daoTester.testSchemaViewDAO();
            }
            if ("protocol".equalsIgnoreCase(daoName)) {
                daoTester.testProtocolDAO();
            }
            if ("rule".equalsIgnoreCase(daoName)) {
                daoTester.testRuleDefinitionDAO();
            }
            if ("protocoltorule".equalsIgnoreCase(daoName)) {
                daoTester.testProtocolToRuleDAO();
            }
            if ("ruletofield".equalsIgnoreCase(daoName)) {
                daoTester.testRuleToFieldDAO();
            }
            if ("message".equalsIgnoreCase(daoName)) {
                daoTester.testValidationMessageDAO();
            }
            if ("protocolview".equalsIgnoreCase(daoName)) {
                daoTester.testProtocolViewDAO();
            }
            if ("data".equalsIgnoreCase(daoName)) {
                daoTester.testDataRecordDAO();
            }
            if ("run".equalsIgnoreCase(daoName)) {
                daoTester.testValidationRunDAO();
            }
            if ("output".equalsIgnoreCase(daoName)) {
                daoTester.testRuleOutputDAO();
            }
            if ("detail".equalsIgnoreCase(daoName)) {
                daoTester.testRuleOutputDetailDAO();
            }
            if ("reference".equalsIgnoreCase(daoName)) {
                daoTester.testReferenceFieldDAO();
            }
            if ("all".equalsIgnoreCase(daoName)) {
                daoTester.testLoggerConfiguration();
                daoTester.testSchemaGroupDAO();
                daoTester.testSchemaDAO();
                daoTester.testFieldDAO();
                daoTester.testSchemaToFieldDAO();
                daoTester.testRangeDAO();
                daoTester.testRangeDataDAO();
                daoTester.testSchemaViewDAO();
                daoTester.testProtocolDAO();
                daoTester.testRuleDefinitionDAO();
                daoTester.testProtocolToRuleDAO();
                daoTester.testRuleToFieldDAO();
                daoTester.testValidationMessageDAO();
                daoTester.testProtocolViewDAO();
                daoTester.testDataRecordDAO();
                daoTester.testValidationRunDAO();
                daoTester.testRuleOutputDAO();
                daoTester.testRuleOutputDetailDAO();
                daoTester.testReferenceFieldDAO();
            }
            this.logAllDynamicFolder();
        } else if (command.hasOption(WRITE)) {
            String daoName = command.getOptionValue(WRITE);
            logger.info("Testing DAO = " + daoName);
            if ("data".equalsIgnoreCase(daoName)) {
                daoWriter.testDataRecordDAO();
            }
            if ("run".equalsIgnoreCase(daoName)) {
                daoWriter.testValidationRunDAO();
            }
            if ("output".equalsIgnoreCase(daoName)) {
                daoWriter.testRuleOutputDAO();
            }
            if ("detail".equalsIgnoreCase(daoName)) {
                daoWriter.testRuleOutputDetailDAO();
            }
            if ("custom".equalsIgnoreCase(daoName)) {
                daoWriter.testCustomDAO();
            }
        } else if (command.hasOption(RANGE)) {
            String[] params = command.getOptionValues(RANGE);
            String fromValue = params[0];
            String toValue = params[1];
            logger.info("Running range producer test using range ends: " + fromValue + "-" + toValue);
            RangeProducer produder = new RangeProducer();
            String value = new String(fromValue);
            ArrayList<String> result = new ArrayList<String>();
            while (!value.equalsIgnoreCase(toValue)) {
                result.add(value);
                value = produder.incrementAlphaNumeric(value, true);
            }
            result.add(toValue);
            String sep = "";
            StringBuilder builder = new StringBuilder();
            for (String string : result) {
                builder.append(sep);
                builder.append(string);
                sep = ", ";
            }
            logger.info("Produced range: " + String.valueOf(builder));
        } else if (command.hasOption(RULE)) {
            logger.info(">>>>>>>>>>> Testing a single rule\n");
            IsBiggerThanRule myRule = new IsBiggerThanRule(RuleDefinition.UNDEF);
            String argument = command.getOptionValue(RULE);
            int ruleID = this.parseIntegerValue(argument);
            if (ruleID > 0) {
                logger.info("Testing ruleID: " + ruleID);
            } else if (ruleID == 0) {
                logger.info("Unit test of the rule: " + String.valueOf(myRule));
            } else {
                logger.info("Testing default rule (hard-coded in the EngineTester class). RuleID: " + ruleID);
            }
            if (ruleID > 0) {
                engineTester.testSingleRule(ruleID);
            } else {
                ArrayList<RuleParameter> targetFields = new ArrayList<RuleParameter>(){
                    {
                        this.add(new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_YEAR_FU.id, false));
                        this.add(new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id, false));
                    }
                };
                myRule.getRuleConfiguration().setRuleParameters((List<RuleParameter>)targetFields);
                engineTester.testSingleRule(myRule);
            }
        } else if (command.hasOption(ENGINE)) {
            String argument = command.getOptionValue(ENGINE);
            int protocolID = this.parseIntegerValue(argument);
            if (protocolID > 0) {
                logger.info("Testing protocolID: " + protocolID);
            } else {
                protocolID = 11;
                logger.info("Testing hard-coded protocol: " + protocolID);
            }
            ValidationEngine validationEngine = new ValidationEngine();
            validationEngine.setProtocolView(protocolID);
            this.logHorizontalLine();
            logger.info("TEST SINGLE PROTOCOL");
            logger.info("");
            validationEngine.run();
        } else if (command.hasOption(SORTER)) {
            int max;
            logger.info("");
            logger.info("Testing External Sorter utility");
            String baseDirectory = "temp";
            String fileName = "unsorted.txt";
            FileConnection fileConnection = new FileConnection(fileName, baseDirectory);
            FileHandlerCSV fileHandler = new FileHandlerCSV(fileConnection);
            fileConnection.setAppend(false);
            fileConnection.setTemporary(true);
            fileConnection.setWriteAccess(true);
            String[] headerArray = new String[]{"FIRST", "SECOND", "THIRD", "ORIGINAL_POSITION"};
            DataRecordCSV headerRecord = new DataRecordCSV(headerArray);
            ArrayList<DataRecordCSV> list = new ArrayList<DataRecordCSV>();
            list.add(headerRecord);
            for (int i = max = 20; i > 1; --i) {
                int index = i % 2 == 0 ? i : max - i;
                String value = Integer.toString(index);
                String[] array = new String[]{value, "second_" + value, "third_" + value, Integer.toString(i)};
                DataRecordCSV record = new DataRecordCSV(array);
                list.add(record);
            }
            fileHandler.writeFile(list);
            ExternalSorter sorterObj = new ExternalSorter(baseDirectory);
            sorterObj.setBunchSize(10);
            sorterObj.setAlphaNumeric(false);
            sorterObj.setAddLineNumber(false);
            String filePath = baseDirectory + "/" + fileName;
            long startTime = System.currentTimeMillis();
            String orderedFileName = sorterObj.sortFile(filePath, "FIRST");
            long endTime = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info("Sorted file \"" + orderedFileName + "\" in " + (endTime - startTime) + " ms");
            }
        }
    }

    protected int parseIntegerValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected boolean parseBooleanValue(String value) {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void logAllDynamicFolder() {
        Map<String, HashSet<String>> dynamicDirectories = DynamicFileConnection.getDynamicDirectories();
        logger.info("");
        logger.info("Dynamic parent directories: " + dynamicDirectories.size());
        logger.info("");
        int index = 0;
        for (Map.Entry<String, HashSet<String>> parentDirectory : dynamicDirectories.entrySet()) {
            String parentName = parentDirectory.getKey();
            HashSet<String> subDirectories = parentDirectory.getValue();
            logger.info(++index + ") " + parentName);
            for (String directory : subDirectories) {
                logger.info("\t" + directory);
            }
        }
    }
}

