/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.Message;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericTester {
    protected long startTime;
    protected static final String HELP = "help";
    protected static final String AID = "aid";
    protected PrintWriter writer;
    protected boolean dump;
    protected String dumpFile;
    protected String dumpPath = "./logs";
    protected static Logger logger = LoggerFactory.getLogger(GenericTester.class);

    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(HELP, options);
        System.out.println();
    }

    protected void startCronwatch() {
        this.startTime = System.currentTimeMillis();
    }

    protected void stopCronwatch() {
        long delta = System.currentTimeMillis() - this.startTime;
        if (logger.isInfoEnabled()) {
            logger.info("Benchmark time: " + delta + " [ms]");
        }
    }

    protected void delay(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            logger.error("delay(): error while sleeping");
            e.printStackTrace();
        }
    }

    protected void logHorizontalLine() {
        if (logger.isInfoEnabled()) {
            logger.info("");
            logger.info("---------------------------------------------------------------------------------------");
        }
    }

    protected void openDumpFile(String fileName, String header) {
        this.dumpFile = fileName;
        this.openDumpFile(header);
    }

    protected void openDumpFile(String header) {
        if (this.dump) {
            String file = this.dumpPath + "/" + this.dumpFile;
            try {
                this.writer = new PrintWriter(file, "UTF-8");
                String headerLine = "*********   " + header + "   *********";
                this.writer.println(headerLine);
                for (int i = 0; i < headerLine.length(); ++i) {
                    this.writer.print("-");
                }
                this.writer.println("\n");
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                logger.error("Impossible to open dump file: " + e.getMessage());
            }
        } else {
            logger.warn("PrinterWriter not opened because dumping is disabled: check the 'dump' property");
        }
    }

    protected void closeDumpFile() {
        this.writer.close();
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public boolean isDump() {
        return this.dump;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public String getDumpFile() {
        return this.dumpFile;
    }

    public void setDumpFile(String dumpFile) {
        this.dumpFile = dumpFile;
    }

    public String getDumpPath() {
        return this.dumpPath;
    }

    public void setDumpPath(String dumpPath) {
        this.dumpPath = dumpPath;
    }

    protected String getModelsStatus(List<? extends GenericModel> list, String label, boolean orphan) {
        if (list == null || list.size() < 1) {
            return "Empty models list\n";
        }
        StringBuilder builder = new StringBuilder();
        for (GenericModel genericModel : list) {
            String modelStatus = this.getModelsStatus(genericModel, label, orphan);
            builder.append(modelStatus);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("getModelsStatus() - Checked " + String.valueOf(genericModel) + " (orphan ? " + orphan + ")");
        }
        if (builder.toString().trim().length() < 1) {
            return label + ": nothing to declare\n";
        }
        return builder.toString();
    }

    protected String getModelsStatus(GenericModel model, String label, boolean orphan) {
        String eol;
        String tab = "\t- ";
        String hyphen = " - ";
        StringBuilder builder = new StringBuilder();
        boolean verbose = false;
        if (verbose) {
            logger.info("getModelsStatus(): checking " + label + " status [orphan=" + orphan + "]");
        }
        if (orphan && !model.isUnreferred()) {
            if (logger.isTraceEnabled()) {
                logger.trace("getModelsStatus - Skipping orhan info for model: " + String.valueOf(builder));
            }
            return "";
        }
        builder.append(model.getModelLabel(null));
        Set<Message> errorMessages = model.getErrorMessages();
        Set<Message> warningMessages = model.getWarningMessages();
        if (verbose && errorMessages != null) {
            logger.info("getModelsStatus(): errorMessages = " + errorMessages.size());
        } else if (verbose) {
            logger.info("getModelsStatus(): no errorMessages");
        }
        if (verbose && errorMessages != null) {
            logger.info("getModelsStatus(): warningMessages = " + warningMessages.size());
        } else if (verbose) {
            logger.info("getModelsStatus(): no warningMessages");
        }
        if (errorMessages != null) {
            eol = "";
            builder.append(": INVALID\n");
            for (Message error : errorMessages) {
                builder.append(eol);
                builder.append(hyphen);
                builder.append(error.toShortString());
                eol = "\n";
            }
        }
        if (warningMessages != null) {
            if (errorMessages == null) {
                builder.append(": WARNING\n");
            } else {
                builder.append("\n");
                builder.append(hyphen);
                builder.append("Warnings:\n");
            }
            eol = "";
            for (Message warning : warningMessages) {
                builder.append(eol);
                builder.append(tab);
                builder.append(warning.toShortString());
                eol = "\n";
            }
        }
        if (errorMessages == null && warningMessages == null) {
            builder.append(" = OK");
        }
        builder.append("\n");
        return builder.toString();
    }
}

