/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DynamicFileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.Message;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.test.DAOReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileTester
extends DAOReader {
    protected static Set<Integer> incidenceRangeIds;
    protected static Set<Integer> mortalityRangeIds;
    protected static Set<Integer> testRangeIds;
    protected static Logger logger;

    public FlatFileTester() {
        this.init();
        incidenceRangeIds = new HashSet<Integer>();
        mortalityRangeIds = new HashSet<Integer>();
        testRangeIds = new HashSet<Integer>();
        incidenceRangeIds.addAll(Set.of(5, 6, 7, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 47, 50, 62));
        mortalityRangeIds.addAll(Set.of(Integer.valueOf(43), Integer.valueOf(61)));
        testRangeIds.addAll(Set.of(Integer.valueOf(915)));
    }

    public boolean checkFlatFilesConfiguration(int schemaID) {
        boolean verbose = logger.isTraceEnabled();
        verbose = true;
        boolean result = true;
        List<FlatFile> flatFileDAOs = this.getDynamicFlatFileDAOs();
        if (flatFileDAOs == null || flatFileDAOs.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("checkFlatFilesConfiguration() - Skipping check because there are not flat-file based DAOs");
            }
            return true;
        }
        String rangeDataFile = FlatFile.RANGE_DATA.name;
        if (verbose) {
            logger.info("checkFlatFilesConfiguration() - Adopting special condition for files: " + rangeDataFile);
        }
        for (FlatFile flatFile : flatFileDAOs) {
            if (flatFile.isTemporaryFile()) {
                if (!verbose) continue;
                logger.info("checkFlatFilesConfiguration() - Skipping existence of files like: " + flatFile.name);
                continue;
            }
            boolean isRangeDataFile = rangeDataFile.equalsIgnoreCase(flatFile.name);
            if (isRangeDataFile) {
                logger.info("checkFlatFilesConfiguration() - Skipping check on " + rangeDataFile + "files (not a sequence)");
                continue;
            }
            if (verbose) {
                logger.info("checkFlatFilesConfiguration() - Checking existence of files like: " + flatFile.name);
            }
            for (Schema schema : this.allSchemas) {
                int resourceID = schema.getId();
                if (schemaID > 0 && resourceID != schemaID) continue;
                result &= this.checkTargetDynamicFile(schema, flatFile, resourceID);
            }
        }
        Schema incidenceSchema = this.getSchemaById(1);
        Schema mortalitySchema = this.getSchemaById(2);
        Schema testSchema = this.getSchemaById(9);
        for (Integer rangeId : incidenceRangeIds) {
            result &= this.checkTargetDynamicFile(incidenceSchema, FlatFile.RANGE_DATA, rangeId);
        }
        for (Integer rangeId : mortalityRangeIds) {
            result &= this.checkTargetDynamicFile(mortalitySchema, FlatFile.RANGE_DATA, rangeId);
        }
        for (Integer rangeId : testRangeIds) {
            result &= this.checkTargetDynamicFile(testSchema, FlatFile.RANGE_DATA, rangeId);
        }
        for (Schema schema : this.allSchemas) {
            Set<Message> errors = schema.getErrorMessages();
            if (errors == null || errors.size() != flatFileDAOs.size()) continue;
            String message = "Impossible to validate configuration path: please check folders names";
            schema.addErrorMessage(message);
            logger.error(message);
        }
        if (logger.isInfoEnabled()) {
            logger.info("checkFlatFilesConfiguration() - Listing status of the flat-file based structure:");
            logger.info(this.getModelsStatus(this.allSchemas, "schema", false));
        }
        return result;
    }

    protected boolean checkTargetDynamicFile(Schema schema, FlatFile flatFile, int resourceID) {
        boolean valid = this.checkDynamicFile(flatFile, resourceID);
        if (!valid) {
            String message = "checkFlatFilesConfiguration() - File not found: " + flatFile.name;
            message = message + "for resource ID = " + resourceID;
            schema.addErrorMessage(message);
            logger.error(message);
            return false;
        }
        return true;
    }

    @Test
    public void checkAllFileHandlers() {
        this.logHorizontalLine();
        logger.info("TESTING DYNAMIC FLAT CONNECTIONS");
        logger.info("");
        Assertions.assertTrue((boolean)this.checkDynamicFile(FlatFile.FIELD, 5), (String)"Wrong or missing connection to DYNAMIC Field config file (resourceID=5)");
        Assertions.assertTrue((!this.checkDynamicFile(FlatFile.SCHEMA, 0) ? 1 : 0) != 0, (String)"Wrong or missing connection to DYNAMIC Schema config file");
        logger.info("");
        logger.info("TESTING RELATIVE FLAT CONNECTIONS (static)");
        logger.info("");
        Assertions.assertTrue((boolean)this.checkRelativeFile(FlatFile.SCHEMA), (String)"Wrong or missing connection to RELATIVE Schema config file");
        Assertions.assertTrue((!this.checkRelativeFile(FlatFile.FIELD) ? 1 : 0) != 0, (String)"Wrong or missing connection to RELATIVE Field config file");
        logger.info("");
        logger.info("TESTING ABSOLUTE FLAT CONNECTIONS (static)");
        logger.info("");
        String firstPath = "C:/Home/workspace/qcs-2.0/pom.xml";
        String secondPath = "C:/Home/workspace/qcs-2.0/not-existing.foo";
        Assertions.assertTrue((boolean)this.checkAbsoluteFile(firstPath), (String)"Wrong or missing resource linked by first ABSOLUTE path");
        Assertions.assertTrue((!this.checkAbsoluteFile(secondPath) ? 1 : 0) != 0, (String)"Wrong or missing resource linked by second ABSOLUTE path");
        logger.info("");
    }

    public boolean checkDynamicFile(FlatFile flatFile, int resourceID) {
        FileConnection fileConnection = FlatFileDAOFactory.getConnection(flatFile);
        if (!(fileConnection instanceof DynamicFileConnection)) {
            logger.error("checkDynamicFile() - FlatFile '" + flatFile.name + "' is not using a dynamic connection");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkDynamicFile() - Checking " + String.valueOf((Object)flatFile) + " (resourceID=" + resourceID + ")");
        }
        if (flatFile == FlatFile.RULE_DEFINITION || flatFile == FlatFile.PROTOCOL || flatFile == FlatFile.PROTOCOL_TO_RULE || flatFile == FlatFile.RULE_TO_FIELD) {
            return true;
        }
        DynamicFileConnection actualConnection = (DynamicFileConnection)fileConnection;
        actualConnection.openStreamFromDynamicPath(resourceID);
        InputStream inputStream = actualConnection.getInputStream();
        String fileName = actualConnection.getLastDynamicName();
        if (inputStream == null) {
            logger.error("checkDynamicFile() - Missing configuration path for FlatFile: " + String.valueOf((Object)flatFile) + " [resourceID=" + resourceID + "]");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkDynamicFile() - Resolved dynamic path for: " + fileName + " [" + String.valueOf(inputStream) + "]");
        }
        return true;
    }

    public boolean checkRelativeFile(FlatFile flatFile) {
        FileConnection fileConnection = FlatFileDAOFactory.getConnection(flatFile);
        fileConnection.openConnection();
        InputStream inputStream = fileConnection.getInputStream();
        String fileName = fileConnection.getFileName();
        if (inputStream == null) {
            logger.error("checkRelativeFile() - Wrong relative path for FlatFile: " + String.valueOf((Object)flatFile));
            return false;
        }
        logger.debug("checkRelativeFile() - Found resource using relative path for: " + fileName + " [" + String.valueOf(inputStream) + "]");
        return true;
    }

    public boolean checkAbsoluteFile(String path) {
        FileConnection fileConnection = new FileConnection(path);
        fileConnection.openConnection();
        InputStream inputStream = fileConnection.getInputStream();
        if (inputStream == null) {
            logger.error("checkAbsoluteFile() - Wrong absolute path: " + path);
            return false;
        }
        logger.info("checkAbsoluteFile() - Found valid absolute path: " + path + " [" + String.valueOf(inputStream) + "]");
        return true;
    }

    protected List<FlatFile> getDynamicFlatFileDAOs() {
        List<DAO> allDAOs = DAO.getAllDAOs();
        ArrayList<FlatFile> dynamicFlatFiles = new ArrayList<FlatFile>();
        for (DAO dao : allDAOs) {
            FlatFile flatFile = dao.fileDAO;
            boolean dynamic = flatFile.isDynamic();
            if (!dynamic) continue;
            dynamicFlatFiles.add(flatFile);
        }
        return dynamicFlatFiles;
    }

    protected Schema getSchemaById(int schemaId) {
        for (Schema schema : this.allSchemas) {
            if (schema.getId() != schemaId) continue;
            return schema;
        }
        return Schema.UNDEF;
    }

    static {
        logger = LoggerFactory.getLogger(FlatFileTester.class);
    }
}

