/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.input.DataConnection;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleScope;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleTarget;
import eu.europa.ec.jrc.qcs.engine.DataSetReader;
import eu.europa.ec.jrc.qcs.engine.RawFilesWriter;
import eu.europa.ec.jrc.qcs.engine.RulesFactory;
import eu.europa.ec.jrc.qcs.engine.ValidationEngine;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultFieldIDencr2014;
import eu.europa.ec.jrc.qcs.engine.rule.AbstractRule;
import eu.europa.ec.jrc.qcs.engine.rule.RuleConfiguration;
import eu.europa.ec.jrc.qcs.engine.rule.RuleParameter;
import eu.europa.ec.jrc.qcs.engine.rule.basic.FileEncodingRule;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.GenericCrossRecordRule;
import eu.europa.ec.jrc.qcs.test.GenericTester;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineTester
extends GenericTester {
    private RulesFactory ruleExecutor;
    private DataSetReader dataSetReader;
    protected RuleDefinitionDAO ruleDAO = null;
    protected static Logger logger = LoggerFactory.getLogger(EngineTester.class);

    public EngineTester() {
        this.init();
    }

    protected void init() {
        this.ruleExecutor = new RulesFactory();
        this.ruleExecutor.setVerbose(false);
        this.dataSetReader = new DataSetReader();
        this.dataSetReader.setMaxRows(10);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        this.ruleDAO = (RuleDefinitionDAO)((Object)daoFactory.getDAO(DAO.RULE_DEFINITION));
    }

    public void testSingleRule(int ruleID) {
        RuleDefinition ruleDefinition = null;
        AbstractRule rule = null;
        FileEncodingRule defaultRule = new FileEncodingRule(RuleDefinition.UNDEF);
        if (ruleID > 0) {
            ruleDefinition = (RuleDefinition)this.ruleDAO.getByID(ruleID);
            rule = this.ruleExecutor.getRuleImplementation(ruleDefinition);
        }
        if (rule == null) {
            rule = defaultRule;
            if (ruleDefinition == null) {
                ruleDefinition = RuleDefinition.UNDEF;
            }
            logger.warn("Failed fetching rule from DAO layer -> testing default rule:" + String.valueOf(defaultRule));
        } else {
            logger.info("Rule created via Java Reflection         : " + String.valueOf(rule));
        }
        this.logHorizontalLine();
        logger.info("RULE DEFINITION");
        logger.info("");
        logger.info("Rule ID                                  : " + ruleID);
        logger.info("RuleDefinition                           : " + String.valueOf(ruleDefinition));
        logger.info("Rule concrete implementation             : " + String.valueOf(rule));
        this.testSingleRule(rule);
    }

    public List<RuleOutput> testSingleRule(AbstractRule rule) {
        ArrayList<RuleParameter> targetFields;
        this.logHorizontalLine();
        logger.info("TESTING RULE: " + rule.getName().toUpperCase());
        logger.info("");
        boolean printResults = true;
        boolean produceRawFiles = true;
        boolean validate = true;
        boolean targetFieldIDs = false;
        boolean targetParameters = false;
        RuleConfiguration ruleConfiguration = rule.getRuleConfiguration();
        RuleScope ruleScope = ruleConfiguration.getRuleScope();
        logger.info("Rule's scope                             : " + String.valueOf((Object)ruleScope));
        if (ruleConfiguration.getValidationMessage() != null) {
            logger.info("Validation message                       : " + ruleConfiguration.getValidationMessage().getCode());
        }
        logger.info("Default schema                           : " + String.valueOf(ruleConfiguration.getDefaultSchemaView()));
        logger.info("Target schema                            : " + String.valueOf(ruleConfiguration.getTargetSchemaView()));
        logger.info("Configuration path                       : " + ruleConfiguration.getConfigurationPath());
        logger.info("Configuration files                      : " + String.valueOf(ruleConfiguration.getConfigurationFiles()));
        logger.info("Preparatory rules                        : " + String.valueOf(ruleConfiguration.getPreparatoryRuleIDs()));
        logger.info("");
        logger.info("Dataset file's path                      : " + this.dataSetReader.getFilePath());
        logger.info("Testing options                          : [validate=" + validate + ", targetFieldIDs=" + targetFieldIDs + ", targetParameters=" + targetParameters + "]");
        if (targetFieldIDs) {
            targetFields = new ArrayList<RuleParameter>(){
                {
                    this.add(new RuleParameter(DefaultFieldIDencr2014.INCIDENCE_SEX.id));
                    this.add(new RuleParameter(DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id));
                }
            };
            ruleConfiguration.setRuleParameters((List<RuleParameter>)targetFields);
            ruleConfiguration.setRuleTarget(RuleTarget.SOME_FIELDS);
            logger.info("Target fields for basic check            : " + RuleParameter.getFormattedFieldIDs((List<RuleParameter>)targetFields));
        }
        if (targetParameters) {
            targetFields = new ArrayList<RuleParameter>(){
                {
                    this.add(new RuleParameter(1, DefaultFieldIDencr2014.INCIDENCE_YEAR_FU.id, false));
                    this.add(new RuleParameter(2, DefaultFieldIDencr2014.INCIDENCE_YEAR_DOI.id, false));
                }
            };
            ruleConfiguration.setRuleParameters((List<RuleParameter>)targetFields);
            ruleConfiguration.setRuleTarget(RuleTarget.SOME_FIELDS);
            logger.info("Target parameters for cross-field check  : " + RuleParameter.getFormattedRuleParameters((List<RuleParameter>)targetFields));
        }
        if (validate && !rule.validate()) {
            logger.info("");
            logger.error("Test stopped - Invalid rule: " + String.valueOf(rule));
            return RuleOutput.INVALID;
        }
        logger.info("");
        List<RuleOutput> result = RuleOutput.INVALID;
        switch (ruleScope) {
            case FILE_METADATA: 
            case FILE_FORMAT: 
            case ALL_RECORDS: {
                result = this.testDataConnectionRule(rule);
                break;
            }
            case HEADER: {
                result = this.testHeaderRule(rule);
                break;
            }
            case RECORD: {
                result = this.testDataRecordRule(rule);
                break;
            }
            default: {
                String message = "Rule scope has not been identified: skipping rule";
                logger.error(message);
            }
        }
        logger.info("");
        if (result == RuleOutput.VALID) {
            logger.info("Rule's result                            : VALID");
            return RuleOutput.VALID;
        }
        char suffix = result.size() > 1 ? (char)'s' : ' ';
        logger.info("Rule's result                            : " + result.size() + " output" + suffix);
        logger.info("");
        int errorNumber = 0;
        if (printResults) {
            for (RuleOutput ruleOutput : result) {
                logger.info(++errorNumber + ") " + ruleOutput.getCSVRepresentation());
                logger.info("");
                List<RuleOutputDetail> outputDetailsList = ruleOutput.getAllRuleOutputDetail();
                if (outputDetailsList == null || outputDetailsList.size() <= 0) continue;
                for (RuleOutputDetail ruleOutputDetail : outputDetailsList) {
                    logger.info("\t\t" + ruleOutputDetail.getCSVRepresentation());
                }
                logger.info("");
            }
        }
        if (produceRawFiles) {
            int protocolID = 1;
            int lineNumber = 666;
            ValidationEngine validationEngine = new ValidationEngine();
            validationEngine.setProtocolView(protocolID);
            validationEngine.initDataAccessors();
            RawFilesWriter rawFilesWriter = validationEngine.getRawFilesWriter();
            long start = new Date().getTime();
            rawFilesWriter.saveRuleOutputDetail(rule, lineNumber, result);
            long end = new Date().getTime();
            logger.info("");
            logger.info("Time for saving rule output: " + (end - start) + " ms");
        }
        return result;
    }

    private List<RuleOutput> testDataConnectionRule(AbstractRule rule) {
        DataConnection connection = this.dataSetReader.getDataConnection();
        if (logger.isInfoEnabled()) {
            logger.info("Testing a DataConnection based rule");
        }
        if (rule instanceof GenericCrossRecordRule) {
            GenericCrossRecordRule crossRecordRule = (GenericCrossRecordRule)rule;
            if (logger.isInfoEnabled()) {
                logger.info("testDataConnectionRule() - GenericCrossRecordRule with WhereCondition: " + crossRecordRule.hasWhereCondition());
            }
            ValidationEngine validationEngine = new ValidationEngine();
            validationEngine.sortDataSet(crossRecordRule);
        }
        rule.setRuleInput(connection);
        return rule.check();
    }

    private List<RuleOutput> testHeaderRule(AbstractRule rule) {
        DataRecord header = this.dataSetReader.getHeader();
        if (logger.isInfoEnabled()) {
            logger.info("Testing an Header based rule");
        }
        rule.setRuleInput(header);
        List<RuleOutput> output = rule.check();
        int validationRunID = 42;
        this.addRunInformation(validationRunID, output, 0, 0);
        return output;
    }

    private List<RuleOutput> testDataRecordRule(AbstractRule rule) {
        DataRecord record;
        boolean verbose = true;
        int numberOfErrors = 0;
        this.dataSetReader.resetDataset();
        if (logger.isInfoEnabled()) {
            logger.info("Testing a DataRecord based rule");
        }
        List<RuleOutput> result = new ArrayList<RuleOutput>();
        while (this.dataSetReader.hasNext() && (record = this.dataSetReader.getNextDataRecord()) != null) {
            int lineNumber = this.dataSetReader.getCounter();
            if (verbose && lineNumber == 2) {
                logger.info("List of DataRecord objects (indexed by line number) and related rule's output:");
                logger.info("");
            }
            List<RuleOutput> output = rule.check(record);
            if (verbose && output != null && output.size() > 0) {
                logger.info(lineNumber + ") " + record.toShortString() + " --> errors: " + output.size());
            }
            int validationRunID = 42;
            numberOfErrors = this.addRunInformation(validationRunID, output, lineNumber, numberOfErrors);
            result.addAll(output);
        }
        if (result.size() == 0) {
            result = RuleOutput.VALID;
        }
        return result;
    }

    private int addRunInformation(int validationRunID, List<RuleOutput> output, int lineNumber, int numberOfErrors) {
        for (RuleOutput ruleOutput : output) {
            Object details;
            ruleOutput.setId(++numberOfErrors);
            ruleOutput.setLineNumber(lineNumber);
            ruleOutput.setValidationRunID(validationRunID);
            List<RuleOutputDetail> ruleOutputDetail = ruleOutput.getAllRuleOutputDetail();
            if (ruleOutputDetail != null && ruleOutputDetail.size() > 0) {
                String suffix = ruleOutputDetail.size() > 1 ? " details" : " detail";
                details = " (" + ruleOutputDetail.size() + suffix + ")";
            } else {
                details = " (no details)";
            }
            logger.info("-> output: " + ruleOutput.getCSVRepresentation() + (String)details);
        }
        return numberOfErrors;
    }

    public RulesFactory getRuleExecutor() {
        return this.ruleExecutor;
    }

    public void setRuleExecutor(RulesFactory ruleExecutor) {
        this.ruleExecutor = ruleExecutor;
    }

    public DataSetReader getDataSetReader() {
        return this.dataSetReader;
    }

    public void setDataSetReader(DataSetReader dataSetReader) {
        this.dataSetReader = dataSetReader;
    }
}

