/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.dao.dto.Field;
import eu.europa.ec.jrc.qcs.dao.dto.Protocol;
import eu.europa.ec.jrc.qcs.dao.dto.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.dto.Range;
import eu.europa.ec.jrc.qcs.dao.dto.RangeData;
import eu.europa.ec.jrc.qcs.dao.dto.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.dto.ReportType;
import eu.europa.ec.jrc.qcs.dao.dto.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.dto.RuleTarget;
import eu.europa.ec.jrc.qcs.dao.dto.RuleToField;
import eu.europa.ec.jrc.qcs.dao.dto.Schema;
import eu.europa.ec.jrc.qcs.dao.dto.SchemaGroup;
import eu.europa.ec.jrc.qcs.dao.dto.SchemaToField;
import eu.europa.ec.jrc.qcs.test.DbSanityCheckConfig;
import jakarta.persistence.TypedQuery;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSanityCheck {
    protected static Logger logger = LoggerFactory.getLogger(DbSanityCheck.class);

    public static void main(String[] args) {
        Set dtoViolationSet;
        ValidatorFactory validatorFactory = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        DbSanityCheckConfig config = new DbSanityCheckConfig();
        TypedQuery query = config.getEntityManager().createNamedQuery("field.getAll", Field.class);
        List listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.info("dto: " + dtoViolation.getMessage() + " (was " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        if (config.isCheck_model()) {
            // empty if block
        }
        query = config.getEntityManager().createNamedQuery("ruleDefinition.getAll", RuleDefinition.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (id: " + ((RuleDefinition)dtoViolation.getInvalidValue()).getId() + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("schema.getAll", Schema.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (!dtoViolationSet.isEmpty()) {
                    for (ConstraintViolation dtoViolation : dtoViolationSet) {
                        logger.warn("dto: " + dtoViolation.getMessage() + " (id: " + ((Schema)dtoViolation.getInvalidValue()).getId() + ")");
                    }
                }
                List<SchemaToField> l = ((Schema)dto).getSchemaToField();
                int i = 1;
                if (((Schema)dto).getParent() != null) {
                    Schema s = ((Schema)dto).getParent();
                    List<SchemaToField> lStf = s.getSchemaToField();
                    int c = 0;
                    for (SchemaToField schemaToField : lStf) {
                        if (schemaToField.getFunction().booleanValue()) continue;
                        ++c;
                    }
                    i = c + 1;
                }
                for (SchemaToField schemaToField : l) {
                    if (!schemaToField.getFunction().booleanValue() && i != schemaToField.getPosition()) {
                        logger.error("dto: SchemaToField " + schemaToField.getId() + " is not following the numeration");
                    }
                    ++i;
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("schemaToField.getAll", SchemaToField.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("protocol.getAll", Protocol.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("protocolToRule.getAll", ProtocolToRule.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("range.getAll", Range.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("rangeData.getAll", RangeData.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("referenceField.getAll", ReferenceField.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("reportType.getAll", ReportType.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("ruleTarget.getAll", RuleTarget.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("ruleToField.getAll", RuleToField.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
        query = config.getEntityManager().createNamedQuery("schemaGroup.getAll", SchemaGroup.class);
        listDTO = query.getResultList();
        if (config.isCheck_dto()) {
            for (Object dto : listDTO) {
                dtoViolationSet = validator.validate(dto, new Class[0]);
                if (dtoViolationSet.isEmpty()) continue;
                for (ConstraintViolation dtoViolation : dtoViolationSet) {
                    logger.warn("dto: " + dtoViolation.getMessage() + " (value: " + String.valueOf(dtoViolation.getInvalidValue()) + ")");
                }
            }
        }
    }
}

