/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.dao.DataRecordDAO;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDAO;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDetailDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationRunDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.DataRecordDAOImpl;
import eu.europa.ec.jrc.qcs.dao.file.RuleOutputDAOImpl;
import eu.europa.ec.jrc.qcs.dao.file.RuleOutputDetailDAOImpl;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceData;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.test.GenericTester;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOWriter
extends GenericTester {
    protected DAOFactory daoFactory = DAOFactory.getDAOFactory();
    protected static Logger logger = LoggerFactory.getLogger(DAOWriter.class);

    public void testDataRecordDAO() {
        this.logHorizontalLine();
        logger.info("TESTING DATA_RECORD DAO");
        DAO targetResource = DAO.DATA_RECORD_CORRECT;
        DataRecordDAO recordReaderDAO = (DataRecordDAO)((Object)this.daoFactory.getDAO(DAO.DATA_RECORD));
        DataRecordDAO recordWriterDAO = (DataRecordDAO)((Object)this.daoFactory.getDAO(targetResource));
        ValidationRunDAO validationRunDAO = (ValidationRunDAO)((Object)this.daoFactory.getDAO(DAO.VALIDATION_RUN));
        boolean verbose = true;
        String inputFilePath = "C:/Home/Workspace/test-suite/input/encr/2014/incidence/incidence_2.csv";
        recordReaderDAO.setDataConnection(new FileConnection(inputFilePath));
        logger.info("");
        logger.info(">>> Reading all lines from dataset: " + inputFilePath);
        List allRecords = recordReaderDAO.getAll();
        DataRecord header = recordReaderDAO.getHeader();
        logger.info("Number of records in dataset      : " + allRecords.size());
        if (verbose) {
            logger.info("");
            logger.info(">>> Dataset's header:");
            logger.info(header.toString());
        }
        DataRecord record_1 = (DataRecord)allRecords.get(0);
        logger.info("");
        logger.info(">>> 1st Record's sample data:");
        logger.info(record_1.toShortString());
        DataRecord newHeader = header.clone();
        DataRecord newRecord = record_1.clone();
        newHeader.unshift("Not used", "Line_Number");
        newRecord.unshift("Line_Number", "Placeholder");
        recordWriterDAO.setHeader(newHeader);
        int maxValidationRunID = validationRunDAO.getMaxID();
        int nextValidationRunID = maxValidationRunID + 1;
        logger.info("");
        logger.info("Max validationRunID " + maxValidationRunID);
        int records = allRecords.size();
        recordWriterDAO.init(nextValidationRunID);
        logger.info("");
        logger.info("Saving " + records + " records for validationRunID  : " + nextValidationRunID);
        logger.info("Target file                            : " + targetResource.fileDAO.name);
        int indexIn = 9;
        int indexOut = indexIn + 1;
        String valueAsString = record_1.getValue(indexIn);
        int value = Integer.parseInt(valueAsString);
        if (verbose) {
            logger.info("");
            logger.info("Sample value from 1st record (index=" + indexIn + ") : " + value);
            logger.info("(will be modified in order to test the \"setValue()\" method)");
        }
        recordWriterDAO.openConnection();
        int counter = 0;
        boolean saved = true;
        for (DataRecord record : allRecords) {
            newRecord = record.clone();
            newRecord.unshift("Line_Number", "Placeholder");
            String lineNumber = String.valueOf(++counter + 1);
            newRecord.setValue(0, lineNumber);
            valueAsString = String.valueOf(value + counter);
            newRecord.setValue(indexOut, valueAsString);
            if (recordWriterDAO.save(newRecord)) continue;
            saved = false;
        }
        Assertions.assertTrue((boolean)saved, (String)"Error writing DataRecord through the \"recordWriterDAO\"");
        recordWriterDAO.closeConnection();
        logger.info("");
        logger.info("testDataRecordDAO: completed\n");
    }

    public void testValidationRunDAO() {
        this.logHorizontalLine();
        logger.info("TESTING VALIDATION_RUN DAO");
        logger.info("");
        ValidationRunDAO validationRunDAO = (ValidationRunDAO)((Object)this.daoFactory.getDAO(DAO.VALIDATION_RUN));
        int maxValidationRunID = validationRunDAO.getMaxID();
        logger.info("");
        logger.info("Maximum ValidationRunID: " + maxValidationRunID);
        ValidationRun run_3 = new ValidationRun("1st Dataset", new Date(), new Date(), "100", "50", "0", "", "10", "20", "scott", "1");
        ValidationRun run_4 = new ValidationRun("2nd Dataset", new Date(), new Date(), "200", "190", "2", "", "15", "30", "tiger", "1");
        logger.info("");
        logger.info("Saving two validation runs:");
        logger.info("1st validation run: " + run_3.toString());
        logger.info("1st validation run: " + run_4.toString());
        validationRunDAO.save(run_3);
        validationRunDAO.save(run_4);
        Assertions.assertTrue((run_3.getId() == maxValidationRunID + 1 ? 1 : 0) != 0, (String)"ID of the next ValidationRun differs from expected one");
        Assertions.assertTrue((run_4.getId() == maxValidationRunID + 2 ? 1 : 0) != 0, (String)"ID of the next-next ValidationRun differs from expected one");
        logger.info("");
        logger.info("testValidationRunDAO: completed\n");
    }

    public void testRuleOutputDAO() {
        this.logHorizontalLine();
        logger.info("TESTING RULE_OUTPUT DAO");
        RuleOutputDAO ruleOutputDAO = (RuleOutputDAO)((Object)this.daoFactory.getDAO(DAO.RULE_OUTPUT));
        ValidationRunDAO validationRunDAO = (ValidationRunDAO)((Object)this.daoFactory.getDAO(DAO.VALIDATION_RUN));
        boolean verbose = true;
        boolean createNewFile = false;
        int maxRuleOutputID = ruleOutputDAO.getMaxID();
        int maxValidationRunID = validationRunDAO.getMaxID();
        if (verbose) {
            logger.info("");
            logger.info("Maximum ValidationRunID : " + maxValidationRunID);
            logger.info("Maximum RuleOutputID    : " + maxRuleOutputID);
        }
        int firstMessageNumber = maxRuleOutputID - 298;
        logger.info("First message number    : " + firstMessageNumber);
        String json = "{PatID:\"11\", TumID:\"2\", Topo:\"C341\", Morpho:\"8000\", Beh:\"3\", Sex:\"1\", MoI:\"9\", YoI:\"2000\", MoB:\"10\", YoB:\"1932\"}";
        ReferenceData referenceData = new ReferenceData(json);
        String lastValidationRunID = String.valueOf(maxValidationRunID);
        String messageNumber_1 = String.valueOf(firstMessageNumber);
        String messageNumber_2 = String.valueOf(firstMessageNumber + 1);
        String messageNumber_3 = String.valueOf(firstMessageNumber + 2);
        RuleOutput ruleOutput_1 = new RuleOutput(messageNumber_1, "1", "N", DefaultRuleID.FIELD_DATA_TYPE.getID(), "E-CODA", "ERROR", "A_1 error line 1", referenceData, lastValidationRunID);
        RuleOutput ruleOutput_2 = new RuleOutput(messageNumber_2, "2", "Y", DefaultRuleID.FIELD_MANDATORY.getID(), "E-CODE", "WARNING", "B_1 error line 2", referenceData, lastValidationRunID);
        RuleOutput ruleOutput_3 = new RuleOutput(messageNumber_3, "2", "Y", DefaultRuleID.FIELD_MAX_SIZE.getID(), "E-CODE", "WARNING", "B_2 error line 2", referenceData, lastValidationRunID);
        ((RuleOutputDAOImpl)ruleOutputDAO).setCurrentValidationRunID(maxValidationRunID);
        ruleOutputDAO.openConnection();
        logger.info("");
        logger.info("Saving 3 rule outputs one by one...");
        ruleOutputDAO.save(ruleOutput_1);
        ruleOutputDAO.save(ruleOutput_2);
        ruleOutputDAO.save(ruleOutput_3);
        logger.info("Successfully saved 3 records for validation run: " + lastValidationRunID);
        Assertions.assertTrue((ruleOutput_1.getId() == maxRuleOutputID + 1 ? 1 : 0) != 0, (String)"ID of the 1st RuleOutput differs from expected one");
        Assertions.assertTrue((ruleOutput_2.getId() == maxRuleOutputID + 2 ? 1 : 0) != 0, (String)"ID of the 2nd RuleOutput differs from expected one");
        Assertions.assertTrue((ruleOutput_3.getId() == maxRuleOutputID + 3 ? 1 : 0) != 0, (String)"ID of the 3rd RuleOutput differs from expected one");
        int messageNumber = createNewFile ? 1 : firstMessageNumber + 3;
        int nextValidationRunID = maxValidationRunID + (createNewFile ? 1 : 0);
        logger.info("");
        logger.info("Writing new file ? " + createNewFile);
        logger.info("Writing data for validaton run ID: " + nextValidationRunID);
        if (createNewFile) {
            ruleOutputDAO.closeConnection();
            ruleOutputDAO.init(nextValidationRunID);
            ruleOutputDAO.openConnection();
        }
        ArrayList<RuleOutput> records = new ArrayList<RuleOutput>();
        records.add(ruleOutput_1);
        records.add(ruleOutput_2);
        records.add(ruleOutput_3);
        for (RuleOutput ruleOutput : records) {
            ruleOutput.setMessageNumber(messageNumber++);
            ruleOutput.setValidationRunID(nextValidationRunID);
        }
        logger.info("");
        logger.info("Saving 3 rule outputs as a list...");
        int saved = ruleOutputDAO.save(records);
        logger.info("Successfully saved " + saved + " records for validation run: " + nextValidationRunID);
        ruleOutputDAO.closeConnection();
        logger.info("");
        logger.info("testRuleOutputDAO: completed\n");
    }

    public void testRuleOutputDetailDAO() {
        this.logHorizontalLine();
        logger.info("TESTING RULE_OUTPUT_DETAIL DAO");
        RuleOutputDetailDAO ruleOutputDetailDAO = (RuleOutputDetailDAO)((Object)this.daoFactory.getDAO(DAO.RULE_OUTPUT_DETAIL));
        RuleOutputDAO ruleOutputDAO = (RuleOutputDAO)((Object)this.daoFactory.getDAO(DAO.RULE_OUTPUT));
        ValidationRunDAO validationRunDAO = (ValidationRunDAO)((Object)this.daoFactory.getDAO(DAO.VALIDATION_RUN));
        boolean verbose = true;
        boolean createNewFile = false;
        int maxValidationRunID = validationRunDAO.getMaxID();
        int maxRuleOutputID = ruleOutputDAO.getMaxID();
        int maxRuleOutputDetailID = ruleOutputDetailDAO.getMaxID();
        if (verbose) {
            logger.info("");
            logger.info("Maximum ValidationRunID    : " + maxValidationRunID);
            logger.info("Maximum RuleOutputID       : " + maxRuleOutputID);
            logger.info("Maximum RuleOutputDetailID : " + maxRuleOutputDetailID);
        }
        String lastRuleOutputID = String.valueOf(maxRuleOutputID);
        RuleOutputDetail ruleOutputDetail_3 = new RuleOutputDetail("12", "Field-12 (dao_write_test)", "42", lastRuleOutputID);
        RuleOutputDetail ruleOutputDetail_4 = new RuleOutputDetail("14", "Field-14 (dao_write_test)", "43", lastRuleOutputID);
        RuleOutputDetail ruleOutputDetail_5 = new RuleOutputDetail("16", "Field-16 (dao_write_test)", "44", lastRuleOutputID);
        ((RuleOutputDetailDAOImpl)ruleOutputDetailDAO).setCurrentValidationRunID(maxValidationRunID);
        ruleOutputDetailDAO.openConnection();
        logger.info("");
        logger.info("Saving 3 records (one by one):");
        logger.info("1st RuleOutputDetail: " + String.valueOf(ruleOutputDetail_3));
        logger.info("2nd RuleOutputDetail: " + String.valueOf(ruleOutputDetail_4));
        logger.info("3nd RuleOutputDetail: " + String.valueOf(ruleOutputDetail_5));
        ruleOutputDetailDAO.save(ruleOutputDetail_3);
        ruleOutputDetailDAO.save(ruleOutputDetail_4);
        ruleOutputDetailDAO.save(ruleOutputDetail_5);
        logger.info("Successfully saved 3 records for RuleOutputID: " + lastRuleOutputID);
        Assertions.assertTrue((ruleOutputDetail_3.getId() == maxRuleOutputDetailID + 1 ? 1 : 0) != 0, (String)"ID of the 1st RuleOutputDetail differs from expected one");
        Assertions.assertTrue((ruleOutputDetail_4.getId() == maxRuleOutputDetailID + 2 ? 1 : 0) != 0, (String)"ID of the 2nd RuleOutputDetail differs from expected one");
        Assertions.assertTrue((ruleOutputDetail_5.getId() == maxRuleOutputDetailID + 3 ? 1 : 0) != 0, (String)"ID of the 3rd RuleOutputDetail differs from expected one");
        int nextValidationRunID = maxValidationRunID + (createNewFile ? 1 : 0);
        logger.info("");
        logger.info("Writing new file ? " + createNewFile);
        logger.info("Writing data for validaton run ID: " + nextValidationRunID);
        if (createNewFile) {
            ruleOutputDetailDAO.closeConnection();
            ruleOutputDetailDAO.init(nextValidationRunID);
            ruleOutputDetailDAO.openConnection();
        }
        ArrayList<RuleOutputDetail> records = new ArrayList<RuleOutputDetail>();
        records.add(ruleOutputDetail_3);
        records.add(ruleOutputDetail_4);
        records.add(ruleOutputDetail_5);
        logger.info("");
        logger.info("Saving 3 records (as list):");
        int saved = ruleOutputDetailDAO.save(records);
        logger.info("Successfully saved " + saved + " records for RuleOutputID: " + lastRuleOutputID);
        ruleOutputDetailDAO.closeConnection();
        logger.info("");
        logger.info("testRuleOutputDetailDAO: completed\n");
    }

    public void testCustomDAO() {
        this.logHorizontalLine();
        logger.info("TESTING CUSTOM DAO");
        logger.info("");
        String reportName = "QCS-After-MPMT-Deletion.csv";
        String reportFolder = "output/incidence/";
        String filePath = reportFolder + reportName;
        boolean deleted = false;
        File file = new File(filePath);
        try {
            deleted = Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            logger.error("Error deleting file: " + filePath);
        }
        if (deleted) {
            logger.info("Deleted previous output file: " + reportName);
        } else {
            logger.info("Previous output file (" + reportName + ") not found: running from clean installation");
        }
        FileConnection connection = new FileConnection(reportName, reportFolder);
        connection.setAppend(true);
        connection.setTemporary(true);
        DataRecordDAOImpl dao = new DataRecordDAOImpl(connection);
        String[] headerArray = new String[]{"FIRST", "SECOND", "THIRD"};
        String[] dataArray = new String[]{"aaa", "bbb", "ccc"};
        DataRecordCSV header = new DataRecordCSV(headerArray);
        DataRecordCSV record = new DataRecordCSV(dataArray);
        logger.info("");
        dao.save(header);
        for (int i = 0; i < 10; ++i) {
            if (dao.save(record)) {
                logger.info("Written record        : " + String.valueOf(record));
                continue;
            }
            logger.error("Error writing record : " + String.valueOf(record));
        }
        logger.info("");
        logger.info("testRuleOutputDetailDAO: completed\n");
    }
}

