/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.dao.model.schema.RangeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DAOTesterData {
    protected boolean testSchema;
    protected final int numberOfGroups = 5;
    protected final int testGroupID = 1;
    protected final int numberOfSchemasInTestGroup = 3;
    protected final int anotherGroupID = 2;
    protected final String anotherGroupName = "Mortality";
    protected final int numberOfSchemas;
    protected final int testSchemaID = 1;
    protected final int numberOfRangesInTestSchema = 39;
    protected final int anotherSchemaID = 3;
    protected final String anotherSchemaName = "Mortality 2014 (default)";
    protected final int numberOfFields;
    protected final int testFieldID = 1;
    protected final List<Integer> IDOfSchemasUsingTestField = new ArrayList<Integer>();
    protected final int anotherFieldID = 60;
    protected final int notIntervalRangeFieldID = 29;
    protected final List<Integer> IDOfSchemasUsingAnotherField = new ArrayList<Integer>();
    protected final int numberOfSchemaToFields;
    protected final int numberOfFieldsInTestSchema;
    protected final int numberOfFieldsInAnotherSchema;
    protected final List<Integer> IDOfFieldsInTestSchema = new ArrayList<Integer>();
    protected final List<Integer> IDOfFieldsInAnotherSchema = new ArrayList<Integer>();
    protected final int numberOfRanges;
    protected final int testRangeID = 1;
    protected final int anotherRangeID = 39;
    protected final int notIntervalRangeID = 13;
    protected final int anotherNotIntervalRangeID = 21;
    protected final int numberOfDistincRangeData = 20;
    protected final int notIntervalRangeId = 13;
    protected final int anotherNotIntervalRangeId = 21;
    protected final List<String> notIntervalRangeValues;
    protected final List<RangeData> notIntervalRangeData = new ArrayList<RangeData>();
    protected final List<String> anotherNotIntevalRangeValues;
    protected final List<RangeData> anotherNotIntervalRangeData = new ArrayList<RangeData>();

    public DAOTesterData(boolean testSchema) {
        RangeData rangeData;
        int i;
        this.testSchema = testSchema;
        this.numberOfSchemas = testSchema ? 16 : 15;
        this.numberOfFields = testSchema ? 179 : 120;
        this.numberOfSchemaToFields = testSchema ? 214 : 144;
        this.numberOfRanges = testSchema ? 88 : 63;
        this.IDOfSchemasUsingTestField.add(1);
        this.IDOfSchemasUsingAnotherField.add(3);
        this.IDOfSchemasUsingAnotherField.add(5);
        this.IDOfSchemasUsingAnotherField.add(7);
        for (i = 1; i <= 56; ++i) {
            this.IDOfFieldsInTestSchema.add(i);
        }
        this.IDOfFieldsInTestSchema.add(108);
        this.numberOfFieldsInTestSchema = this.IDOfFieldsInTestSchema.size();
        for (i = 58; i <= 62; ++i) {
            this.IDOfFieldsInAnotherSchema.add(i);
        }
        this.numberOfFieldsInAnotherSchema = this.IDOfFieldsInAnotherSchema.size();
        this.notIntervalRangeValues = new ArrayList<String>(Arrays.asList("y", "a"));
        for (String value : this.notIntervalRangeValues) {
            Objects.requireNonNull(this);
            rangeData = new RangeData(Integer.toString(13), value);
            this.notIntervalRangeData.add(rangeData);
        }
        this.anotherNotIntevalRangeValues = new ArrayList<String>(Arrays.asList("1", "2", "3", "9"));
        for (String value : this.anotherNotIntevalRangeValues) {
            Objects.requireNonNull(this);
            rangeData = new RangeData(Integer.toString(21), value);
            this.anotherNotIntervalRangeData.add(rangeData);
        }
    }

    public int getNumberOfGroups() {
        return 5;
    }

    public int getTestGroupID() {
        return 1;
    }

    public int getNumberOfSchemasInTestGroup() {
        return 3;
    }

    public int getAnotherGroupID() {
        return 2;
    }

    public String getAnotherGroupName() {
        return "Mortality";
    }

    public int getNumberOfSchemas() {
        return this.numberOfSchemas;
    }

    public int getTestSchemaID() {
        return 1;
    }

    public int getNumberOfRangesInTestSchema() {
        return 39;
    }

    public int getAnotherSchemaID() {
        return 3;
    }

    public String getAnotherSchemaName() {
        return "Mortality 2014 (default)";
    }

    public int getNumberOfFields() {
        return this.numberOfFields;
    }

    public int getTestFieldID() {
        return 1;
    }

    public int getAnotherFieldID() {
        return 60;
    }

    public int getNotIntervalRangeFieldID() {
        return 29;
    }

    public List<Integer> getIDOfSchemasUsingTestField() {
        return this.IDOfSchemasUsingTestField;
    }

    public List<Integer> getIDOfSchemasUsingAnotherField() {
        return this.IDOfSchemasUsingAnotherField;
    }

    public int getNumberOfSchemaToFields() {
        return this.numberOfSchemaToFields;
    }

    public int getNumberOfActualFieldsInTestSchema() {
        return this.numberOfFieldsInTestSchema - 1;
    }

    public int getNumberOfAllFieldsInTestSchema() {
        return this.numberOfFieldsInTestSchema;
    }

    public int getNumberOfFieldsInAnotherSchema() {
        return this.numberOfFieldsInAnotherSchema;
    }

    public List<Integer> getIDOfFieldsInTestSchema() {
        return this.IDOfFieldsInTestSchema;
    }

    public List<Integer> getIDOfFieldsInAnotherSchema() {
        return this.IDOfFieldsInAnotherSchema;
    }

    public int getNumberOfRanges() {
        return this.numberOfRanges;
    }

    public int getTestRangeID() {
        return 1;
    }

    public int getAnotherRangeID() {
        return 39;
    }

    public int getNotIntervalRangeID() {
        return 13;
    }

    public int getAnotherNotIntervalRangeID() {
        return 21;
    }

    public int getNumberOfDistincRangeData() {
        return 20;
    }

    public int getNotIntervalRangeId() {
        return 13;
    }

    public int getAnotherNotIntervalRangeId() {
        return 21;
    }

    public List<String> getNotIntervalRangeValues() {
        return this.notIntervalRangeValues;
    }

    public List<RangeData> getNotIntervalRangeData() {
        return this.notIntervalRangeData;
    }

    public List<String> getAnotherNotIntervalRangeValues() {
        return this.anotherNotIntevalRangeValues;
    }

    public List<RangeData> getAnotherNotIntervalRangeData() {
        return this.anotherNotIntervalRangeData;
    }

    public boolean isTestSchema() {
        return this.testSchema;
    }
}

