/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.DataRecordDAO;
import eu.europa.ec.jrc.qcs.dao.FieldDAO;
import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.ProtocolToRuleDAO;
import eu.europa.ec.jrc.qcs.dao.ProtocolViewDAO;
import eu.europa.ec.jrc.qcs.dao.RangeDAO;
import eu.europa.ec.jrc.qcs.dao.RangeDataDAO;
import eu.europa.ec.jrc.qcs.dao.ReferenceFieldDAO;
import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDAO;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDetailDAO;
import eu.europa.ec.jrc.qcs.dao.RuleToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaGroupDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaToFieldDAO;
import eu.europa.ec.jrc.qcs.dao.SchemaViewDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationMessageDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationRunDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.DatabaseDAOFactory;
import eu.europa.ec.jrc.qcs.dao.datasource.EndOfDataConnetionException;
import eu.europa.ec.jrc.qcs.dao.datasource.ExhaustedDataConnectionException;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFileDAOFactory;
import eu.europa.ec.jrc.qcs.dao.file.handler.LoggerConfigurationHandler;
import eu.europa.ec.jrc.qcs.dao.model.GenericModel;
import eu.europa.ec.jrc.qcs.dao.model.config.ApplicationProperties;
import eu.europa.ec.jrc.qcs.dao.model.config.Internationalization;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.LoggerConfiguration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceData;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceDatum;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolToRule;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleToField;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleType;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Key;
import eu.europa.ec.jrc.qcs.dao.model.schema.Range;
import eu.europa.ec.jrc.qcs.dao.model.schema.RangeData;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaToField;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultRuleID;
import eu.europa.ec.jrc.qcs.test.DAOTesterData;
import eu.europa.ec.jrc.qcs.test.GenericTester;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOReader
extends GenericTester {
    protected List<SchemasGroup> allGroups;
    protected List<Schema> allSchemas;
    protected DAOFactory daoFactory;
    protected DAOTesterData data;
    protected boolean includeTestSchema;
    protected boolean jpa;
    protected static Logger logger = LoggerFactory.getLogger(DAOReader.class);

    public DAOReader() {
        this.init();
    }

    protected void init() {
        this.daoFactory = DAOFactory.getDAOFactory();
        if (this.daoFactory instanceof DatabaseDAOFactory) {
            this.jpa = true;
            if (logger.isDebugEnabled()) {
                logger.debug("init() - Using DatabaseDAO (JPA) -> skip test on lazy fetching");
            }
        }
        SchemaGroupDAO schemaGroupDAO = (SchemaGroupDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMAS_GROUP));
        this.allGroups = schemaGroupDAO.getAll();
        SchemaDAO schemaDAO = (SchemaDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA));
        this.allSchemas = schemaDAO.getAll();
        this.includeTestSchema = false;
        this.data = new DAOTesterData(this.includeTestSchema);
    }

    @Test
    public void testLoggerConfiguration() {
        this.logHorizontalLine();
        logger.info("TESTING LOGGER CONFIGURATION");
        FileConnection connection = FlatFileDAOFactory.getConnection(FlatFile.LOGGER_CONFIG);
        LoggerConfigurationHandler handler = new LoggerConfigurationHandler(connection);
        LoggerConfiguration loggerConfiguration = handler.getConfiguration();
        logger.info("Logger info:\n" + loggerConfiguration.getLoggersInfo());
        List<Appender> appenders = loggerConfiguration.getAppenders();
        for (Appender appender : appenders) {
            if (!(appender instanceof FileAppender)) continue;
            FileAppender fileAppender = (FileAppender)appender;
            boolean matchesFileName = "logs/qcs-library.log".equals(fileAppender.getFileName());
            Assertions.assertTrue((boolean)matchesFileName, (String)"Expected logger's file name differs from current one");
        }
    }

    @Test
    public void testProperties() {
        this.logHorizontalLine();
        logger.info("TESTING PROPERTIES CONFIGURATION");
        Configuration configuration = Configuration.getInstance();
        ApplicationProperties properties = configuration.getApplicationProperties();
        String value = properties.getValue(Property.NAME);
        logger.info("testInternationalization() - Label for 'startChecks' : " + value);
        boolean matchesExpectedValue = "Quality Check Software".equals(value);
        Assertions.assertTrue((boolean)matchesExpectedValue, (String)"Expected value differs from current one");
    }

    @Test
    public void testValidationOptions() {
        this.logHorizontalLine();
        logger.info("TESTING VALIDATION OPTIONS");
        Configuration configuration = Configuration.getInstance();
        ApplicationProperties properties = configuration.getApplicationProperties();
        String value = properties.getValue(Property.DEFAULT_PROTOCOL);
        logger.info("testValidationOptions() - Default protocol (user's profile) : " + value);
        boolean matchesExpectedValue = "11".equals(value);
        Assertions.assertTrue((boolean)matchesExpectedValue, (String)"Expected value differs from current one");
    }

    @Test
    public void testInternationalization() {
        this.logHorizontalLine();
        logger.info("TESTING I18N CONFIGURATION");
        Configuration configuration = Configuration.getInstance();
        Internationalization internationalization = configuration.getInternationalization();
        String label = internationalization.getLabel(Label.START_CHECKS);
        logger.info("testInternationalization() - Label for 'startChecks' : " + label);
        boolean matchesExpectedLabel = "Start checks".equals(label);
        Assertions.assertTrue((boolean)matchesExpectedLabel, (String)"Expected label's differs from current one");
    }

    @Test
    public void testSchemaGroupDAO() {
        this.logHorizontalLine();
        logger.info("TESTING SCHEMAS_GROUP DAO");
        SchemaGroupDAO schemaGroupDAO = (SchemaGroupDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMAS_GROUP));
        List<SchemasGroup> groups = schemaGroupDAO.getAll();
        int maxGroupID = schemaGroupDAO.getMaxID();
        logger.info(this.formatSchemaGroups(groups, maxGroupID));
        Assertions.assertTrue((groups.size() == this.data.getNumberOfGroups() ? 1 : 0) != 0, (String)"Total number of schemas groups has wrong size");
        SchemasGroup group_1 = groups.get(0);
        logger.info("First group in the above list: " + group_1.toLongString());
        Assertions.assertTrue((group_1.getId() == this.data.getTestGroupID() ? 1 : 0) != 0, (String)"ID of the first group differs from expected one");
        List<Schema> schemas = group_1.getAllSchema();
        logger.info("Printing list of all schemas in the first group:");
        logger.info("");
        logger.info(this.formatSchemas(schemas, 0));
        logger.info("Total number of schemas      : " + schemas.size());
        Assertions.assertTrue((schemas.size() == this.data.getNumberOfSchemasInTestGroup() ? 1 : 0) != 0, (String)"Total number of schemas differs from expected one");
        SchemasGroup group_1_byID = (SchemasGroup)schemaGroupDAO.getByID(group_1.getId());
        SchemasGroup group_1_byName = schemaGroupDAO.getByName(group_1.getName());
        logger.info("Name of SchemasGroup fetched from groupID : " + String.valueOf(group_1_byID));
        logger.info("Name of SchemasGroup fetched from name    : " + String.valueOf(group_1_byName));
        Assertions.assertTrue((boolean)group_1_byID.equals(group_1), (String)"Group fetched from groupID differs from group_1");
        Assertions.assertTrue((boolean)group_1_byName.equals(group_1), (String)"Group fetched from name differs from group_1");
        SchemasGroup group_2 = (SchemasGroup)schemaGroupDAO.getByID(this.data.getAnotherGroupID());
        String group_2_name = group_2.getName();
        logger.info("Name of another SchemasGroup              : " + group_2_name);
        Assertions.assertTrue((boolean)group_2_name.equals(this.data.getAnotherGroupName()), (String)"Name of another SchemasGroup differs from expected one");
        Schema schema_1 = schemas.get(0);
        SchemasGroup group_1_bis = schema_1.getSchemaGroup();
        List<SchemaToField> schemaToFields = schema_1.getAllSchemaToField();
        logger.info("");
        logger.info("Checking that SchemaGroup.Schema is fully loaded                 : " + String.valueOf(schema_1));
        logger.info("Group fetched from SchemaGroup.Schema                            : " + String.valueOf(group_1_bis));
        logger.info("Fields list fetched from SchemaGroup.Schema                      : " + schemaToFields.size());
        logger.info("Expetected size of fields list                                   : " + this.data.getNumberOfAllFieldsInTestSchema());
        Assertions.assertTrue((boolean)group_1_bis.equals(group_1), (String)"Group fetched from SchemaGroup.Schema differs from group_1");
        Assertions.assertTrue((schemaToFields.size() == this.data.getNumberOfAllFieldsInTestSchema() ? 1 : 0) != 0, (String)"Fields list fetched from SchemaGroup.Schema has wrong size");
        SchemaToField schemaToFields_1 = schema_1.getAllSchemaToField().get(0);
        Field field_1 = schemaToFields_1.getField();
        Schema schema_1_bis = schemaToFields_1.getSchema();
        logger.info("");
        logger.info("Checking that SchemaGroup.Schema.SchemaToField is fully loaded   : " + String.valueOf(schemaToFields_1));
        logger.info("Field fetched from SchemaGroup.Schema                            : " + String.valueOf(field_1));
        logger.info("Schema fetched from SchemaGroup.Schema.Field                     : " + String.valueOf(schema_1_bis));
        Assertions.assertTrue((field_1.getId() == this.data.getTestFieldID() ? 1 : 0) != 0, (String)"Field fetched from SchemaGroup.Schema.Field differs from expected one");
        Assertions.assertTrue((boolean)schema_1_bis.equals(schema_1), (String)"Schema fetched from SchemaGroup.Schema.Field differs from schema_1");
        logger.info("");
        logger.info("testSchemaGroupDAO: completed\n");
    }

    @Test
    public void testSchemaDAO() {
        this.logHorizontalLine();
        logger.info("TESTING SCHEMA DAO");
        SchemaDAO schemaDAO = (SchemaDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA));
        List schemas = schemaDAO.getAll();
        int maxSchemaID = schemaDAO.getMaxID();
        logger.info(this.formatSchemas(schemas, maxSchemaID));
        logger.info("Total number of schemas      : " + schemas.size());
        Assertions.assertTrue((schemas.size() == this.data.getNumberOfSchemas() ? 1 : 0) != 0, (String)"Total number of schemas differs from expected one");
        Schema schema_1 = (Schema)schemas.get(0);
        logger.info("First schema in list         : " + String.valueOf(schema_1));
        Assertions.assertTrue((schema_1.getId() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"ID of the first Schema differs from expected one");
        Schema schema_1_byID = (Schema)schemaDAO.getByID(schema_1.getId());
        logger.info("Schema fetched from schemaID : " + String.valueOf(schema_1_byID));
        Assertions.assertTrue((boolean)schema_1_byID.equals(schema_1), (String)"Schema fetched from schemaID differs from schema_1");
        List<Schema> schemas_in_group = schemaDAO.getByGroupID(schema_1.getGroupID());
        Schema schema_1_by_group = schemas_in_group.get(0);
        logger.info("Schema fetched from groupID  : " + String.valueOf(schema_1_by_group));
        Assertions.assertTrue((boolean)schema_1_by_group.equals(schema_1), (String)"Schema fetched from groupID differs from schema_1");
        Schema schema_2 = (Schema)schemaDAO.getByID(this.data.getAnotherSchemaID());
        String schema_2_name = schema_2.getName();
        logger.info("Name of another Schema       : " + schema_2_name);
        Assertions.assertTrue((boolean)schema_2_name.equals(this.data.getAnotherSchemaName()), (String)"Name of another Schema differs from expected one");
        SchemasGroup group_1 = schema_1.getSchemaGroup();
        Schema schema_1_bis = group_1.getSchema(schema_1.getId());
        Assertions.assertTrue((group_1.getId() == this.data.getTestGroupID() ? 1 : 0) != 0, (String)"SchemasGroup fetched from Schema differs from expected one");
        Assertions.assertTrue((boolean)schema_1_bis.equals(schema_1), (String)"Schema fetched from Schema.SchemasGroup object differs from schema_1");
        List<Schema> schemas_in_group_1 = group_1.getAllSchema();
        logger.info("");
        logger.info("Fetching all schemas in group " + group_1.toLongString());
        logger.info(this.formatSchemas(schemas_in_group_1, 0));
        Assertions.assertTrue((schemas_in_group_1.size() == this.data.getNumberOfSchemasInTestGroup() ? 1 : 0) != 0, (String)"Total number of Schema in Schema.SchemaGroup differs from expected");
        List<SchemaToField> fields_in_schema_1 = schema_1.getAllSchemaToField();
        SchemaToField schemaToField = schema_1.getSchemaToField(this.data.getTestFieldID());
        Assertions.assertTrue((fields_in_schema_1.size() == this.data.getNumberOfAllFieldsInTestSchema() ? 1 : 0) != 0, (String)"Size of fields in Schema.SchemaToField object has wrong size");
        Assertions.assertTrue((schemaToField.getSchemaID() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"Schema ID fetched from Schema.SchemaToField object differs from expected one");
        SchemaToField schema_to_field_1 = fields_in_schema_1.get(0);
        Schema schema_1_ter = schema_to_field_1.getSchema();
        Assertions.assertTrue((boolean)schema_1_ter.equals(schema_1), (String)"Schema fetched from Schema.SchemaToField.Field object differs from schema_1");
        logger.info("testSchemaDAO: completed\n");
    }

    @Test
    public void testFieldDAO() {
        this.logHorizontalLine();
        logger.info("TESTING FIELD DAO\n");
        FieldDAO fieldDAO = (FieldDAO)((Object)this.daoFactory.getDAO(DAO.FIELD));
        boolean verbose = false;
        Field.setVerbose(false);
        if (verbose) {
            logger.info("");
        }
        logger.info("Max GLOBAL fieldID : " + fieldDAO.getMaxID());
        if (verbose) {
            logger.info("");
        }
        List allFields = fieldDAO.getAll();
        if (verbose) {
            logger.info("List of ALL fields in ALL schemas:");
            for (Field field : allFields) {
                logger.info("Field: " + String.valueOf(field));
            }
            logger.info("");
        }
        Assertions.assertTrue((allFields.size() == this.data.getNumberOfFields() ? 1 : 0) != 0, (String)"Total number of Field differs from expected one");
        Field field_0 = (Field)allFields.get(0);
        Field field_1 = (Field)fieldDAO.getByID(this.data.getTestFieldID());
        Field field_2 = (Field)fieldDAO.getByID(this.data.getAnotherFieldID());
        logger.info("");
        logger.info("Main test Field    : " + String.valueOf(field_1));
        logger.info("Another test Field : " + String.valueOf(field_2));
        Assertions.assertTrue((boolean)field_1.equals(field_0), (String)"Field fetched from ID differs from field_1");
        Assertions.assertTrue((field_1.getId() == this.data.getTestFieldID() ? 1 : 0) != 0, (String)"ID of the first Field fetched from ID differs from expected one");
        Assertions.assertTrue((field_2.getId() == this.data.getAnotherFieldID() ? 1 : 0) != 0, (String)"ID of another Field fetched from ID differs from expected one");
        SchemaToField schemaToField = field_2.getSchemaToField(this.data.getAnotherSchemaID());
        logger.info("");
        logger.info("SchemaToField fetched via DAO shortcut   : " + String.valueOf(schemaToField));
        Assertions.assertTrue((schemaToField.getFieldID() == this.data.getAnotherFieldID() ? 1 : 0) != 0, (String)"ID of another Field fetched via DAO shortcut differs from expected one");
        SchemaToField schema_to_field_1 = field_1.getAllSchemaToField().get(0);
        Schema schema_1 = schema_to_field_1.getSchema();
        Field field_1_bis = schema_to_field_1.getField();
        field_1_bis.getAllSchemaToField();
        logger.info("");
        logger.info("SchemaToField fetched from Field 1       : " + String.valueOf(schema_to_field_1));
        logger.info("Schema fetched from Field.SchemaToField  : " + String.valueOf(schema_1));
        logger.info("Field fetched from Field.SchemaToField   : " + String.valueOf(field_1_bis));
        Assertions.assertTrue((schema_1.getId() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"Schema ID fetched from Field.SchemaToField differs from expected one");
        Assertions.assertTrue((boolean)field_1_bis.equals(field_1), (String)"Field fetched from Field.SchemaToField differs from field_1");
        Field field_improper = (Field)fieldDAO.getByID(this.data.getNotIntervalRangeFieldID());
        Range range_improper = field_improper.getRange();
        List<RangeData> rangeData = range_improper.getRangeData();
        Field field_improper_1 = range_improper.getAllField().get(0);
        logger.info("");
        logger.info("RangeData fetched from Field.Range       : " + String.valueOf(rangeData));
        logger.info("Field fetched from Field.Range           : " + String.valueOf(field_improper_1));
        Assertions.assertTrue((range_improper.getId() == this.data.getNotIntervalRangeID() ? 1 : 0) != 0, (String)"Range ID of fetched from Field.Range differs from expected one");
        Assertions.assertTrue((boolean)field_improper_1.equals(field_improper), (String)"Field fetched from Field.Range differs from field_improper");
        Assertions.assertTrue((boolean)rangeData.equals(this.data.getNotIntervalRangeData()), (String)"RangeData fetched from Field.Range differs from expected one");
        SchemasGroup group_1 = schema_1.getSchemaGroup();
        int group_1_id = group_1.getId();
        Assertions.assertTrue((group_1_id == this.data.getTestGroupID() ? 1 : 0) != 0, (String)"Group ID fetched from Field differs from firstGroupID");
        logger.info("");
        logger.info("testFieldDAO: completed\n");
    }

    @Test
    public void testSchemaToFieldDAO() {
        this.logHorizontalLine();
        logger.info("TESTING SCHEMA_TO_FIELD DAO\n");
        SchemaToFieldDAO schemaToFieldDAOImpl = (SchemaToFieldDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA_TO_FIELD));
        boolean verbose = false;
        List allLinks = schemaToFieldDAOImpl.getAll();
        if (verbose) {
            logger.info("");
            logger.info("List of all schema-field links [" + allLinks.size() + " elements]");
            for (SchemaToField link : allLinks) {
                logger.info("Link: " + String.valueOf(link));
            }
            logger.info("");
        }
        logger.info("Total number of SchemaToField  : " + allLinks.size());
        Assertions.assertTrue((allLinks.size() == this.data.getNumberOfSchemaToFields() ? 1 : 0) != 0, (String)"Total number of SchemaToField differs from expected one");
        logger.info("");
        logger.info("Max GLOBAL schemaToFieldID     : " + schemaToFieldDAOImpl.getMaxID());
        logger.info("Max GLOBAL schemaID            : " + schemaToFieldDAOImpl.getMaxSchemaID());
        List<Integer> schemaIDs_1 = schemaToFieldDAOImpl.getSchemasIDsByFieldID(this.data.getTestFieldID());
        List<Integer> schemaIDs_2 = schemaToFieldDAOImpl.getSchemasIDsByFieldID(this.data.getAnotherFieldID());
        logger.info("");
        logger.info("List of all schemas IDs using field " + this.data.getTestFieldID() + "  : " + String.valueOf(schemaIDs_1));
        logger.info("List of all schemas IDs using field " + this.data.getAnotherFieldID() + " : " + String.valueOf(schemaIDs_2));
        Assertions.assertTrue((boolean)schemaIDs_1.equals(this.data.getIDOfSchemasUsingTestField()), (String)"List of schemas using the main field differs from the expected one");
        Assertions.assertTrue((boolean)schemaIDs_2.equals(this.data.getIDOfSchemasUsingAnotherField()), (String)"List of schemas using another field differs from the expected one");
        List<Integer> fieldIDs_1 = schemaToFieldDAOImpl.getFieldsIDsBySchemaID(this.data.getTestSchemaID());
        List<Integer> fieldIDs_2 = schemaToFieldDAOImpl.getFieldsIDsBySchemaID(this.data.getAnotherSchemaID());
        logger.info("");
        logger.info("List of all field IDs declared in 1st schema " + this.data.getTestSchemaID() + " : " + String.valueOf(fieldIDs_1));
        logger.info("List of all field IDs expected in 1st schema " + this.data.getTestSchemaID() + " : " + String.valueOf(this.data.getIDOfFieldsInTestSchema()));
        logger.info("List of all field IDs declared in 2nd schema " + this.data.getAnotherSchemaID() + " : " + String.valueOf(fieldIDs_2));
        logger.info("List of all field IDs expected in 2nd schema " + this.data.getAnotherSchemaID() + " : " + String.valueOf(this.data.getIDOfFieldsInAnotherSchema()));
        Assertions.assertTrue((boolean)fieldIDs_1.equals(this.data.getIDOfFieldsInTestSchema()), (String)"List of fieldIDs used by the 1st schema differs from the expected ones");
        Assertions.assertTrue((boolean)fieldIDs_2.equals(this.data.getIDOfFieldsInAnotherSchema()), (String)"List of fieldIDs used by the 2nd schema differs from the expected ones");
        List<SchemaToField> schemaToFieldsBySchemaID_1 = schemaToFieldDAOImpl.getBySchemaID(this.data.getTestSchemaID());
        List<SchemaToField> schemaToFieldsBySchemaID_2 = schemaToFieldDAOImpl.getBySchemaID(this.data.getAnotherSchemaID());
        logger.info("");
        logger.info("Number of SchemaToField (by schemaID) declared in 1st schema : " + schemaToFieldsBySchemaID_1.size());
        logger.info("Number of SchemaToField (by schemaID) declared in 2nd schema : " + schemaToFieldsBySchemaID_2.size());
        Assertions.assertTrue((schemaToFieldsBySchemaID_1.size() == 57 ? 1 : 0) != 0, (String)"Number of SchemaToField (by schemaID) in 1st schema differs from the expected one");
        Assertions.assertTrue((schemaToFieldsBySchemaID_2.size() == 5 ? 1 : 0) != 0, (String)"Number of SchemaToField (by schemaID) in 2nd schema differs from the expected one");
        List<SchemaToField> schemaToFieldsByFieldID_1 = schemaToFieldDAOImpl.getByFieldID(this.data.getTestFieldID());
        List<SchemaToField> schemaToFieldsByFieldID_2 = schemaToFieldDAOImpl.getByFieldID(this.data.getAnotherFieldID());
        logger.info("");
        logger.info("Number of SchemaToField (by fieldID) reffering the 1st field : " + schemaToFieldsByFieldID_1.size());
        logger.info("Number of SchemaToField (by fieldID) reffering the 2nd field : " + schemaToFieldsByFieldID_2.size());
        Assertions.assertTrue((schemaToFieldsByFieldID_1.size() == 1 ? 1 : 0) != 0, (String)"Number of SchemaToField (by fieldID) differs from the expected one");
        Assertions.assertTrue((schemaToFieldsByFieldID_2.size() == 3 ? 1 : 0) != 0, (String)"Number of SchemaToField (by fieldID) differs from the expected one");
        List<Schema> schemas_list_1 = schemaToFieldDAOImpl.getSchemasByFieldID(this.data.getTestFieldID());
        Schema schema_1 = schemas_list_1.get(0);
        SchemasGroup group_1 = schema_1.getSchemaGroup();
        SchemaToField schemaToField_1 = schema_1.getAllSchemaToField().get(0);
        logger.info("");
        logger.info("SchemasGroup fetched from SchemaToField.Schema  : " + String.valueOf(group_1));
        logger.info("SchemaToField fetched from SchemaToField.Schema : " + String.valueOf(schemaToField_1));
        Assertions.assertTrue((group_1.getId() == this.data.getTestGroupID() ? 1 : 0) != 0, (String)"ID of Group fetched from the SchemaFieldLink.Schema differs from expected one");
        Assertions.assertTrue((schemaToField_1.getSchemaID() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"ID of SchemaToField fetched from SchemaFieldLink.Schema differs from expected one");
        List<Field> fields_list_1 = schemaToFieldDAOImpl.getFieldsBySchemaID(this.data.getTestSchemaID());
        Field field_1 = fields_list_1.get(0);
        Range range_1 = field_1.getRange();
        SchemaToField schemaToField_2 = field_1.getAllSchemaToField().get(0);
        logger.info("Range fetched from SchemaToField.Field          : " + String.valueOf(range_1));
        logger.info("SchemaToField fetched from SchemaToField.Field  : " + String.valueOf(schemaToField_2));
        Assertions.assertTrue((range_1.getId() == this.data.getTestRangeID() ? 1 : 0) != 0, (String)"ID of Range fetched from the SchemaFieldLink.Field differs from expected one");
        Assertions.assertTrue((schemaToField_2.getSchemaID() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"ID of SchemaToField fetched from SchemaFieldLink.Schema differs from expected one");
        if (this.includeTestSchema) {
            boolean detailed = false;
            logger.info("");
            logger.info("Extra check: verifying that \"getAllSchemaToField()\" returns also invalid records");
            int wrongPosition = 0;
            SchemaDAO schemaDAO = (SchemaDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA));
            for (Schema schema : schemaDAO.getAll()) {
                if (detailed) {
                    logger.info("Checking schema: " + schema.getId());
                }
                for (SchemaToField schema_to_field : schema.getAllSchemaToField()) {
                    if (schema_to_field.getId() >= 79 && schema_to_field.getId() <= 81) {
                        ++wrongPosition;
                    }
                    if (!detailed) continue;
                    logger.info(schema_to_field.toString());
                }
            }
            Assertions.assertTrue((wrongPosition == 3 ? 1 : 0) != 0, (String)"Failed to load SchemaToField with wrong position");
        }
        logger.info("");
        logger.info("testSchemaFieldLinkDAO: completed\n");
    }

    @Test
    public void testRangeDAO() {
        this.logHorizontalLine();
        logger.info("TESTING RANGE DAO\n");
        RangeDAO rangeDAO = (RangeDAO)((Object)this.daoFactory.getDAO(DAO.RANGE));
        boolean verbose = false;
        logger.info("");
        logger.info("Max GLOBAL range ID     : " + rangeDAO.getMaxID());
        List allRanges = rangeDAO.getAll();
        if (verbose) {
            logger.info("");
            logger.info("List of ALL ranges in ALL schemas:");
            for (Range range : allRanges) {
                logger.info("Range: " + String.valueOf(range));
            }
        }
        Assertions.assertTrue((allRanges.size() == this.data.getNumberOfRanges() ? 1 : 0) != 0, (String)"Total number of Range differs from expected one");
        Range range_0 = (Range)allRanges.get(1);
        Range range_1 = (Range)rangeDAO.getByID(this.data.getTestRangeID());
        Range range_2 = (Range)rangeDAO.getByID(this.data.getAnotherRangeID());
        Range improper_range_1 = (Range)rangeDAO.getByID(this.data.getNotIntervalRangeID());
        Range improper_range_2 = (Range)rangeDAO.getByID(this.data.getAnotherNotIntervalRangeID());
        logger.info("");
        logger.info("Main test Range         : " + String.valueOf(range_1));
        logger.info("Another test Range      : " + String.valueOf(range_2));
        logger.info("Improper Range          : " + String.valueOf(improper_range_1));
        logger.info("Another improper Range  : " + String.valueOf(improper_range_2));
        Assertions.assertTrue((boolean)range_1.equals(range_0), (String)"Range fetched from ID differs from range_0");
        Assertions.assertTrue((range_1.getId() == this.data.getTestRangeID() ? 1 : 0) != 0, (String)"ID of the first Range fetched from ID differs from expected one");
        Assertions.assertTrue((range_2.getId() == this.data.getAnotherRangeID() ? 1 : 0) != 0, (String)"ID of another Range fetched from ID differs from expected one");
        Assertions.assertTrue((improper_range_1.getId() == this.data.getNotIntervalRangeId() ? 1 : 0) != 0, (String)"RangeId of the first improper Range fetched from ID differs from expected one");
        Assertions.assertTrue((improper_range_2.getId() == this.data.getAnotherNotIntervalRangeId() ? 1 : 0) != 0, (String)"RangeId of another improper Range fetched from ID differs from expected one");
        List<Field> fields_1 = range_1.getAllField();
        Field field_1 = fields_1.get(0);
        Range range_1_bis = field_1.getRange();
        SchemaToField schema_to_field_1 = field_1.getAllSchemaToField().get(0);
        range_1_bis.getAllField();
        logger.info("");
        logger.info("Range fetched from Range.Field                       : " + range_1_bis.toShortString());
        logger.info("SchemaToField fetched from Range.Field               : " + String.valueOf(schema_to_field_1));
        Assertions.assertTrue((boolean)range_1.equals(range_1_bis), (String)"Range fetched from Range.Field object differs from the range_1");
        Assertions.assertTrue((schema_to_field_1.getSchemaID() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"SchemaToField ID fetched from Range.Field object differs from the expected one");
        List<RangeData> rangeData_1 = improper_range_1.getRangeData();
        RangeData rangeData = rangeData_1.get(0);
        Range improper_range_1_bis = rangeData.getAllRange().get(0);
        improper_range_1_bis.getRangeData();
        logger.info("");
        logger.info("Improper Range fetched from Range.RangeData          : " + improper_range_1_bis.toShortString());
        Assertions.assertTrue((boolean)improper_range_1.equals(improper_range_1_bis), (String)"Range fetched from Range.RangeData object differs from the range_1");
        List<String> rangeValues_1 = improper_range_1.getRangeValues();
        List<RangeData> rangeData_1_test = this.data.getNotIntervalRangeData();
        List<String> rangeValues_1_test = this.data.getNotIntervalRangeValues();
        logger.info("");
        logger.info("Testing values for improper range                    : " + improper_range_1.toShortString());
        logger.info("Improper range description                           : " + improper_range_1.getRangeDescription());
        logger.info("Improper range sample                                : " + improper_range_1.getRangeSample());
        Assertions.assertTrue((boolean)this.compare(rangeData_1, rangeData_1_test), (String)("List of range data for (improper) rangeID=" + improper_range_1.getId() + " differs from expected one"));
        Assertions.assertTrue((boolean)rangeValues_1.equals(rangeValues_1_test), (String)("List of range values for (improper) rangeID=" + improper_range_1.getId() + " differs from expected one"));
        boolean showRangeData = false;
        if (showRangeData) {
            logger.info("");
            logger.info("Range.RangeData objects (from RANGE DTO):");
            for (RangeData data : rangeData_1) {
                logger.info(data.toString());
            }
            logger.info("Range.RangeData objects (from test data):");
            for (RangeData data : rangeData_1_test) {
                logger.info(data.toString());
            }
            logger.info("");
            logger.info("Range.values: string values (from RANGE DTO):");
            for (String value : rangeValues_1) {
                logger.info(value);
            }
            logger.info("Range.values: string values (from test data):");
            for (String value : rangeValues_1_test) {
                logger.info(value);
            }
        }
        Schema schema_1 = schema_to_field_1.getSchema();
        Field field_1_bis = schema_to_field_1.getField();
        field_1_bis.getAllSchemaToField();
        logger.info("");
        logger.info("Schema fetched from Range.Field.SchemaToField        : " + String.valueOf(schema_1));
        logger.info("Field fetched from Range.Field.SchemaToField         : " + String.valueOf(field_1_bis));
        Assertions.assertTrue((schema_1.getId() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"Schema ID fetched from Range.Field.SchemaToField object differs from expected one");
        Assertions.assertTrue((boolean)field_1.equals(field_1_bis), (String)"Field fetched from Range.Field.SchemaToField object differs from the original Field object");
        logger.info("");
        logger.info("testRangeDAO: completed\n");
    }

    @Test
    public void testRangeDataDAO() {
        this.logHorizontalLine();
        logger.info("TESTING RANGE_DATA DAO\n");
        RangeDataDAO rangeDataDAO = (RangeDataDAO)((Object)this.daoFactory.getDAO(DAO.RANGE_DATA));
        this.dump = true;
        this.openDumpFile("all-range-data.txt", "Full dump of the RANGE_DATA table");
        if (this.data.isTestSchema()) {
            logger.info("WARNING EXPECTED for resource ID = 999  : see ranges_list_009.csv for details");
            logger.info("ERROR EXPECTED for resource   ID = 1024 : see ranges_list_009.csv for details");
            logger.info("");
        }
        int maxRangeId = rangeDataDAO.getMaxRangeId();
        logger.info("");
        logger.info("Max GLOBAL RangeId            : " + maxRangeId);
        List allRangeData = rangeDataDAO.getAll();
        if (this.dump) {
            StringBuilder report = new StringBuilder();
            for (RangeData rangeData : allRangeData) {
                report.append(rangeData.toCSVString());
                report.append("\n");
            }
            this.writer.print(report);
            this.closeDumpFile();
        }
        boolean verbose = false;
        List<String> rangeValues_1 = rangeDataDAO.geValuesById(this.data.getNotIntervalRangeId());
        List<String> rangeValues_2 = rangeDataDAO.geValuesById(this.data.getAnotherNotIntervalRangeId());
        if (verbose) {
            logger.info("");
            logger.info("List of ALL range values (as String) for RangeId: " + this.data.getNotIntervalRangeId());
            for (String rangeData : rangeValues_1) {
                logger.info("Range data: " + rangeData);
            }
            logger.info("");
            logger.info("List of ALL range values (as String) for RangeId: " + this.data.getAnotherNotIntervalRangeId());
            for (String rangeData : rangeValues_2) {
                logger.info("Range data: " + rangeData);
            }
            logger.info("");
        }
        Assertions.assertTrue((boolean)rangeValues_1.equals(this.data.getNotIntervalRangeValues()), (String)("List of range values for (improper) rangeID=" + this.data.getNotIntervalRangeID() + " differs from expected one"));
        Assertions.assertTrue((boolean)rangeValues_2.equals(this.data.getAnotherNotIntervalRangeValues()), (String)("List of range values for (improper) rangeID=" + this.data.getAnotherNotIntervalRangeID() + " differs from expected one"));
        List<RangeData> rangeData_1 = rangeDataDAO.getRangeDataById(this.data.getNotIntervalRangeId());
        List<RangeData> rangeData_2 = rangeDataDAO.getRangeDataById(this.data.getAnotherNotIntervalRangeId());
        if (verbose) {
            logger.info("");
            logger.info("List of ALL range values (as RangeData) for RangeId: " + this.data.getNotIntervalRangeId());
            for (RangeData rangeData : rangeData_1) {
                logger.info("Range data: " + String.valueOf(rangeData));
            }
            logger.info("");
            logger.info("List of ALL range values (as RangeData) for RangeId: " + this.data.getAnotherNotIntervalRangeId());
            for (RangeData rangeData : rangeData_2) {
                logger.info("Range data: " + String.valueOf(rangeData));
            }
        }
        Assertions.assertTrue((boolean)rangeData_1.equals(this.data.getNotIntervalRangeData()), (String)("List of range data for (improper) rangeID=" + this.data.getNotIntervalRangeID() + " differs from expected one"));
        Assertions.assertTrue((boolean)rangeData_2.equals(this.data.getAnotherNotIntervalRangeData()), (String)("List of range data for (another) rangeID=" + this.data.getAnotherNotIntervalRangeID() + " differs from expected one"));
        List<RangeData> distinctRangesData = rangeDataDAO.getDistinctById();
        logger.info("");
        logger.info("Number of DISTINCT rangeIds   : " + distinctRangesData.size());
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (RangeData model : distinctRangesData) {
            builder.append(sep);
            builder.append(model.getId());
            sep = "-";
        }
        logger.info("List of all DISTINCT rangeIds : " + String.valueOf(builder));
        Assertions.assertTrue((distinctRangesData.size() == this.data.getNumberOfDistincRangeData() ? 1 : 0) != 0, (String)"Total number of DISTINCT rangeIds differs from expected");
        if (this.jpa) {
            logger.info("");
            logger.info("Using JPA datasource -> skip test on sub-objects");
            return;
        }
        RangeData range_data_1 = rangeData_1.get(0);
        Range range_1 = range_data_1.getAllRange().get(0);
        RangeData range_data_1_bis = range_1.getRangeData().get(0);
        Field field_1 = range_1.getAllField().get(0);
        logger.info("");
        logger.info("RangeData fetched from RangeData.Range     : " + String.valueOf(range_data_1_bis));
        logger.info("Field fetched from RangeData.Range         : " + field_1.toShortString());
        Assertions.assertTrue((range_data_1_bis.getId() == this.data.getNotIntervalRangeId() ? 1 : 0) != 0, (String)"Field ID fetched from RangeData.Range differs from expected one");
        Assertions.assertTrue((field_1.getId() == this.data.getNotIntervalRangeFieldID() ? 1 : 0) != 0, (String)"Field ID fetched from RangeData.Range differs from expected one");
        Range range_1_bis = field_1.getRange();
        SchemaToField schema_to_field = field_1.getAllSchemaToField().get(0);
        logger.info("");
        logger.info("Range fetched from RangeData.Range.Field         : " + range_1_bis.toShortString());
        logger.info("SchemaToField fetched from RangeData.Range.Field : " + String.valueOf(schema_to_field));
        Assertions.assertTrue((boolean)range_1.equals(range_1_bis), (String)"Range fetched from RangeData.Range.Field object differs from the original Range object");
        Assertions.assertTrue((schema_to_field.getSchemaID() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"SchemaToLink ID fetched from Range.Field.SchemaToField object differs from expected one");
        Schema schema = schema_to_field.getSchema();
        SchemasGroup group = schema.getSchemaGroup();
        Schema chain_schema = group.getSchema(this.data.getTestSchemaID());
        SchemaToField chain_schema_to_field = chain_schema.getSchemaToField(this.data.getNotIntervalRangeFieldID());
        Field chain_field = chain_schema_to_field.getField();
        Range chain_range = chain_field.getRange();
        List<String> chain_values = chain_range.getRangeValues();
        logger.info("");
        logger.info("Testing whole chain, starting from : " + group.getModelLabel());
        logger.info("Level 1                            : " + chain_schema.getModelLabel());
        logger.info("Level 2 (SchemaToLink)             : " + String.valueOf(chain_schema_to_field));
        logger.info("Level 3                            : " + chain_field.getModelLabel());
        logger.info("Level 4                            : " + chain_range.getModelLabel());
        logger.info("Level 5                            : " + String.valueOf(chain_values));
        Assertions.assertTrue((boolean)chain_values.equals(this.data.getNotIntervalRangeValues()), (String)"Range values of the 'chained' RangeId differs from expected");
        logger.info("");
        logger.info("testRangeDataDAO: completed\n");
    }

    public void getFieldInformation(int fieldID) {
        FieldDAO fieldDAO = (FieldDAO)((Object)this.daoFactory.getDAO(DAO.FIELD));
        Field field = (Field)fieldDAO.getByID(fieldID);
        this.logHorizontalLine();
        logger.info("FIELD INFORMATION");
        logger.info("\n\n" + field.toPrettyString());
        logger.info("");
    }

    public void testSchemaViewDAO() {
        List<Key> key;
        this.logHorizontalLine();
        logger.info("TESTING SCHEMA_VIEW DAO");
        logger.info("");
        this.daoFactory = DAOFactory.getDAOFactory();
        SchemaViewDAO schemaViewDAO = (SchemaViewDAO)((Object)this.daoFactory.getDAO(DAO.SCHEMA_VIEW));
        List allViews = schemaViewDAO.getAll();
        int maxSchemaID = schemaViewDAO.getMaxID();
        logger.info("Maximum schemaID (in strict mode): " + maxSchemaID);
        logger.info(this.formatSchemas(allViews, maxSchemaID));
        logger.info("Total number of SchemaView records: " + allViews.size() + " (expected = " + this.data.getNumberOfSchemas() + ")");
        Assertions.assertTrue((allViews.size() == this.data.getNumberOfSchemas() ? 1 : 0) != 0, (String)"Total number of schemas differs from expected one");
        Assertions.assertTrue((maxSchemaID == 17 ? 1 : 0) != 0, (String)"Maximum ID of schemas differs from expected one");
        SchemaView schema_view_1 = (SchemaView)schemaViewDAO.getByID(this.data.getTestSchemaID());
        SchemaView schema_view_2 = (SchemaView)schemaViewDAO.getByID(this.data.getAnotherSchemaID());
        Schema schema_1 = schema_view_1.getSchema();
        Schema schema_2 = schema_view_2.getSchema();
        List<SchemaToField> schema_to_fields_1 = schema_view_1.getSchemaToFields();
        List<SchemaToField> schema_to_fields_2 = schema_view_2.getSchemaToFields();
        logger.info("");
        logger.info("First SchemaView record (schema_view_1)    : " + String.valueOf(schema_view_1));
        logger.info("Second SchemaView record (schema_view_2)   : " + String.valueOf(schema_view_2));
        boolean verbose = false;
        if (verbose) {
            logger.info("");
            logger.info("List of fields in the test schema: " + String.valueOf(schema_1));
            logger.info("");
            for (SchemaToField schemaToField : schema_to_fields_1) {
                logger.info(schemaToField.getPosition() + ") " + String.valueOf(schemaToField));
            }
            logger.info("");
            logger.info("List of fields in another schema: " + String.valueOf(schema_2));
            logger.info("");
            for (SchemaToField schemaToField : schema_to_fields_2) {
                logger.info(schemaToField.getPosition() + ") " + String.valueOf(schemaToField));
            }
        }
        logger.info("");
        logger.info("Checking total number of fields in test schema    : " + String.valueOf(schema_view_1));
        logger.info("Expected total number of fields in test schema    : " + this.data.getNumberOfActualFieldsInTestSchema());
        logger.info("Checking total number of fields in another schema : " + String.valueOf(schema_view_2));
        logger.info("Expected total number of fields in another schema : " + this.data.getNumberOfFieldsInAnotherSchema());
        Assertions.assertTrue((schema_view_1.getNumberOfFields() == this.data.getNumberOfActualFieldsInTestSchema() ? 1 : 0) != 0, (String)"Total number of fields in test schema differs from expected one");
        Assertions.assertTrue((schema_view_2.getNumberOfFields() == this.data.getNumberOfFieldsInAnotherSchema() ? 1 : 0) != 0, (String)"Total number of fields in another schema differs from expected one");
        SchemaView full_schema_view_1 = schemaViewDAO.getFullSchemaViewByID(this.data.getTestSchemaID());
        logger.info("");
        logger.info("Fetched first full SchemaView                     : " + String.valueOf(full_schema_view_1));
        HashSet<Integer> schemaKeys = new HashSet<Integer>();
        List<SchemaToField> keySchemaToFields_1 = schema_view_1.getKeySchemaToFields();
        logger.info("");
        logger.info("List of keys in the test schema                   : " + String.valueOf(schema_1));
        for (SchemaToField schemaToField : keySchemaToFields_1) {
            Field field = schemaToField.getField();
            key = schemaToField.getKey();
            logger.info("Key SchemaToField                                 : " + field.getModelLabel() + " -> " + String.valueOf(key));
            schemaKeys.add(schemaToField.getId());
        }
        Iterator<SchemaToField> iterator = schemaKeys.iterator();
        while (iterator.hasNext()) {
            int keySchemaToFieldId = (Integer)((Object)iterator.next());
            SchemaToField keySchemaToField = schema_view_1.getKeySchemaToFieldByID(keySchemaToFieldId);
            key = keySchemaToField.getKey();
            if (Key.isMainKey(key)) {
                logger.info("Main primary key                                  : " + keySchemaToField.toShortString());
            }
            if (Key.isCompositeKey(key)) {
                logger.info("Composite primary key                             : " + keySchemaToField.toShortString());
            }
            Assertions.assertTrue((boolean)key.get(0).isPrimaryKey(), (String)"Wrong primary key for Incidence schema 1 (1st field)");
            Assertions.assertTrue((boolean)key.get(1).isPrimaryKey(), (String)"Wrong main primary key for Incidence schema 1 (2nd field)");
        }
        SchemasGroup group_1 = schema_1.getSchemaGroup();
        SchemaToField schemaToField_1 = schema_1.getAllSchemaToField().get(0);
        logger.info("");
        logger.info("SchemasGroup fetched from SchemaView.Schema       : " + String.valueOf(group_1));
        logger.info("SchemaToField fetched from SchemaView.Schema      : " + String.valueOf(schemaToField_1));
        Assertions.assertTrue((group_1.getId() == this.data.getTestGroupID() ? 1 : 0) != 0, (String)"ID of Group fetched from the SchemaView.Schema differs from expected one");
        Assertions.assertTrue((schemaToField_1.getSchemaID() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"ID of SchemaToField fetched from SchemaView.Schema differs from expected one");
        SchemaToField schema_to_field = schema_to_fields_1.get(0);
        Schema schema_1_bis = schema_to_field.getSchema();
        Field field_1_bis = schema_to_field.getField();
        logger.info("");
        logger.info("Schema fetched from SchemaView.SchemaToField      : " + String.valueOf(schema_1_bis));
        logger.info("Field fetched from SchemaView.SchemaToField       : " + field_1_bis.toShortString());
        Assertions.assertTrue((schema_1_bis.getId() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"Schema ID fetched from SchemaView.SchemaToField differs from expected one");
        Assertions.assertTrue((field_1_bis.getId() == this.data.getTestFieldID() ? 1 : 0) != 0, (String)"Field ID fetched from SchemaView.SchemaToField differs from expected one");
        logger.info("");
        logger.info("testSchemaViewDAO: completed\n");
    }

    public void testRuleDefinitionDAO() {
        this.logHorizontalLine();
        logger.info("TESTING RULE DAO");
        logger.info("");
        RuleDefinitionDAO ruleDefinitionDAO = (RuleDefinitionDAO)((Object)this.daoFactory.getDAO(DAO.RULE_DEFINITION));
        boolean verbose = false;
        int maxRuleID = ruleDefinitionDAO.getMaxID();
        logger.info("");
        logger.info("Maximum RuleID: " + maxRuleID);
        logger.info("");
        Assertions.assertTrue((maxRuleID == 360 ? 1 : 0) != 0, (String)"ID of maximum rule differs from expected one");
        List allRules = ruleDefinitionDAO.getAll();
        logger.info("Total number of loaded rules : " + allRules.size());
        if (verbose) {
            logger.info("");
            logger.info("List of all Rules:");
            logger.info("");
            for (RuleDefinition rule : allRules) {
                logger.info(rule.toString());
            }
        }
        Assertions.assertTrue((allRules.size() == 76 ? 1 : 0) != 0, (String)"Total number of rules differs from expected one");
        int ruleID_1 = 20;
        int ruleID_2 = 200;
        logger.info("");
        logger.info("Get Rule by ID:");
        RuleDefinition rule_1 = (RuleDefinition)ruleDefinitionDAO.getByID(ruleID_1);
        RuleDefinition rule_2 = (RuleDefinition)ruleDefinitionDAO.getByID(ruleID_2);
        logger.info("");
        logger.info("Main test Rule                             : " + rule_1.toString());
        logger.info("Another test Rule                          : " + rule_2.toString());
        int protocolID = 1;
        ProtocolToRule protocolToRule_short = rule_1.getProtocolToRule(protocolID);
        List<RuleToField> ruleToFields_short = rule_2.getRuleToField(protocolID);
        logger.info("");
        logger.info("ProtocolToRule fetched via DAO shortcut    : " + String.valueOf(protocolToRule_short));
        logger.info("RuleToField fetched via DAO shortcut       : " + RuleToField.fieldsToString(ruleToFields_short));
        Assertions.assertTrue((protocolToRule_short.getRuleID() == ruleID_1 ? 1 : 0) != 0, (String)"Rule's ID fetched from Rule.ProtocolToRule differs expeted one");
        Assertions.assertTrue((ruleToFields_short.size() == 7 ? 1 : 0) != 0, (String)"Number of RuleToFields fetched from Rule.ProtocolToRule differs expeted one");
        if (this.jpa) {
            logger.info("");
            logger.info("Using JPA datasource -> skip test on sub-objects");
            return;
        }
        ValidationMessage validationMessage_1 = rule_1.getValidationMessage();
        RuleDefinition rule_1_ter = validationMessage_1.getRuleDefinition(ruleID_1);
        logger.info("");
        logger.info("Rule.ValidationMessage                     : " + String.valueOf(validationMessage_1));
        logger.info("Rule fetched from Rule.ValidationMessage   : " + String.valueOf(rule_1_ter));
        Assertions.assertTrue((boolean)rule_1_ter.equals(rule_1), (String)"Rule fetched from Rule.ValidationMessage differs from rule_1");
        logger.info("");
        logger.info("testRuleDAO: completed\n");
    }

    public void testProtocolDAO() {
        this.logHorizontalLine();
        logger.info("TESTING PROTOCOL DAO");
        logger.info("");
        ProtocolDAO protocolDAO = (ProtocolDAO)((Object)this.daoFactory.getDAO(DAO.PROTOCOL));
        boolean verbose = false;
        int maxProtocolID = protocolDAO.getMaxID();
        logger.info("");
        logger.info("Maximum ProtocolID: " + maxProtocolID);
        List allProtocols = protocolDAO.getAll();
        logger.info("");
        logger.info("Total number of Protocols: " + allProtocols.size());
        if (verbose) {
            logger.info("");
            logger.info("List of all Protocols:");
            for (Protocol protocol : allProtocols) {
                logger.info(protocol.toString());
            }
        }
        Assertions.assertTrue((maxProtocolID == 17 ? 1 : 0) != 0, (String)"Maxium ID of Protocols differs from expected one");
        Assertions.assertTrue((allProtocols.size() == 14 ? 1 : 0) != 0, (String)"Total number of Protocols differs from expected one");
        int protocolID_1 = 1;
        int protocolID_2 = 2;
        logger.info("");
        logger.info("Get Protocol by ID:");
        Protocol protocol_1 = (Protocol)protocolDAO.getByID(protocolID_1);
        Protocol protocol_2 = (Protocol)protocolDAO.getByID(protocolID_2);
        logger.info("");
        logger.info("Main test Protocol                             : " + protocol_1.toShortString());
        logger.info("Another test Protocol                          : " + protocol_2.toShortString());
        Assertions.assertTrue((protocol_1.getSchemaID() == 1 ? 1 : 0) != 0, (String)"Schema ID of test Protocol differs from expected one");
        Assertions.assertTrue((protocol_2.getSchemaID() == 2 ? 1 : 0) != 0, (String)"Schema ID of another Protocol differs from expected one");
        int ruleID = 20;
        ProtocolToRule protocol_short = protocol_1.getProtocolToRule(ruleID);
        List<RuleToField> ruleToFields_short = protocol_1.getRuleToField(ruleID);
        logger.info("");
        logger.info("ProtocolToRule fetched via DAO shortcut        : " + String.valueOf(protocol_short));
        logger.info("RuleToField fetched via DAO shortcut           : " + RuleToField.fieldsToString(ruleToFields_short));
        Assertions.assertTrue((boolean)protocol_short.isBlocking(), (String)"ProtocolToRule fetched via DAO shortcut should be BLOCKING");
        if (this.jpa) {
            logger.info("");
            logger.info("Using JPA datasource -> skip test on sub-objects");
            return;
        }
        logger.info("");
        logger.info("Status of sub-objects for                      : protocolID=" + protocolID_1 + ", ruleID=" + ruleID);
        Schema schema_1 = protocol_1.getSchema();
        Schema parent_1 = schema_1.getParent();
        SchemasGroup group_1 = schema_1.getSchemaGroup();
        List<SchemaToField> schemaToFields = schema_1.getAllSchemaToField();
        Protocol protocol_1_bis = schema_1.getProtocol(protocolID_1);
        logger.info("");
        logger.info("Group fetched from Protocol.Schema             : " + String.valueOf(group_1));
        logger.info("Parent fetched from Protocol.Schema            : " + String.valueOf(parent_1));
        logger.info("SchemaToFields fetched from Protocol.Schema    : " + schemaToFields.size());
        logger.info("Protocol fetched from Protocol.Schema          : " + String.valueOf(protocol_1_bis));
        Assertions.assertTrue((group_1.getId() == this.data.getTestGroupID() ? 1 : 0) != 0, (String)"Group fetched from Protocol.Schema differs from group_1");
        Assertions.assertTrue((schemaToFields.size() == this.data.getNumberOfAllFieldsInTestSchema() ? 1 : 0) != 0, (String)"Fields list fetched from Protocol.Schema has wrong size");
        Assertions.assertTrue((protocol_1 == protocol_1_bis ? 1 : 0) != 0, (String)"Protocol fetched from Protocol.Schema differs from protocol_1");
        List<ProtocolToRule> allProtocolToRule = protocol_1.getAllProtocolToRule();
        ProtocolToRule protocolToRule_1 = allProtocolToRule.get(0);
        Protocol protocol_1_ter = protocolToRule_1.getProtocol();
        RuleDefinition rule_1 = protocolToRule_1.getRule();
        logger.info("");
        logger.info("Protocol fetched from Protocol.ProtocolToRule  : " + String.valueOf(protocol_1_ter));
        logger.info("Rule fetched from Protocol.ProtocolToRule      : " + String.valueOf(rule_1));
        Assertions.assertTrue((protocol_1_ter == protocol_1 ? 1 : 0) != 0, (String)"Protocol fetched from Protocol.ProtocolToRule differs from expected one");
        Assertions.assertTrue((rule_1.getId() == ruleID ? 1 : 0) != 0, (String)"Rule fetched from Protocol.ProtocolToRule differs from expected one");
        List<RuleToField> allRuleToField = protocol_1.getAllRuleToField();
        RuleToField ruleToField_1 = allRuleToField.get(0);
        Protocol protocol_1_quater = ruleToField_1.getProtocol();
        RuleDefinition rule_1_bis = ruleToField_1.getRule();
        logger.info("");
        logger.info("Protocol fetched from Protocol.RuleToField     : " + String.valueOf(protocol_1_quater));
        logger.info("Rule fetched from Protocol.RuleToField         : " + String.valueOf(rule_1_bis));
        Assertions.assertTrue((protocol_1_quater == protocol_1 ? 1 : 0) != 0, (String)"Protocol fetched from Protocol.RuleToField differs from expected one");
        Assertions.assertTrue((rule_1_bis.getId() == ruleID ? 1 : 0) != 0, (String)"Rule fetched from Protocol.RuleToField differs from expected one");
        List<ValidationRun> allValidationRuns = protocol_1.getAllValidationRun();
        ValidationRun validationRun_1 = allValidationRuns.get(0);
        Protocol protocol_1_quinque = validationRun_1.getProtocol();
        List<RuleOutput> allRuleOutput = validationRun_1.getAllRuleOutput();
        RuleOutput ruleOutput = allRuleOutput.get(0);
        logger.info("");
        logger.info("Main test Protocol                             : " + protocol_1.toShortString());
        logger.info("Protocol fetched from Protocol.ValidationRun   : " + protocol_1_quinque.toShortString());
        logger.info("RuleOutput fetched from Protocol.ValidationRun : " + String.valueOf(ruleOutput));
        Assertions.assertTrue((boolean)protocol_1_quinque.equals(protocol_1), (String)"Protocol fetched from Protocol.ValidationRun differs from expected one");
        Assertions.assertTrue((ruleOutput.getId() == 100 ? 1 : 0) != 0, (String)"RuleOutput fetched from Protocol.ValidationRun differs from expected one");
        logger.info("");
        logger.info("testProtocolDAO: completed\n");
    }

    public void testProtocolToRuleDAO() {
        this.logHorizontalLine();
        logger.info("TESTING PROTOCOL_TO_RULE DAO");
        logger.info("");
        ProtocolToRuleDAO protocolToRuleDAO = (ProtocolToRuleDAO)((Object)this.daoFactory.getDAO(DAO.PROTOCOL_TO_RULE));
        boolean verbose = false;
        int maxProtocolToRuleID = protocolToRuleDAO.getMaxID();
        logger.info("");
        logger.info("Maximum protocolToRuleID: " + maxProtocolToRuleID);
        logger.info("");
        int counter = 1;
        int maxRows = verbose ? 50 : 10;
        List allProtocolToRules = protocolToRuleDAO.getAll();
        logger.info("");
        logger.info("Total number of ProtocolToRules: " + allProtocolToRules.size());
        logger.info("");
        logger.info("List of first " + maxRows + " ProtocolToRules:");
        logger.info("");
        for (ProtocolToRule protocolToRule : allProtocolToRules) {
            logger.info(protocolToRule.toString());
            if (counter++ < maxRows) continue;
            break;
        }
        Assertions.assertTrue((maxProtocolToRuleID == 770 ? 1 : 0) != 0, (String)"Maximum ID of ProtocolToRule differs from expected one");
        Assertions.assertTrue((allProtocolToRules.size() == 157 ? 1 : 0) != 0, (String)"Total number of ProtocolToRule differs from expected one");
        int protocolToRuleID_1 = 1;
        int protocolToRuleID_2 = 20;
        logger.info("");
        logger.info("Get ProtocolToRule by ID:");
        ProtocolToRule protocolToRule_1 = (ProtocolToRule)protocolToRuleDAO.getByID(protocolToRuleID_1);
        ProtocolToRule protocolToRule_2 = (ProtocolToRule)protocolToRuleDAO.getByID(protocolToRuleID_2);
        logger.info("");
        logger.info("Main test ProtocolToRule                                       : " + protocolToRule_1.toString());
        logger.info("Another test ProtocolToRule                                    : " + protocolToRule_2.toString());
        Assertions.assertTrue((protocolToRule_1.getRuleID() == 20 ? 1 : 0) != 0, (String)"Schema ID of test ProtocolToRule differs from expected one");
        Assertions.assertTrue((protocolToRule_2.getRuleID() == 200 ? 1 : 0) != 0, (String)"Schema ID of another ProtocolToRule differs from expected one");
        int protocolToRuleID_3 = 650;
        logger.info("");
        logger.info("Get \"minor\" ProtocolToRule by ID:");
        ProtocolToRule protocolToRule_3 = (ProtocolToRule)protocolToRuleDAO.getByID(protocolToRuleID_3);
        Protocol protocol_3 = protocolToRule_3.getProtocol();
        Schema schema_3 = protocol_3.getSchema();
        SchemasGroup group_3 = schema_3.getSchemaGroup();
        logger.info("");
        logger.info("1st minor ProtocolToRule                                       : " + protocolToRule_3.toString());
        logger.info("Protocol fetched from 1st minor ProtocolToRule                 : " + protocol_3.toShortString());
        logger.info("Schema fetched from 1st minor ProtocolToRule                   : " + String.valueOf(schema_3));
        logger.info("SchemasGroup fetched from 1st ProtocolToRule                   : " + String.valueOf(group_3));
        if (this.jpa) {
            logger.info("");
            logger.info("Using JPA datasource -> skip test on sub-objects");
            return;
        }
        int ruleID_1 = protocolToRule_1.getRuleID();
        int protocolID_1 = protocolToRule_1.getProtocolID();
        logger.info("");
        logger.info("Status of sub-objects for                                      : protocolID=" + protocolID_1 + ", ruleID=" + ruleID_1);
        Protocol protocol_1 = protocolToRule_1.getProtocol();
        Schema schema_1 = protocol_1.getSchema();
        ProtocolToRule protocolToRule_1_bis = protocol_1.getProtocolToRule(ruleID_1);
        List<RuleToField> ruleToFields_1_bis = protocol_1.getRuleToField(ruleID_1);
        logger.info("");
        logger.info("Schema fetched from ProtocolToRule.Protocol                    : " + String.valueOf(schema_1));
        logger.info("ProtocolToRule fetched from ProtocolToRule.Protocol            : " + String.valueOf(protocolToRule_1_bis));
        logger.info("RuleToField fetched from ProtocolToRule.Protocol               : " + RuleToField.fieldsToString(ruleToFields_1_bis));
        Assertions.assertTrue((schema_1.getId() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"Schema fetched from ProtocolToRule.Protocol differs from expected one");
        Assertions.assertTrue((boolean)protocolToRule_1_bis.equals(protocolToRule_1), (String)"ProtocolToRule fetched from ProtocolToRule.Protocol differs from protocolToRule_1");
        Assertions.assertTrue((ruleToFields_1_bis.size() == 1 ? 1 : 0) != 0, (String)"RuleToField fetched from ProtocolToRule.Protocol differs from expected one");
        RuleDefinition rule_1 = protocolToRule_1.getRule();
        RuleType ruleType_1 = rule_1.getRuleType();
        ValidationMessage message_1 = rule_1.getValidationMessage();
        ProtocolToRule protocolToRule_1_ter = rule_1.getProtocolToRule(protocolID_1);
        List<RuleToField> ruleToFields_1_ter = rule_1.getRuleToField(protocolID_1);
        logger.info("");
        logger.info("RuleType fetched from ProtocolToRule.Rule                      : " + String.valueOf((Object)ruleType_1));
        logger.info("ProtocolToRule fetched from ProtocolToRule.Rule                : " + String.valueOf(protocolToRule_1_ter));
        logger.info("RuleToField fetched from ProtocolToRule.Rule                   : " + RuleToField.fieldsToString(ruleToFields_1_ter));
        logger.info("ValidationMessage fetched from ProtocolToRule.Rule             : " + String.valueOf(message_1));
        Assertions.assertTrue((ruleType_1 == RuleType.FILE_FORMAT ? 1 : 0) != 0, (String)"RuleType fetched from ProtocolToRule.Rule differs from expected one");
        Assertions.assertTrue((boolean)protocolToRule_1_ter.equals(protocolToRule_1), (String)"ProtocolToRule fetched from ProtocolToRule.Rule differs from protocolToRule_1");
        Assertions.assertTrue((ruleToFields_1_ter.size() == 1 ? 1 : 0) != 0, (String)"RuleToField fetched from ProtocolToRule.Rule differs from expected one");
        logger.info("");
        logger.info("testProtocolToRuleDAO: completed\n");
    }

    public void testRuleToFieldDAO() {
        this.logHorizontalLine();
        logger.info("TESTING RULE_TO_FIELD DAO");
        logger.info("");
        RuleToFieldDAO ruleToFieldDAO = (RuleToFieldDAO)((Object)this.daoFactory.getDAO(DAO.RULE_TO_FIELD));
        int maxRuleToFieldID = ruleToFieldDAO.getMaxID();
        logger.info("");
        logger.info("Maximum ruleToFieldID: " + maxRuleToFieldID);
        logger.info("");
        int counter = 1;
        int maxRows = 10;
        List allRuleToFields = ruleToFieldDAO.getAll();
        logger.info("List of first " + maxRows + " RuleToField:");
        logger.info("");
        for (RuleToField ruleToFields : allRuleToFields) {
            logger.info(ruleToFields.toString());
            if (counter++ < maxRows) continue;
            break;
        }
        int ruleToFieldID_1 = 10;
        int ruleToFieldID_2 = 20;
        logger.info("");
        logger.info("Get RuleToField by ID:");
        RuleToField ruleToField_1 = (RuleToField)ruleToFieldDAO.getByID(ruleToFieldID_1);
        RuleToField ruleToField_2 = (RuleToField)ruleToFieldDAO.getByID(ruleToFieldID_2);
        logger.info("");
        logger.info("Main test RuleToField                                          : " + ruleToField_1.toString());
        logger.info("Another test RuleToField                                       : " + ruleToField_2.toString());
        if (this.jpa) {
            logger.info("");
            logger.info("Using JPA datasource -> skip test on sub-objects");
            return;
        }
        int ruleID_1 = ruleToField_1.getRuleID();
        int protocolID_1 = ruleToField_1.getProtocolID();
        logger.info("");
        logger.info("Status of sub-objects for                                      : protocolID=" + protocolID_1 + ", ruleID=" + ruleID_1);
        Protocol protocol_1 = ruleToField_1.getProtocol();
        Schema schema_1 = protocol_1.getSchema();
        ProtocolToRule protocolToRule_1 = protocol_1.getProtocolToRule(ruleID_1);
        List<RuleToField> ruleToFields_1 = protocol_1.getRuleToField(ruleID_1);
        RuleToField ruleToField_1_single = null;
        for (RuleToField ruleToField : ruleToFields_1) {
            if (ruleToField.getId() != ruleToField_1.getId()) continue;
            ruleToField_1_single = ruleToField;
            break;
        }
        logger.info("");
        logger.info("Schema fetched from RuleToField.Protocol                       : " + String.valueOf(schema_1));
        logger.info("ProtocolToRule fetched from RuleToField.Protocol               : " + String.valueOf(protocolToRule_1));
        logger.info("RuleToFields fetched from RuleToField.Protocol (all)           : " + RuleToField.fieldsToString(ruleToFields_1));
        logger.info("RuleToField fetched from RuleToField.Protocol (single)         : " + ruleToField_1_single.toString());
        Assertions.assertTrue((schema_1.getId() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"Schema fetched from RuleToField.Protocol differs from expected one");
        Assertions.assertTrue((protocolToRule_1.getId() == 1 ? 1 : 0) != 0, (String)"ProtocolToRule fetched from ProtocolToRule.Protocol differs from expected one");
        Assertions.assertTrue((boolean)ruleToField_1_single.equals(ruleToField_1), (String)"RuleToField fetched from RuleToField.Protocol differs from expected one");
        RuleDefinition rule_1 = ruleToField_1.getRule();
        RuleType ruleType_1 = rule_1.getRuleType();
        ValidationMessage message_1 = rule_1.getValidationMessage();
        ProtocolToRule protocolToRule_1_bis = rule_1.getProtocolToRule(protocolID_1);
        List<RuleToField> ruleToFields_1_bis = rule_1.getRuleToField(protocolID_1);
        RuleToField ruleToField_1_single_bis = null;
        for (RuleToField ruleToField : ruleToFields_1_bis) {
            if (ruleToField.getId() != ruleToField_1.getId()) continue;
            ruleToField_1_single_bis = ruleToField;
            break;
        }
        logger.info("");
        logger.info("RuleType fetched from RuleToField.Rule                        : " + String.valueOf((Object)ruleType_1));
        logger.info("ProtocolToRule fetched from RuleToField.Rule                  : " + String.valueOf(protocolToRule_1_bis));
        logger.info("RuleToField fetched from RuleToField.Rule (all)               : " + RuleToField.fieldsToString(ruleToFields_1_bis));
        logger.info("RuleToField fetched from RuleToField.Rule (single)            : " + ruleToField_1_single_bis.toString());
        logger.info("ValidationMessage fetched from RuleToField.Rule               : " + String.valueOf(message_1));
        Assertions.assertTrue((ruleType_1 == RuleType.FILE_FORMAT ? 1 : 0) != 0, (String)"RuleType fetched from ProtocolToRule.Rule differs from expected one");
        Assertions.assertTrue((boolean)protocolToRule_1_bis.equals(protocolToRule_1), (String)"ProtocolToRule fetched from ProtocolToRule.Rule differs from protocolToRule_1");
        Assertions.assertTrue((ruleToFields_1_bis.size() == 1 ? 1 : 0) != 0, (String)"RuleToField fetched from ProtocolToRule.Rule differs from expected one");
        int ruleToFieldID_3 = 90;
        logger.info("");
        logger.info("Status of sub-objects for                                     : ruleToFieldID_3=" + ruleToFieldID_3);
        RuleToField ruleToField_3 = (RuleToField)ruleToFieldDAO.getByID(ruleToFieldID_3);
        Field field_3 = ruleToField_3.getField();
        Range range_3 = field_3.getRange();
        SchemaToField schemaToField_3 = field_3.getSchemaToField(schema_1.getId());
        List<RuleToField> ruleToFields_3 = field_3.getRuleToField(protocolID_1);
        RuleToField ruleToField_3_single = null;
        for (RuleToField ruleToField : ruleToFields_3) {
            if (ruleToField.getId() != ruleToFieldID_3) continue;
            ruleToField_3_single = ruleToField;
            break;
        }
        logger.info("");
        logger.info("Field fetched from RuleToField                                : " + String.valueOf(field_3));
        logger.info("Range fetched from RuleToField.Field                          : " + String.valueOf(range_3));
        logger.info("SchemaToField fetched from RuleToField.Field                  : " + String.valueOf(schemaToField_3));
        logger.info("RuleToField fetched from RuleToField.Field (all rules)        : " + RuleToField.rulesToString(ruleToFields_3));
        logger.info("RuleToField fetched from RuleToField.Field (all fields)       : " + RuleToField.fieldsToString(ruleToFields_3));
        logger.info("RuleToField fetched from RuleToField.Field (single)           : " + ruleToField_3_single.toString());
        Assertions.assertTrue((range_3.getId() == 9 ? 1 : 0) != 0, (String)"Range fetched from RuleToField.Field differs from expected one");
        Assertions.assertTrue((schemaToField_3.getId() == 21 ? 1 : 0) != 0, (String)"SchemaToField fetched from RuleToField.Field differs from expected one");
        Assertions.assertTrue((ruleToFields_3.size() == 7 ? 1 : 0) != 0, (String)"RuleToField size fetched from ProtocolToRule.Rule differs from expected one");
        logger.info("");
        logger.info("testRuleToFieldDAO: completed\n");
    }

    public void testValidationMessageDAO() {
        this.logHorizontalLine();
        logger.info("TESTING VALIDATION_MESSAGE DAO");
        logger.info("");
        ValidationMessageDAO validationMessageDAO = (ValidationMessageDAO)((Object)this.daoFactory.getDAO(DAO.VALIDATION_MESSAGE));
        int maxValidationMessageID = validationMessageDAO.getMaxID();
        logger.info("");
        logger.info("Maximum ValidationMessageID: " + maxValidationMessageID);
        logger.info("");
        int counter = 1;
        int maxRows = 10;
        List allMessages = validationMessageDAO.getAll();
        logger.info("List of first " + maxRows + " ValidationMessage:");
        logger.info("");
        for (ValidationMessage message : allMessages) {
            logger.info(message.toString());
            if (counter++ < maxRows) continue;
            break;
        }
        int messageID_1 = 20;
        int messageID_2 = 30;
        logger.info("");
        logger.info("Get ValidationMessage by ID:");
        ValidationMessage message_1 = (ValidationMessage)validationMessageDAO.getByID(messageID_1);
        ValidationMessage message_2 = (ValidationMessage)validationMessageDAO.getByID(messageID_2);
        logger.info("");
        logger.info("Main test ValidationMessage                  : " + message_1.toString());
        logger.info("Another test ValidationMessage               : " + message_2.toString());
        String keyword = "morphology";
        List<ValidationMessage> messages = validationMessageDAO.getByDescription(keyword);
        logger.info("");
        logger.info("ValidationMessage containing the keyword: " + keyword);
        for (ValidationMessage message : messages) {
            logger.info("ValidationMessage                            : " + String.valueOf(message));
        }
        int ruleID = 20;
        RuleDefinition rule_short = message_1.getRuleDefinition(ruleID);
        logger.info("");
        logger.info("Rule fetched via DAO shortcut                : " + String.valueOf(rule_short));
        RuleDefinition rule_1 = message_1.getRuleDefinitions().get(0);
        RuleType ruleType_1 = rule_1.getRuleType();
        logger.info("");
        logger.info("RuleType fetched from ValidationMessage.Rule : " + String.valueOf((Object)ruleType_1));
        logger.info("");
        logger.info("testValidationMessageDAO: completed\n");
    }

    public void testProtocolViewDAO() {
        this.logHorizontalLine();
        logger.info("TESTING PROTOCOL_VIEW DAO");
        logger.info("");
        ProtocolViewDAO protocolViewDAO = (ProtocolViewDAO)((Object)this.daoFactory.getDAO(DAO.PROTOCOL_VIEW));
        List allViews = protocolViewDAO.getAll();
        int maxProtocolID = protocolViewDAO.getMaxID();
        logger.info("Maximum protocolID (in strict mode): " + maxProtocolID);
        logger.info(this.formatProtocols(allViews, maxProtocolID));
        Assertions.assertTrue((allViews.size() == 14 ? 1 : 0) != 0, (String)"Total number of protocols differs from expected one");
        Assertions.assertTrue((maxProtocolID == 17 ? 1 : 0) != 0, (String)"Maximum ID of protocols differs from expected one");
        boolean verbose = false;
        ProtocolView protocol_view_1 = (ProtocolView)protocolViewDAO.getByID(1);
        ProtocolView protocol_view_2 = (ProtocolView)protocolViewDAO.getByID(2);
        Protocol protocol_1 = protocol_view_1.getProtocol();
        Protocol protocol_2 = protocol_view_2.getProtocol();
        List<ProtocolToRule> protocol_to_rules_1 = protocol_view_1.getProtocolToRules();
        List<ProtocolToRule> protocol_to_rules_2 = protocol_view_2.getProtocolToRules();
        if (verbose) {
            logger.info("");
            logger.info("List of rules in the test protocol: " + String.valueOf(protocol_1) + " (" + protocol_to_rules_1.size() + ")");
            logger.info("");
            for (ProtocolToRule protocolToRule : protocol_to_rules_1) {
                logger.info(protocolToRule.toString());
            }
            logger.info("");
            logger.info("List of rules in another protocol: " + String.valueOf(protocol_2) + " (" + protocol_to_rules_2.size() + ")");
            logger.info("");
            for (ProtocolToRule protocolToRule : protocol_to_rules_2) {
                logger.info(protocolToRule.toString());
            }
        }
        logger.info("");
        logger.info("Checking total number of rules in test protocol      : " + String.valueOf(protocol_view_1));
        logger.info("Checking total number of rules in another protocol   : " + String.valueOf(protocol_view_2));
        Assertions.assertTrue((protocol_view_1.getNumberOfRules() == 53 ? 1 : 0) != 0, (String)"Total number of rules in test protocol differs from expected one");
        Assertions.assertTrue((protocol_view_2.getNumberOfRules() == 0 ? 1 : 0) != 0, (String)"Total number of rules in another protocol differs from expected one");
        boolean ordered = true;
        int counter = 0;
        int maxProtocolToRule = 10;
        ProtocolView protocol_view_ordered = protocolViewDAO.getOrderedByPriority(1);
        Protocol protocol_ordered = protocol_view_ordered.getProtocol();
        List<ProtocolToRule> protocol_to_rules_ordered = protocol_view_ordered.getProtocolToRules();
        if (ordered) {
            String label = verbose ? "all" : "the first " + Integer.toString(maxProtocolToRule);
            logger.info("");
            logger.info("List of " + label + " rules in the test protocol (ordered by priority): " + String.valueOf(protocol_ordered));
            logger.info("");
            for (ProtocolToRule protocolToRule : protocol_to_rules_ordered) {
                logger.info(protocolToRule.getPriority() + ") " + String.valueOf(protocolToRule));
                if (verbose || ++counter <= maxProtocolToRule) continue;
                break;
            }
        }
        logger.info("");
        logger.info("Checking total number of priorities in test protocol : " + protocol_view_ordered.getPriorities().size());
        Assertions.assertTrue((protocol_view_ordered.getPriorities().size() == 8 ? 1 : 0) != 0, (String)"Total number of priorities in test protocol differs from expected one");
        if (this.jpa) {
            logger.info("");
            logger.info("Using JPA datasource -> skip test on sub-objects");
            return;
        }
        int ruleID_1 = DefaultRuleID.RECORD_FORMAT.id;
        int ruleToFieldID_1 = 40;
        logger.info("");
        logger.info("Status of sub-objects for                                      : ruleID=" + ruleID_1 + ", ruleToFieldID=" + ruleToFieldID_1);
        Schema schema_1 = protocol_1.getSchema();
        ProtocolToRule protocolToRule_1 = protocol_1.getProtocolToRule(ruleID_1);
        List<RuleToField> ruleToFields_1 = protocol_1.getRuleToField(ruleID_1);
        RuleToField ruleToField_1_single = null;
        for (RuleToField ruleToField : ruleToFields_1) {
            if (ruleToField.getId() != ruleToFieldID_1) continue;
            ruleToField_1_single = ruleToField;
            break;
        }
        logger.info("");
        logger.info("Schema fetched from ProtocolView.Protocol                      : " + String.valueOf(schema_1));
        logger.info("ProtocolToRule fetched from ProtocolView.Protocol              : " + String.valueOf(protocolToRule_1));
        logger.info("RuleToFields fetched from ProtocolView.Protocol (all)          : " + RuleToField.fieldsToString(ruleToFields_1));
        logger.info("RuleToField fetched from ProtocolView.Protocol (single)        : " + ruleToField_1_single.toString());
        Assertions.assertTrue((schema_1.getId() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"Schema fetched from ProtocolView.Protocol differs from expected one");
        Assertions.assertTrue((protocolToRule_1.getId() == 4 ? 1 : 0) != 0, (String)"ProtocolToRule fetched from ProtocolView.Protocol differs from expected one");
        Protocol protocol_1_bis = protocolToRule_1.getProtocol();
        RuleDefinition rule_1 = protocolToRule_1.getRule();
        logger.info("");
        logger.info("Protocol fetched from ProtocolView.ProtocolToRule              : " + String.valueOf(protocol_1_bis));
        logger.info("Rule fetched from ProtocolView.ProtocolToRule                  : " + String.valueOf(rule_1));
        Assertions.assertTrue((protocol_1_bis == protocol_1 ? 1 : 0) != 0, (String)"Protocol fetched from ProtocolView.ProtocolToRule differs from expected one");
        Assertions.assertTrue((rule_1.getId() == ruleID_1 ? 1 : 0) != 0, (String)"Rule fetched from ProtocolView.ProtocolToRule differs from expected one");
        logger.info("");
        logger.info("ProtocolViewDAO: completed\n");
    }

    public void testDataRecordDAO() {
        List records_1;
        block7: {
            this.logHorizontalLine();
            logger.info("TESTING DATA_RECORD DAO");
            logger.info("");
            DataRecordDAO recordReaderDAO = (DataRecordDAO)((Object)this.daoFactory.getDAO(DAO.DATA_RECORD));
            DataRecordDAO validRecordsDAO = (DataRecordDAO)((Object)this.daoFactory.getDAO(DAO.DATA_RECORD_CORRECT));
            DataRecordDAO invalidRecordsDAO = (DataRecordDAO)((Object)this.daoFactory.getDAO(DAO.DATA_RECORD_WITH_ISSUES));
            boolean verbose = false;
            String windowsDomain = this.getUserDomain();
            if (logger.isInfoEnabled()) {
                logger.info("RecordReaderDAO - Windows domain  : " + windowsDomain);
            }
            boolean personalPC = windowsDomain == null || "LEGION".equalsIgnoreCase(windowsDomain);
            String inputFilePath = personalPC ? "C:/Home/Workspace/test-suite/input/encr/2014/incidence/incidence_2.csv" : "C:/Users/adriste/Home/Workspace/test-suite/input/encr/2014/incidence/incidence_2.csv";
            recordReaderDAO.setDataConnection(new FileConnection(inputFilePath));
            if (verbose) {
                logger.info("");
                logger.info("RecordReaderDAO         : " + String.valueOf(recordReaderDAO));
                logger.info("ValidRecordsDAO         : " + String.valueOf(validRecordsDAO));
                logger.info("InvalidRecordsDAO       : " + String.valueOf(invalidRecordsDAO));
            }
            int counter = 1;
            int maxRows = 10;
            records_1 = null;
            logger.info("");
            logger.info(">>> Reading all lines from dataset: " + inputFilePath);
            logger.info("");
            records_1 = recordReaderDAO.getAll();
            logger.info("");
            logger.info("Sample of first " + maxRows + " records:");
            logger.info("");
            for (DataRecord dataRecord : records_1) {
                logger.info(dataRecord.toShortString());
                if (counter++ < maxRows) continue;
                break;
            }
            DataRecord header = recordReaderDAO.getHeader();
            logger.info("");
            logger.info(">>> Dataset's header: \n");
            logger.info(header.toString());
            counter = 1;
            recordReaderDAO.reset();
            logger.info("");
            logger.info(">>> Reading file line by line (up to " + maxRows + " maximum rows):");
            logger.info("");
            do {
                DataRecord record = null;
                try {
                    record = recordReaderDAO.getNext();
                }
                catch (EndOfDataConnetionException e) {
                    logger.info(e.getMessage());
                    break block7;
                }
                catch (ExhaustedDataConnectionException e) {
                    logger.error(e.getMessage());
                    break block7;
                }
                logger.info(counter + ") " + record.toShortString() + " (cursor=" + recordReaderDAO.getCursor() + ")");
            } while (counter++ < maxRows);
            logger.info("Closing connection...");
            recordReaderDAO.closeConnection();
        }
        int index = 1;
        DataRecord record_1 = (DataRecord)records_1.get(0);
        Object[] columns = record_1.getColumnNames();
        logger.info("");
        logger.info(">>> Testing DataRecordCSV APIs (for the 1st record)");
        logger.info("");
        logger.info("Record's header  : " + Arrays.toString(columns));
        logger.info("Record's data    : " + record_1.toShortString());
        logger.info("Value by index   : " + record_1.getValue(index));
        logger.info("Value by column  : " + record_1.getValue((String)columns[index]));
        logger.info("");
        logger.info("");
        logger.info("testDataRecordDAO: completed\n");
    }

    public void testValidationRunDAO() {
        this.logHorizontalLine();
        logger.info("TESTING VALIDATION_RUN DAO");
        logger.info("");
        ValidationRunDAO validationRunDAO = (ValidationRunDAO)((Object)this.daoFactory.getDAO(DAO.VALIDATION_RUN));
        int expectedMaxValidationRunID = 3;
        int totalValidationRunRecords = 3;
        int maxValidationRunID = validationRunDAO.getMaxID();
        logger.info("");
        logger.info("Maximum ValidationRunID: " + maxValidationRunID);
        logger.info("");
        Assertions.assertTrue((maxValidationRunID == expectedMaxValidationRunID ? 1 : 0) != 0, (String)"Maximum ValidationRun's ID differs from expected one");
        List validationRuns = validationRunDAO.getAll();
        logger.info("List of all ValidationRuns:");
        logger.info("");
        for (ValidationRun validationRun : validationRuns) {
            logger.info(validationRun.toString());
        }
        Assertions.assertTrue((validationRuns.size() == totalValidationRunRecords ? 1 : 0) != 0, (String)"Total number of ValidationRun differs from expected one");
        int runID_1 = 1;
        int runID_2 = 2;
        logger.info("");
        logger.info("Get ValidationRun by ID:");
        ValidationRun run_1 = (ValidationRun)validationRunDAO.getByID(runID_1);
        ValidationRun run_2 = (ValidationRun)validationRunDAO.getByID(runID_2);
        logger.info("");
        logger.info("Main test ValidationRun                    : " + run_1.toString());
        logger.info("Another test ValidationRun                 : " + run_2.toString());
        Assertions.assertTrue((run_1.getId() == runID_1 ? 1 : 0) != 0, (String)"ID of the first ValidationRun fetched by ID differs from expected one");
        Assertions.assertTrue((run_2.getId() == runID_2 ? 1 : 0) != 0, (String)"ID of another ValidationRun fetched by ID differs from expected one");
        int lineNumber = 1;
        List<RuleOutput> ruleOutputs = run_1.getRuleOutput(lineNumber);
        logger.info("");
        logger.info("RuleOutputs fetched via DAO shortcut       : " + ruleOutputs.size());
        Assertions.assertTrue((ruleOutputs.size() == 3 ? 1 : 0) != 0, (String)"Number of RuleOutputs fetched via DAO shortcut differs from expected one");
        int ruleID_1 = 20;
        logger.info("");
        logger.info("Status of sub-objects                      : ruleID=" + ruleID_1);
        Protocol protocol_1 = run_1.getProtocol();
        Schema schema_1 = protocol_1.getSchema();
        ProtocolToRule protocolToRule_1 = protocol_1.getProtocolToRule(ruleID_1);
        List<RuleToField> ruleToFields_1 = protocol_1.getRuleToField(ruleID_1);
        logger.info("");
        logger.info("Schema fetched from ValidationRun.Protocol                     : " + String.valueOf(schema_1));
        logger.info("ProtocolToRule fetched from ValidationRun.Protocol             : " + String.valueOf(protocolToRule_1));
        logger.info("RuleToField fetched from ValidationRun.Protocol                : " + RuleToField.fieldsToString(ruleToFields_1));
        Assertions.assertTrue((schema_1.getId() == this.data.getTestSchemaID() ? 1 : 0) != 0, (String)"Schema fetched from ValidationRun.Protocol differs from expected one");
        Assertions.assertTrue((protocolToRule_1.getId() == 1 ? 1 : 0) != 0, (String)"ProtocolToRule fetched from ValidationRun.Protocol differs from expected one");
        Assertions.assertTrue((ruleToFields_1.size() == 1 ? 1 : 0) != 0, (String)"RuleToField fetched from ValidationRun.Protocol differs from expected one");
        RuleOutput ruleOutput_1 = ruleOutputs.get(0);
        ValidationRun run_1_bis = ruleOutput_1.getValidationRun();
        List<RuleOutputDetail> details = ruleOutput_1.getAllRuleOutputDetail();
        logger.info("");
        logger.info("Checking that RuleOutput is fully loaded                       : " + ruleOutput_1.getId());
        logger.info("ValidationRun fetched from ValidationRun.RuleOutput            : " + String.valueOf(run_1_bis));
        logger.info("List of RuleOutputDetail fetched from ValidationRun.RuleOutput : " + details.size());
        for (int i = 0; i < details.size(); ++i) {
            RuleOutputDetail ruleOutputDetail = details.get(i);
            logger.info(" " + (i + 1) + ") RuleOutputDetail fetched from ValidationRun.RuleOutput     : " + String.valueOf(ruleOutputDetail));
        }
        Assertions.assertTrue((boolean)run_1_bis.equals(run_1), (String)"ValidationRun fetched from ValidationRun.RuleOutput differs from original one");
        Assertions.assertTrue((details.size() == 2 ? 1 : 0) != 0, (String)"Number of RuleOutputDetail differs from expected");
        Assertions.assertTrue((details.get(0).getId() == 300 ? 1 : 0) != 0, (String)"RuleOutputDetail fetched from ValidationRun.RuleOutput differs from expected");
        logger.info("");
        logger.info("testValidationRunDAO: completed\n");
    }

    public void testRuleOutputDAO() {
        this.logHorizontalLine();
        logger.info("TESTING RULE_OUTPUT DAO");
        logger.info("");
        RuleOutputDAO ruleOutputDAO = (RuleOutputDAO)((Object)this.daoFactory.getDAO(DAO.RULE_OUTPUT));
        boolean verbose = false;
        boolean lastValidationRun = true;
        ruleOutputDAO.setLastValidationRun(lastValidationRun);
        int runRuleOutputRecords = 13;
        int totalRuleOutputRecords = 39;
        int expectedMaxRuleOutputID = 312;
        int maxRuleOutputID = ruleOutputDAO.getMaxID();
        logger.info("");
        logger.info("Maximum RuleOutputID: " + maxRuleOutputID);
        Assertions.assertTrue((maxRuleOutputID == expectedMaxRuleOutputID ? 1 : 0) != 0, (String)"Maximum RuleOutput's ID differs from expected one");
        int counter = 1;
        int maxRows = 10;
        List ruleOutputs = ruleOutputDAO.getAll();
        if (verbose) {
            logger.info("");
            logger.info("List of first " + maxRows + " RuleOutputs [total=" + ruleOutputs.size() + "]:");
            logger.info("");
            for (RuleOutput ruleOutput : ruleOutputs) {
                logger.info(ruleOutput.toString());
                if (counter++ < maxRows) continue;
                break;
            }
        }
        if (lastValidationRun) {
            Assertions.assertTrue((ruleOutputs.size() == runRuleOutputRecords ? 1 : 0) != 0, (String)"Total number of RuleOutput differs from expected one");
        } else {
            Assertions.assertTrue((ruleOutputs.size() == totalRuleOutputRecords ? 1 : 0) != 0, (String)"Total number of RuleOutput differs from expected one");
        }
        logger.info("");
        if (lastValidationRun) {
            logger.info("LastValidationRun -> main record is NULL");
        }
        int ruleOutputID_1 = 112;
        int ruleOutputID_2 = 312;
        logger.info("");
        logger.info("Get RuleOutput by ID:");
        RuleOutput ruleOutput_1 = (RuleOutput)ruleOutputDAO.getByID(ruleOutputID_1);
        RuleOutput ruleOutput_2 = (RuleOutput)ruleOutputDAO.getByID(ruleOutputID_2);
        logger.info("Main test RuleOutput                       : " + ruleOutput_1.toString());
        logger.info("Another test RuleOutput                    : " + ruleOutput_2.toString());
        Assertions.assertTrue((ruleOutput_2.getId() == ruleOutputID_2 ? 1 : 0) != 0, (String)"ID of another RuleOutput fetched by ID differs from expected one");
        if (!lastValidationRun) {
            Assertions.assertTrue((ruleOutput_1.getId() == ruleOutputID_1 ? 1 : 0) != 0, (String)"ID of the first RuleOutput fetched by ID differs from expected one");
        }
        counter = 1;
        int validationRunID = ruleOutput_2.getValidationRunID();
        List<RuleOutput> ruleOutputsByValidationRun = ruleOutputDAO.getByValidationRunID(validationRunID);
        if (verbose) {
            logger.info("");
            logger.info("List of first " + maxRows + " RuleOutputs by VALIDATION_RUN [total=" + ruleOutputsByValidationRun.size() + "]:");
            logger.info("");
            for (RuleOutput ruleOutput : ruleOutputsByValidationRun) {
                logger.info(ruleOutput.toString());
                if (counter++ < maxRows) continue;
                break;
            }
        }
        Assertions.assertTrue((ruleOutputsByValidationRun.size() == runRuleOutputRecords ? 1 : 0) != 0, (String)"Total number of RuleOutput by ValidationRun differs from expected one");
        int firstRuleOutputID = 300;
        ruleOutputDAO.resetAll();
        RuleOutput firstRuleOutput = ruleOutputDAO.getNextByValidationRunID(validationRunID);
        RuleOutput secondRuleOutput = ruleOutputDAO.getNextByValidationRunID(validationRunID);
        logger.info("");
        logger.info("First RuleOutput by \"byNext()\"             : " + firstRuleOutput.toShortString());
        logger.info("Second RuleOutput by \"byNext()\"            : " + secondRuleOutput.toShortString());
        Assertions.assertTrue((firstRuleOutput.getId() == firstRuleOutputID ? 1 : 0) != 0, (String)"ID of 1st RuleOutput fetched \"byNext()\" differs from expected one");
        Assertions.assertTrue((secondRuleOutput.getId() == firstRuleOutputID + 1 ? 1 : 0) != 0, (String)"ID of 2nd RuleOutput fetched \"byNext()\" differs from expected one");
        int protocolID = 11;
        ValidationOptions validationOptions = Configuration.getInstance().getValidationOptions();
        List<ReferenceField> referenceFields = validationOptions.getReferenceFields(protocolID);
        ReferenceData referenceDataSingleton = new ReferenceData(referenceFields, true);
        ReferenceData referenceData = ruleOutput_2.getReferenceData();
        referenceData.setReferenceData(referenceDataSingleton);
        List<ReferenceDatum> referenceDataAsList = referenceData.getAllReferenceData();
        logger.info("");
        logger.info("ReferenceData for another test RuleOutput  : " + referenceData.toShortString());
        logger.info("ReferenceData for another test RuleOutput  : " + String.valueOf(referenceData));
        Assertions.assertTrue((referenceDataAsList != null ? 1 : 0) != 0, (String)"Null list of ReferenceDatum in another test RuleOutput");
        Assertions.assertTrue((referenceDataAsList.size() == 10 ? 1 : 0) != 0, (String)"Wrong number of ReferenceDatum in another test RuleOutput");
        int lineNumber = 3;
        logger.info("");
        logger.info("Status of sub-objects parameters           : lineNumber = " + lineNumber);
        ValidationRun validationRun_1 = ruleOutput_2.getValidationRun();
        Protocol protocol_1 = validationRun_1.getProtocol();
        List<RuleOutput> allRuleOutput = validationRun_1.getAllRuleOutput();
        List<RuleOutput> allRuleOutputByLine = validationRun_1.getRuleOutput(lineNumber);
        RuleOutput ruleOutput_2_bis = allRuleOutput.get(12);
        logger.info("");
        logger.info("Checking status of sub-objects for RuleOutput                     : " + String.valueOf(ruleOutput_2));
        logger.info("ValidationRun fetched from RuleOutput                             : " + String.valueOf(validationRun_1));
        logger.info("Protocol fetched from RuleOutput.ValidationRun                    : " + String.valueOf(protocol_1));
        logger.info("List of ALL RuleOutputs fetched from RuleOutput.ValidationRun     : " + allRuleOutput.size());
        logger.info("List of RuleOutputs fetched from RuleOutput.ValidationRun BY LINE : " + allRuleOutputByLine.size());
        logger.info("RuleOutput fetched from RuleOutput.ValidationRun                  : " + String.valueOf(ruleOutput_2_bis));
        Assertions.assertTrue((protocol_1.getId() == 1 ? 1 : 0) != 0, (String)"Protocol fetched from Protocol.ValidationRun differs from expected one");
        Assertions.assertTrue((boolean)ruleOutput_2.equals(ruleOutput_2_bis), (String)"RuleOutput fetched from RuleOutput.ValidationRun differs from expected one");
        List<RuleOutputDetail> ruleOutputDetails = ruleOutput_2.getAllRuleOutputDetail();
        RuleOutputDetail ruleOutputDetail_2 = ruleOutputDetails.get(0);
        RuleOutput ruleOutput_2_ter = ruleOutputDetail_2.getRuleOutput();
        logger.info("");
        logger.info("Checking status of sub-objects for RuleOutput                     : " + String.valueOf(ruleOutput_2));
        logger.info("List of ALL RuleOutputDetails fetched from RuleOutput             : " + ruleOutputDetails.size());
        for (int i = 0; i < ruleOutputDetails.size(); ++i) {
            RuleOutputDetail ruleOutputDetail = ruleOutputDetails.get(i);
            logger.info(" " + (i + 1) + ") RuleOutputDetail fetched from RuleOutput                      : " + String.valueOf(ruleOutputDetail));
        }
        logger.info("RuleOutput fetched from 1st RuleOutput.RuleOutputDetail           : " + String.valueOf(ruleOutput_2_ter));
        Assertions.assertTrue((ruleOutputDetail_2.getId() == 511 ? 1 : 0) != 0, (String)"RuleOutputDetail fetched from RuleOutput.RuleOutputDetail differs from expected one");
        Assertions.assertTrue((ruleOutputDetails.size() == 2 ? 1 : 0) != 0, (String)"Number of RuleOutputDetail differs from expected");
        Assertions.assertTrue((boolean)ruleOutput_2_ter.equals(ruleOutput_2), (String)"RuleOutput fetched from RuleOutput.RuleOutputDetail differs from expected");
        logger.info("");
        logger.info("testRuleOutputDAO: completed\n");
    }

    public void testRuleOutputDetailDAO() {
        this.logHorizontalLine();
        logger.info("TESTING RULE_OUTPUT_DETAIL DAO");
        logger.info("");
        RuleOutputDetailDAO ruleOutputDetailDAO = (RuleOutputDetailDAO)((Object)this.daoFactory.getDAO(DAO.RULE_OUTPUT_DETAIL));
        boolean verbose = false;
        boolean lastValidationRun = true;
        ruleOutputDetailDAO.setLastValidationRun(lastValidationRun);
        int runRuleOutputDetailRecords = 13;
        int totalRuleOutputDetailRecords = 39;
        int expectedMaxRuleOutputDetailID = 512;
        int maxRuleOutputDetailID = ruleOutputDetailDAO.getMaxID();
        logger.info("");
        logger.info("Maximum RuleOutputDetailID: " + maxRuleOutputDetailID);
        Assertions.assertTrue((maxRuleOutputDetailID == expectedMaxRuleOutputDetailID ? 1 : 0) != 0, (String)"Maximum RuleOutputDetail's ID differs from expected one");
        int counter = 1;
        int maxRows = 10;
        List ruleOutputDetails = ruleOutputDetailDAO.getAll();
        if (verbose) {
            logger.info("");
            logger.info("List of first " + maxRows + " RuleOutputDetails [total=" + ruleOutputDetails.size() + "]:");
            logger.info("");
            for (RuleOutputDetail ruleOutputDetail : ruleOutputDetails) {
                logger.info(ruleOutputDetail.toString());
                if (counter++ < maxRows) continue;
                break;
            }
        }
        if (lastValidationRun) {
            Assertions.assertTrue((ruleOutputDetails.size() == runRuleOutputDetailRecords ? 1 : 0) != 0, (String)"Total number of RuleOutputDetail differs from expected one");
        } else {
            Assertions.assertTrue((ruleOutputDetails.size() == totalRuleOutputDetailRecords ? 1 : 0) != 0, (String)"Total number of RuleOutputDetail differs from expected one");
        }
        int ruleOutputDetailID_1 = 312;
        int ruleOutputDetailID_2 = 512;
        logger.info("");
        logger.info("Get RuleOutputDetail by ID:");
        RuleOutputDetail ruleOutputDetail_1 = (RuleOutputDetail)ruleOutputDetailDAO.getByID(ruleOutputDetailID_1);
        RuleOutputDetail ruleOutputDetail_2 = (RuleOutputDetail)ruleOutputDetailDAO.getByID(ruleOutputDetailID_2);
        logger.info("");
        logger.info("Main test RuleOutputDetail                       : " + ruleOutputDetail_1.toString());
        logger.info("Another test RuleOutputDetail                    : " + ruleOutputDetail_2.toString());
        Assertions.assertTrue((ruleOutputDetail_2.getId() == ruleOutputDetailID_2 ? 1 : 0) != 0, (String)"ID of another RuleOutputDetail fetched by ID differs from expected one");
        if (!lastValidationRun) {
            Assertions.assertTrue((ruleOutputDetail_1.getId() == ruleOutputDetailID_1 ? 1 : 0) != 0, (String)"ID of the first RuleOutputDetail fetched by ID differs from expected one");
        }
        counter = 1;
        RuleOutput ruleOutput_1 = ruleOutputDetail_2.getRuleOutput();
        int validationRunID = ruleOutput_1.getValidationRunID();
        List<RuleOutputDetail> ruleOutputDetailsByValidationRun = ruleOutputDetailDAO.getByValidationRunID(validationRunID);
        if (verbose) {
            logger.info("");
            logger.info("List of first " + maxRows + " RuleOutputDetails by VALIDATION_RUN [total=" + ruleOutputDetailsByValidationRun.size() + "]:");
            logger.info("");
            for (RuleOutputDetail ruleOutputDetail : ruleOutputDetailsByValidationRun) {
                logger.info(ruleOutputDetail.toString());
                if (counter++ < maxRows) continue;
                break;
            }
        }
        Assertions.assertTrue((ruleOutputDetailsByValidationRun.size() == runRuleOutputDetailRecords ? 1 : 0) != 0, (String)"Total number of RuleOutputDetail differs from expected one");
        int firstRuleOutputDetailID = 500;
        ruleOutputDetailDAO.resetAll();
        RuleOutputDetail firstRuleOutputDetail = ruleOutputDetailDAO.getNextByValidationRunID(validationRunID);
        RuleOutputDetail secondRuleOutputDetail = ruleOutputDetailDAO.getNextByValidationRunID(validationRunID);
        logger.info("");
        logger.info("First RuleOutputDetail \"byNext()\"                : " + String.valueOf(firstRuleOutputDetail));
        logger.info("Second RuleOutputDetail \"byNext()\"               : " + String.valueOf(secondRuleOutputDetail));
        Assertions.assertTrue((firstRuleOutputDetail.getId() == firstRuleOutputDetailID ? 1 : 0) != 0, (String)"ID of 1st RuleOutputDetail fetched \"byNext()\" differs from expected one");
        Assertions.assertTrue((secondRuleOutputDetail.getId() == firstRuleOutputDetailID + 1 ? 1 : 0) != 0, (String)"ID of 2nd RuleOutputDetail fetched \"byNext()\" differs from expected one");
        RuleOutput ruleOutput_1_bis = ruleOutputDetail_2.getRuleOutput();
        ValidationRun run_1_bis = ruleOutput_1_bis.getValidationRun();
        List<RuleOutputDetail> details = ruleOutput_1_bis.getAllRuleOutputDetail();
        logger.info("");
        logger.info("Checking that RuleOutput is fully loaded                       : " + ruleOutput_1_bis.getId());
        logger.info("ValidationRun fetched from ValidationRun.RuleOutput            : " + String.valueOf(run_1_bis));
        logger.info("List of RuleOutputDetail fetched from ValidationRun.RuleOutput : " + details.size());
        for (int i = 0; i < details.size(); ++i) {
            RuleOutputDetail ruleOutputDetail = details.get(i);
            logger.info(" " + (i + 1) + ") RuleOutputDetail fetched from ValidationRun.RuleOutput     : " + String.valueOf(ruleOutputDetail));
        }
        Assertions.assertTrue((boolean)ruleOutput_1_bis.equals(ruleOutput_1), (String)"RuleOutput fetched from RuleOutputDetail.RuleOutput differs from original one");
        Assertions.assertTrue((details.size() == 2 ? 1 : 0) != 0, (String)"Number of RuleOutputDetail differs from expected");
        Assertions.assertTrue((details.get(0).getId() == 511 ? 1 : 0) != 0, (String)"RuleOutputDetail fetched from RuleOutputDetail.RuleOutput differs from expected");
        logger.info("");
        logger.info("testRuleOutputDetailDAO: completed\n");
    }

    public void testReferenceFieldDAO() {
        this.logHorizontalLine();
        logger.info("TESTING REFERENCE_FIELD DAO");
        logger.info("");
        ReferenceFieldDAO referenceFieldDAO = (ReferenceFieldDAO)((Object)this.daoFactory.getDAO(DAO.REFERENCE_FIELD));
        boolean verbose = false;
        int totalReferenceFieldRecords = 62;
        int expectedMaxReferenceFieldID = 62;
        int maxReferenceFieldID = referenceFieldDAO.getMaxID();
        logger.info("");
        logger.info("Maximum ReferenceFieldID: " + maxReferenceFieldID);
        Assertions.assertTrue((maxReferenceFieldID == expectedMaxReferenceFieldID ? 1 : 0) != 0, (String)"Maximum ReferenceField's ID differs from expected one");
        List referenceFields = referenceFieldDAO.getAll();
        if (verbose) {
            logger.info("");
            logger.info("List of all ReferenceField [total=" + referenceFields.size() + "]:");
            logger.info("");
            for (ReferenceField referenceField : referenceFields) {
                logger.info(referenceField.toString());
            }
        }
        Assertions.assertTrue((referenceFields.size() == totalReferenceFieldRecords ? 1 : 0) != 0, (String)"Total number of ReferenceField differs from expected one");
        int referenceFieldID_1 = 3;
        int referenceFieldID_2 = 4;
        logger.info("");
        logger.info("Get ReferenceField by ID:");
        ReferenceField referenceField_1 = (ReferenceField)referenceFieldDAO.getByID(referenceFieldID_1);
        ReferenceField referenceField_2 = (ReferenceField)referenceFieldDAO.getByID(referenceFieldID_2);
        logger.info("");
        logger.info("Main test ReferenceField                            : " + referenceField_1.toString());
        logger.info("Another test ReferenceField                         : " + referenceField_2.toString());
        Assertions.assertTrue((referenceField_1.getId() == referenceFieldID_1 ? 1 : 0) != 0, (String)"ID of main ReferenceField fetched by ID differs from expected one");
        int protocolID = 1;
        int fieldID = 15;
        logger.info("");
        logger.info("Get ReferenceField by foreign key:");
        List<ReferenceField> referenceFieldsByProtocolID = referenceFieldDAO.getByProtocolID(protocolID);
        List<ReferenceField> referenceFieldsByFieldID = referenceFieldDAO.getByFieldID(fieldID);
        ReferenceField behaviourField = referenceFieldsByFieldID.get(0);
        if (verbose) {
            logger.info("");
            logger.info("List of all ReferenceField declared for protocol " + protocolID + " : ");
            for (ReferenceField referenceField : referenceFieldsByProtocolID) {
                logger.info("\t" + String.valueOf(referenceField));
            }
        }
        logger.info("List of all ReferenceField declared for field " + fieldID + "    : " + String.valueOf(referenceFieldsByFieldID));
        Assertions.assertTrue((referenceFieldsByProtocolID.size() == 13 ? 1 : 0) != 0, (String)("Size of ReferenceFields for protocol " + protocolID + " differs from expected one"));
        Assertions.assertTrue((boolean)"Beh".equals(behaviourField.getFieldLabel()), (String)("Name of ReferenceField for fieldID " + fieldID + " differs from the expected ones"));
        int position = 8;
        logger.info("");
        logger.info("Get ReferenceFields by position:");
        logger.info("");
        int maxPosition = referenceFieldDAO.getMaxPositionByProtocolID(protocolID);
        List<String> names = referenceFieldDAO.getNamesSortedByProtocolID(protocolID);
        List<ReferenceField> samePosition = referenceFieldDAO.getByProtocolIDAndPosition(protocolID, position);
        ReferenceField.sortByOrder(samePosition);
        logger.info("Max position for protocol " + protocolID + "             : " + maxPosition);
        logger.info("ReferenceFields in position " + position + " (sorted)  : " + ReferenceField.formatList(samePosition));
        logger.info("Names of ReferenceFields for protocol " + protocolID + " : " + String.valueOf(names));
        Assertions.assertTrue((maxPosition == 9 ? 1 : 0) != 0, (String)("Max position for protocol " + protocolID + " differs from expected one"));
        Assertions.assertTrue((names.size() == 9 ? 1 : 0) != 0, (String)("Number of names for protocol " + protocolID + " differs from expected one"));
        Assertions.assertTrue((samePosition.size() == 3 ? 1 : 0) != 0, (String)("Number of fields in position " + position + " for protocol " + protocolID + " differs from expected one"));
        logger.info("");
        logger.info("Get ReferenceFields by order:");
        logger.info("");
        int maxReferenceFields = 13;
        List<ReferenceField> fields = referenceFieldDAO.getSortedByProtocolID(protocolID);
        logger.info("ReferenceFields for protocol " + protocolID + "          : " + ReferenceField.formatList(fields));
        Assertions.assertTrue((fields.size() == maxReferenceFields ? 1 : 0) != 0, (String)("Number of names for protocol " + protocolID + " differs from expected one"));
        int testReferenceField_1 = 0;
        int testReferenceField_2 = 5;
        int testReferenceField_3 = maxReferenceFields - 1;
        if (verbose) {
            logger.info("");
            logger.info("ReferenceField[0]  = " + String.valueOf(fields.get(testReferenceField_1)));
            logger.info("ReferenceField[6]  = " + String.valueOf(fields.get(testReferenceField_2)));
            logger.info("ReferenceField[" + maxReferenceFields + "] = " + String.valueOf(fields.get(testReferenceField_3)));
            logger.info("");
        }
        int testReferenceField_1_ID = fields.get(testReferenceField_1).getFieldID();
        int testReferenceField_2_ID = fields.get(testReferenceField_2).getFieldID();
        int testReferenceField_3_ID = fields.get(testReferenceField_3).getFieldID();
        Assertions.assertTrue((testReferenceField_1_ID == 2 ? 1 : 0) != 0, (String)("Wrong ReferenceField, should be 2, found " + testReferenceField_1_ID));
        Assertions.assertTrue((testReferenceField_2_ID == 15 ? 1 : 0) != 0, (String)("Wrong ReferenceField, should be 15, found " + testReferenceField_2_ID));
        Assertions.assertTrue((testReferenceField_3_ID == 6 ? 1 : 0) != 0, (String)("Wrong ReferenceField, should be 6, found " + testReferenceField_3_ID));
        int ruleID = 204;
        Protocol protocol_1 = referenceField_1.getProtocol();
        Schema schema_1 = protocol_1.getSchema();
        ProtocolToRule protocolToRule_1 = protocol_1.getProtocolToRule(ruleID);
        List<RuleToField> ruleToFields_1 = protocol_1.getRuleToField(ruleID);
        logger.info("");
        logger.info("ReferenceField.Protocol                                        : " + String.valueOf(protocol_1));
        logger.info("Schema fetched from ReferenceField.Protocol                    : " + String.valueOf(schema_1));
        logger.info("ProtocolToRule fetched from ReferenceField.Protocol            : " + String.valueOf(protocolToRule_1));
        logger.info("RuleToField fetched from ReferenceField.Protocol               : " + RuleToField.fieldsToString(ruleToFields_1));
        Assertions.assertTrue((schema_1.getId() == 1 ? 1 : 0) != 0, (String)"ID of Schema fetched from ReferenceField.Protocol differs from expected one");
        Assertions.assertTrue((protocolToRule_1.getId() == 30 ? 1 : 0) != 0, (String)"ProtocolToRule fetched from ReferenceField.Protocol differs from expected one");
        Assertions.assertTrue((ruleToFields_1.size() == 2 ? 1 : 0) != 0, (String)"RuleToField fetched from ReferenceField.Protocol differs from expected one");
        Field field_1 = referenceField_1.getField();
        Range range_1 = field_1.getRange();
        SchemaToField schemaToField_1 = field_1.getAllSchemaToField().get(0);
        logger.info("");
        logger.info("ReferenceField.Field                                           : " + String.valueOf(field_1));
        logger.info("Range fetched from ReferenceField.Field                        : " + String.valueOf(range_1));
        logger.info("SchemaToField fetched from ReferenceField.Field                : " + String.valueOf(schemaToField_1));
        Assertions.assertTrue((range_1.getId() == 10 ? 1 : 0) != 0, (String)"ID of Range fetched from the ReferenceField.Field differs from expected one");
        Assertions.assertTrue((schemaToField_1.getId() == 13 ? 1 : 0) != 0, (String)"ID of SchemaToField fetched from ReferenceField.Schema differs from expected one");
        logger.info("");
        logger.info("testReferenceFieldDAO: completed\n");
    }

    protected void loadAllFieldsData(List<Field> allFields) {
        for (Field field : allFields) {
            List<SchemaToField> schemaToFields = field.getAllSchemaToField();
            for (SchemaToField schemaToField : schemaToFields) {
                Field field_bis = schemaToField.getField();
                field_bis.getAllSchemaToField();
            }
        }
    }

    public boolean compare(Collection<?> first, Collection<?> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.getClass() != second.getClass()) {
            return false;
        }
        if (first.size() != second.size()) {
            logger.warn("Compare - collections have different sizes: " + first.size() + " vs " + second.size());
            return false;
        }
        ArrayList copy = new ArrayList(first);
        for (Object object : second) {
            if (copy.remove(object)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Compare - object not found in 1st collection: " + String.valueOf(object));
            }
            return false;
        }
        return true;
    }

    protected String getUserDomain() {
        String userDomain = null;
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/c", "echo %USERDOMAIN%");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                userDomain = new String(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                logger.warn("getUserDomain() - Error when trying to read value of the USERDOMAIN variable");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return userDomain;
    }

    protected String formatSchemaGroups(List<SchemasGroup> list, int maxID) {
        if (list == null) {
            return "None";
        }
        StringBuilder builder = new StringBuilder("Available schema groups (");
        builder.append(list.size());
        builder.append(" groups):\n\n");
        builder.append("Max groupID  : ");
        if (maxID > 0) {
            builder.append(maxID);
        } else {
            builder.append("undef");
        }
        builder.append("\n");
        for (SchemasGroup sg : list) {
            builder.append("Schema group : ");
            builder.append(sg);
            builder.append(" [id=");
            builder.append(sg.getId());
            builder.append("]");
            builder.append("\n");
        }
        return builder.toString();
    }

    protected String formatSchemas(List<? extends GenericModel> list, int maxID) {
        if (list == null) {
            return "None";
        }
        StringBuilder builder = new StringBuilder("Available schemas (");
        builder.append(list.size());
        builder.append(" schemas):\n\n");
        if (maxID > 0) {
            builder.append("Max schemaID    : ");
            builder.append(maxID);
            builder.append("\n");
        }
        for (GenericModel genericModel : list) {
            builder.append("Schema metadata : ");
            builder.append(genericModel);
            builder.append("\n");
        }
        return builder.toString();
    }

    protected String formatProtocols(List<? extends GenericModel> list, int maxID) {
        if (list == null) {
            return "None";
        }
        StringBuilder builder = new StringBuilder("Available protocols (");
        builder.append(list.size());
        builder.append(" protocols):\n\n");
        if (maxID > 0) {
            builder.append("Max protocolID    : ");
            builder.append(maxID);
            builder.append("\n");
        }
        for (GenericModel genericModel : list) {
            builder.append("Protocol metadata : ");
            builder.append(genericModel);
            builder.append("\n");
        }
        return builder.toString();
    }
}

