/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.test;

public class Breakpoint {
    protected long total = 0L;
    protected long sum = 0L;
    protected long min;
    protected long max = Long.MIN_VALUE;
    protected double sumSquared = 0.0;

    public Breakpoint() {
        this.min = Long.MAX_VALUE;
    }

    public void incrementAll(long delta) {
        this.incrementTotal(1L);
        this.incrementSum(delta);
        if (delta > this.max) {
            this.max = delta;
        }
        if (delta < this.min) {
            this.min = delta;
        }
        this.sumSquared += Math.pow(delta, 2.0);
    }

    public void incrementSum(long delta) {
        this.sum += delta;
    }

    public void incrementTotal(long delta) {
        this.total += delta;
    }

    public long getAverage() {
        return this.sum / this.total;
    }

    public double getRootMeanSquare() {
        double mean = this.sumSquared / (double)this.total;
        double root = Math.sqrt(mean);
        return root;
    }

    public long getSum() {
        return this.sum;
    }

    public void setSum(long sum) {
        this.sum = sum;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }
}

