/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportOverviewMessage {
    protected String message;
    protected String description;
    protected MessageType type = MessageType.UNDEF;
    protected int count;
    protected Map<MessageType, Integer> messageCount;
    protected static Logger logger = LoggerFactory.getLogger(ReportOverviewMessage.class);

    public ReportOverviewMessage(ValidationMessage validationMessage) {
        this(validationMessage.getCode(), validationMessage.getMessageType(), validationMessage.getDescription());
    }

    public ReportOverviewMessage(String message, MessageType type, String description) {
        this.message = message;
        this.type = type;
        this.description = description;
    }

    public ReportOverviewMessage(String field) {
        this.message = field;
    }

    public void incrementCount(RuleOutput ruleOutput) {
        MessageType messageType;
        if (logger.isTraceEnabled()) {
            logger.trace("incrementCount() - Handling RuleOutput: " + String.valueOf(ruleOutput));
        }
        if (ruleOutput == null) {
            logger.error("incrementCount() - Failed incrementing the specific counter (RuleOutput = null)");
            return;
        }
        boolean debug = false;
        if (debug) {
            logger.info("incrementCount() - Incrementing counter for RuleOutput: " + String.valueOf(ruleOutput));
        }
        if (this.messageCount == null) {
            this.messageCount = new HashMap<MessageType, Integer>();
            if (logger.isTraceEnabled()) {
                logger.trace("incrementCount() - Created brand new messages counter map");
            }
        }
        if (!this.messageCount.containsKey((Object)(messageType = ruleOutput.getMessageType()))) {
            this.messageCount.put(messageType, 0);
            if (logger.isTraceEnabled()) {
                logger.trace("incrementCount() - Created empty map's entry for message type: " + String.valueOf((Object)messageType));
            }
        }
        int counter = this.messageCount.get((Object)messageType);
        this.messageCount.put(messageType, ++counter);
        if (debug) {
            logger.info("incrementCount() - Incremeted field's counter : " + this.message + "_" + String.valueOf((Object)messageType) + " : " + counter);
        }
        this.incrementCount();
    }

    public void incrementCount() {
        ++this.count;
    }

    public int getMessageCount(MessageType messageType) {
        if (this.messageCount == null) {
            return 0;
        }
        if (this.messageCount.containsKey((Object)messageType)) {
            return this.messageCount.get((Object)messageType);
        }
        return 0;
    }

    public String getFormattedMessageCount() {
        List<MessageType> messageTypes;
        if (logger.isTraceEnabled()) {
            logger.trace("getFormattedMessageCount() - Getting list of possible messages");
        }
        if ((messageTypes = MessageType.getReportMessageTypes(true)) == null) {
            logger.error("getFormattedMessageCount() - Null list of message types: is definition of MessageType eumn correct?");
            return "N/A (null list of message types)";
        }
        String sep = "";
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMessage());
        builder.append(": ");
        for (MessageType messageType : messageTypes) {
            int counter = this.getMessageCount(messageType);
            String suffix = counter == 1 ? "" : "s";
            builder.append(sep);
            builder.append(counter);
            builder.append(" ");
            builder.append(messageType.name);
            builder.append(suffix);
            sep = ", ";
        }
        builder.append(" (");
        builder.append(this.getCount());
        builder.append(")");
        return builder.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Map<MessageType, Integer> getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(Map<MessageType, Integer> messageCount) {
        this.messageCount = messageCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.message);
        builder.append(" (");
        builder.append(this.description);
        builder.append("): ");
        builder.append(this.count);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportOverviewMessage other = (ReportOverviewMessage)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.type == other.type;
    }
}

