/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.report.model.ReportOverviewMessage;
import eu.europa.ec.jrc.qcs.report.model.ReportOverviewMessageComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportOverview {
    protected String processStartDate;
    protected String processEndDate;
    protected String appVersion;
    protected String dbVersion;
    protected String filename;
    protected int protocolId;
    protected int recordCount;
    protected int errorCount;
    protected int warningCount;
    protected int recordsWithIssuesCount;
    protected int recordRejectedCount;
    protected List<Integer> failedPreliminaryRuleIds;
    protected List<ReportOverviewMessage> messageList = new ArrayList<ReportOverviewMessage>();
    protected List<ReportOverviewMessage> fieldList = new ArrayList<ReportOverviewMessage>();
    protected static Logger logger = LoggerFactory.getLogger(ReportOverview.class);

    public void sortMessageList() {
        Collections.sort(this.messageList, new ReportOverviewMessageComparator());
    }

    public void addMessage(ReportOverviewMessage message) {
        if (message == null) {
            logger.warn("addMessage() - Ignoring null message");
            return;
        }
        if (this.messageList.contains(message)) {
            if (logger.isDebugEnabled()) {
                logger.debug("addMessage() - Ignoring duplicate message: " + String.valueOf(message));
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addMessage() - Adding message: " + String.valueOf(message));
        }
        this.messageList.add(message);
    }

    public void addFieldMessage(RuleOutput ruleOutput, ReportOverviewMessage message) {
        if (logger.isTraceEnabled()) {
            logger.trace("addFieldMessage() - Handling RuleOutput: " + String.valueOf(ruleOutput));
        }
        if (message == null) {
            logger.warn("addFieldMessage() - Ignoring null message");
            return;
        }
        ReportOverviewMessage storedMessage = this.getReportOverviewMessage(message);
        if (storedMessage != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("addFieldMessage() - Incrementing counter for message: " + String.valueOf(storedMessage));
            }
            storedMessage.incrementCount(ruleOutput);
            return;
        }
        message.incrementCount(ruleOutput);
        this.fieldList.add(message);
        if (logger.isTraceEnabled()) {
            logger.trace("addFieldMessage() - Initialzed counter for message: " + String.valueOf(storedMessage));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("addFieldMessage() - Handled ReportOverviewMessage: " + String.valueOf(message));
        }
    }

    public ReportOverviewMessage getReportOverviewMessage(ReportOverviewMessage message) {
        if (message == null) {
            logger.warn("getReportOverviewMessage() - Can't look for a message object if argument is null");
            return null;
        }
        return this.getReportOverviewMessageByName(message.getMessage());
    }

    public ReportOverviewMessage getReportOverviewMessageByName(String messageName) {
        if (messageName == null) {
            logger.warn("getReportOverviewMessageByName() - Can't look for a message field if argument is null");
            return null;
        }
        for (ReportOverviewMessage message : this.fieldList) {
            if (message == null) {
                logger.error("getReportOverviewMessageByName() - Found null item in the message fields list");
                continue;
            }
            if (!message.getMessage().equals(messageName)) continue;
            return message;
        }
        return null;
    }

    public String getFormattedFailedPreliminaryRuleIDs() {
        String sep = "";
        StringBuilder builder = new StringBuilder();
        for (int ruleID : this.failedPreliminaryRuleIds) {
            builder.append(sep);
            builder.append(ruleID);
            sep = ",";
        }
        return builder.toString();
    }

    public boolean hasFailedPreliminaryRules() {
        return this.getNumberOfFailedPreliminaryRules() > 0;
    }

    public int getNumberOfFailedPreliminaryRules() {
        if (this.failedPreliminaryRuleIds == null) {
            return 0;
        }
        return this.failedPreliminaryRuleIds.size();
    }

    public String getProcessStartDate() {
        return this.processStartDate;
    }

    public void setProcessStartDate(String processStartDate) {
        this.processStartDate = processStartDate;
    }

    public String getProcessEndDate() {
        return this.processEndDate;
    }

    public void setProcessEndDate(String processEndDate) {
        this.processEndDate = processEndDate;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setWarningCount(int warningCount) {
        this.warningCount = warningCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void setRecordsWithIssuesCount(int recordRejectedCount) {
        this.recordsWithIssuesCount = recordRejectedCount;
    }

    public int getRecordsWithIssuesCount() {
        return this.recordsWithIssuesCount;
    }

    public int getRecordRejectedCount() {
        return this.recordRejectedCount;
    }

    public void setRecordRejectedCount(int recordRejectedCount) {
        this.recordRejectedCount = recordRejectedCount;
    }

    public List<ReportOverviewMessage> getMessages() {
        return this.messageList;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public List<ReportOverviewMessage> getFieldList() {
        return this.fieldList;
    }

    public List<Integer> getFailedPreliminaryRuleIds() {
        return this.failedPreliminaryRuleIds;
    }

    public void setFailedPreliminaryRuleIds(List<Integer> failedPreliminaryRuleIds) {
        this.failedPreliminaryRuleIds = failedPreliminaryRuleIds;
    }

    public String getFormattedFieldsList() {
        String sep = "";
        StringBuilder builder = new StringBuilder();
        if (logger.isDebugEnabled()) {
            logger.debug("getFormattedFieldsList() - Preparing fields messages list:\n" + String.valueOf(builder));
        }
        for (ReportOverviewMessage message : this.fieldList) {
            builder.append(sep);
            builder.append(message);
            sep = "\n";
        }
        logger.info("getFormattedFieldsList() - Printing fields messages list:\n" + String.valueOf(builder));
        return builder.toString();
    }
}

