/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.engine.rule.crossrecord.GenericEquivalentRecordsRule;
import eu.europa.ec.jrc.qcs.report.TXTReport;
import eu.europa.ec.jrc.qcs.report.model.GenericReportLine;
import eu.europa.ec.jrc.qcs.report.model.ReportLayout;
import eu.europa.ec.jrc.qcs.report.model.TableRow;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportLineTXT
extends GenericReportLine {
    protected TableRow rowType;
    protected Map<Integer, Integer> positionToKey;
    protected int numberOfDetails;
    protected GenericReportLine parentLine;
    protected String[] captionRow;
    protected String[] headerRow;
    protected String[] referenceRow;
    protected String[] detailRow;
    protected String[] matchingRow;
    protected String[] captionFormat;
    protected String[] referenceFormat;
    protected String[] detailFormat;
    protected String[] shortReferenceFormat;
    protected String[] matchingFormat;
    protected static Logger logger = LoggerFactory.getLogger(ReportLineTXT.class);

    public ReportLineTXT() {
        this.setValid(false);
        this.setName("undefined_reportLineTXT");
        this.setDescription("Empty reference for a \"null\" ReportLineTXT instance");
        this.numberOfDetails = 3;
        this.rowType = TableRow.UNDEF;
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Created new ReportLineTXT instance");
        }
    }

    public ReportLineTXT(GenericReportLine reportLine) {
        this();
        this.parentLine = reportLine;
        this.setRuleOutput(reportLine);
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Created ReportLineTXT from GenericReportLine");
        }
    }

    public ReportLineTXT(TXTReport txtReport, GenericReportLine reportLine) {
        this(reportLine);
        this.report = txtReport;
        ReportLayout reportLayout = this.report.getReportLayout();
        String[] headerCSV = reportLine.getReferenceHeader();
        this.referenceHeader = reportLayout.getReferenceHeader(headerCSV);
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Loaded reference header: " + Arrays.toString(this.referenceHeader));
        }
        List<ReferenceField> referenceFields = this.report.getReferenceFields();
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Loaded reference fields: " + String.valueOf(referenceFields));
        }
        this.positionToKey = new HashMap<Integer, Integer>();
        for (ReferenceField referenceField : referenceFields) {
            int fieldPosition = referenceField.getPosition();
            int keyPosition = referenceField.getKeyPosition();
            if (keyPosition <= 0) continue;
            this.positionToKey.put(fieldPosition, keyPosition);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Constructor() - Found key reference field: " + String.valueOf(referenceField));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Using report's layout: " + String.valueOf(reportLayout));
        }
        this.captionFormat = reportLayout.getCaptionRowFormat();
        this.referenceFormat = reportLayout.getReferenceRowFormat();
        this.detailFormat = reportLayout.getDetailRowFormat();
        this.shortReferenceFormat = reportLayout.getShortReferenceRowFormat();
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Report's detail_format: " + Arrays.toString(this.detailFormat));
        }
        if (Configuration.getInstance().getBooleanProperty(Property.MPMT_MATCH_INFO)) {
            this.matchingFormat = reportLayout.getMatchingRowFormat();
            if (logger.isInfoEnabled()) {
                logger.info("Constructor() - Loaded format for cross-record matching information: " + String.valueOf(this.matchingFormat));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Constructor() - Created ReportLineTXT from GenericReportLine and protocolID " + this.report.getProtocolID());
        }
    }

    protected String formatArray(String[] values, String[] format) {
        if (values == null || format == null) {
            String message = "formatArray() - Null list of values and/or format";
            logger.error(message);
            return "N/A (null array)";
        }
        if (values.length != format.length) {
            String message = "formatArray() - Wrong " + String.valueOf((Object)this.rowType) + " configuration. ";
            message = message + "Different dimensions for \"values\" and \"format\" arrays: ";
            message = message + "values: " + values.length + ", format: " + format.length + "\n";
            message = message + "\tvalues: " + Arrays.toString(values) + "\n";
            message = message + "\tformat: " + Arrays.toString(format);
            logger.error(message);
            return "N/A (wrong dimension)";
        }
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder, Locale.ENGLISH);
        if (logger.isTraceEnabled()) {
            logger.trace("formatArray() - Formatting values: " + Arrays.toString(values));
        }
        for (int index = 0; index < values.length; ++index) {
            String value = values[index];
            if (value == null) {
                value = "N/A";
                logger.warn("formatArray() - Forced \"N/A\" value for index: " + index);
            }
            String trimmed = value.trim();
            formatter.format(format[index], trimmed);
        }
        formatter.close();
        return builder.toString();
    }

    public void setRuleOutputDetail(RuleOutputDetail ruleOutputDetail) {
        this.detailRow = new String[this.numberOfDetails + 1];
        this.detailRow[0] = "";
        this.detailRow[1] = ruleOutputDetail.getFieldName();
        this.detailRow[2] = ruleOutputDetail.getFieldValue();
        this.detailRow[3] = this.errorCode;
    }

    public TableRow getRowType() {
        return this.rowType;
    }

    public void setRowType(TableRow rowType) {
        this.rowType = rowType;
    }

    public int getNumberOfDetails() {
        return this.numberOfDetails;
    }

    public void setNumberOfDetails(int numberOfDetails) {
        this.numberOfDetails = numberOfDetails;
    }

    public String[] getCaptionFormat() {
        return this.captionFormat;
    }

    public void setCaptionFormat(String[] captionFormat) {
        this.captionFormat = captionFormat;
    }

    public String[] getReferenceFormat() {
        return this.referenceFormat;
    }

    public void setReferenceFormat(String[] referenceFormat) {
        this.referenceFormat = referenceFormat;
    }

    public String[] getDetailFormat() {
        return this.detailFormat;
    }

    public void setDetailFormat(String[] detailFormat) {
        this.detailFormat = detailFormat;
    }

    public String[] getShortReferenceFormat() {
        return this.shortReferenceFormat;
    }

    public void setShortReferenceFormat(String[] shortReferenceFormat) {
        this.shortReferenceFormat = shortReferenceFormat;
    }

    @Override
    public String[] serialize() {
        List<RuleOutputDetail> ruleOutputDetails;
        boolean debug = logger.isTraceEnabled();
        int numberOfKeys = this.positionToKey.size();
        this.captionRow = new String[2 * numberOfKeys];
        int length = this.referenceData.length - numberOfKeys + this.numberOfDetails;
        this.referenceRow = new String[length];
        if (debug) {
            logger.info("serialize() - Number of items in this line: " + length);
        }
        int dataIndex = 0;
        for (int index = 0; index < this.referenceData.length; ++index) {
            int position = index + 1;
            if (this.positionToKey.containsKey(position)) {
                int keyPosition = this.positionToKey.get(position);
                if (keyPosition > 0) {
                    int captionIndex = 2 * (keyPosition - 1);
                    this.captionRow[captionIndex] = this.referenceHeader[index];
                    this.captionRow[captionIndex + 1] = this.referenceData[index];
                    if (!debug) continue;
                    logger.info("serialize() - Set caption key: " + index + " -> " + captionIndex + " : " + Arrays.toString(this.captionRow));
                    continue;
                }
                logger.error("serialize() - Wrong reference field configuration. Position: " + position + " -> keyPosition: " + keyPosition);
                continue;
            }
            this.referenceRow[dataIndex++] = this.referenceData[index];
        }
        if (debug) {
            logger.info("serialize() - Set caption data     : " + Arrays.toString(this.captionRow));
        }
        if (debug) {
            logger.info("serialize() - Added reference data : " + Arrays.toString(this.referenceRow));
        }
        if ((ruleOutputDetails = this.ruleOutput.getAllRuleOutputDetail()) != null && ruleOutputDetails.size() > 0) {
            RuleOutputDetail ruleOutputDetail = ruleOutputDetails.get(0);
            this.referenceRow[dataIndex] = ruleOutputDetail.getFieldName();
            this.referenceRow[dataIndex + 1] = ruleOutputDetail.getFieldValue();
            this.referenceRow[dataIndex + 2] = this.errorCode;
            if (debug) {
                logger.info("serialize() - Handled rule output details : " + String.valueOf(ruleOutputDetails));
            }
        } else {
            String errorCode = null;
            if (this.parentLine != null) {
                errorCode = this.parentLine.getErrorCode();
            }
            if (errorCode == null) {
                errorCode = "FATAL";
            }
            this.referenceRow[dataIndex] = "N/A";
            this.referenceRow[dataIndex + 1] = "N/A";
            this.referenceRow[dataIndex + 2] = errorCode;
        }
        int matchingIndex = 0;
        boolean printMatchInfo = Configuration.getInstance().getBooleanProperty(Property.MPMT_MATCH_INFO);
        boolean foundFirstKey = false;
        this.matchingRow = new String[numberOfKeys];
        this.matchingRow = new String[numberOfKeys + 1];
        if (printMatchInfo) {
            if (ruleOutputDetails != null && ruleOutputDetails.size() > 0) {
                for (RuleOutputDetail ruleOutputDetail : ruleOutputDetails) {
                    String fieldName = ruleOutputDetail.getFieldName();
                    if (!GenericEquivalentRecordsRule.isDuplicateField(fieldName)) continue;
                    if (foundFirstKey) {
                        this.matchingRow[matchingIndex] = "Duplicated record: ";
                        this.matchingRow[matchingIndex + 1] = this.referenceHeader[1];
                        this.matchingRow[matchingIndex + 2] = ruleOutputDetail.getFieldValue();
                        matchingIndex += 3;
                        continue;
                    }
                    foundFirstKey = true;
                }
            } else {
                int lineNumber = this.ruleOutput.getLineNumber();
                logger.error("serialize() - Print match info is enabled, but report line does not contain any RuleOutputDetail");
                logger.error("serialize() - For detail see record in positio: " + lineNumber);
            }
        }
        if (debug) {
            logger.info("serialize() - Serialized all data:");
            logger.info("serialize() - Caption row    : " + Arrays.toString(this.captionRow));
            logger.info("serialize() - Reference row  : " + Arrays.toString(this.referenceRow));
        }
        return this.referenceRow;
    }

    @Override
    protected String[] getHeader() {
        int index;
        if (this.referenceHeader == null) {
            String message = "getHeader() - Found null referenceHeader: using default values";
            logger.error(message);
            this.referenceHeader = new String[]{"Topo", "Morpho", "Beh", "Sex", "DoI", "DoB", "Var_Name", "Var_Value", "Error_Code"};
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getHeader() - Original reference: " + Arrays.toString(this.referenceHeader));
        }
        int skip = 0;
        if (this.captionFormat != null) {
            skip = this.captionFormat.length / 2;
        }
        int length = this.referenceHeader.length + 3 - skip;
        Object[] values = new String[length];
        if (logger.isTraceEnabled()) {
            logger.trace("getHeader() - Set values length: " + length + "/" + this.referenceHeader.length);
        }
        for (index = 0; index < this.referenceHeader.length - skip; ++index) {
            values[index] = this.referenceHeader[skip + index];
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getHeader() - Temporary reference [index:" + index + "] = " + Arrays.toString(values));
        }
        values[index + 0] = "Var_Name";
        values[index + 1] = "Var_Value";
        values[index + 2] = "Error_Code";
        return values;
    }

    public String toString() {
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("toString() - Just before serialization: " + String.valueOf(this.ruleOutput));
        }
        this.serialize();
        if (debug) {
            logger.info("toString() - Formatting TYPE (GENERAL) : " + String.valueOf((Object)this.rowType));
            logger.info("toString() - Values array              : " + Arrays.toString(this.referenceRow));
            logger.info("toString() - Format array              : " + Arrays.toString(this.referenceFormat));
        }
        switch (this.rowType) {
            case UNDEF: {
                logger.warn("toString() - Assuming \"reference row\" as default format for UNDEF line");
                return this.formatArray(this.referenceRow, this.referenceFormat);
            }
            case CAPTION: {
                return this.formatArray(this.captionRow, this.captionFormat);
            }
            case HEADER: {
                return this.formatArray(this.getHeader(), this.referenceFormat);
            }
            case REFERENCE: {
                return this.formatArray(this.referenceRow, this.referenceFormat);
            }
            case DETAIL: {
                return this.formatArray(this.detailRow, this.detailFormat);
            }
            case HEADER_SHORT: {
                String[] shortHeader = Arrays.copyOfRange(this.getHeader(), 0, 7);
                return this.formatArray(shortHeader, this.shortReferenceFormat);
            }
            case REFERENCE_SHORT: {
                String[] shortReference = Arrays.copyOfRange(this.referenceRow, 0, 7);
                return this.formatArray(shortReference, this.shortReferenceFormat);
            }
            case CROSS_MATCH: {
                return this.formatArray(this.matchingRow, this.matchingFormat);
            }
        }
        logger.warn("toString() - Assuming \"reference row\" as default format for DEFAULT line");
        return this.formatArray(this.referenceRow, this.referenceFormat);
    }

    public Object clone() {
        ReportLineTXT line = null;
        try {
            line = (ReportLineTXT)super.clone();
        }
        catch (CloneNotSupportedException e) {
            line = new ReportLineTXT(this.parentLine);
        }
        line.referenceHeader = this.referenceHeader;
        line.positionToKey = this.positionToKey;
        line.captionFormat = this.captionFormat;
        line.referenceFormat = this.referenceFormat;
        line.detailFormat = this.detailFormat;
        line.shortReferenceFormat = this.shortReferenceFormat;
        line.matchingFormat = this.matchingFormat;
        return line;
    }

    public String toPlainString() {
        Object[] array = this.serialize();
        String signature = Arrays.toString(array);
        return signature;
    }
}

