/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.report.model.GenericReportLine;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportLineCSV
extends GenericReportLine {
    protected int numberOfVarColumns;
    protected String[] varColumns;
    protected static Logger logger = LoggerFactory.getLogger(ReportLineCSV.class);

    public ReportLineCSV() {
        this.setValid(false);
        this.setName("undefined_reportLineCSV");
        this.setDescription("Empty reference for a \"null\" ReportLineCSV instance");
    }

    public ReportLineCSV(int numberOfVarColumns) {
        this.numberOfVarColumns = numberOfVarColumns;
    }

    public int getNumberOfVarColumns() {
        return this.numberOfVarColumns;
    }

    public void setNumberOfVarColumns(int numberOfVarColumns) {
        this.numberOfVarColumns = numberOfVarColumns;
    }

    public String[] getVarColumns() {
        return this.varColumns;
    }

    public void setVarColumns(String[] varColumns) {
        this.varColumns = varColumns;
    }

    @Override
    protected String[] getHeader() {
        if (this.referenceHeader == null) {
            String message = "getHeader() - Found null referenceHeader: using default values";
            logger.error(message);
            this.referenceHeader = new String[]{"PAT", "TUM", "Bod", "Topo", "Morpho", "Beh", "Sex", "DoI", "DoB"};
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getHeader() - Number of variale columns: " + this.numberOfVarColumns);
        }
        int referenceLength = this.referenceData.length;
        int length = referenceLength + this.numberOfVarColumns + 3;
        String[] values = new String[length];
        values[0] = "Line";
        for (int index = 0; index < this.referenceHeader.length; ++index) {
            values[index + 1] = this.referenceHeader[index];
        }
        values[++index] = "Error_Code";
        values[++index] = "Error_Description";
        for (int varIndex = 0; varIndex < this.numberOfVarColumns; varIndex += 2) {
            int suffix = (varIndex + 2) / 2;
            values[index + varIndex + 1] = "Var" + suffix + "_Name";
            values[index + varIndex + 2] = "Var" + suffix + "_Value";
        }
        return values;
    }

    @Override
    public String[] serialize() {
        boolean debug = false;
        if (this.referenceData == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("serialize() - Null ReferenceData -> setting NA values");
            }
            this.referenceData = new String[this.referenceHeader.length];
            for (int i = 0; i < this.referenceHeader.length; ++i) {
                this.referenceData[i] = "NA";
            }
        }
        int referenceLength = this.referenceData.length;
        int totalLength = referenceLength + this.numberOfVarColumns + 3;
        if (debug) {
            logger.info("");
            logger.info("serialize() - Number of reference data       : " + referenceLength);
            logger.info("serialize() - Number of variale columns      : " + this.numberOfVarColumns);
            logger.info("serialize() - Length of serialised array     : " + totalLength);
            logger.info("serialize() - HEADER                         : " + Arrays.toString(this.getHeader()));
        }
        Object[] values = new String[totalLength];
        values[0] = Integer.toString(this.lineNumber);
        for (int index = 0; index < this.referenceData.length; ++index) {
            values[index + 1] = this.referenceData[index];
        }
        values[++index] = this.errorCode;
        values[++index] = this.errorDescription;
        if (debug) {
            logger.info("serialize() - Values (after reference data)  : " + Arrays.toString(values));
        }
        List<RuleOutputDetail> ruleOutputDetails = this.ruleOutput.getAllRuleOutputDetail();
        Iterator<RuleOutputDetail> detailsIterator = ruleOutputDetails.iterator();
        for (int varIndex = 0; varIndex < this.numberOfVarColumns; varIndex += 2) {
            if (detailsIterator.hasNext()) {
                RuleOutputDetail ruleOutputDetail = detailsIterator.next();
                values[index + varIndex + 1] = ruleOutputDetail.getFieldName();
                values[index + varIndex + 2] = ruleOutputDetail.getFieldValue();
                continue;
            }
            values[index + varIndex + 1] = "";
            values[index + varIndex + 2] = "";
        }
        if (debug) {
            logger.info("serialize() - Values (added variables data)  : " + Arrays.toString(values));
        }
        return values;
    }

    public String toString() {
        Object[] array = this.serialize();
        String string = Arrays.toString(array) + " (vars=" + this.numberOfVarColumns + ")";
        return string;
    }
}

