/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.report.ReportType;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportLayout {
    protected ReportType reportType;
    protected int[] captionWidths;
    protected int[] referenceWidths;
    protected int[] detailWidths;
    protected int[] shortReferenceWidths;
    protected int[] matchingRowWidths;
    public static ReportLayout INCIDENCE_2014_LAYOUT;
    public static ReportLayout MORTALITY_2014_LAYOUT;
    public static ReportLayout MORTALITY_2020_LAYOUT;
    public static ReportLayout LIFE_TABLE_2014_LAYOUT;
    public static ReportLayout LIFE_TABLE_2020_LAYOUT;
    public static ReportLayout POPULATION_2014_LAYOUT;
    public static ReportLayout POPULATION_2020_LAYOUT;
    public static final int[] NOT_USED;
    protected static Logger logger;

    public ReportLayout(int[] captionWidths, int[] referenceWidths, int[] detailWidths, int[] shortReferenceWidths) {
        this.captionWidths = captionWidths;
        this.referenceWidths = referenceWidths;
        this.detailWidths = detailWidths;
        this.shortReferenceWidths = shortReferenceWidths;
    }

    public ReportLayout(ReportType reportType, int[] captionWidths, int[] referenceWidths, int[] detailWidths, int[] shortReferenceWidths) {
        this(captionWidths, referenceWidths, detailWidths, shortReferenceWidths);
        this.reportType = reportType;
    }

    public ReportLayout(int[] referenceWidths) {
        this.captionWidths = NOT_USED;
        this.referenceWidths = referenceWidths;
        this.detailWidths = NOT_USED;
        this.shortReferenceWidths = NOT_USED;
    }

    public ReportLayout(ReportType reportType, int[] referenceWidths) {
        this(referenceWidths);
        this.reportType = reportType;
    }

    public ReportLayout(ReportType reportType, int[] referenceWidths, int[] detailWidths) {
        this(referenceWidths);
        this.reportType = reportType;
        this.detailWidths = detailWidths;
    }

    public static ReportLayout getReportLayout(ReportType reportType) {
        if (logger.isTraceEnabled()) {
            logger.trace("getReportLayout() - Getting layout for report's type: " + String.valueOf((Object)reportType));
        }
        switch (reportType) {
            case INCIDENCE_2014: 
            case INCIDENCE_2020: {
                return INCIDENCE_2014_LAYOUT;
            }
            case MORTALITY_2014: {
                return MORTALITY_2014_LAYOUT;
            }
            case MORTALITY_2020: {
                return MORTALITY_2020_LAYOUT;
            }
            case LIFE_TABLE_2014: {
                return LIFE_TABLE_2014_LAYOUT;
            }
            case LIFE_TABLE_2020: {
                return LIFE_TABLE_2020_LAYOUT;
            }
            case POPULATION_2014: {
                return POPULATION_2014_LAYOUT;
            }
            case POPULATION_2020: {
                return POPULATION_2020_LAYOUT;
            }
        }
        return INCIDENCE_2014_LAYOUT;
    }

    public String[] getCaptionRowFormat() {
        return this.getFormatFromWidth(this.captionWidths);
    }

    public String[] getReferenceRowFormat() {
        return this.getFormatFromWidth(this.referenceWidths);
    }

    public String[] getDetailRowFormat() {
        return this.getFormatFromWidth(this.detailWidths);
    }

    public String[] getShortReferenceRowFormat() {
        return this.getFormatFromWidth(this.shortReferenceWidths);
    }

    public String[] getMatchingRowFormat() {
        return this.getFormatFromWidth(this.matchingRowWidths);
    }

    public int getCaptionRowWidth() {
        return this.getFormatWidth(this.captionWidths);
    }

    public int getReferenceRowWidth() {
        return this.getFormatWidth(this.referenceWidths);
    }

    public int getDetailRowWidth() {
        if (this.detailWidths == null || this.detailWidths.length == 0) {
            return 0;
        }
        int totalWidth = this.getFormatWidth(this.detailWidths);
        int leftMargin = this.detailWidths[0];
        return totalWidth - leftMargin - 1;
    }

    public int getShortReferenceRowWidth() {
        return this.getFormatWidth(this.shortReferenceWidths);
    }

    public String[] getReferenceHeader(String[] headerCSV) {
        String[] referenceHeader = new String[headerCSV.length];
        if (logger.isDebugEnabled()) {
            logger.debug("getReferenceHeader() - Getting reference header for report: " + String.valueOf((Object)this.reportType));
        }
        for (int i = 0; i < headerCSV.length; ++i) {
            String headerTXT = headerCSV[i];
            if (this.reportType == ReportType.INCIDENCE_2014) {
                switch (i) {
                    case 0: {
                        headerTXT = headerCSV[i].substring(0, 3).toUpperCase();
                        break;
                    }
                    case 1: {
                        headerTXT = headerCSV[i].substring(0, 3);
                        break;
                    }
                    default: {
                        headerTXT = headerCSV[i];
                    }
                }
            }
            referenceHeader[i] = new String(headerTXT);
        }
        return referenceHeader;
    }

    protected String[] getFormatFromWidth(int[] widths) {
        if (widths == null) {
            return null;
        }
        String[] format = new String[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            format[i] = "%-" + widths[i] + "s";
        }
        return format;
    }

    protected int getFormatWidth(int[] widths) {
        int totalWidth = 0;
        for (int i = 0; i < widths.length; ++i) {
            totalWidth += widths[i];
        }
        return totalWidth;
    }

    public int[] getCaptionWidths() {
        return this.captionWidths;
    }

    public void setCaptionWidths(int[] captionWidths) {
        this.captionWidths = captionWidths;
    }

    public int[] getReferenceWidths() {
        return this.referenceWidths;
    }

    public void setReferenceWidths(int[] referenceWidths) {
        this.referenceWidths = referenceWidths;
    }

    public int[] getDetailWidths() {
        return this.detailWidths;
    }

    public void setDetailWidths(int[] detailWidths) {
        this.detailWidths = detailWidths;
    }

    public int[] getShortReferenceWidths() {
        return this.shortReferenceWidths;
    }

    public void setShortReferenceWidths(int[] shortReferenceWidths) {
        this.shortReferenceWidths = shortReferenceWidths;
    }

    public int[] getMatchingRowWidths() {
        return this.matchingRowWidths;
    }

    public void setMatchingRowWidths(int[] matchingRowWidths) {
        this.matchingRowWidths = matchingRowWidths;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append((Object)this.reportType);
        builder.append(", captionWidths=");
        builder.append(Arrays.toString(this.captionWidths));
        builder.append(", referenceWidths=");
        builder.append(Arrays.toString(this.referenceWidths));
        builder.append(", ...");
        builder.append("]");
        return builder.toString();
    }

    static {
        NOT_USED = new int[0];
        logger = LoggerFactory.getLogger(ReportLayout.class);
        int[] incidenceCaption = new int[]{5, 41, 5, 3};
        int[] incidenceReference = new int[]{9, 9, 11, 8, 7, 12, 13, 17, 11, 11};
        int[] incidenceDetail = new int[]{69, 17, 11, 11};
        int[] incidenceShortReference = new int[]{5, 6, 14, 5, 5, 12, 13};
        INCIDENCE_2014_LAYOUT = new ReportLayout(ReportType.INCIDENCE_2014, incidenceCaption, incidenceReference, incidenceDetail, incidenceShortReference);
        int[] matchingReference = new int[]{46, 5, 2};
        INCIDENCE_2014_LAYOUT.setMatchingRowWidths(matchingReference);
        int[] mortalityReference = new int[]{9, 8, 6, 19, 11, 20, 14, 11};
        int[] mortalityDetail = new int[]{53, 20, 14, 11};
        MORTALITY_2014_LAYOUT = new ReportLayout(ReportType.MORTALITY_2014, mortalityReference, mortalityDetail);
        int[] mortalityReference2020 = new int[]{9, 8, 6, 19, 11, 20, 14, 11};
        int[] mortalityDetail2020 = new int[]{53, 20, 14, 11};
        MORTALITY_2020_LAYOUT = new ReportLayout(ReportType.MORTALITY_2020, mortalityReference2020, mortalityDetail2020);
        int[] lifeTableReference = new int[]{8, 7, 8, 15, 27, 14, 11};
        int[] lifeTableDetail = new int[]{38, 27, 14, 11};
        LIFE_TABLE_2014_LAYOUT = new ReportLayout(ReportType.LIFE_TABLE_2014, lifeTableReference, lifeTableDetail);
        int[] lifeTableDetail2020 = new int[]{49, 27, 14, 11};
        int[] lifeTableReference2020 = new int[]{8, 7, 8, 11, 15, 27, 14, 11};
        LIFE_TABLE_2020_LAYOUT = new ReportLayout(ReportType.LIFE_TABLE_2014, lifeTableReference2020, lifeTableDetail2020);
        int[] populationReference = new int[]{8, 7, 8, 12, 25, 14, 11};
        int[] populationDetail = new int[]{35, 25, 14, 11};
        POPULATION_2014_LAYOUT = new ReportLayout(ReportType.POPULATION_2014, populationReference, populationDetail);
        int[] populationReference2020 = new int[]{8, 7, 8, 11, 12, 25, 14, 11};
        int[] populationDetail2020 = new int[]{46, 25, 14, 11};
        POPULATION_2020_LAYOUT = new ReportLayout(ReportType.POPULATION_2020, populationReference2020, populationDetail2020);
    }
}

