/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.report.GenericReport;
import eu.europa.ec.jrc.qcs.report.model.GenericRecordTable;
import eu.europa.ec.jrc.qcs.report.model.ReportLayout;
import eu.europa.ec.jrc.qcs.report.model.ReportLineTXT;
import eu.europa.ec.jrc.qcs.report.model.TableRow;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordTable
extends GenericRecordTable {
    protected static Logger logger = LoggerFactory.getLogger(RecordTable.class);

    public RecordTable(GenericReport report) {
        super(report);
    }

    public RecordTable(ReportLineTXT reportLineTXT) {
        super(reportLineTXT);
    }

    @Override
    public List<String> getTableRows() {
        RuleOutput firstRuleOutput;
        List<RuleOutputDetail> firstDetails;
        ReportLayout reportLayout = this.report.getReportLayout();
        int lineWith = reportLayout.getReferenceRowWidth();
        int paddingWidth = reportLayout.getDetailRowWidth();
        if (logger.isTraceEnabled()) {
            logger.trace("getTableRows() - Layout's parameters: " + lineWith + "/" + paddingWidth);
        }
        this.init(lineWith, paddingWidth);
        ArrayList<String> list = new ArrayList<String>();
        if (this.reportLines == null) {
            return list;
        }
        ReportLineTXT firstReportLine = (ReportLineTXT)this.reportLines.get(0);
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("");
            logger.info("getTableRows() - Formatting line       : " + firstReportLine.toPlainString());
        }
        firstReportLine.setRowType(TableRow.CAPTION);
        String caption = this.leftPadding + firstReportLine.toString();
        list.add(this.getLineSeparator());
        list.add(caption);
        list.add(this.getLineSeparator());
        if (debug) {
            logger.info("getTableRows() - CAPTION                " + caption);
        }
        firstReportLine.setRowType(TableRow.HEADER);
        String headerRow = this.leftPadding + firstReportLine.toString();
        list.add(headerRow);
        list.add(this.getLineSeparator());
        if (debug) {
            logger.info("getTableRows() - HEADER ROW             " + headerRow);
        }
        firstReportLine.setRowType(TableRow.REFERENCE);
        String referenceRow = this.leftPadding + firstReportLine.toString();
        list.add(referenceRow);
        if (debug) {
            logger.info("getTableRows() - REFERENCE ROW          " + referenceRow);
        }
        if ((firstDetails = (firstRuleOutput = firstReportLine.getRuleOutput()).getAllRuleOutputDetail()) != null) {
            if (debug) {
                logger.info("getTableRows() - Number of details (1st)   : " + firstDetails.size());
                logger.info("getTableRows() - Details_array     (1st)   : " + String.valueOf(firstDetails));
            }
            for (int detail = 1; detail < firstDetails.size(); ++detail) {
                RuleOutputDetail ruleOutputDetail = firstDetails.get(detail);
                firstReportLine.setRowType(TableRow.DETAIL);
                firstReportLine.setRuleOutputDetail(ruleOutputDetail);
                String detailAsString = this.leftPadding + firstReportLine.toString();
                list.add(detailAsString);
                if (!debug) continue;
                logger.info("                 RuleOutputDetails (0) :" + detailAsString);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getTableRows() - Number of reportLines : " + this.reportLines.size());
        }
        for (int index = 1; index < this.reportLines.size(); ++index) {
            list.add(this.detailSeparator);
            ReportLineTXT reportLineTXT = (ReportLineTXT)this.reportLines.get(index);
            RuleOutput ruleOutput = reportLineTXT.getRuleOutput();
            List<RuleOutputDetail> ruleOutputDetails = ruleOutput.getAllRuleOutputDetail();
            if (debug) {
                logger.info("getTableRows() - Number of details (2nd)   : " + ruleOutputDetails.size());
                logger.info("getTableRows() - Details_array     (2nd)   : " + String.valueOf(ruleOutputDetails));
            }
            if (ruleOutputDetails == null) continue;
            for (RuleOutputDetail ruleOutputDetail : ruleOutputDetails) {
                reportLineTXT.setRowType(TableRow.DETAIL);
                reportLineTXT.setRuleOutputDetail(ruleOutputDetail);
                String detailAsString = this.leftPadding + reportLineTXT.toString();
                list.add(detailAsString);
                if (!debug) continue;
                logger.info("                 RuleOutputDetails (" + index + ") :" + detailAsString);
            }
        }
        list.add(this.getLineSeparator());
        if (debug) {
            logger.info("getTableRows() - Formatted line        : OK");
        }
        return list;
    }
}

