/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.report.GenericReport;
import eu.europa.ec.jrc.qcs.report.model.GenericRecordTable;
import eu.europa.ec.jrc.qcs.report.model.ReportLayout;
import eu.europa.ec.jrc.qcs.report.model.ReportLineTXT;
import eu.europa.ec.jrc.qcs.report.model.TableRow;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreRecordTable
extends GenericRecordTable {
    protected static Logger logger = LoggerFactory.getLogger(PreRecordTable.class);

    public PreRecordTable(GenericReport report) {
        super(report);
    }

    public PreRecordTable(ReportLineTXT reportLineTXT) {
        super(reportLineTXT);
    }

    @Override
    public List<String> getTableRows() {
        ReportLayout reportLayout = this.report.getReportLayout();
        int lineWith = reportLayout.getCaptionRowWidth();
        if (logger.isTraceEnabled()) {
            logger.trace("getTableRows() - Layout's parameters: " + lineWith);
        }
        this.init(lineWith, 0);
        ArrayList<String> list = new ArrayList<String>();
        if (this.reportLines == null) {
            return list;
        }
        ReportLineTXT firstReportLine = (ReportLineTXT)this.reportLines.get(0);
        boolean debug = false;
        firstReportLine.setRowType(TableRow.CAPTION);
        String caption = this.leftPadding + firstReportLine.toString();
        list.add(this.getLineSeparator());
        list.add(caption);
        list.add(this.getLineSeparator());
        if (debug) {
            logger.info("");
            logger.info("getTableRows() - CAPTION                " + caption);
        }
        return list;
    }
}

