/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.report.GenericReport;
import eu.europa.ec.jrc.qcs.report.model.GenericRecordTable;
import eu.europa.ec.jrc.qcs.report.model.ReportLayout;
import eu.europa.ec.jrc.qcs.report.model.ReportLineTXT;
import eu.europa.ec.jrc.qcs.report.model.TableRow;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostRecordTable
extends GenericRecordTable {
    protected static Logger logger = LoggerFactory.getLogger(PostRecordTable.class);

    public PostRecordTable(GenericReport report) {
        super(report);
    }

    public PostRecordTable(ReportLineTXT reportLineTXT) {
        super(reportLineTXT);
    }

    @Override
    public List<String> getTableRows() {
        ReportLayout reportLayout = this.report.getReportLayout();
        int lineWith = reportLayout.getCaptionRowWidth();
        if (logger.isTraceEnabled()) {
            logger.trace("getTableRows() - Layout's parameters: " + lineWith);
        }
        this.init(lineWith, 0);
        ArrayList<String> list = new ArrayList<String>();
        if (this.reportLines == null) {
            return list;
        }
        ReportLineTXT firstReportLine = (ReportLineTXT)this.reportLines.get(0);
        boolean debug = false;
        boolean printMatchingInfo = Configuration.getInstance().getBooleanProperty(Property.MPMT_MATCH_INFO);
        firstReportLine.setRowType(TableRow.CAPTION);
        String caption = this.leftPadding + firstReportLine.toString();
        list.add(this.getLineSeparator());
        list.add(caption);
        if (!printMatchingInfo) {
            list.add(this.getLineSeparator());
        }
        if (debug) {
            logger.info("");
            logger.info("getTableRows() - CAPTION                " + caption);
        }
        if (printMatchingInfo) {
            firstReportLine.setRowType(TableRow.CROSS_MATCH);
            String matchingRow = this.leftPadding + firstReportLine.toString();
            list.add(matchingRow);
            list.add(this.getLineSeparator());
        }
        firstReportLine.setRowType(TableRow.HEADER_SHORT);
        String headerRow = this.leftPadding + firstReportLine.toString();
        list.add(headerRow);
        list.add(this.getLineSeparator());
        if (debug) {
            logger.info("getTableRows() - HEADER ROW             " + headerRow);
        }
        firstReportLine.setRowType(TableRow.REFERENCE_SHORT);
        String referenceRow = this.leftPadding + firstReportLine.toString();
        list.add(referenceRow);
        list.add(this.getLineSeparator());
        if (debug) {
            logger.info("getTableRows() - REFERENCE ROW          " + referenceRow);
        }
        return list;
    }
}

