/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.dao.model.SerializableModel;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.report.GenericReport;
import eu.europa.ec.jrc.qcs.test.SystemTester;
import java.util.List;

public abstract class GenericReportLine
extends SerializableModel {
    protected int lineNumber;
    protected String errorCode;
    protected String errorDescription;
    protected RuleOutput ruleOutput;
    protected GenericReport report;
    protected String[] referenceHeader;
    protected String[] referenceData;
    public static final String PLACEHOLDER_INT = "_INT_VAL_";
    public static final String LINE = "Line ";

    public void setReferenceHeader(List<String> list) {
        String[] header = list.toArray(new String[list.size()]);
        this.referenceHeader = header;
    }

    public void setRuleOutput(GenericReportLine reportLine) {
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("setRuleOutput() - Handling line : " + reportLine.toShortString());
        }
        this.referenceData = reportLine.getReferenceData();
        this.setRuleOutput(reportLine.getRuleOutput());
    }

    public void setRuleOutput(RuleOutput ruleOutput) {
        List<RuleOutputDetail> ruleOutputDetails;
        this.ruleOutput = ruleOutput;
        int lineNumber = ruleOutput.getLineNumber();
        String errorCode = ruleOutput.getErrorCode();
        String errorDescription = ruleOutput.getDescription();
        if (logger.isTraceEnabled()) {
            logger.trace("setRuleOutput() - " + this.getModelLabel() + " - Setting data: " + lineNumber + " -> " + errorCode + " - " + errorDescription);
        }
        this.setLineNumber(lineNumber);
        this.setErrorCode(errorCode);
        this.setErrorDescription(errorDescription);
        if (!ruleOutput.isDetached()) {
            logger.warn("setRuleOutput() - Fetching RuleOutputDetails via lazy fetching: can affect performances");
        }
        if ((ruleOutputDetails = ruleOutput.getAllRuleOutputDetail()) != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("setRuleOutput() - Line number " + lineNumber + " has " + ruleOutputDetails.size() + " details");
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("setRuleOutput() - RuleOutput with null details: " + String.valueOf(ruleOutput));
        }
    }

    public boolean setLineNumberAsPrimaryKey(int value) {
        String label = LINE + Integer.toString(this.lineNumber);
        return this.setReferenceData(0, label);
    }

    public boolean setReferenceData(int index, int value) {
        return this.setReferenceData(index, Integer.toString(this.lineNumber));
    }

    public boolean setReferenceData(int index, String value) {
        if (this.referenceData == null) {
            logger.error("setReferenceData(int, String): null ReferenceData object");
            return false;
        }
        if (index >= this.referenceData.length) {
            logger.error("setReferenceData(int, String): wrong index: " + index);
            return false;
        }
        this.referenceData[index] = new String(value);
        return true;
    }

    public RuleOutput getRuleOutput() {
        return this.ruleOutput;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public GenericReport getReport() {
        return this.report;
    }

    public void setReport(GenericReport report) {
        this.report = report;
    }

    public String[] getReferenceHeader() {
        return this.referenceHeader;
    }

    public void setReferenceHeader(String[] referenceHeader) {
        this.referenceHeader = referenceHeader;
    }

    public String[] getReferenceData() {
        return this.referenceData;
    }

    public void setReferenceData(String[] referenceData) {
        this.referenceData = referenceData;
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RuleOutput=");
        builder.append(this.ruleOutput.toShortString());
        if (this.referenceData != null) {
            builder.append(", refData=[");
            if (this.referenceData.length >= 0) {
                String firstData = this.referenceData[0];
                if (firstData == null || firstData.isEmpty()) {
                    firstData = "N/A";
                }
                builder.append(firstData);
            }
            if (this.referenceData.length >= 1) {
                builder.append(", ");
                builder.append(this.referenceData[1]);
            }
            if (this.referenceData.length >= 2) {
                builder.append(" ... (");
                builder.append(this.referenceData.length);
                builder.append(" elements)");
            }
            builder.append("]");
        } else {
            builder.append(", refData=[null]");
        }
        return builder.toString();
    }

    protected void benchmarkRecord(String prefix, RuleOutput ruleOutput) {
        StringBuilder builder = new StringBuilder();
        builder.append(" LINE:");
        builder.append(ruleOutput.getLineNumber());
        builder.append(" CODE:");
        builder.append(ruleOutput.getErrorCode());
        SystemTester.benchmark(prefix, builder.toString());
    }
}

