/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.model;

import eu.europa.ec.jrc.qcs.report.GenericReport;
import eu.europa.ec.jrc.qcs.report.model.ReportLineTXT;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericRecordTable {
    protected GenericReport report;
    protected List<ReportLineTXT> reportLines;
    protected String leftPadding;
    protected int separatorWidth;
    protected int detailWidth;
    protected String lineSeparator;
    protected String detailSeparator;
    protected static Logger logger = LoggerFactory.getLogger(GenericRecordTable.class);

    public GenericRecordTable(GenericReport report) {
        this.report = report;
    }

    public GenericRecordTable(ReportLineTXT reportLineTXT) {
        this.setReportLine(reportLineTXT);
        if (logger.isTraceEnabled()) {
            logger.trace("Created new instance from line: " + reportLineTXT.toPlainString());
        }
    }

    public void init(int line, int padding) {
        this.leftPadding = " ";
        this.separatorWidth = line;
        this.detailWidth = padding;
        if (logger.isTraceEnabled()) {
            logger.trace(this.getClassName() + ".getTableRows() - Initialising with parameters: " + this.separatorWidth + "/" + this.detailWidth);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.separatorWidth; ++i) {
            builder.append("-");
        }
        this.lineSeparator = builder.toString();
        builder = new StringBuilder();
        int margin = this.separatorWidth - this.detailWidth;
        for (int i = 0; i < this.separatorWidth; ++i) {
            if (i < margin) {
                builder.append(" ");
                continue;
            }
            builder.append("-");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("init() - Set line separator (" + this.separatorWidth + "): " + this.lineSeparator);
        }
        this.detailSeparator = builder.toString();
    }

    public abstract List<String> getTableRows();

    public void setReportLine(ReportLineTXT reportLineTXT) {
        this.resetReportLines();
        boolean added = this.reportLines.add(reportLineTXT);
        if (logger.isTraceEnabled()) {
            logger.trace("setReportLine() - Added line: " + reportLineTXT.toPlainString());
        }
        if (!added) {
            logger.warn("setReportLine() - Skipped reportLineTXT: " + reportLineTXT.toShortString());
        }
    }

    public void addReportLine(ReportLineTXT reportLineTXT) {
        if (this.reportLines == null) {
            this.resetReportLines();
        }
        boolean added = this.reportLines.add(reportLineTXT);
        if (logger.isTraceEnabled()) {
            logger.trace("addReportLine() - Added line: " + reportLineTXT.toPlainString());
        }
        if (!added) {
            logger.warn("addReportLine() - Skipped reportLineTXT: " + String.valueOf(reportLineTXT));
        }
    }

    public void resetReportLines() {
        this.reportLines = new ArrayList<ReportLineTXT>();
    }

    public int getNumberOfReportLines() {
        if (this.reportLines == null) {
            return 0;
        }
        return this.reportLines.size();
    }

    public List<ReportLineTXT> getReportLines() {
        return this.reportLines;
    }

    public void setReportLines(List<ReportLineTXT> reportLines) {
        this.reportLines = reportLines;
    }

    public String getLeftPadding() {
        return this.leftPadding;
    }

    public void setLeftPadding(String leftPadding) {
        this.leftPadding = leftPadding;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    protected String getClassName() {
        String qualifiedName = this.getClass().getName();
        String[] tokens = qualifiedName.split("\\.");
        return tokens[tokens.length - 1];
    }
}

