/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.handlers;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.ValidationRunDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceData;
import eu.europa.ec.jrc.qcs.dao.model.output.ReferenceDatum;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.report.handlers.ReferenceDataReader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceDataReaderRaw
implements ReferenceDataReader {
    protected int validationRunID;
    protected ReferenceData referenceData;
    protected List<ReferenceDatum> referenceDataAsList;
    protected static ValidationRunDAO validationRunDAO;
    protected static Logger logger;

    public ReferenceDataReaderRaw(int validationRunID) {
        this.validationRunID = validationRunID;
        this.initReader();
        if (logger.isInfoEnabled()) {
            logger.info("Constructor() - Creating new ReferenceDataReaderRaw object for validationRunID: " + validationRunID);
        }
    }

    public ReferenceDataReaderRaw(ReferenceData referenceData) {
        this.referenceData = referenceData;
        if (logger.isInfoEnabled()) {
            logger.info("Creating new ReferenceDataReaderRaw object for referenceData: " + referenceData.toShortString());
        }
    }

    @Override
    public boolean initReader() {
        if (this.validationRunID <= 0) {
            return false;
        }
        ValidationRun validationRun = (ValidationRun)validationRunDAO.getByID(this.validationRunID);
        int protocolID = validationRun.getProtocolID();
        if (protocolID <= 0) {
            return false;
        }
        ValidationOptions validationOptions = Configuration.getInstance().getValidationOptions();
        List<ReferenceField> referenceFields = validationOptions.getReferenceFields(protocolID);
        this.referenceData = new ReferenceData(referenceFields, true);
        if (logger.isDebugEnabled()) {
            logger.debug("initReader() - Created ReferenceData \"singleton\": " + String.valueOf(this.referenceData));
        }
        return this.referenceData != null;
    }

    @Override
    public boolean validate() {
        return this.referenceData != null;
    }

    @Override
    public boolean hasInfoAboutRecord(RuleOutput ruleOutput) {
        if (ruleOutput == null) {
            return false;
        }
        ReferenceData referenceData = ruleOutput.getReferenceData();
        if (referenceData == null) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("hasInfoAboutRecord() - Using ReferenceData: " + referenceData.toShortString());
        }
        referenceData.setReferenceData(this.referenceData);
        this.referenceDataAsList = referenceData.getAllReferenceData();
        if (this.referenceDataAsList == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("hasInfoAboutRecord() - Null list of ReferenceData for: " + referenceData.toShortString());
            }
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("hasInfoAboutRecord() - Set reference data: " + String.valueOf(this.referenceDataAsList));
        }
        return this.referenceDataAsList.size() > 0;
    }

    @Override
    public String getFieldValue(RuleOutput ruleOutput, String fieldName) {
        boolean ready;
        boolean debug = false;
        if (fieldName == null) {
            return null;
        }
        if (debug) {
            logger.info("getFieldValue() - Using RuleOutput: " + String.valueOf(ruleOutput));
            logger.info("getFieldValue() - Checking value for field: " + fieldName);
        }
        if (!(ready = this.hasInfoAboutRecord(ruleOutput))) {
            if (debug) {
                logger.info("getFieldValue() - Reference Data: " + String.valueOf(this.referenceDataAsList) + " [hasInfo=" + this.hasInfoAboutRecord(ruleOutput) + "]");
            }
            return null;
        }
        if (debug) {
            logger.info("getFieldValue() - Getting value for field : " + fieldName);
        }
        for (ReferenceDatum referenceDatum : this.referenceDataAsList) {
            Field field = referenceDatum.getField();
            if (!field.getName().equals(fieldName)) continue;
            if (debug) {
                logger.info("getFieldValue() - Found value  : " + referenceDatum.getValue());
            }
            return referenceDatum.getValue();
        }
        return null;
    }

    public ReferenceData getReferenceData() {
        return this.referenceData;
    }

    static {
        logger = LoggerFactory.getLogger(ReferenceDataReaderRaw.class);
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        validationRunDAO = (ValidationRunDAO)((Object)daoFactory.getDAO(DAO.VALIDATION_RUN));
    }
}

