/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.handlers;

import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.datasource.FlatFile;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecord;
import eu.europa.ec.jrc.qcs.dao.model.input.DataRecordCSV;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.report.handlers.ReferenceDataReader;
import java.io.EOFException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceDataReaderCached
implements ReferenceDataReader {
    protected String perfectRecordsPath;
    protected String recordsWithIssuesPath;
    protected Hashtable<Integer, DataRecord> allCorrectRecords;
    protected Hashtable<Integer, DataRecord> allRecordsWithIssues;
    protected DataRecordCSV dataRecordHeader;
    protected static Logger logger = LoggerFactory.getLogger(ReferenceDataReaderCached.class);

    public ReferenceDataReaderCached(int validationRunID) {
        this.perfectRecordsPath = FlatFile.getRelativePath(FlatFile.DATA_RECORD_CORRECT, validationRunID);
        this.recordsWithIssuesPath = FlatFile.getRelativePath(FlatFile.DATA_RECORD_WITH_ISSUES, validationRunID);
        if (logger.isInfoEnabled()) {
            logger.info("Creating new ReferenceDataReaderCached object for validationRunID: " + validationRunID);
        }
    }

    @Override
    public boolean initReader() {
        this.allCorrectRecords = new Hashtable();
        this.allRecordsWithIssues = new Hashtable();
        boolean correctRecords = this.loadRecords(this.perfectRecordsPath, this.allCorrectRecords);
        boolean recordsWithIssues = this.loadRecords(this.recordsWithIssuesPath, this.allRecordsWithIssues);
        if (logger.isInfoEnabled()) {
            logger.info("initReader() - Cached " + this.allCorrectRecords.size() + " perfect records");
            logger.info("initReader() - Cached " + this.allRecordsWithIssues.size() + " records with issues");
        }
        return recordsWithIssues && correctRecords;
    }

    protected boolean loadRecords(String filePath, Hashtable<Integer, DataRecord> hashTable) {
        FileHandlerCSV<DataRecordCSV> fileHandler = null;
        try {
            FileConnection connection = new FileConnection(filePath);
            fileHandler = new FileHandlerCSV<DataRecordCSV>(connection);
            fileHandler.setType(DataRecordCSV.class);
        }
        catch (Exception e) {
            logger.error("loadRecords() - Error opening output file: " + filePath);
            return false;
        }
        try {
            this.dataRecordHeader = (DataRecordCSV)fileHandler.readNextLine();
            if (logger.isDebugEnabled()) {
                logger.debug("loadRecords() - Fetched header : " + String.valueOf(this.dataRecordHeader));
            }
        }
        catch (Exception e) {
            logger.error("loadRecords() - Error fetching header: " + e.getMessage());
            return false;
        }
        while (true) {
            DataRecordCSV record = null;
            try {
                record = (DataRecordCSV)fileHandler.readNextLine();
            }
            catch (EOFException e) {
                if (!logger.isDebugEnabled()) break;
                logger.debug("loadRecords() - Reached end of output file");
                break;
            }
            catch (InterruptedIOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("loadRecords() - Interrupted while reading output file");
                }
                return false;
            }
            catch (Exception e) {
                logger.error("loadRecords() - Generic exception: " + e.getMessage());
                return false;
            }
            int lineNumber = Integer.valueOf(record.getValue(0));
            hashTable.put(lineNumber, record);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadRecords() - HashTable size: " + hashTable.size());
        }
        return true;
    }

    @Override
    public boolean validate() {
        if (this.allCorrectRecords == null || this.allRecordsWithIssues == null) {
            return false;
        }
        return this.allRecordsWithIssues.size() != 0 || this.allRecordsWithIssues.size() != 0;
    }

    @Override
    public boolean hasInfoAboutRecord(RuleOutput ruleOutput) {
        int lineNumber = ruleOutput.getLineNumber();
        return this.hasInfoAboutRecord(lineNumber);
    }

    protected boolean hasInfoAboutRecord(int lineNumber) {
        if (this.allRecordsWithIssues != null && this.allRecordsWithIssues.containsKey(lineNumber)) {
            return true;
        }
        return this.allCorrectRecords != null && this.allCorrectRecords.containsKey(lineNumber);
    }

    @Override
    public String getFieldValue(RuleOutput ruleOutput, String fieldName) {
        int lineNumber = ruleOutput.getLineNumber();
        return this.getFieldValue(lineNumber, fieldName);
    }

    protected String getFieldValue(int lineNumber, String fieldName) {
        DataRecord outputRecord;
        String fieldValue = "N/A";
        if (logger.isTraceEnabled()) {
            logger.trace("getFieldValue() - Fetching field's value for lineNumber = " + lineNumber + ", fieldName = " + fieldName);
        }
        if ((outputRecord = this.getOutputRecord(lineNumber)) == null) {
            logger.error("getFieldValue() - Found null DataRecord for lineNumber = " + lineNumber + ", fieldName = " + fieldName);
            return fieldValue;
        }
        Object[] recordHeader = this.dataRecordHeader.getArray();
        if (logger.isTraceEnabled()) {
            logger.trace("getFieldValue() - Setting columnNames: " + Arrays.toString(recordHeader));
        }
        outputRecord.setColumnNames((String[])recordHeader);
        fieldValue = outputRecord.getValue(fieldName);
        if (fieldValue == null) {
            logger.error("getFieldValue() - Missing field value for lineNumber = " + lineNumber + ", fieldName = " + fieldName);
        }
        return fieldValue;
    }

    protected DataRecord getOutputRecord(int lineNumber) {
        boolean debug = false;
        DataRecord record = null;
        if (debug) {
            logger.info("getOutputRecord() - Fetching copy of original record for lineNumber: " + lineNumber);
        }
        if (this.allRecordsWithIssues != null && (record = this.allRecordsWithIssues.get(lineNumber)) != null) {
            return record;
        }
        if (debug) {
            logger.info("getOutputRecord() - Original record not in the \"qcs_output_with_issues\" file for lineNumber: " + lineNumber);
        }
        if (this.allCorrectRecords != null && (record = this.allCorrectRecords.get(lineNumber)) != null) {
            return record;
        }
        logger.error("getOutputRecord() - Failed fetching copy of original record for lineNumber: " + lineNumber);
        return null;
    }
}

