/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report.handlers;

import eu.europa.ec.jrc.qcs.engine.RawFilesReader;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFileWatchdog
implements Runnable {
    protected String fileName;
    protected static Logger logger = LoggerFactory.getLogger(RawFilesReader.class);

    public OpenFileWatchdog(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void run() {
        int counter = 0;
        boolean polling = true;
        while (polling) {
            try {
                ++counter;
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("run() - InterruptedException: " + e.getMessage());
            }
            if (!this.fileIsOpen(this.fileName)) {
                polling = false;
            }
            if (counter % 5 == 0) {
                // empty if block
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("run() - Polling: " + counter);
        }
    }

    public boolean fileIsOpen(String path) {
        if (logger.isDebugEnabled()) {
            logger.debug("fileIsOpen() - Checking path: " + path);
        }
        try {
            File file = new File(path);
            if (!file.exists()) {
                return false;
            }
            File sameFile = new File(path);
            boolean isClosed = file.renameTo(sameFile);
            if (logger.isDebugEnabled()) {
                logger.debug("fileIsOpen() - isClosed: " + isClosed);
            }
            return !isClosed;
        }
        catch (Exception e) {
            logger.error("fileIsOpen() - We should never get here:" + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

