/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerTXT;
import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import eu.europa.ec.jrc.qcs.engine.ValidationCycle;
import eu.europa.ec.jrc.qcs.report.GenericReport;
import eu.europa.ec.jrc.qcs.report.ReportFormat;
import eu.europa.ec.jrc.qcs.report.ReportSection;
import eu.europa.ec.jrc.qcs.report.ReportSubSection;
import eu.europa.ec.jrc.qcs.report.ReportType;
import eu.europa.ec.jrc.qcs.report.SummarySection;
import eu.europa.ec.jrc.qcs.report.model.GenericRecordTable;
import eu.europa.ec.jrc.qcs.report.model.GenericReportLine;
import eu.europa.ec.jrc.qcs.report.model.PostRecordTable;
import eu.europa.ec.jrc.qcs.report.model.PreRecordTable;
import eu.europa.ec.jrc.qcs.report.model.RecordTable;
import eu.europa.ec.jrc.qcs.report.model.ReportLayout;
import eu.europa.ec.jrc.qcs.report.model.ReportLineTXT;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TXTReport
extends GenericReport {
    protected ValidationCycle previousCycle;
    protected String previousErrorCode;
    ReportLineTXT reportLineTXT;
    protected int previousLineNumber;
    protected GenericRecordTable recordTable;
    protected FileHandlerTXT<String> fileHandler;
    protected String sectionSeparator;
    protected static Logger logger = LoggerFactory.getLogger(TXTReport.class);

    public TXTReport(int validationRunID) {
        super(ReportFormat.TXT, validationRunID);
        if (logger.isDebugEnabled()) {
            logger.debug("Created TXTReport instance for validationRunID : " + validationRunID + " (format = " + String.valueOf((Object)this.reportFormat) + ")");
        }
    }

    @Override
    public boolean init() {
        boolean deleted;
        boolean parent = super.init();
        if (!parent) {
            logger.error("init() - Error when creating GenericReport");
            return false;
        }
        ReportLayout reportLayout = this.getReportLayout();
        StringBuilder builder = new StringBuilder();
        int lineWith = reportLayout.getReferenceRowWidth();
        for (int i = 0; i < lineWith; ++i) {
            builder.append("*");
        }
        this.sectionSeparator = builder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Getting report's file and path");
        }
        String finalReportFile = this.getReportFilename() + ReportFormat.TXT.getFileExtension();
        String finalReportPath = this.addRelativePath(finalReportFile);
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Deleting previous report: " + finalReportPath);
        }
        if (!(deleted = this.deleteFile(finalReportPath))) {
            logger.error("init() - Failed removing previous report: " + finalReportPath);
        }
        this.previousLineNumber = 0;
        this.previousCycle = ValidationCycle.PRE_RECORD;
        boolean opened = this.initSection(this.previousCycle);
        if (!opened) {
            logger.error("init() - Error when initialising first section");
        }
        return parent && opened;
    }

    @Override
    public long generate() {
        String message = "The new TXT report should never be created using the generate() method: it should be created during creation of the CSV report";
        logger.error("generate() - " + message);
        return 0L;
    }

    public void handleLine(GenericReportLine reportLine) {
        ValidationMessage message;
        RuleOutput ruleOutput = reportLine.getRuleOutput();
        int lineNumber = ruleOutput.getLineNumber();
        boolean debug = logger.isTraceEnabled();
        RuleDefinition ruleDefinition = ruleOutput.getRule();
        ValidationCycle cycle = ruleDefinition.getValidationCycle();
        if (debug) {
            logger.info("handleLine() - >>> Handling report_line : " + reportLine.toShortString() + " (cycle:" + String.valueOf((Object)cycle) + ")");
            logger.info("handleLine() - Report line              : " + String.valueOf(reportLine));
        }
        if (cycle != this.previousCycle) {
            if (this.previousCycle != ValidationCycle.UNDEF) {
                this.flushRecordTable();
                if (debug) {
                    logger.info("handleLine() - Printed last handled RecordTable");
                }
            }
            if (debug) {
                logger.info("handleLine() - Checking in new report_line : " + String.valueOf((Object)cycle) + " (prev_cycle = " + String.valueOf((Object)this.previousCycle) + ")");
            }
            this.initSection(cycle, ruleDefinition);
            this.previousCycle = cycle;
            if (debug) {
                logger.info("handleLine() - Started new validation cycle: " + String.valueOf((Object)cycle));
            }
            if (cycle == ValidationCycle.POST_RECORD) {
                message = ruleDefinition.getValidationMessage();
                this.previousErrorCode = message.getCode();
                if (debug) {
                    logger.info("handleLine() - Reset previous error message to code: " + this.previousErrorCode);
                }
            }
        }
        if (cycle == ValidationCycle.POST_RECORD) {
            message = ruleDefinition.getValidationMessage();
            String currentErrorCode = message.getCode();
            if (debug) {
                logger.info("handleLine() - Checking if \"breaking_code\": " + this.previousErrorCode + " (previous) VS " + currentErrorCode + " (current)");
            }
            if (!currentErrorCode.equals(this.previousErrorCode)) {
                if (debug) {
                    logger.info("handleLine() - BREAK_POST_RECORD. Changed error code: " + this.previousErrorCode + " -> " + currentErrorCode);
                }
                this.flushRecordTable();
                this.initSubSection(message);
                this.previousErrorCode = new String(currentErrorCode);
            }
        }
        if (debug) {
            logger.info("handleLine() - Current ReportLineTXT: " + String.valueOf(reportLine));
        }
        if (this.reportLineTXT == null) {
            this.reportLineTXT = new ReportLineTXT(this, reportLine);
            if (debug) {
                logger.info("handleLine() - Created new ReportLineTXT: " + this.reportLineTXT.toPlainString());
            }
        } else {
            this.reportLineTXT = (ReportLineTXT)this.reportLineTXT.clone();
            this.reportLineTXT.setRuleOutput(reportLine);
            if (debug) {
                logger.info("handleLine() - Cloned existing ReportLineTXT: " + this.reportLineTXT.toPlainString());
            }
        }
        if (debug) {
            logger.info("handleLine() - Handling TXT report line: " + this.reportLineTXT.toShortString() + " (prevLine:" + this.previousLineNumber + ")");
        }
        if (lineNumber != this.previousLineNumber) {
            int rows = this.recordTable.getNumberOfReportLines();
            if (rows > 0) {
                this.printRecordTable();
            }
            if (debug) {
                logger.info("handleLine() - Setting new report line: " + this.reportLineTXT.toPlainString());
            }
            this.recordTable.setReportLine(this.reportLineTXT);
            this.previousLineNumber = lineNumber;
        } else {
            this.recordTable.addReportLine(this.reportLineTXT);
            if (debug) {
                logger.info("handleLine() - Appended data to existing RecordTable for line: " + lineNumber);
            }
        }
        if (debug) {
            logger.info("handleLine() - Handled correctly: OK");
        }
    }

    public void printRecordTable() {
        List<String> tableRows = this.recordTable.getTableRows();
        this.printLines(tableRows);
    }

    public void flushRecordTable() {
        this.printRecordTable();
        this.previousLineNumber = 0;
        this.recordTable.resetReportLines();
    }

    protected boolean initSection(ValidationCycle cycle) {
        return this.initSection(cycle, null);
    }

    protected boolean initSection(ValidationCycle cycle, RuleDefinition ruleDefinition) {
        boolean debug = false;
        if (ruleDefinition != null) {
            debug = logger.isTraceEnabled();
        }
        if (debug) {
            logger.info("initSection() - Initialising section for cycle: " + String.valueOf((Object)cycle));
        }
        if (cycle != ValidationCycle.PRE_RECORD) {
            this.closeWriter();
        }
        this.reportLineTXT = null;
        ReportSection reportSection = ReportSection.getByValidationCycle(cycle);
        if (debug) {
            logger.info("initSection() - Initialising new section: " + String.valueOf((Object)reportSection) + " [" + String.valueOf(ruleDefinition) + "]");
        }
        String firstFileName = reportSection.fileName + ReportFormat.TXT.getFileExtension();
        String firstFilePath = this.addRelativePath(firstFileName);
        boolean opened = this.openWriter(firstFilePath);
        String title = reportSection.title;
        if (reportSection == ReportSection.POST_RECORD) {
            if (debug) {
                logger.info("initSection() - Checking rule definition: " + String.valueOf(ruleDefinition));
            }
            if (ruleDefinition != null) {
                ValidationMessage validationMessage = ruleDefinition.getValidationMessage();
                int messageID = validationMessage.getId();
                ReportSubSection firstSubSection = ReportSubSection.getByMessageID(messageID);
                title = this.addErrorCodeToSectionTitle(validationMessage, firstSubSection.title);
                if (debug) {
                    logger.info("initSection() - Created firstSubSection: " + title);
                }
            } else {
                Object error = "Starting POST RECORD section without a reference to the first message ID.\n";
                error = (String)error + "-> The first sub-section will have the default title: " + title;
                logger.error("initSection() - " + (String)error);
            }
        }
        this.printLine(this.sectionSeparator);
        this.printLine(title);
        this.printLine(this.sectionSeparator);
        this.printLine();
        if (debug) {
            logger.info("initSection() - Initialised new section: " + opened);
        }
        switch (cycle) {
            case PRE_RECORD: {
                this.recordTable = new PreRecordTable(this);
                break;
            }
            case RECORD: {
                this.recordTable = new RecordTable(this);
                break;
            }
            case POST_RECORD: {
                this.recordTable = new PostRecordTable(this);
                break;
            }
            default: {
                this.recordTable = new RecordTable(this);
            }
        }
        return opened;
    }

    protected void initSubSection(ValidationMessage newMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug("initSubSection() - Checking message: " + String.valueOf(newMessage));
        }
        ReportSubSection subSection = ReportSubSection.getByMessageID(newMessage.getId());
        String subSectionTitle = this.addErrorCodeToSectionTitle(newMessage, subSection.title);
        this.printLine();
        this.printLine(this.sectionSeparator);
        this.printLine(subSectionTitle);
        this.printLine(this.sectionSeparator);
        this.printLine();
    }

    protected String addErrorCodeToSectionTitle(ValidationMessage message, String bareTitle) {
        StringBuilder builder = new StringBuilder();
        String errorCode = message != null ? message.getCode() : "UNKN";
        builder.append(bareTitle);
        builder.append(" (");
        builder.append(errorCode);
        builder.append(")");
        return builder.toString();
    }

    public long mergeSections() {
        long lines = 0L;
        List<ReportSection> list = ReportSection.getByOrder();
        if (logger.isDebugEnabled()) {
            logger.debug("mergeSections() - Merging sections: " + String.valueOf(list));
        }
        boolean detailedReport = Configuration.getInstance().getBooleanProperty(Property.REPORTS_DETAILED);
        boolean shortReport = Configuration.getInstance().getBooleanProperty(Property.REPORT_SUMMARY);
        if (logger.isDebugEnabled()) {
            logger.debug("mergeSections() - Merging sections: " + String.valueOf(list));
        }
        String mainDestinationPath = this.getFileWriterPath(this.getReportFilename());
        if (logger.isDebugEnabled()) {
            logger.debug("mergeSections() - Main report path : " + mainDestinationPath);
        }
        String shortDestinationPath = this.getFileWriterPath(this.getShortReportFilename());
        if (logger.isDebugEnabled()) {
            logger.debug("mergeSections() - Short report path : " + shortDestinationPath);
        }
        if (shortReport) {
            this.deleteFile(shortDestinationPath);
        }
        int section = 0;
        for (ReportSection reportSection : list) {
            if (logger.isDebugEnabled()) {
                logger.debug("mergeSections() - ReportSection: " + String.valueOf((Object)reportSection));
            }
            if (reportSection == ReportSection.UNDEF) continue;
            if (reportSection == ReportSection.SUMMARY) {
                this.appendSummarySection(mainDestinationPath);
                if (!shortReport) continue;
                this.appendSummarySection(shortDestinationPath);
                continue;
            }
            ++section;
            String sectionFilePath = this.getFileWriterPath(reportSection.fileName);
            if (detailedReport) {
                lines += this.appendToFile(sectionFilePath, mainDestinationPath);
            } else if (logger.isInfoEnabled()) {
                logger.info("mergeSections() - Detailed report is disabled -> ignoring detailed sections");
            }
            String sectionFileName = reportSection.fileName + ReportFormat.TXT.getFileExtension();
            String sectionRelativePath = this.addRelativePath(sectionFileName);
            this.deleteFile(sectionRelativePath);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("mergeSections() - Successfully merged " + section + " report's sections");
        }
        this.setNumberOflines(lines);
        if (logger.isDebugEnabled()) {
            logger.debug("mergeSections() - Completed TXT report with " + lines + " lines (ignoring summary)");
        }
        return lines;
    }

    protected boolean appendSummarySection(String destinationPath) {
        ReportType reportType = this.getReportType();
        String reportTitle = "QUALITY CHECK SOFTWARE REPORT - " + reportType.title;
        if (logger.isDebugEnabled()) {
            logger.debug("appendSummarySection() - Appending summary section to: " + destinationPath + "\"");
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(destinationPath, true));
            writer.println(this.sectionSeparator);
            writer.println(reportTitle);
            writer.println(this.sectionSeparator);
            writer.println();
            SummarySection summarySection = new SummarySection(this);
            String runInformation = summarySection.getRunInformation();
            writer.println(runInformation);
            String statistics = summarySection.getStatistics();
            writer.println(statistics);
            String legend = summarySection.getMessagesLegend();
            writer.println(legend);
            String errorMessages = summarySection.getNumberOfMessages(MessageType.ERROR);
            writer.print(errorMessages);
            String warningMessages = summarySection.getNumberOfMessages(MessageType.WARNING);
            writer.print(warningMessages);
            boolean printFieldsStatistic = Configuration.getInstance().getBooleanProperty(Property.REPORTS_FIELDS);
            if (logger.isDebugEnabled()) {
                logger.debug("appendSummarySection() - Printing fields statistics ? " + printFieldsStatistic);
            }
            if (printFieldsStatistic) {
                String fieldStatistics = summarySection.getFieldsStatistics();
                writer.print(fieldStatistics);
            }
            writer.close();
        }
        catch (Exception e) {
            String message = "Error Appending to \"" + destinationPath + "\"";
            logger.error("appendSummarySection() - " + message + " : " + e.getMessage());
            return false;
        }
        return true;
    }

    protected long appendToFile(String sourcePath, String destinationPath) {
        long totalLines = 0L;
        PrintWriter writer = null;
        BufferedReader reader = null;
        if (logger.isDebugEnabled()) {
            logger.debug("appendToFile() - Copying \"" + sourcePath + "\" into \"" + destinationPath + "\"");
        }
        try {
            String line;
            reader = new BufferedReader(new FileReader(sourcePath));
            writer = new PrintWriter(new FileWriter(destinationPath, true));
            writer.println();
            while ((line = reader.readLine()) != null) {
                writer.println(line);
                ++totalLines;
                if (!logger.isTraceEnabled()) continue;
                logger.trace("appendToFile() - Printing line: " + line);
            }
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            String message = "Error copying from \"" + sourcePath + "\" to \"" + destinationPath + "\"";
            logger.error("appendToFile() - " + message + " : " + e.getMessage());
            return totalLines;
        }
        return totalLines;
    }

    protected void setFileHandler(FileHandlerTXT<String> handler) {
        this.fileHandler = handler;
    }

    protected FileHandlerTXT<String> getFileHandler() {
        return this.fileHandler;
    }

    protected boolean openWriter(String path) {
        FileConnection connection = new FileConnection(path);
        connection.setWriteAccess(true);
        connection.setTemporary(true);
        if (logger.isDebugEnabled()) {
            logger.debug("openWriter() - Opened connection for path: " + path);
        }
        FileHandlerTXT<String> mainHandler = new FileHandlerTXT<String>(connection, String.class);
        mainHandler.setHeader(false);
        mainHandler.setAutoCommit(false);
        mainHandler.setNewFile(true);
        mainHandler.openWriter();
        this.setFileHandler(mainHandler);
        if (logger.isDebugEnabled()) {
            logger.debug("openWriter() - Opened FileHandlerTXT on connection: " + String.valueOf(connection));
        }
        return true;
    }

    protected void closeWriter() {
        FileHandlerTXT<String> mainHandler = this.getFileHandler();
        mainHandler.closeWriter();
    }

    protected void printLine() {
        this.printLine("");
    }

    protected int printLine(String line) {
        if (logger.isTraceEnabled()) {
            logger.trace("printLines() - Appending report line: " + line);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(line);
        return this.printLines(list);
    }

    protected int printLines(List<String> lines) {
        boolean debug = logger.isTraceEnabled();
        if (debug) {
            logger.info("");
            logger.info("printLines() - Appending report lines: " + lines.size());
            for (String line : lines) {
                logger.info("printLines() - LINE: " + line);
            }
        }
        if (lines.size() > 1) {
            boolean fixedMissingInt = this.handleMissingInteger(lines);
            if (debug && fixedMissingInt) {
                logger.info("printLines() - Handled missing integer field");
            }
        }
        int rows = 0;
        try {
            FileHandlerTXT<String> mainHandler = this.getFileHandler();
            rows = mainHandler.writeFile(lines);
        }
        catch (IllegalStateException e) {
            logger.error("printLines() - Error writing line: " + e.getMessage());
        }
        if (debug) {
            logger.info("printLines() - Appended new TXT lines: " + rows);
        }
        return rows;
    }

    public ValidationCycle getPreviousCycle() {
        return this.previousCycle;
    }

    public void setPreviousCycle(ValidationCycle previousCycle) {
        this.previousCycle = previousCycle;
    }

    public int getPreviousLineNumber() {
        return this.previousLineNumber;
    }

    public void setPreviousLineNumber(int previousLineNumber) {
        this.previousLineNumber = previousLineNumber;
    }

    public GenericRecordTable getRecordTable() {
        return this.recordTable;
    }

    public void setRecordTable(GenericRecordTable recordTable) {
        this.recordTable = recordTable;
    }

    public String getSectionSeparator() {
        return this.sectionSeparator;
    }

    public void setSectionSeparator(String sectionSeparator) {
        this.sectionSeparator = sectionSeparator;
    }
}

