/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.ProtocolDAO;
import eu.europa.ec.jrc.qcs.dao.RuleDefinitionDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleScope;
import eu.europa.ec.jrc.qcs.report.TXTReport;
import eu.europa.ec.jrc.qcs.report.model.ReportOverview;
import eu.europa.ec.jrc.qcs.report.model.ReportOverviewMessage;
import eu.europa.ec.jrc.qcs.util.HashedTimestamp;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummarySection {
    protected TXTReport report;
    protected HashedTimestamp timestamp;
    protected boolean markTestSuiteLabels;
    protected static Logger logger = LoggerFactory.getLogger(SummarySection.class);

    public SummarySection(TXTReport report) {
        this.report = report;
        this.markTestSuiteLabels = Configuration.getInstance().getBooleanProperty(Property.REPORT_HASH);
    }

    public String getRunInformation() {
        ReportOverview overview = this.report.getReportOverview();
        if (overview == null) {
            return this.handleMissingReportOverview("appendRunInformation()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getRunInformation() - Producing \"run parameters\" section");
        }
        StringBuilder builder = new StringBuilder();
        String separator = this.report.getSectionSeparator();
        builder.append(separator);
        builder.append("\n");
        builder.append("PROCESSING PARAMETERS\n");
        builder.append(separator);
        builder.append("\n\n");
        builder.append("File process start : ");
        builder.append(overview.getProcessStartDate());
        builder.append("\n");
        builder.append("File process end   : ");
        builder.append(overview.getProcessEndDate());
        builder.append("\n\n");
        if (logger.isDebugEnabled()) {
            logger.debug("getRunInformation() - Flag mark suite label ? " + this.isMarkTestSuiteLabels());
        }
        builder.append("Validated by       : ");
        builder.append(overview.getAppVersion());
        if (this.isMarkTestSuiteLabels()) {
            this.timestamp = new HashedTimestamp();
            builder.append(" (run ");
            builder.append(this.timestamp.getNounce());
            builder.append(")");
        }
        builder.append("\n");
        builder.append("Using DB version   : ");
        builder.append(overview.getDbVersion());
        if (this.isMarkTestSuiteLabels()) {
            builder.append(" (run ");
            builder.append(this.timestamp.getNounce());
            builder.append(")");
        }
        builder.append("\n\n");
        builder.append("File Processed:\n");
        builder.append(overview.getFilename());
        if (this.isMarkTestSuiteLabels()) {
            builder.append(" (");
            builder.append(this.timestamp.getHash());
            builder.append(")");
        }
        builder.append("\n");
        if (logger.isDebugEnabled()) {
            logger.debug("getRunInformation() - Produced \"run parameters\" section");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getRunInformation() - Adding \"validation options\" section");
        }
        String options = this.getValidationOptions();
        builder.append(options);
        return builder.toString();
    }

    public String getStatistics() {
        ReportOverview overview = this.report.getReportOverview();
        if (overview == null) {
            return this.handleMissingReportOverview("getStatistics()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getStatistics() - Producing statistics section");
        }
        StringBuilder builder = new StringBuilder();
        String separator = this.report.getSectionSeparator();
        builder.append(separator);
        builder.append("\n");
        builder.append("PROCESSING STATISTICS\n");
        builder.append(separator);
        builder.append("\n\n");
        builder.append("Number of records read                  : ");
        builder.append(overview.getRecordCount());
        builder.append("\n");
        builder.append("Total number of errors                  : ");
        builder.append(overview.getErrorCount());
        builder.append("\n");
        builder.append("Total number of warnings                : ");
        builder.append(overview.getWarningCount());
        builder.append("\n");
        builder.append("Total number of records with issues     : ");
        builder.append(overview.getRecordsWithIssuesCount());
        builder.append("\n");
        builder.append("Total number of rejected records        : ");
        builder.append(overview.getRecordRejectedCount());
        builder.append("\n");
        if (overview.hasFailedPreliminaryRules()) {
            DAOFactory daoFactory = DAOFactory.getDAOFactory();
            RuleDefinitionDAO ruleDefinitionDAO = (RuleDefinitionDAO)((Object)daoFactory.getDAO(DAO.RULE_DEFINITION));
            for (int ruleId : overview.getFailedPreliminaryRuleIds()) {
                RuleDefinition ruleDefinition = (RuleDefinition)ruleDefinitionDAO.getByID(ruleId);
                RuleScope scope = ruleDefinition.getRuleType().scope;
                if (logger.isDebugEnabled()) {
                    logger.debug("getStatistics() - Handling failed preliminary rule: " + ruleDefinition.toShortString());
                }
                if (scope == RuleScope.HEADER) {
                    builder.append("Failed preliminary rule                 : ");
                    builder.append(ruleDefinition.getName());
                    builder.append("\n");
                    if (logger.isDebugEnabled()) {
                        logger.debug("getStatistics() - Written failed preliminary rule: " + ruleDefinition.getName());
                    }
                }
                if (ruleId != RuleDefinition.UNDEF.getId()) continue;
                builder.append("Failed unknown rule                     : ");
                builder.append(ruleDefinition.getName());
                builder.append("\n");
                if (!logger.isDebugEnabled()) continue;
                logger.debug("getStatistics() - Written failed unknown rule");
            }
            builder.append("Preliminary rules                       : nothing critical\n");
        } else {
            builder.append("Preliminary rules                       : all passed\n");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getStatistics() - Produced statistics section");
        }
        return builder.toString();
    }

    public String getValidationOptions() {
        ReportOverview overview = this.report.getReportOverview();
        if (overview == null) {
            return this.handleMissingReportOverview("getValidationOptions()");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\nValidation options:\n\n");
        boolean detailedReport = Configuration.getInstance().getBooleanProperty(Property.REPORTS_DETAILED);
        boolean referenceData = Configuration.getInstance().getBooleanProperty(Property.REFERENCE_DATA);
        int stripQuotes = Configuration.getInstance().getIntegerProperty(Property.STRIP_CRITERION);
        boolean printMatchingInfo = Configuration.getInstance().getBooleanProperty(Property.MPMT_MATCH_INFO);
        if (logger.isDebugEnabled()) {
            logger.debug("getValidationOptions() - Flat detailedReport ? " + detailedReport);
        }
        String stripQuotesLabel = "undef";
        switch (stripQuotes) {
            case 1: {
                stripQuotesLabel = "true";
                break;
            }
            default: {
                stripQuotesLabel = "false";
            }
        }
        DAOFactory daoFactory = DAOFactory.getDAOFactory();
        ProtocolDAO protocolDAO = (ProtocolDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL));
        int protocolId = overview.getProtocolId();
        Protocol protocol = (Protocol)protocolDAO.getByID(protocolId);
        builder.append("Validation protocol ID                  : ");
        builder.append(protocolId);
        builder.append("\n");
        builder.append("Name of validation protocol             : ");
        builder.append(protocol.toString());
        builder.append("\n");
        builder.append("Print detailed TXT report               : ");
        builder.append(detailedReport);
        builder.append("\n");
        builder.append("Use reference data                      : ");
        builder.append(referenceData);
        builder.append("\n");
        builder.append("Strip all quotes from dataset           : ");
        builder.append(stripQuotesLabel);
        builder.append("\n");
        builder.append("Print cross-record matching info        : ");
        builder.append(printMatchingInfo);
        builder.append("\n");
        if (protocolId == 1 || protocolId == 11) {
            builder.append("\nENCR Incidence options:\n\n");
            int mpmtCriterion = Configuration.getInstance().getIntegerProperty(Property.MPMT_CRITERION);
            boolean mpmtMerge = Configuration.getInstance().getBooleanProperty(Property.MPMT_ALGORITHM);
            boolean survival = Configuration.getInstance().getBooleanProperty(Property.MANDATORY_FLAG_1);
            builder.append("Acceptance MP criterion                  : ");
            builder.append(mpmtCriterion);
            builder.append("\n");
            builder.append("Apply MPMT merging algorithm             : ");
            builder.append(mpmtMerge);
            builder.append("\n");
            builder.append("Survival variables 'mandatory' flag      : ");
            builder.append(survival);
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getFieldsStatistics() {
        ReportOverview overview = this.report.getReportOverview();
        if (overview == null) {
            return this.handleMissingReportOverview("getFieldsStatistics()");
        }
        StringBuilder builder = new StringBuilder();
        String separator = this.report.getSectionSeparator();
        builder.append(separator);
        builder.append("\n");
        builder.append("SUMMARY OF MESSAGES BY VARIABLE\n");
        builder.append(separator);
        builder.append("\n\n");
        List<ReportOverviewMessage> fieldsList = overview.getFieldList();
        if (fieldsList.size() <= 0) {
            return "No fields statistics (no messages at all)";
        }
        String margin = " ";
        String dashedLine = "----------------------------------------------\n";
        boolean found = false;
        for (ReportOverviewMessage message : fieldsList) {
            if (logger.isTraceEnabled()) {
                logger.trace("getFieldsStatistics() - Handling ReportOverviewMessage: " + String.valueOf(message));
            }
            if (message.getCount() <= 0) {
                logger.warn("getFieldsStatistics() - Found ReportOverviewMessage with zero messages: " + String.valueOf(message));
                continue;
            }
            if (!found) {
                found = true;
                builder.append(dashedLine);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("getFieldsStatistics() - Bulding target message");
            }
            builder.append(margin);
            builder.append(message.getFormattedMessageCount());
            builder.append("\n");
            builder.append(dashedLine);
        }
        return builder.toString();
    }

    public String getMessagesLegend() {
        ReportOverview overview = this.report.getReportOverview();
        if (overview == null) {
            return this.handleMissingReportOverview("getMessagesLegend()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getMessagesLegend() - Producing legend section");
        }
        StringBuilder builder = new StringBuilder();
        String separator = this.report.getSectionSeparator();
        builder.append(separator);
        builder.append("\n");
        builder.append("KEY TO ERROR AND WARNING CODES\n");
        builder.append(separator);
        builder.append("\n\n");
        List<ReportOverviewMessage> messageList = overview.getMessages();
        if (messageList.size() <= 0) {
            return "No legend (no messages at all)";
        }
        boolean hasErrorCodes = false;
        for (ReportOverviewMessage message : messageList) {
            if (message == null || message.getType() != MessageType.ERROR) continue;
            if (!hasErrorCodes) {
                hasErrorCodes = true;
            }
            builder.append(message.getMessage());
            builder.append(": ");
            builder.append(message.getDescription());
            builder.append("\n");
        }
        if (hasErrorCodes) {
            builder.append("\n");
        }
        boolean hasWarningCodes = false;
        for (ReportOverviewMessage message : messageList) {
            if (message == null || message.getType() != MessageType.WARNING) continue;
            if (!hasWarningCodes) {
                hasWarningCodes = true;
                builder.append("WARNING CODES:\n\n");
            }
            builder.append(message.getMessage());
            builder.append(": ");
            builder.append(message.getDescription());
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getNumberOfMessages(MessageType messageType) {
        ReportOverview overview = this.report.getReportOverview();
        if (overview == null) {
            return this.handleMissingReportOverview("getNumberOfMessages()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getNumberOfMessages() - Producing \"Total number of messages\" section");
        }
        StringBuilder builder = new StringBuilder();
        String separator = this.report.getSectionSeparator();
        String label = messageType.name.toUpperCase() + "S";
        builder.append(separator);
        builder.append("\n");
        builder.append("SUMMARY OF ");
        builder.append(label);
        builder.append(" BY CODE\n");
        builder.append(separator);
        builder.append("\n\n");
        List<ReportOverviewMessage> messageList = overview.getMessages();
        if (messageList.size() <= 0) {
            return "No summary section (no messages at all)";
        }
        String margin = " ";
        String padding = "                                   ";
        String dashedLine = "----------------------------------------------\n";
        boolean found = false;
        for (ReportOverviewMessage message : messageList) {
            if (message.getType() != messageType || message.getCount() <= 0) continue;
            if (!found) {
                found = true;
                builder.append(dashedLine);
            }
            builder.append(margin);
            builder.append(message.getMessage());
            builder.append(padding);
            builder.append(String.valueOf(message.getCount()));
            builder.append("\n");
            builder.append(dashedLine);
        }
        if (found) {
            builder.append("\n");
        }
        return builder.toString();
    }

    protected String handleMissingReportOverview(String method) {
        String message = method + " - Null Report Overview";
        logger.error(message);
        return "N/A (null report's overview)\n";
    }

    public boolean isMarkTestSuiteLabels() {
        return this.markTestSuiteLabels;
    }

    public void setMarkTestSuiteLabels(boolean markTestSuiteLabels) {
        this.markTestSuiteLabels = markTestSuiteLabels;
    }

    public TXTReport getReport() {
        return this.report;
    }

    public void setReport(TXTReport report) {
        this.report = report;
    }

    public HashedTimestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(HashedTimestamp timestamp) {
        this.timestamp = timestamp;
    }
}

