/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ReportType {
    WRONG("Wrong definition", "Wrong", "WRONG", "undef", -1),
    UNDEF("Not defined", "Undefined", "UNDEFINED", "undef", 0),
    INCIDENCE_2014("Incidence 2014", "Incidence", "INCIDENCE", "incidence", 1),
    MORTALITY_2014("Mortality 2014", "Mortality", "MORTALITY", "mortality", 2),
    POPULATION_2014("Population 2014", "Population", "POPULATION", "population", 3),
    LIFE_TABLE_2014("Life Table 2014", "LifeTable", "LIFE TABLE", "lifetable", 4),
    INCIDENCE_2020("Incidence 2022", "Incidence", "INCIDENCE", "incidence", 11),
    MORTALITY_2020("Mortality 2022", "Mortality", "MORTALITY", "mortality", 12),
    POPULATION_2020("Population 2022", "Population", "POPULATION", "population", 13),
    LIFE_TABLE_2020("Life Table 2022", "LifeTable", "LIFE TABLE", "lifetable", 14);

    public final String name;
    public final String fileName;
    public final String title;
    public final String folder;
    public final int id;
    protected static Logger logger;

    private ReportType(String name, String fileName, String title, String folder, int id) {
        this.name = name;
        this.fileName = fileName;
        this.title = title;
        this.folder = folder;
        this.id = id;
    }

    public String getID() {
        return String.valueOf(this.id);
    }

    public String getReportName() {
        return "QCS-" + this.fileName + "-Output";
    }

    public String getShortReportName() {
        return "QCS-" + this.fileName + "-Output-Summary";
    }

    public static ReportType getByID(String id) {
        int reportTypeID;
        try {
            reportTypeID = Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            logger.error("getByID() - Wrong report type: " + id);
            return WRONG;
        }
        return ReportType.getByID(reportTypeID);
    }

    public static ReportType getByID(int id) {
        for (ReportType type : ReportType.values()) {
            if (type.id != id) continue;
            return type;
        }
        return UNDEF;
    }

    public static ReportType getByName(String name) {
        for (ReportType type : ReportType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return UNDEF;
    }

    public static String getRelativePath(ReportType reportType) {
        return "output/" + reportType.folder;
    }

    static {
        logger = LoggerFactory.getLogger(ReportType.class);
    }
}

