/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report;

import eu.europa.ec.jrc.qcs.engine.ValidationCycle;
import eu.europa.ec.jrc.qcs.engine.preset.DefaultMessageID;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum ReportSubSection {
    UNDEF("REPORT SUB SECTION (undef)", ValidationCycle.UNDEF, 0, 0),
    MPMT_ERRORS("MULTIPLE PRIMARY MALIGNANT TUMOUR CHECK", ValidationCycle.POST_RECORD, DefaultMessageID.W_MPCR.id, 1),
    MPMT_WARNINGS("MULTIPLE PRIMARY MALIGNANT TUMOUR CHECK", ValidationCycle.POST_RECORD, DefaultMessageID.W_MPMT.id, 2);

    public final String title;
    public final ValidationCycle cycle;
    public final int messageID;
    public final int order;

    private ReportSubSection(String title, ValidationCycle cycle, int messageID, int order) {
        this.title = title;
        this.cycle = cycle;
        this.messageID = messageID;
        this.order = order;
    }

    public static List<ReportSubSection> getByOrder() {
        ReportSubSection[] array = ReportSubSection.values();
        List<ReportSubSection> values = Arrays.asList(array);
        Collections.sort(values, new Comparator<ReportSubSection>(){

            @Override
            public int compare(ReportSubSection section_1, ReportSubSection section_2) {
                Integer order_1 = section_1.order;
                Integer order_2 = section_2.order;
                return order_1.compareTo(order_2);
            }
        });
        return values;
    }

    public static ReportSubSection getByMessageID(int messageID) {
        for (ReportSubSection subSection : ReportSubSection.values()) {
            if (subSection.messageID != messageID) continue;
            return subSection;
        }
        return UNDEF;
    }
}

