/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report;

import eu.europa.ec.jrc.qcs.engine.ValidationCycle;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum ReportSection {
    UNDEF("REPORT SECTION (undef)", "report-section", ValidationCycle.UNDEF, 0),
    SUMMARY("SUMMARY OF ERRORS BY CODE", "report-summary", ValidationCycle.UNDEF, 1),
    PRE_RECORD("DUPLICATE RECORDS", "report-pre-record", ValidationCycle.PRE_RECORD, 2),
    RECORD("ERRORS AND WARNINGS", "report-record", ValidationCycle.RECORD, 4),
    POST_RECORD("MULTIPLE PRIMARY MALIGNANT TUMOUR SECTION", "report-post-record", ValidationCycle.POST_RECORD, 3);

    public final String title;
    public final String fileName;
    public final ValidationCycle cycle;
    public final int order;

    private ReportSection(String title, String fileName, ValidationCycle cycle, int order) {
        this.title = title;
        this.fileName = fileName;
        this.cycle = cycle;
        this.order = order;
    }

    public static List<ReportSection> getByOrder() {
        ReportSection[] array = ReportSection.values();
        List<ReportSection> values = Arrays.asList(array);
        Collections.sort(values, new Comparator<ReportSection>(){

            @Override
            public int compare(ReportSection section_1, ReportSection section_2) {
                Integer order_1 = section_1.order;
                Integer order_2 = section_2.order;
                return order_1.compareTo(order_2);
            }
        });
        return values;
    }

    public static ReportSection getByValidationCycle(ValidationCycle cycle) {
        for (ReportSection section : ReportSection.values()) {
            if (section.cycle != cycle) continue;
            return section;
        }
        return UNDEF;
    }
}

