/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.report.GenericReport;
import eu.europa.ec.jrc.qcs.report.ReportFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.tools.TextToPDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFReport
extends GenericReport {
    protected int fontSize;
    protected String fontName;
    protected static Logger logger = LoggerFactory.getLogger(PDFReport.class);

    public PDFReport(int validationRunID) {
        super(ReportFormat.PDF, validationRunID);
        this.init();
    }

    @Override
    public boolean init() {
        boolean parent = super.init();
        this.setFontName("Courier");
        this.setFontSize(8);
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Initialization completed");
        }
        return parent;
    }

    @Override
    public long generate() {
        String txtFileName = this.getReportFilename() + ReportFormat.TXT.getFileExtension();
        String txtFilePath = this.addRelativePath(txtFileName);
        if (logger.isDebugEnabled()) {
            logger.debug("generate() - Sourcing from  TXT report: " + txtFilePath);
        }
        String pdfFileName = this.getReportFilename() + ReportFormat.PDF.getFileExtension();
        String pdfFilePath = this.addRelativePath(pdfFileName);
        TextToPDF pdf = new TextToPDF();
        File pdfFile = new File(pdfFilePath);
        BufferedReader reader = null;
        if (logger.isDebugEnabled()) {
            logger.debug("generate() - Starting production of PDF report: " + String.valueOf(pdfFile));
        }
        try {
            reader = new BufferedReader(new FileReader(txtFilePath));
        }
        catch (FileNotFoundException e) {
            boolean produceCSVReport = Configuration.getInstance().getBooleanProperty(Property.REPORT_CSV);
            boolean produceTXTReport = Configuration.getInstance().getBooleanProperty(Property.REPORT_TXT);
            if (produceTXTReport) {
                if (produceCSVReport) {
                    logger.warn("generate() - Something went wrong when writing \"" + txtFilePath + "\"");
                } else {
                    logger.warn("generate() - The CSV report is disabled: it's MUST be enabled in order to produce the TXT one!");
                }
            } else {
                logger.warn("generate() - The TXT report is disabled: it's MUST be enabled in order to produce the PDF one!");
            }
            logger.error("generate() - Failed to open TXT report file: " + txtFilePath);
            return 0L;
        }
        catch (Exception e) {
            logger.error("generate() - Generic exception opening TXT report file " + txtFilePath + " : " + e.getMessage());
            try {
                reader.close();
            }
            catch (IOException ioe) {
                logger.error("generate() - IO exception when closing file " + txtFilePath + " : " + e.getMessage());
                ioe.printStackTrace();
            }
            return 0L;
        }
        if (logger.isDebugEnabled()) {
            logger.info("generate() - Produced BufferedReader : " + String.valueOf(reader));
        }
        PDType1Font fontName = this.getPDFont(this.fontName);
        pdf.setFont((PDFont)fontName);
        pdf.setFontSize(this.fontSize);
        PDDocument document = new PDDocument();
        if (logger.isInfoEnabled()) {
            logger.info("generate() - Starting conversion from TXT to PDF");
        }
        try {
            pdf.createPDFFromText(document, (Reader)reader);
        }
        catch (IOException e) {
            logger.error("generate() - Failed to create PDF from TXT report file: " + txtFilePath);
            e.printStackTrace();
            return 0L;
        }
        catch (Exception e) {
            logger.error("generate() - Generic exception credting PDF report file from TXT report " + txtFilePath + " : " + e.getMessage());
            e.printStackTrace();
            return 0L;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("generate() - Saving PDF report : " + String.valueOf(pdfFile));
        }
        try {
            document.save(pdfFile);
            document.close();
            reader.close();
        }
        catch (IOException e) {
            logger.error("generate() - Failed to save PDF file: " + pdfFilePath);
            return 0L;
        }
        catch (Exception e) {
            logger.error("generate() - Generic exception saving PDF file " + pdfFilePath + " : " + e.getMessage());
            return 0L;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("generate() - Completed PDF report : " + pdfFilePath);
        }
        return 1L;
    }

    private String prepareOldFilePath(String filePath) {
        int lastDotIndex = filePath.lastIndexOf(".");
        if (lastDotIndex > 0) {
            return filePath.substring(0, lastDotIndex) + "_OLD" + filePath.substring(lastDotIndex);
        }
        return filePath + "_OLD";
    }

    public boolean renameReportFileToOld() {
        boolean renamed;
        String pdfFileName = this.getReportFilename() + ReportFormat.PDF.getFileExtension();
        String pdfFilePath = this.addRelativePath(pdfFileName);
        File pdfFile = new File(pdfFilePath);
        if (!pdfFile.exists() || pdfFile.isDirectory()) {
            if (logger.isDebugEnabled()) {
                logger.debug("renameReportFileToOld() - No previous PDF report found at: {}", (Object)pdfFilePath);
            }
            return false;
        }
        String filePathWithOld = this.prepareOldFilePath(pdfFilePath);
        File fileWithOld = new File(filePathWithOld);
        if (fileWithOld.exists() && !fileWithOld.delete()) {
            logger.warn("renameReportFileToOld() - Could not delete existing old PDF: {}", (Object)filePathWithOld);
        }
        if (renamed = pdfFile.renameTo(fileWithOld)) {
            if (logger.isInfoEnabled()) {
                logger.info("renameReportFileToOld() - Renamed previous PDF report: {} -> {}", (Object)pdfFilePath, (Object)filePathWithOld);
            }
        } else {
            logger.warn("renameReportFileToOld() - Failed to rename PDF report: {}", (Object)pdfFilePath);
        }
        return renamed;
    }

    public boolean deleteOldPDF() {
        String pdfFileName = this.getReportFilename() + ReportFormat.PDF.getFileExtension();
        String pdfFilePath = this.addRelativePath(pdfFileName);
        String oldFilePath = this.prepareOldFilePath(pdfFilePath);
        return this.deleteFile(oldFilePath);
    }

    protected PDType1Font getPDFont(String fontName) {
        switch (fontName) {
            case "Courier": {
                return PDType1Font.COURIER;
            }
            case "Helvetica": {
                return PDType1Font.HELVETICA;
            }
            case "Times": {
                return PDType1Font.TIMES_ROMAN;
            }
        }
        return PDType1Font.COURIER;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }
}

