/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.ProtocolViewDAO;
import eu.europa.ec.jrc.qcs.dao.ReferenceFieldDAO;
import eu.europa.ec.jrc.qcs.dao.RuleOutputDAO;
import eu.europa.ec.jrc.qcs.dao.ValidationRunDAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAO;
import eu.europa.ec.jrc.qcs.dao.datasource.DAOFactory;
import eu.europa.ec.jrc.qcs.dao.model.MessageType;
import eu.europa.ec.jrc.qcs.dao.model.config.ApplicationProperties;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.config.ReferenceField;
import eu.europa.ec.jrc.qcs.dao.model.config.ValidationOptions;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.dao.model.output.ValidationRun;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ProtocolView;
import eu.europa.ec.jrc.qcs.dao.model.protocol.RuleDefinition;
import eu.europa.ec.jrc.qcs.dao.model.protocol.ValidationMessage;
import eu.europa.ec.jrc.qcs.dao.model.schema.Field;
import eu.europa.ec.jrc.qcs.dao.model.schema.Schema;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemaView;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.engine.RawFilesReader;
import eu.europa.ec.jrc.qcs.report.ReportFormat;
import eu.europa.ec.jrc.qcs.report.ReportType;
import eu.europa.ec.jrc.qcs.report.handlers.ReferenceDataReader;
import eu.europa.ec.jrc.qcs.report.model.GenericReportLine;
import eu.europa.ec.jrc.qcs.report.model.ReportLayout;
import eu.europa.ec.jrc.qcs.report.model.ReportOverview;
import eu.europa.ec.jrc.qcs.report.model.ReportOverviewMessage;
import eu.europa.ec.jrc.qcs.test.SystemTester;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericReport {
    protected long numberOflines;
    protected ReportType reportType;
    protected ReportFormat reportFormat;
    protected ReportLayout reportLayout;
    protected ReportOverview reportOverview;
    protected RawFilesReader rawFilesReader;
    protected int validationRunID;
    protected ProtocolView protocolView;
    protected ValidationRun validationRun;
    protected String reportBaseFolder;
    protected String reportFolder;
    protected String reportFileName;
    protected String shortReportFileName;
    protected List<ReferenceField> referenceFields;
    protected boolean benchmark = false;
    protected static DAOFactory daoFactory;
    protected static ValidationRunDAO validationRunDAO;
    protected static RuleOutputDAO ruleOutputDAO;
    protected static ProtocolViewDAO protocolViewDAO;
    protected static ReferenceFieldDAO referenceFieldDAO;
    protected static Logger logger;

    public GenericReport(ReportFormat reportFormat) {
        this.reportFormat = reportFormat;
        this.reportBaseFolder = this.getBaseAbsolutePath();
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - Constructor() - Set base folder: " + this.reportBaseFolder);
        }
    }

    public GenericReport(ReportFormat reportFormat, int validationRunID) {
        this(reportFormat);
        this.validationRunID = validationRunID;
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - Constructor() - Created instance for validationRunID : " + validationRunID + " (format = " + String.valueOf((Object)reportFormat) + ")");
        }
    }

    public boolean init() {
        this.reportOverview = null;
        this.validationRun = (ValidationRun)validationRunDAO.getByID(this.validationRunID);
        int protocolID = this.validationRun.getProtocolID();
        this.protocolView = (ProtocolView)protocolViewDAO.getByID(protocolID);
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - init() - Loaded validation run: " + String.valueOf(this.validationRun));
        }
        if (this.validationRun == ValidationRun.UNDEF) {
            logger.error(this.getClassName() + " - init() - Failed to fetch validation run: " + this.validationRunID);
            return false;
        }
        if (this.protocolView == ProtocolView.UNDEF) {
            logger.error(this.getClassName() + " - init() - Failed to fetch protocol: " + protocolID);
            return false;
        }
        this.reportFolder = this.initReportFolder();
        return true;
    }

    public String initReportFolder() {
        ReportType reportType;
        File path;
        String specificPath = null;
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - initReportFolder() - Checking report base path: " + this.reportBaseFolder);
        }
        if (!(path = new File(this.reportBaseFolder)).exists()) {
            path.mkdir();
            if (logger.isInfoEnabled()) {
                logger.info(this.getClassName() + " - initReportFolder() - Created report base path: " + this.reportBaseFolder);
            }
            if (!path.exists()) {
                logger.error(this.getClassName() + " - initReportFolder() - Failed creating directory: " + String.valueOf(path));
                return null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - initReportFolder() - Checking report type for base path: " + this.reportBaseFolder);
        }
        if ((reportType = this.getReportType()) != null) {
            specificPath = this.reportBaseFolder + "/" + reportType.folder;
        }
        path = new File(specificPath);
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - initReportFolder() - Creating report's folder: " + String.valueOf(path));
        }
        if (!path.exists()) {
            path.mkdir();
            if (logger.isInfoEnabled()) {
                logger.info(this.getClassName() + " - initReportFolder() - Created report specific path: " + specificPath);
            }
            if (!path.exists()) {
                logger.error(this.getClassName() + " - initReportFolder() - Failed creating directory: " + String.valueOf(path));
                return null;
            }
        } else if (!path.isDirectory()) {
            logger.error(this.getClassName() + " - initReportFolder() - Wrong file type (must be a directory): " + String.valueOf(path));
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + "- initReportFolder() - Set report's folder: " + specificPath);
        }
        return specificPath;
    }

    public abstract long generate();

    public ReportOverview getReportOverview() {
        int withIssuesCount;
        if (this.reportOverview != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getReportOverview() - Returning cached ReportOverview: " + String.valueOf(this.reportOverview));
            }
            return this.reportOverview;
        }
        ReportOverview overview = new ReportOverview();
        Configuration configuration = Configuration.getInstance();
        ApplicationProperties appProp = configuration.getApplicationProperties();
        String appVersion = appProp.getValue(Property.PREFIX) + " " + appProp.getValue(Property.VERSION);
        String dbVersion = configuration.getDatabaseVersion();
        overview.setAppVersion(appVersion);
        overview.setDbVersion(dbVersion);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd H:m:s.S");
        if (this.validationRun.getProcessStart() != null) {
            overview.setProcessStartDate(dateFormat.format(this.validationRun.getProcessStart()));
        } else {
            overview.setProcessStartDate("N/A");
        }
        if (this.validationRun.getProcessEnd() != null) {
            overview.setProcessEndDate(dateFormat.format(this.validationRun.getProcessEnd()));
        } else {
            overview.setProcessEndDate("N/A");
        }
        overview.setFilename(this.validationRun.getName());
        overview.setProtocolId(this.validationRun.getProtocolID());
        overview.setRecordCount(this.validationRun.getRecordsIn());
        overview.setErrorCount(this.validationRun.getErrorsNumber());
        overview.setWarningCount(this.validationRun.getWarningsNumber());
        overview.setRecordRejectedCount(this.validationRun.getRecordsKO());
        overview.setFailedPreliminaryRuleIds(this.validationRun.getFailedPreliminaryRuleIds());
        if (logger.isDebugEnabled()) {
            logger.debug("getReportOverview() - Comparing records IN/OUT: " + this.validationRun.getRecordsIn() + "/" + this.validationRun.getRecordsOut());
        }
        if ((withIssuesCount = this.validationRun.getRecordsIn() - this.validationRun.getRecordsOut()) < 0) {
            withIssuesCount = 0;
        }
        overview.setRecordsWithIssuesCount(withIssuesCount);
        this.initOverviewMessages(overview);
        if (this.reportOverview == null) {
            this.reportOverview = overview;
            if (logger.isDebugEnabled()) {
                logger.debug("getReportOverview() - Cached ReportOverview: " + String.valueOf(this.reportOverview));
            }
        }
        return overview;
    }

    protected void initOverviewMessages(ReportOverview reportOverview) {
        boolean printFieldsStatistic = Configuration.getInstance().getBooleanProperty(Property.REPORTS_FIELDS);
        List<RuleDefinition> rules = this.protocolView.getRuleDefinitions();
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - initOverviewMessages() - Size of list with rules definitions: " + rules.size());
        }
        int counter = 0;
        for (RuleDefinition rule : rules) {
            MessageType messageType;
            ++counter;
            if (logger.isDebugEnabled()) {
                logger.debug(this.getClassName() + " - initOverviewMessages() - Analysing messages for rule: " + String.valueOf(rule) + "(counter: " + counter + ")");
            }
            if (rule == RuleDefinition.UNDEF) {
                logger.warn(this.getClassName() + " - initOverviewMessages() - Skipping UNDEF rule definition");
                continue;
            }
            ValidationMessage message = rule.getValidationMessage();
            if (message == null || message.getMessageType() == null) {
                logger.error(this.getClassName() + " - initOverviewMessages() - missing validation message for rule: " + rule.getName());
                message = ValidationMessage.UNDEF;
            }
            if ((messageType = message.getMessageType()) != MessageType.ERROR && messageType != MessageType.WARNING) {
                logger.warn(this.getClassName() + " - initOverviewMessages() - Skipping message type: " + String.valueOf((Object)messageType));
                continue;
            }
            String name = message.getCode();
            String description = message.getDescription();
            ReportOverviewMessage reportOverviewMessage = new ReportOverviewMessage(name, messageType, description);
            reportOverview.addMessage(reportOverviewMessage);
            if (logger.isDebugEnabled()) {
                logger.debug(this.getClassName() + " - initOverviewMessages() - Added message: " + String.valueOf(reportOverviewMessage));
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(this.getClassName() + " - initOverviewMessages() - Added alternate message: " + String.valueOf(reportOverviewMessage));
        }
        List<ReportOverviewMessage> messageList = reportOverview.getMessages();
        List outputList = ruleOutputDAO.getAll();
        if (outputList == null) {
            return;
        }
        if (printFieldsStatistic) {
            if (logger.isInfoEnabled()) {
                logger.info(this.getClassName() + " - initOverviewMessages() - Producing fields statistics (could take a long time)");
            }
        } else if (logger.isInfoEnabled()) {
            logger.info(this.getClassName() + " - initOverviewMessages() - Producing message statistics (without fields statistics)");
        }
        counter = 0;
        for (RuleOutput ruleOutput : outputList) {
            ++counter;
            if (logger.isDebugEnabled()) {
                logger.debug(this.getClassName() + " - initOverviewMessages() - Analysing RuleOutput: " + String.valueOf(ruleOutput) + "(counter: " + counter + ")");
            }
            if (ruleOutput.getValidationRunID() != this.getValidationRunID()) {
                logger.warn(this.getClassName() + " - initOverviewMessages() - RunId of RuleOutput differs from RunId of this report");
                logger.warn(this.getClassName() + " - initOverviewMessages() - RunId (RuleOutput)    : " + ruleOutput.getValidationRunID());
                logger.warn(this.getClassName() + " - initOverviewMessages() - RunId (GenericReport) : " + this.getValidationRunID());
                continue;
            }
            String errorCode = ruleOutput.getErrorCode();
            for (ReportOverviewMessage message : messageList) {
                if (!message.getMessage().equals(errorCode)) continue;
                message.incrementCount();
            }
            if (!printFieldsStatistic) continue;
            List<RuleOutputDetail> allOutputDetails = ruleOutput.getAllRuleOutputDetail();
            if (logger.isDebugEnabled()) {
                logger.debug(this.getClassName() + " - initOverviewMessages() - Analysing RuleOutputDetail: " + String.valueOf(allOutputDetails));
            }
            for (RuleOutputDetail ruleOutputDetail : allOutputDetails) {
                String name = ruleOutputDetail.getFieldName();
                ReportOverviewMessage reportOverviewMessage = new ReportOverviewMessage(name);
                reportOverview.addFieldMessage(ruleOutput, reportOverviewMessage);
            }
        }
        reportOverview.sortMessageList();
        if (logger.isDebugEnabled()) {
            for (ReportOverviewMessage message : messageList) {
                logger.debug(this.getClassName() + " - initOverviewMessages() - Overview's message: " + String.valueOf(message));
            }
        }
    }

    public ReportType getReportType() {
        if (this.reportType != null) {
            return this.reportType;
        }
        if (this.protocolView == null) {
            logger.error(this.getClassName() + " - getReportType() - Protocol view not set");
            return ReportType.UNDEF;
        }
        Schema schema = this.protocolView.getProtocol().getSchema();
        if (schema == null) {
            logger.error(this.getClassName() + " - getReportType() - Null ReportType and null Schema-> Cannot identify the propert report type");
            return ReportType.UNDEF;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - getReportType() - Protocol view -> Schema : " + String.valueOf(schema));
        }
        this.reportType = schema.getReportType();
        if (logger.isInfoEnabled()) {
            logger.info(this.getClassName() + " - getReportType() - Schema : " + schema.getName() + " -> ReportType : " + String.valueOf((Object)this.reportType));
        }
        if (this.reportType == null || this.reportType == ReportType.UNDEF) {
            SchemasGroup group = schema.getSchemaGroup();
            if (group == null) {
                logger.error(this.getClassName() + " - getReportType() - Null ReportType and null SchemasGroup -> Cannot identify the propert report type");
                return ReportType.UNDEF;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.getClassName() + " - getReportType() - Protocol view -> Guessing ReportType from SchemasGroup : " + String.valueOf(group));
            }
            String groupName = group.getName();
            this.reportType = ReportType.getByName(groupName);
            if (logger.isInfoEnabled()) {
                logger.info(this.getClassName() + " - getReportType() - ReportType guessed by validation group (" + groupName + "): " + String.valueOf((Object)this.reportType));
            }
        }
        return this.reportType;
    }

    public String getBaseAbsolutePath() {
        String basePath = System.getProperty("user.dir") + "/output";
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - getBaseAbsolutePath (): " + basePath);
        }
        return basePath;
    }

    public String getProtocolPath() {
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - getProtocolPath(): Checking report type");
        }
        String folderName = "unknown";
        ReportType reportType = this.getReportType();
        if (reportType != null) {
            folderName = reportType.folder;
        }
        return folderName;
    }

    public String getReportFilename() {
        if (this.reportFileName != null) {
            return this.reportFileName;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - getReportFilename() - Checking report type");
        }
        ReportType reportType = this.getReportType();
        this.reportFileName = reportType.getReportName();
        return this.reportFileName;
    }

    public String getShortReportFilename() {
        if (this.shortReportFileName != null) {
            return this.shortReportFileName;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - getShortReportFilename() - Checking report type");
        }
        ReportType reportType = this.getReportType();
        this.shortReportFileName = reportType.getShortReportName();
        return this.shortReportFileName;
    }

    public String addRelativePath(String fileName) {
        ReportType reportType = this.getReportType();
        String relativePath = ReportType.getRelativePath(reportType) + "/" + fileName;
        if (logger.isDebugEnabled()) {
            logger.debug(this.getClassName() + " - getRelativePath(): " + fileName + " -> " + relativePath);
        }
        return relativePath;
    }

    public String getFileWriterPath(String fileName) {
        String root = "./";
        String destinationName = fileName + ReportFormat.TXT.getFileExtension();
        String destinationPath = root + this.addRelativePath(destinationName);
        return destinationPath;
    }

    public Field getFieldByID(int fieldID) {
        SchemaView schemaView = this.protocolView.getSchemaView();
        Field field = schemaView.getFieldByID(fieldID);
        return field;
    }

    protected void setRegistryData(GenericReportLine reportLine, RuleOutput ruleOutput) {
        boolean debug = logger.isTraceEnabled();
        Object[] header = reportLine.getReferenceHeader();
        Object[] dataArray = new String[header.length];
        if (debug) {
            logger.info(this.getClassName() + " - setRegistryData() - Getting data for header      : " + Arrays.toString(header));
            logger.info(this.getClassName() + " - setRegistryData() - Getting data from RuleOutput : " + String.valueOf(ruleOutput));
        }
        int collatePosition = 0;
        boolean collated = false;
        Object collatedValue = "";
        String collatedSeparator = "";
        ReferenceDataReader referenceDataReader = this.rawFilesReader.getReferenceDataReader();
        for (ReferenceField referenceField : this.referenceFields) {
            Field field = referenceField.getField();
            String fieldName = field.getName();
            String fieldValue = referenceDataReader.getFieldValue(ruleOutput, fieldName);
            collated = referenceField.isCollated(this.referenceFields);
            if (debug) {
                logger.info(this.getClassName() + " - setRegistryData() - " + referenceField.formatMapping(fieldValue) + (collated ? "collated" : ""));
            }
            int position = referenceField.getPosition();
            int index = position - 1;
            if (collated && collatePosition == 0) {
                collatePosition = position;
            }
            if (!collated) {
                if (referenceField.isFirstKeyField() && (fieldValue == null || fieldValue.isEmpty())) {
                    int lineNumber = ruleOutput.getLineNumber();
                    fieldValue = this.storeIntegerValue(lineNumber);
                    if (debug) {
                        logger.info(this.getClassName() + " - setRegistryData() - First key field is empty");
                    }
                }
                dataArray[index] = fieldValue;
                if (!debug) continue;
                logger.info(this.getClassName() + " - setRegistryData() - Set simple field : " + fieldName + " = " + fieldValue);
                continue;
            }
            if (position != collatePosition) {
                if (debug) {
                    logger.info(this.getClassName() + " - setRegistryData() -   SAVING  collated value [" + collatePosition + "] : " + (String)collatedValue);
                }
                dataArray[index - 1] = new String((String)collatedValue);
                collatedValue = "";
                collatedSeparator = "";
                collatePosition = position;
            }
            collatedValue = (String)collatedValue + collatedSeparator;
            collatedValue = (String)collatedValue + fieldValue;
            collatedSeparator = "/";
            if (!debug) continue;
            logger.info(this.getClassName() + " - setRegistryData() -   Current collated value [" + collatePosition + "] : " + (String)collatedValue);
        }
        if (collated) {
            int index = collatePosition - 1;
            dataArray[index] = collatedValue;
            if (debug) {
                logger.info(this.getClassName() + " - setRegistryData() -   Ended cycle with unhandled collated value [" + collatePosition + "]: " + (String)collatedValue);
            }
        }
        reportLine.setReferenceData((String[])dataArray);
        if (debug) {
            logger.info(this.getClassName() + " - setRegistryData() - Set Reference Data: " + Arrays.toString(dataArray));
        }
    }

    protected boolean deleteFile(String path) {
        File file = new File(path);
        if (file.exists() && !file.isDirectory()) {
            if (logger.isInfoEnabled()) {
                logger.info(this.getClassName() + " - deleteFile() - Removing previous report: " + path);
            }
            return file.delete();
        }
        logger.warn(this.getClassName() + " - deleteFile() " + path + " not found -> nothing to clean");
        return false;
    }

    protected String join(List<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String string : list) {
            builder.append(string);
        }
        String output = builder.toString();
        return output;
    }

    protected boolean handleMissingInteger(List<String> lines) {
        String referenceLine = lines.get(1);
        String result = this.handleMissingInteger(referenceLine);
        if (result != null) {
            lines.set(1, result);
            return true;
        }
        return false;
    }

    protected String handleMissingInteger(String line) {
        boolean missingIntegerValue = line.contains("_INT_VAL_");
        if (missingIntegerValue) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.getClassName() + " - handleMissingKeyField() - Missing integer value in line : " + line);
            }
            String pattern = ".*_INT_VAL_(\\d+)";
            String result = line.replaceAll(pattern, "Line $1");
            if (logger.isInfoEnabled()) {
                logger.info(this.getClassName() + " - handleMissingKeyField() - Replaced key field as: " + result);
            }
            return result;
        }
        return null;
    }

    protected String storeIntegerValue(int value) {
        StringBuilder builder = new StringBuilder("_INT_VAL_");
        builder.append(value);
        return builder.toString();
    }

    public int getProtocolID() {
        return this.protocolView.getProtocolID();
    }

    public int getSchemaID() {
        return this.protocolView.getSchemaID();
    }

    public Schema getSchema() {
        return this.protocolView.getSchema();
    }

    public SchemaView getSchemaView() {
        return this.protocolView.getSchemaView();
    }

    public int getSchemaGroupID() {
        return this.protocolView.getSchemaGroupID();
    }

    public SchemasGroup getSchemaGroup() {
        return this.protocolView.getSchemaGroup();
    }

    public List<ReferenceField> getReferenceFields() {
        int protocolID = this.getProtocolID();
        ValidationOptions validationOptions = Configuration.getInstance().getValidationOptions();
        List<ReferenceField> referenceFields = validationOptions.getReferenceFields(protocolID);
        return referenceFields;
    }

    public ReportLayout getReportLayout() {
        if (this.reportLayout != null) {
            return this.reportLayout;
        }
        Schema schema = this.getSchema();
        ReportType reportType = schema.getReportType();
        if (reportType == null || reportType == ReportType.UNDEF) {
            SchemasGroup schemasGroup = this.getSchemaGroup();
            reportType = schemasGroup.getReportType();
            if (logger.isWarnEnabled()) {
                logger.warn("getReportLayout() - Guessed report's layout from SchemasGroup (fallback): " + String.valueOf(this.reportLayout));
            }
        }
        this.reportLayout = ReportLayout.getReportLayout(reportType);
        if (logger.isDebugEnabled()) {
            logger.debug("getReportLayout() - Returning report's layout (): " + String.valueOf(this.reportLayout));
        }
        return this.reportLayout;
    }

    public String getReportBaseFolder() {
        return this.reportBaseFolder;
    }

    public int getValidationRunID() {
        return this.validationRunID;
    }

    public ProtocolView getProtocolView() {
        return this.protocolView;
    }

    public void setProtocolView(ProtocolView protocolView) {
        this.protocolView = protocolView;
    }

    public void setReportLayout(ReportLayout reportLayout) {
        this.reportLayout = reportLayout;
    }

    public long getNumberOflines() {
        return this.numberOflines;
    }

    public void setNumberOflines(long numberOflines) {
        this.numberOflines = numberOflines;
    }

    protected String getClassName() {
        String qualifiedName = this.getClass().getName();
        String[] tokens = qualifiedName.split("\\.");
        return tokens[tokens.length - 1];
    }

    protected void benchmarkRecord(String prefix, RuleOutput ruleOutput) {
        StringBuilder builder = new StringBuilder();
        builder.append(" LINE:");
        builder.append(ruleOutput.getLineNumber());
        builder.append(" CODE:");
        builder.append(ruleOutput.getErrorCode());
        SystemTester.benchmark(prefix, builder.toString());
    }

    static {
        logger = LoggerFactory.getLogger(GenericReport.class);
        daoFactory = DAOFactory.getDAOFactory();
        ruleOutputDAO = (RuleOutputDAO)((Object)daoFactory.getDAO(DAO.RULE_OUTPUT));
        protocolViewDAO = (ProtocolViewDAO)((Object)daoFactory.getDAO(DAO.PROTOCOL_VIEW));
        validationRunDAO = (ValidationRunDAO)((Object)daoFactory.getDAO(DAO.VALIDATION_RUN));
        referenceFieldDAO = (ReferenceFieldDAO)((Object)daoFactory.getDAO(DAO.REFERENCE_FIELD));
    }
}

