/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.report;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.datasource.FileConnection;
import eu.europa.ec.jrc.qcs.dao.file.handler.FileHandlerCSV;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutput;
import eu.europa.ec.jrc.qcs.dao.model.output.RuleOutputDetail;
import eu.europa.ec.jrc.qcs.engine.RawFilesReader;
import eu.europa.ec.jrc.qcs.report.GenericReport;
import eu.europa.ec.jrc.qcs.report.ReportFormat;
import eu.europa.ec.jrc.qcs.report.TXTReport;
import eu.europa.ec.jrc.qcs.report.model.ReportLineCSV;
import eu.europa.ec.jrc.qcs.test.SystemTester;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVReport
extends GenericReport {
    protected TXTReport reportTXT;
    protected FileHandlerCSV<ReportLineCSV> fileHandler;
    private int maxNumberOfDetails;
    protected boolean produceTXTReport = Configuration.getInstance().getBooleanProperty(Property.REPORT_TXT);
    protected static Logger logger = LoggerFactory.getLogger(CSVReport.class);

    public CSVReport(int validationRunID) {
        super(ReportFormat.CSV, validationRunID);
    }

    @Override
    public boolean init() {
        boolean parent = super.init();
        String finalReportFile = this.getReportFilename() + ReportFormat.CSV.getFileExtension();
        String relativePath = this.addRelativePath(finalReportFile);
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Deleting previous report: " + relativePath);
        }
        this.deleteFile(relativePath);
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Opening connection to report's file: " + relativePath);
        }
        FileConnection connection = new FileConnection(relativePath);
        connection.setWriteAccess(true);
        connection.setTemporary(true);
        this.fileHandler = new FileHandlerCSV<ReportLineCSV>(connection, ReportLineCSV.class);
        this.fileHandler.setHeader(true);
        this.fileHandler.setAutoCommit(false);
        this.fileHandler.setNewFile(true);
        this.fileHandler.openWriter();
        if (logger.isDebugEnabled()) {
            logger.debug("init() - Opened FileHandlerCSV on connection: " + String.valueOf(connection));
        }
        if (this.produceTXTReport) {
            this.reportTXT = new TXTReport(this.getValidationRunID());
            if (!this.reportTXT.init()) {
                this.produceTXTReport = false;
                logger.error("init() - Error opening TXT report handlers");
            }
        }
        return parent;
    }

    @Override
    public long generate() {
        boolean firstInit;
        if (this.benchmark && !(firstInit = SystemTester.initBenchmark())) {
            SystemTester.benchmark("report.init");
        }
        this.init();
        int protocolID = this.protocolView.getProtocolID();
        this.referenceFields = referenceFieldDAO.getSortedByProtocolID(protocolID);
        List<String> referenceHeader = referenceFieldDAO.getNamesSortedByProtocolID(protocolID);
        if (logger.isDebugEnabled()) {
            logger.debug("generate() - Creating report file for referenceHeader: " + String.valueOf(referenceHeader));
        }
        int numberOfVarColumns = 2 * this.maxNumberOfDetails;
        ReportLineCSV reportLine = new ReportLineCSV(numberOfVarColumns);
        reportLine.setReferenceHeader(referenceHeader);
        if (logger.isInfoEnabled()) {
            logger.info("generate() - Maximum number of variable columns: " + numberOfVarColumns);
        }
        this.rawFilesReader = new RawFilesReader(this.validationRunID);
        this.rawFilesReader.setReadFromDAO(true);
        this.rawFilesReader.setReadFromFile(false);
        this.rawFilesReader.init();
        if (this.benchmark) {
            SystemTester.benchmark("report.start.cycle");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("generate() - Starting main cycle. Using RawFilesReader: " + String.valueOf(this.rawFilesReader));
        }
        long numberOfLines = 0L;
        while (true) {
            boolean debug;
            RuleOutput ruleOutput;
            if (this.benchmark) {
                SystemTester.benchmark("FETCHING");
            }
            try {
                ruleOutput = this.rawFilesReader.getNextRuleOutput();
            }
            catch (EOFException e) {
                if (!logger.isInfoEnabled()) break;
                logger.info("generate() - Reached EOF for RULE_OUTPUT datasource");
                break;
            }
            if (this.benchmark) {
                this.benchmarkRecord("FETCHED", ruleOutput);
            }
            if (debug = logger.isTraceEnabled()) {
                logger.info("generate() - Fetched RuleOutput " + String.valueOf(ruleOutput));
            }
            List<RuleOutputDetail> ruleOutputDetails = this.rawFilesReader.getNextRuleOutputDetails(ruleOutput);
            ruleOutput.setRuleOutputDetails(ruleOutputDetails);
            ruleOutput.setDetached(true);
            reportLine.setRuleOutput(ruleOutput);
            if (this.benchmark) {
                this.benchmarkRecord("SET_RULE_OUTPUT", ruleOutput);
            }
            this.setRegistryData(reportLine, ruleOutput);
            if (this.benchmark) {
                this.benchmarkRecord("REGISTRY_DATA", ruleOutput);
            }
            if (debug) {
                logger.info("generate() - Set registry data for line: " + reportLine.toShortString());
            }
            this.printLine(reportLine);
            ++numberOfLines;
            if (this.benchmark) {
                this.benchmarkRecord("PRINTED_CSV", ruleOutput);
            }
            if (debug) {
                logger.info("generate() - Handled CSV RuleOutput " + String.valueOf(ruleOutput));
            }
            if (this.produceTXTReport) {
                this.reportTXT.handleLine(reportLine);
            }
            if (this.benchmark) {
                this.benchmarkRecord("PRINTED_TXT", ruleOutput);
            }
            if (!debug) continue;
            logger.info("generate() - Handled TXT RuleOutput " + String.valueOf(ruleOutput));
        }
        if (this.benchmark) {
            SystemTester.benchmark("report.end.cycle");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("generate() - Closing all handlers (CSV and TXT)");
        }
        this.fileHandler.closeWriter();
        if (this.produceTXTReport) {
            this.reportTXT.flushRecordTable();
            this.reportTXT.closeWriter();
            this.reportTXT.mergeSections();
        }
        if (this.benchmark) {
            SystemTester.benchmark("Produced CSV report");
            SystemTester.endBenchmark();
            SystemTester.logMasterAverage();
            logger.info("End of reporting benchmark");
        }
        this.setNumberOflines(numberOfLines);
        if (logger.isDebugEnabled()) {
            logger.debug("generate() - Produced CSV report with about " + numberOfLines + " lines");
        }
        return numberOfLines;
    }

    protected void printLine(ReportLineCSV reportLine) {
        if (logger.isTraceEnabled()) {
            logger.trace("printLine() - Printing ReportLineCSV: " + String.valueOf(reportLine));
        }
        this.handleMissingInteger(reportLine);
        ArrayList<ReportLineCSV> list = new ArrayList<ReportLineCSV>();
        list.add(reportLine);
        int rows = this.fileHandler.writeFile(list);
        if (logger.isTraceEnabled()) {
            logger.trace("printLine() - Printed new CSV lines: " + rows);
        }
    }

    protected void handleMissingInteger(ReportLineCSV reportLine) {
        if (reportLine == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("handleMissingInteger() - Found null ReportLineCSV");
            }
            return;
        }
        String[] values = reportLine.getReferenceData();
        if (values == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("handleMissingInteger() - Found empty ReportLineCSV");
            }
            return;
        }
        for (int index = 0; index < values.length; ++index) {
            String result;
            if (values[index] == null || (result = this.handleMissingInteger(values[index])) == null) continue;
            reportLine.setReferenceData(index, result);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("handleMissingInteger() - Handled missing integer: " + result);
        }
    }

    public int getNumberOfReports() {
        int reports = 1;
        boolean shortReport = Configuration.getInstance().getBooleanProperty(Property.REPORT_SUMMARY);
        if (this.isProduceTXTReport()) {
            ++reports;
            if (shortReport) {
                ++reports;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getNumberOfReports() - Number of produced reports: " + reports);
        }
        return reports;
    }

    public long getNumberOfLinesInTXTReport() {
        if (this.reportTXT == null) {
            return 0L;
        }
        return this.reportTXT.getNumberOflines();
    }

    public int getMaxNumberOfDetails() {
        return this.maxNumberOfDetails;
    }

    public void setMaxNumberOfDetails(int maxNumberOfDetails) {
        this.maxNumberOfDetails = maxNumberOfDetails;
    }

    public boolean isProduceTXTReport() {
        return this.produceTXTReport;
    }

    public void setProduceTXTReport(boolean produceTXTReport) {
        this.produceTXTReport = produceTXTReport;
    }
}

