/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view.style;

import eu.europa.ec.jrc.qcs.gui.view.style.GroupColor;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowIndexCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -8676580774126305177L;
    protected Color foregroundColor;
    protected Color backgroundColor;
    protected Color alternateColor;
    protected Map<Integer, GroupColor> rowsColorMap = new HashMap<Integer, GroupColor>();
    protected static Logger logger = LoggerFactory.getLogger(RowIndexCellRenderer.class);

    public RowIndexCellRenderer(Color foregroundColor, Color backgroundColor) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        try {
            int delta = -20;
            this.alternateColor = new Color(backgroundColor.getRed() + delta, backgroundColor.getGreen() + delta, backgroundColor.getBlue() + delta);
        }
        catch (Exception e) {
            this.alternateColor = backgroundColor;
            logger.error("Zebra crossing disabled: background colour is too dark");
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        GroupColor groupColor = this.rowsColorMap.get(row);
        if (groupColor != null) {
            cell.setForeground(groupColor.getForegroundColor());
            if (row % 2 == 0) {
                cell.setBackground(groupColor.getBackgroundColor());
            } else {
                cell.setBackground(groupColor.getAlternateBackgroundColor());
            }
        } else {
            cell.setForeground(this.foregroundColor);
            if (row % 2 == 0) {
                cell.setBackground(this.backgroundColor);
            } else {
                cell.setBackground(this.alternateColor);
            }
        }
        return cell;
    }

    public Map<Integer, GroupColor> getRowsColorMap() {
        return this.rowsColorMap;
    }

    public void setRowsColorMap(Map<Integer, GroupColor> rowsColorMap) {
        this.rowsColorMap = rowsColorMap;
    }

    private void createDummyGroups() {
        GroupColor color_1 = new GroupColor(Color.WHITE, Color.RED, new Color(200, 0, 0));
        GroupColor color_2 = new GroupColor(Color.BLACK, Color.WHITE, Color.LIGHT_GRAY);
        GroupColor color_3 = new GroupColor(Color.BLUE, Color.GREEN, new Color(0, 200, 0));
        this.rowsColorMap = new HashMap<Integer, GroupColor>();
        this.rowsColorMap.put(0, color_1);
        this.rowsColorMap.put(1, color_2);
        this.rowsColorMap.put(2, color_3);
    }
}

