/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view.style;

import java.awt.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupColor {
    private Color foregroundColor;
    private Color backgroundColor;
    private Color alternateBackgroundColor;
    protected static Logger logger = LoggerFactory.getLogger(GroupColor.class);

    public GroupColor(Color foregroundColor, Color backgroundColor) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        try {
            int delta = -20;
            this.alternateBackgroundColor = new Color(backgroundColor.getRed() + delta, backgroundColor.getGreen() + delta, backgroundColor.getBlue() + delta);
        }
        catch (Exception e) {
            this.alternateBackgroundColor = backgroundColor;
            logger.error("Zebra crossing disabled: background colour is too dark");
        }
    }

    public GroupColor(Color foregroundColor, Color backgroundColor, Color alternateBackgroundColor) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.alternateBackgroundColor = alternateBackgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getAlternateBackgroundColor() {
        return this.alternateBackgroundColor;
    }

    public void setAlternateBackgroundColor(Color alternateBackgroundColor) {
        this.alternateBackgroundColor = alternateBackgroundColor;
    }

    public String toString() {
        return "GroupColor [foregroundColor=" + String.valueOf(this.foregroundColor) + ", backgroundColor=" + String.valueOf(this.backgroundColor) + ", alternateBackgroundColor=" + String.valueOf(this.alternateBackgroundColor) + "]";
    }
}

