/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view.style;

import eu.europa.ec.jrc.qcs.gui.view.style.GroupColor;
import eu.europa.ec.jrc.qcs.gui.view.style.GroupRange;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 7674617579473120246L;
    protected Color foregroundColor;
    protected Color backgroundColor;
    protected Color alternateColor;
    protected Map<GroupRange, GroupColor> rowsColorMap = new HashMap<GroupRange, GroupColor>();
    protected Map<GroupRange, GroupColor> columnsColorMap = new HashMap<GroupRange, GroupColor>();
    protected static Logger logger = LoggerFactory.getLogger(GroupCellRenderer.class);

    public GroupCellRenderer(Color foregroundColor, Color backgroundColor) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        try {
            int delta = -20;
            this.alternateColor = new Color(backgroundColor.getRed() + delta, backgroundColor.getGreen() + delta, backgroundColor.getBlue() + delta);
        }
        catch (Exception e) {
            this.alternateColor = backgroundColor;
            logger.error("Zebra crossing disabled: background colour is too dark");
        }
        this.createDummyGroups();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        GroupColor groupColor = this.getRowColorByIndex(row);
        if (groupColor != null) {
            cell.setForeground(groupColor.getForegroundColor());
            if (row % 2 == 0) {
                cell.setBackground(groupColor.getBackgroundColor());
            } else {
                cell.setBackground(groupColor.getAlternateBackgroundColor());
            }
        } else {
            cell.setForeground(this.foregroundColor);
            if (row % 2 == 0) {
                cell.setBackground(this.backgroundColor);
            } else {
                cell.setBackground(this.alternateColor);
            }
        }
        return cell;
    }

    public GroupColor getRowColorByIndex(int index) {
        for (Map.Entry<GroupRange, GroupColor> entry : this.rowsColorMap.entrySet()) {
            GroupRange groupRange = entry.getKey();
            if (!groupRange.isWithin(index)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<GroupRange, GroupColor> getRowsColorMap() {
        return this.rowsColorMap;
    }

    public void setRowsColorMap(Map<GroupRange, GroupColor> rowsColorMap) {
        this.rowsColorMap = rowsColorMap;
    }

    private void createDummyGroups() {
        GroupRange group_1 = new GroupRange(0, 4);
        GroupRange group_2 = new GroupRange(5, 9);
        GroupRange group_3 = new GroupRange(10, 14);
        GroupColor color_1 = new GroupColor(Color.WHITE, Color.RED, new Color(200, 0, 0));
        GroupColor color_2 = new GroupColor(Color.BLACK, Color.WHITE, Color.LIGHT_GRAY);
        GroupColor color_3 = new GroupColor(Color.BLUE, Color.GREEN, new Color(0, 200, 0));
        this.rowsColorMap = new HashMap<GroupRange, GroupColor>();
        this.rowsColorMap.put(group_1, color_1);
        this.rowsColorMap.put(group_2, color_2);
        this.rowsColorMap.put(group_3, color_3);
    }
}

