/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.file.handler.LocalFile;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.protocol.Protocol;
import eu.europa.ec.jrc.qcs.dao.model.schema.SchemasGroup;
import eu.europa.ec.jrc.qcs.gui.controller.SelectInputAction;
import eu.europa.ec.jrc.qcs.gui.controller.ValidationWorkerMonitor;
import eu.europa.ec.jrc.qcs.gui.model.ComboBoxUIModel;
import eu.europa.ec.jrc.qcs.gui.model.DataSetModel;
import eu.europa.ec.jrc.qcs.gui.model.ListDataModel;
import eu.europa.ec.jrc.qcs.gui.model.MessageLayout;
import eu.europa.ec.jrc.qcs.gui.view.GenericPanel;
import eu.europa.ec.jrc.qcs.gui.view.action.ValidationActions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationBar
extends GenericPanel
implements ValidationActions,
ValidationWorkerMonitor {
    private JComboBox<SchemasGroup> schemaGroupChoice;
    private JComboBox<Protocol> protocolChoice;
    private JButton chooseFileButton;
    private JTextField inputFileTextField;
    private JButton startButton = new JButton("Start checks");
    private JButton openButton;
    protected static Logger logger = LoggerFactory.getLogger(ValidationBar.class);

    public ValidationBar() {
        Configuration configuration = Configuration.getInstance();
        String openLabel = configuration.getLabel(Label.OPEN);
        String buttonLabel = configuration.getLabel(Label.SELECT_FILE);
        String checkLabel = configuration.getLabel(Label.START_CHECKS);
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.chooseFileButton = new JButton(buttonLabel);
        this.chooseFileButton.setPreferredSize(new Dimension(30, 0));
        this.inputFileTextField = new JTextField(12);
        this.startButton = new JButton(checkLabel);
        this.startButton.setPreferredSize(new Dimension(40, 0));
        this.openButton = new JButton(openLabel);
        this.openButton.setPreferredSize(new Dimension(10, 0));
        this.inputFileTextField.setEditable(false);
    }

    public ValidationBar(DataSetModel dataSetModel) {
        this();
        LocalFile localFile = dataSetModel.getLocalFile();
        this.updateTextField(localFile.getAbsolutePath());
    }

    public boolean init() {
        this.addComponent(this.protocolChoice, 0, 0);
        this.addComponent(this.chooseFileButton, 1, 0);
        this.addComponent(this.inputFileTextField, 2, 0);
        this.addComponent(this.startButton, 3, 0);
        this.addComponent(this.openButton, 4, 0);
        return true;
    }

    public void setSchemaGroupUIModel(ComboBoxUIModel<SchemasGroup> schemaGroupUIModel) {
        this.schemaGroupChoice = new JComboBox<SchemasGroup>(schemaGroupUIModel);
        this.schemaGroupChoice.setPreferredSize(new Dimension(105, 0));
    }

    public void setProtocolUIModel(ComboBoxUIModel<Protocol> protocolUIModel) {
        this.protocolChoice = new JComboBox<Protocol>(protocolUIModel);
        this.protocolChoice.setPreferredSize(new Dimension(130, 0));
        this.protocolChoice.setMaximumRowCount(20);
        this.protocolChoice.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JComponent && value instanceof Protocol) {
                    JComponent jcomponent = (JComponent)renderer;
                    Protocol protocol = (Protocol)value;
                    jcomponent.setToolTipText(protocol.getName());
                }
                return renderer;
            }
        });
        protocolUIModel.setComponent(this.protocolChoice);
        ListDataModel<Protocol> dataModel = protocolUIModel.getListDataModel();
        String defaultProtocolID = dataModel.getDefaultItemID();
        if (logger.isDebugEnabled()) {
            logger.debug("setProtocolUIModel() - defaultProtocolID = " + defaultProtocolID);
        }
        for (Protocol protocol : dataModel.getList()) {
            if (!logger.isDebugEnabled()) continue;
            logger.debug("setProtocolUIModel() - Protocol: " + String.valueOf(protocol));
        }
        int selectedIndex = 0;
        boolean found = false;
        for (Protocol protocol : dataModel.getList()) {
            if (protocol.getIdAsString().equalsIgnoreCase(defaultProtocolID)) {
                found = true;
                break;
            }
            ++selectedIndex;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("setProtocolUIModel() - selectedIndex = " + selectedIndex + " (found=" + found + ")");
        }
        if (found) {
            this.protocolChoice.setSelectedIndex(selectedIndex);
        } else {
            this.protocolChoice.setBackground(Color.RED);
            logger.error("setProtocolUIModel() - Default protocolID not supported");
        }
    }

    public void updateTextField(String string) {
        this.inputFileTextField.setText(string);
        this.inputFileTextField.setToolTipText(string);
    }

    @Override
    public void setSelectSchemaGroupAction(Action selectSchemaGroupAction) {
        this.schemaGroupChoice.setAction(selectSchemaGroupAction);
    }

    @Override
    public void setSelectProtocolAction(Action selectProtocolAction) {
        this.protocolChoice.setAction(selectProtocolAction);
    }

    @Override
    public void setSelectInputAction(SelectInputAction selectInputAction) {
        this.chooseFileButton.setAction(selectInputAction);
        selectInputAction.setView(this);
    }

    @Override
    public void setValidateAction(Action validateAction) {
        this.startButton.setAction(validateAction);
    }

    @Override
    public void setOpenOutputAction(Action openOutputAction) {
        this.openButton.setAction(openOutputAction);
    }

    @Override
    public void setMessageLayout(MessageLayout layout) {
        logger.error("setMessageLayout() - Not implemented yet!");
    }

    @Override
    public void setWorkerProgress(int progress) {
        if (logger.isDebugEnabled()) {
            logger.debug("setWorkerProgress() -> progress: " + progress);
        }
    }

    @Override
    public void setWorkerMessage(String message) {
        if ("Validation started".equals(message)) {
            this.startButton.setEnabled(false);
        } else if ("Validation completed".equals(message)) {
            this.startButton.setEnabled(true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("setWorkerMessage() - Message: " + message);
        }
    }
}

