/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.gui.model.TableDataModel;
import eu.europa.ec.jrc.qcs.gui.model.TableDataUIModel;
import eu.europa.ec.jrc.qcs.gui.view.GenericFrame;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablePanel
extends GenericFrame {
    private static final long serialVersionUID = -8579156086738041831L;
    protected JTable table;
    protected String title;
    protected TableDataModel tableDataModel;
    protected TableDataUIModel tableDataUIModel;
    protected static Logger logger = LoggerFactory.getLogger(TablePanel.class);

    public TablePanel() {
        this.title = "Dummy table";
        Object[] columns = new String[]{"Id", "Name", "Age", "Role"};
        Object[][] data = new Object[][]{{1, "Belfader", 42, "Healer"}, {2, "Minkwardr", 75, "Tank"}, {3, "YuGuan", 77, "DPS"}};
        this.table = new JTable(data, columns);
        this.openTable();
    }

    public TablePanel(TableDataModel model) {
        this.tableDataModel = model;
        this.title = this.tableDataModel.getTitle();
        Object[] columns = this.tableDataModel.getHeader();
        Object[][] data = this.tableDataModel.getData();
        this.table = this.getTableWithAutoWidth(columns, data);
        this.tableDataUIModel = new TableDataUIModel(this.table);
    }

    public void openTable(MouseAdapter listener) {
        this.table.addMouseListener(listener);
        this.openTable();
    }

    public void openTable() {
        this.add(new JScrollPane(this.table));
        this.setTitle(this.title);
        this.pack();
        this.setVisible(true);
    }

    protected void checkTableDataUIModel() {
        if (this.tableDataUIModel == null) {
            this.tableDataUIModel = new TableDataUIModel(this.table);
            this.tableDataUIModel.setTemplate(1);
        }
    }

    public void setTableCellRenderer(DefaultTableCellRenderer renderer) {
        this.checkTableDataUIModel();
        this.tableDataUIModel.setRenderer(renderer);
        int columns = this.table.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            TableColumn tColumn = this.table.getColumnModel().getColumn(i);
            tColumn.setCellRenderer(renderer);
        }
    }

    public void setTemplate(int template) {
        this.tableDataUIModel.setTemplate(template);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public TableDataModel getTableDataModel() {
        return this.tableDataModel;
    }

    public void setTableDataModel(TableDataModel tableDataModel) {
        this.tableDataModel = tableDataModel;
    }

    public TableDataUIModel getTableDataUIModel() {
        return this.tableDataUIModel;
    }

    public void setTableDataUIModel(TableDataUIModel tableDataUIModel) {
        this.tableDataUIModel = tableDataUIModel;
    }

    protected JTable getTableWithAutoWidth(Object[] columns, Object[][] data) {
        JTable table = new JTable(data, columns){
            private static final long serialVersionUID = -5504770071304117849L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component component = super.prepareRenderer(renderer, row, column);
                int rendererWidth = component.getPreferredSize().width;
                TableColumn tableColumn = this.getColumnModel().getColumn(column);
                tableColumn.setPreferredWidth(Math.max(rendererWidth + this.getIntercellSpacing().width, tableColumn.getPreferredWidth()));
                return component;
            }
        };
        return table;
    }

    protected void resizeColumnWidth() {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int column = 0; column < this.table.getColumnCount(); ++column) {
            int minWidth = 20;
            for (int row = 0; row < this.table.getRowCount(); ++row) {
                TableCellRenderer renderer = this.table.getCellRenderer(row, column);
                Component compent = this.table.prepareRenderer(renderer, row, column);
                minWidth = Math.max(compent.getPreferredSize().width + 1, minWidth);
            }
            if (minWidth > 400) {
                minWidth = 400;
            }
            columnModel.getColumn(column).setPreferredWidth(minWidth);
        }
    }
}

