/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.gui.model.RuleTableDataModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleInformationPanel
implements Runnable {
    protected JFrame parent;
    protected JDialog frame;
    protected RuleTableDataModel model;
    protected int index;
    protected static Logger logger = LoggerFactory.getLogger(RuleInformationPanel.class);

    public RuleInformationPanel() {
        this.frame = new JDialog(this.parent, "Rule information", true);
    }

    public RuleInformationPanel(RuleTableDataModel model) {
        this();
        this.model = model;
    }

    @Override
    public void run() {
        int rowNumber = this.getIndex();
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<body style='margin: 0px 10px'>");
        builder.append("<p style='font-size: 10px; margin-top: 10px;'><strong>");
        builder.append(this.model.getRuleName(rowNumber));
        builder.append("</strong>");
        builder.append(": ");
        builder.append(this.model.getErrorCode(rowNumber));
        builder.append("<p/>");
        builder.append("<br/>");
        builder.append("<p style='font-size: 9px; font-style: italic'>");
        builder.append("Implementation: ");
        builder.append(this.model.getRuleImplementation(rowNumber));
        builder.append("</p>");
        builder.append("<br/>");
        builder.append("<p>");
        builder.append(this.model.getRuleDescription(rowNumber));
        builder.append("</p>");
        builder.append("<br/><br/><hr/>");
        builder.append("<p style='font-size: 9px; font-style: italic'>");
        builder.append("Rule type: ");
        builder.append(this.model.getRuleType(rowNumber));
        builder.append("</p>");
        builder.append("</body>");
        builder.append("</html>");
        JLabel label = new JLabel(builder.toString());
        this.frame.setDefaultCloseOperation(2);
        this.frame.setPreferredSize(new Dimension(600, 300));
        Container pane = this.frame.getContentPane();
        pane.add((Component)label, "North");
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

