/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.jrc.qcs.gui.view;

import eu.europa.ec.jrc.qcs.Configuration;
import eu.europa.ec.jrc.qcs.dao.model.config.Label;
import eu.europa.ec.jrc.qcs.dao.model.config.Property;
import eu.europa.ec.jrc.qcs.gui.model.OptionModel;
import eu.europa.ec.jrc.qcs.gui.model.OptionsDataModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionPanel
extends JDialog {
    private static final long serialVersionUID = 3704888973468692029L;
    private OptionsDataModel optionsDataModel;
    private JTabbedPane jTabbedPane;
    private JPanel jPanel_1 = new JPanel();
    private JPanel jPanel_2 = new JPanel();
    private ActionListener validationOptionsListener;
    private int width = 350;
    private int height = 400;
    protected Dialog.ModalityType modalType = Dialog.ModalityType.APPLICATION_MODAL;
    public static final String keyValueSeparator = "=";
    protected static Logger logger = LoggerFactory.getLogger(OptionPanel.class);

    public OptionPanel(OptionsDataModel model) {
        this.optionsDataModel = model;
    }

    public void openPanel(JFrame parent) {
        Configuration configuration = Configuration.getInstance();
        String panelTitle = configuration.getLabel(Label.OPTIONS_TITLE);
        String tabTitle_1 = configuration.getLabel(Label.OPTIONS_TAB_1);
        this.setTitle(panelTitle);
        this.setSize(this.width, this.height);
        this.setBackground(Color.LIGHT_GRAY);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.getContentPane().add(panel);
        this.setValidationOptionsPanel(this.jPanel_1);
        this.setAuhtenticationPanel(this.jPanel_2);
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.addTab(tabTitle_1, this.jPanel_1);
        this.setResizable(false);
        this.setModalityType(this.modalType);
        panel.add((Component)this.jTabbedPane, "Center");
        Dimension size = this.getSize();
        int width = (int)size.getWidth();
        int height = (int)size.getHeight();
        Rectangle bounds = parent.getBounds();
        int centerX = (int)(bounds.getCenterX() - (double)(width / 2));
        int centerY = (int)(bounds.getCenterY() - (double)(height / 2));
        if (logger.isTraceEnabled()) {
            logger.trace("Size: " + size.getWidth() + " x " + size.getHeight());
        }
        this.setBounds(centerX, centerY, width, height);
        this.setVisible(true);
    }

    protected void setValidationOptionsPanel(JPanel panel) {
        panel.setLayout(null);
        int boundWidth = 250;
        int boundHeight = 25;
        int stepY = 20;
        int offsetX = 20;
        int offsetY = 35;
        int checkBoxOffsetY = 50;
        Map<Property, OptionModel<Boolean>> checkBoxesMap = this.optionsDataModel.getCheckBoxes();
        int numberOfOptions = checkBoxesMap.size();
        JCheckBox[] checkBox = new JCheckBox[numberOfOptions];
        if (logger.isDebugEnabled()) {
            logger.debug("setValidationOptionsPanel() - Creating " + numberOfOptions + " boolean check-boxes");
        }
        int positionX = offsetX + 80;
        int positionY = offsetY - 10;
        JLabel row_1 = new JLabel("<html><b>Validation options</b></html>");
        row_1.setBounds(positionX, positionY, this.width, boundHeight);
        panel.add(row_1);
        if (logger.isDebugEnabled()) {
            logger.info("setValidationOptionsPanel() - Title coordinates: " + positionX + "," + positionY);
        }
        positionX = offsetX + 40;
        positionY = offsetY + 10;
        JLabel row_2 = new JLabel("<html><i>(allows to configure data validation)</i></html>)");
        row_2.setBounds(positionX, positionY, this.width, boundHeight);
        panel.add(row_2);
        if (logger.isDebugEnabled()) {
            logger.debug("setValidationOptionsPanel() - Subtitle coordinates: " + positionX + "," + positionY);
        }
        int optionIndex = 0;
        for (Map.Entry<Property, OptionModel<Boolean>> entry : checkBoxesMap.entrySet()) {
            Property property = entry.getKey();
            OptionModel<Boolean> optionModel = entry.getValue();
            boolean value = optionModel.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("setValidationOptionsPanel() - Handling check boxes entry: " + property.key + " -> " + value);
            }
            String label = optionModel.getLabel();
            checkBox[optionIndex] = new JCheckBox(label);
            checkBox[optionIndex].setName(label);
            positionY = offsetY + checkBoxOffsetY + stepY * optionIndex;
            checkBox[optionIndex].setBounds(offsetX, positionY, boundWidth, boundHeight);
            panel.add(checkBox[optionIndex]);
            checkBox[optionIndex].setSelected(value);
            checkBox[optionIndex].setActionCommand(property.key);
            checkBox[optionIndex].addActionListener(this.validationOptionsListener);
            if (Property.MPMT_ALGORITHM == property) {
                checkBox[optionIndex].setEnabled(false);
            }
            if (Property.MANDATORY_FLAG_1 == property) {
                checkBox[optionIndex].setEnabled(false);
            }
            ++optionIndex;
        }
        int radioGroupY = offsetY + checkBoxOffsetY + stepY * numberOfOptions;
        this.addRadioButtonGroups(panel, offsetX, radioGroupY);
        if (logger.isTraceEnabled()) {
            logger.trace("setComboBoxPanel() - Created options panel");
        }
    }

    protected void addRadioButtonGroups(JPanel panel, int x, int y) {
        int stepY = 20;
        int marginY = 5;
        int offsetY = marginY + y;
        Map<Property, OptionModel<Integer>> radioButtonsMap = this.optionsDataModel.getRadioButtons();
        if (logger.isDebugEnabled()) {
            logger.debug("addRadioButtonGroups() - Creating " + radioButtonsMap.size() + " radio-button groups");
        }
        Set<Property> originalKeys = radioButtonsMap.keySet();
        List<Property> sortedKeys = this.sortOptionModels(originalKeys);
        if (logger.isDebugEnabled()) {
            logger.debug("addRadioButtonGroups() - RadioButtonsMap: " + String.valueOf(radioButtonsMap));
        }
        for (Property property : sortedKeys) {
            OptionModel<Integer> optionModel = radioButtonsMap.get((Object)property);
            int value = optionModel.getValue();
            if (logger.isTraceEnabled()) {
                logger.trace("addRadioButtonGroups() - Current value for group    " + String.valueOf((Object)property) + " = " + value);
            }
            ButtonGroup buttonGroup = new ButtonGroup();
            int numberOfOptionsInGroup = optionModel.getNumberOfOptions();
            JRadioButton[] radioButtons = new JRadioButton[numberOfOptionsInGroup];
            if (logger.isTraceEnabled()) {
                logger.trace("addRadioButtonGroups() - Number of options in group " + String.valueOf((Object)property) + " : " + numberOfOptionsInGroup);
            }
            Set<Integer> allValues = optionModel.getAllOptionsValues();
            int positionY = 0;
            int optionIndex = 0;
            if (allValues != null) {
                for (int optionValue : allValues) {
                    String label = optionModel.getOptionLabel(optionValue);
                    radioButtons[optionIndex] = new JRadioButton(label);
                    radioButtons[optionIndex].setName(label);
                    positionY = offsetY + stepY * optionIndex;
                    radioButtons[optionIndex].setBounds(x, positionY, 300, 30);
                    if (logger.isTraceEnabled()) {
                        logger.trace("addRadioButtonGroups() - Radio button coordinates: " + property.key + " -> " + positionY);
                    }
                    if (optionValue == value) {
                        radioButtons[optionIndex].setSelected(true);
                    } else {
                        radioButtons[optionIndex].setSelected(false);
                    }
                    radioButtons[optionIndex].setActionCommand(property.key + keyValueSeparator + optionValue);
                    radioButtons[optionIndex].addActionListener(this.validationOptionsListener);
                    if (logger.isTraceEnabled()) {
                        logger.trace("addRadioButtonGroups() - Adding single radio-button: " + radioButtons[optionIndex].getText());
                    }
                    panel.add(radioButtons[optionIndex]);
                    buttonGroup.add(radioButtons[optionIndex]);
                    ++optionIndex;
                }
            } else {
                logger.warn("addRadioButtonGroups() - Found null list of option values");
            }
            panel.add(new JSeparator());
            offsetY = positionY + stepY + marginY;
        }
        panel.setSize(300, 300);
        panel.setLayout(null);
        panel.setVisible(true);
    }

    protected void setAuhtenticationPanel(JPanel panel) {
        panel.setLayout(null);
        int width = 100;
        int height = 25;
        int offsetX = 20;
        int offsetY = 15;
        JLabel row_1 = new JLabel("<html><b>Authentication panel</b></html>");
        row_1.setBounds(offsetX + 80, offsetY - 10, this.width, height);
        panel.add(row_1);
        JLabel row_2 = new JLabel("<html><i>(allows to update via remote server)</i></html>)");
        row_2.setBounds(offsetX + 40, offsetY + 10, this.width, height);
        panel.add(row_2);
        JLabel caption = new JLabel("User credential:");
        caption.setBounds(offsetX, offsetY + 50, this.width, height);
        panel.add(caption);
        JLabel label1 = new JLabel("Username:");
        label1.setBounds(offsetX, offsetY + 80, width, height);
        panel.add(label1);
        JTextField field = new JTextField();
        field.setBounds(offsetX, offsetY + 100, width, height);
        panel.add(field);
        JLabel label2 = new JLabel("Password:");
        label2.setBounds(offsetX, offsetY + 130, width, height);
        panel.add(label2);
        JPasswordField fieldPass = new JPasswordField();
        fieldPass.setBounds(offsetX, offsetY + 150, width, height);
        panel.add(fieldPass);
        JButton button = new JButton("Submit");
        button.setBounds(offsetX + 100, offsetY + 200, width, height);
        panel.add(button);
        if (logger.isTraceEnabled()) {
            logger.trace("setAuhtenticationPanel() - Created authentication options panel");
        }
    }

    public OptionsDataModel getOptionsDataModel() {
        return this.optionsDataModel;
    }

    public void setOptionsDataModel(OptionsDataModel optionsDataModel) {
        this.optionsDataModel = optionsDataModel;
    }

    public ActionListener getValidationOptionsListener() {
        return this.validationOptionsListener;
    }

    public void setValidationOptionsListener(ActionListener validationOptionsListener) {
        this.validationOptionsListener = validationOptionsListener;
    }

    protected List<Property> sortOptionModels(Set<Property> originalSet) {
        int firstIndex = 999;
        for (Property property : originalSet) {
            if (property.index >= firstIndex) continue;
            firstIndex = property.index;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sortOptionModels() - First property index: " + firstIndex);
        }
        ArrayList<Property> sortedSet = new ArrayList<Property>();
        int failed = 0;
        int index = firstIndex;
        int originalSize = originalSet.size();
        do {
            Iterator<Property> iterator = originalSet.iterator();
            if (logger.isDebugEnabled()) {
                logger.debug("sortOptionModels() - Sorting set: " + String.valueOf(originalSet));
            }
            while (iterator.hasNext()) {
                Property property = iterator.next();
                if (logger.isDebugEnabled()) {
                    logger.debug("sortOptionModels() - Analysing entry: " + String.valueOf((Object)property));
                }
                if (property.index == index) {
                    ++index;
                    sortedSet.add(property);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("sortOptionModels() - Sorted entry: " + String.valueOf((Object)property) + " (new firstIndex =" + index + ")");
                    continue;
                }
                ++failed;
            }
            if (failed > originalSize) {
                logger.error("sortOptionModels() - Wrong index order in the Property enumeration: " + String.valueOf(originalSet));
                break;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("sortOptionModels() - Comparing set dimensions: sorted = " + sortedSet.size() + " VS original = " + originalSet.size());
        } while (sortedSet.size() < originalSize);
        if (logger.isDebugEnabled()) {
            logger.debug("sortOptionModels() - Returning Sorted set: " + String.valueOf(sortedSet));
        }
        return sortedSet;
    }
}

